/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.etl.kettle.KettleUtils;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.swingui.db.DataSourceTypeEditorTabPanel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class KettleDataSourceTypeOptionPanel
implements DataSourceTypeEditorTabPanel {
    private JPanel panel;
    private JComboBox kettleConnectionType = new JComboBox();
    private JDBCDataSourceType dsType;

    public KettleDataSourceTypeOptionPanel() {
        PanelBuilder pb = new PanelBuilder(new FormLayout("4dlu,pref,4dlu,pref:grow,4dlu", "4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu"));
        CellConstraints cc = new CellConstraints();
        CellConstraints cl = new CellConstraints();
        int row = 2;
        pb.addLabel("Kettle Connection Type", cl.xy(2, row), (Component)this.kettleConnectionType, cc.xy(4, row));
        List<String> dbConnectionNames = KettleUtils.retrieveKettleConnectionTypes();
        for (String dbConnectionName : dbConnectionNames) {
            this.kettleConnectionType.addItem(dbConnectionName);
        }
        this.kettleConnectionType.setSelectedIndex(-1);
        this.panel = pb.getPanel();
    }

    public boolean applyChanges() {
        if (this.dsType != null) {
            this.dsType.putProperty("ca.sqlpower.architect.etl.kettle.connectionType", (String)this.kettleConnectionType.getSelectedItem());
        }
        return true;
    }

    public void discardChanges() {
        this.editDsType(this.dsType);
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public void editDsType(JDBCDataSourceType dsType) {
        this.dsType = dsType;
        if (dsType != null && dsType.getKettleNames().size() > 0) {
            this.kettleConnectionType.setSelectedItem(dsType.getKettleNames().get(0));
        } else {
            this.kettleConnectionType.setSelectedItem("");
        }
    }

    public boolean hasUnsavedChanges() {
        return true;
    }
}

