/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.PrefixOperator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class MinusSignOperator
implements PrefixOperator {
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final long serialVersionUID = 7453766552980074751L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, TypeValuePair value1) throws EvaluationException {
        Type type = value1.getType();
        Object val = value1.getValue();
        if (val == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        if (type.isFlagSet("type.numeric")) {
            TypeRegistry typeRegistry = context.getTypeRegistry();
            Number number = typeRegistry.convertToNumber(type, val);
            if (number == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            BigDecimal value = NumberUtil.getAsBigDecimal(number);
            return new TypeValuePair(NumberType.GENERIC_NUMBER, ZERO.subtract(value));
        }
        if (val instanceof Number) {
            BigDecimal value = NumberUtil.getAsBigDecimal((Number)val);
            if (value == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            return new TypeValuePair(type, ZERO.subtract(value));
        }
        throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
    }

    public String toString() {
        return "-";
    }
}

