/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.xml;

import java.io.PrintWriter;

public class XMLHelper {
    public int indent;

    public void print(PrintWriter out, String text) {
        for (int i = 0; i < this.indent; ++i) {
            out.print(" ");
        }
        out.print(XMLHelper.escape(text));
    }

    public void niprint(PrintWriter out, String text) {
        out.print(XMLHelper.escape(text));
    }

    public void niprintln(PrintWriter out, String text) {
        out.println(XMLHelper.escape(text));
    }

    public void println(PrintWriter out, String text) {
        for (int i = 0; i < this.indent; ++i) {
            out.print(" ");
        }
        out.println(XMLHelper.escape(text));
    }

    static String escape(String text) {
        if (text.equals("")) {
            return "";
        }
        StringBuilder sb = new StringBuilder(text.length() + 10);
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char ch = text.charAt(i);
            char nextch = i == n - 1 ? (char)'\u0000' : text.charAt(i + 1);
            if (ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' && ch != '\\' || ch >= '\ue000' && ch <= '\ufffd' || ch == '\\' && nextch != 'u') {
                sb.append(ch);
                continue;
            }
            sb.append(String.format("\\u%04x", ch));
        }
        return sb.toString();
    }

    static String unescape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder unescapedText = new StringBuilder(text.length());
        int i = 0;
        int n = text.length();
        while (i < n) {
            char ch = text.charAt(i);
            char nextch = i == n - 1 ? (char)'\u0000' : text.charAt(i + 1);
            if (ch == '\\' && nextch == 'u') {
                int charVal = Integer.parseInt(text.substring(i + 2, i + 6), 16);
                char unescapedChar = (char)charVal;
                unescapedText.append(unescapedChar);
                i += 6;
                continue;
            }
            unescapedText.append(ch);
            ++i;
        }
        return unescapedText.toString();
    }
}

