/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.naming.Reference;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class SQLServerConnectionPoolDataSource
extends SQLServerDataSource
implements ConnectionPoolDataSource {
    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getPooledConnection");
        }
        PooledConnection pooledConnection = this.getPooledConnection(this.getUser(), this.getPassword());
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getPooledConnection", pooledConnection);
        }
        return pooledConnection;
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getPooledConnection", new Object[]{string, "Password not traced"});
        }
        SQLServerPooledConnection sQLServerPooledConnection = new SQLServerPooledConnection(this, string, string2);
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getPooledConnection", sQLServerPooledConnection);
        }
        return sQLServerPooledConnection;
    }

    @Override
    public Reference getReference() {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "getReference");
        }
        Reference reference = this.getReferenceInternal("com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource");
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getReference", reference);
        }
        return reference;
    }
}

