"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkbenchPlugin = void 0;
var _sqlPlugin = _interopRequireDefault(require("./clusters/sql/sqlPlugin"));
var _routes = require("./routes");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class WorkbenchPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, {
    dataSource
  }) {
    this.logger.debug('queryWorkbenchDashboards: Setup');
    const router = core.http.createRouter();
    const dataSourceEnabled = !!dataSource;
    const client = core.opensearch.legacy.createClient('query_workbench', {
      plugins: [_sqlPlugin.default]
    });
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_sqlPlugin.default);
    }

    // Register server side APIs
    (0, _routes.defineRoutes)(router, client, core.opensearch, dataSourceEnabled, this.logger);
    return {};
  }
  start() {
    this.logger.debug('queryWorkbenchDashboards: Started');
    return {};
  }
  stop() {}
}
exports.WorkbenchPlugin = WorkbenchPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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