"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseDateString = void 0;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const parseDateString = dateString => {
  const date = _datemath.default.parse(dateString);
  return date ? date.toDate().toISOString() : new Date().toISOString();
};
exports.parseDateString = parseDateString;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfZGF0ZW1hdGgiLCJfaW50ZXJvcFJlcXVpcmVEZWZhdWx0IiwicmVxdWlyZSIsIm9iaiIsIl9fZXNNb2R1bGUiLCJkZWZhdWx0IiwicGFyc2VEYXRlU3RyaW5nIiwiZGF0ZVN0cmluZyIsImRhdGUiLCJkYXRlTWF0aCIsInBhcnNlIiwidG9EYXRlIiwidG9JU09TdHJpbmciLCJEYXRlIiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbIkRhdGVVdGlscy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5pbXBvcnQgZGF0ZU1hdGggZnJvbSAnQGVsYXN0aWMvZGF0ZW1hdGgnO1xuXG5leHBvcnQgY29uc3QgcGFyc2VEYXRlU3RyaW5nID0gKGRhdGVTdHJpbmc6IHN0cmluZyk6IHN0cmluZyA9PiB7XG4gIGNvbnN0IGRhdGUgPSBkYXRlTWF0aC5wYXJzZShkYXRlU3RyaW5nKTtcbiAgcmV0dXJuIGRhdGUgPyBkYXRlLnRvRGF0ZSgpLnRvSVNPU3RyaW5nKCkgOiBuZXcgRGF0ZSgpLnRvSVNPU3RyaW5nKCk7XG59O1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFJQSxJQUFBQSxTQUFBLEdBQUFDLHNCQUFBLENBQUFDLE9BQUE7QUFBeUMsU0FBQUQsdUJBQUFFLEdBQUEsV0FBQUEsR0FBQSxJQUFBQSxHQUFBLENBQUFDLFVBQUEsR0FBQUQsR0FBQSxLQUFBRSxPQUFBLEVBQUFGLEdBQUE7QUFKekM7QUFDQTtBQUNBO0FBQ0E7O0FBR08sTUFBTUcsZUFBZSxHQUFJQyxVQUFrQixJQUFhO0VBQzdELE1BQU1DLElBQUksR0FBR0MsaUJBQVEsQ0FBQ0MsS0FBSyxDQUFDSCxVQUFVLENBQUM7RUFDdkMsT0FBT0MsSUFBSSxHQUFHQSxJQUFJLENBQUNHLE1BQU0sQ0FBQyxDQUFDLENBQUNDLFdBQVcsQ0FBQyxDQUFDLEdBQUcsSUFBSUMsSUFBSSxDQUFDLENBQUMsQ0FBQ0QsV0FBVyxDQUFDLENBQUM7QUFDdEUsQ0FBQztBQUFDRSxPQUFBLENBQUFSLGVBQUEsR0FBQUEsZUFBQSJ9