"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NODE_CATEGORY = exports.MULTIMODAL_SEARCH_QUERY_NEURAL = exports.MULTIMODAL_SEARCH_QUERY_BOOL = exports.MODEL_TYPE = exports.MODEL_OUTPUT_SCHEMA_NESTED_PATH = exports.MODEL_OUTPUT_SCHEMA_FULL_PATH = exports.MODEL_ID_PATTERN = exports.ML_SEARCH_MODELS_ROUTE = exports.ML_SEARCH_CONNECTORS_ROUTE = exports.ML_REMOTE_MODEL_LINK = exports.ML_MODEL_ROUTE_PREFIX = exports.ML_INFERENCE_RESPONSE_DOCS_LINK = exports.ML_INFERENCE_DOCS_LINK = exports.ML_CONNECTOR_ROUTE_PREFIX = exports.ML_CHOOSE_MODEL_LINK = exports.ML_API_ROUTE_PREFIX = exports.MIN_SUPPORTED_VERSION = exports.MINIMUM_FULL_SUPPORTED_VERSION = exports.MAX_WORKFLOW_NAME_TO_DISPLAY = exports.MAX_TEMPLATE_STRING_LENGTH = exports.MAX_STRING_LENGTH = exports.MAX_JSON_STRING_LENGTH = exports.MAX_DOCS_TO_IMPORT = exports.MAX_DOCS = exports.MAX_DESCRIPTION_LENGTH = exports.MAX_BYTES_FORMATTED = exports.MAX_BYTES = exports.LABEL_FIELD_PATTERN = exports.KNN_VECTOR_DOCS_LINK = exports.KNN_QUERY = exports.JSONPATH_ROOT_SELECTOR = exports.JSONPATH_DOCS_LINK = exports.INVALID_DATASOURCE_MSG = exports.INSPECTOR_TAB_ID = exports.INSPECTOR_TABS = exports.INPUT_TRANSFORM_OPTIONS = exports.INGEST_PIPELINE_NODE_API_PATH = exports.INGEST_NODE_API_PATH = exports.INDEX_NOT_FOUND_EXCEPTION = exports.INDEX_NAME_REGEXP = exports.IMAGE_FIELD_PATTERN = exports.HYBRID_SEARCH_QUERY_MATCH_TERM = exports.HYBRID_SEARCH_QUERY_MATCH_NEURAL = exports.HYBRID_SEARCH_QUERY_MATCH_KNN = exports.GITHUB_FEEDBACK_LINK = exports.GET_WORKFLOW_STATE_NODE_API_PATH = exports.GET_WORKFLOW_NODE_API_PATH = exports.GET_PRESET_WORKFLOWS_NODE_API_PATH = exports.GET_MAPPINGS_NODE_API_PATH = exports.GET_INDEX_NODE_API_PATH = exports.GENERAL_TEXT_GENERATION_PROMPT = exports.GENERAL_SUMMARIZE_PROMPT = exports.GENERAL_QA_WITH_CONTEXT_PROMPT = exports.GENERAL_QA_NO_CONTEXT_PROMPT = exports.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = exports.FLOW_FRAMEWORK_API_ROUTE_PREFIX = exports.FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = exports.FETCH_ALL_QUERY_LARGE = exports.FETCH_ALL_QUERY = exports.ERROR_GETTING_WORKFLOW_MSG = exports.EMPTY_OUTPUT_MAP_ENTRY = exports.EMPTY_MAP_ENTRY = exports.EMPTY_INPUT_MAP_ENTRY = exports.EMPTY_FIELD_STRING = exports.DEPROVISION_WORKFLOW_NODE_API_PATH = exports.DELIMITER_OPTIONAL_FIELDS = exports.DELETE_WORKFLOW_NODE_API_PATH = exports.DEFAULT_VECTOR_FIELD = exports.DEFAULT_TEXT_FIELD = exports.DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = exports.DEFAULT_PROMPT_ROLE_FIELD = exports.DEFAULT_PROMPT_RESULTS_FIELD = exports.DEFAULT_PROMPT_QUESTION_FIELD = exports.DEFAULT_NEW_WORKFLOW_STATE_TYPE = exports.DEFAULT_NEW_WORKFLOW_NAME = exports.DEFAULT_NEW_WORKFLOW_DESCRIPTION = exports.DEFAULT_LLM_RESPONSE_FIELD = exports.DEFAULT_K = exports.DEFAULT_IMAGE_FIELD = exports.DEFAULT_FETCH_SIZE = exports.DATE_FORMAT_PATTERN = exports.CREATE_WORKFLOW_NODE_API_PATH = exports.CREATE_WORKFLOW_LINK = exports.CONFIG_STEP = exports.COMPONENT_CLASS = exports.COMPONENT_CATEGORY = exports.COHERE_CONFIGS = exports.CLAUDE_SUMMARIZE_PROMPT = exports.CLAUDE_QA_WITH_CONTEXT_PROMPT = exports.CAT_INDICES_NODE_API_PATH = exports.BULK_NODE_API_PATH = exports.BULK_API_DOCS_LINK = exports.BEDROCK_CONFIGS = exports.BASE_WORKFLOW_NODE_API_PATH = exports.BASE_OPENSEARCH_NODE_API_PATH = exports.BASE_NODE_API_PATH = exports.BASE_MODEL_NODE_API_PATH = exports.BASE_CONNECTOR_NODE_API_PATH = void 0;
exports.WORKFLOW_TYPE = exports.WORKFLOW_TUTORIAL_LINK = exports.WORKFLOW_NAME_RESTRICTIONS = exports.WORKFLOW_NAME_REGEXP = exports.VECTOR_TEMPLATE_PLACEHOLDER = exports.VECTOR_PATTERN = exports.VECTOR_FIELD_PATTERN = exports.VECTOR = exports.UPDATE_WORKFLOW_NODE_API_PATH = exports.UI_METADATA_SCHEMA_VERSION = exports.TRANSFORM_TYPE = exports.TRANSFORM_CONTEXT = exports.TEXT_FIELD_PATTERN = exports.TEXT_CHUNKING_PROCESSOR_LINK = exports.TEXT_CHUNKING_ALGORITHM = exports.TERM_QUERY_TEXT = exports.SOURCE_OPTIONS = exports.SORT_ORDER = exports.SIMULATE_PIPELINE_NODE_API_PATH = exports.SHARED_OPTIONAL_FIELDS = exports.SEMANTIC_SEARCH_QUERY_NEURAL = exports.SEARCH_WORKFLOWS_NODE_API_PATH = exports.SEARCH_PIPELINE_ROUTE = exports.SEARCH_PIPELINE_NODE_API_PATH = exports.SEARCH_PIPELINE_DOCS_LINK = exports.SEARCH_MODELS_NODE_API_PATH = exports.SEARCH_INDEX_NODE_API_PATH = exports.SEARCH_CONNECTORS_NODE_API_PATH = exports.REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = exports.REQUEST_PREFIX = exports.QUERY_TEXT_PATTERN = exports.QUERY_PRESETS = exports.QUERY_IMAGE_PATTERN = exports.PROVISION_WORKFLOW_NODE_API_PATH = exports.PROMPT_PRESETS = exports.PROCESSOR_TYPE = exports.PROCESSOR_CONTEXT = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OUTPUT_TRANSFORM_OPTIONS = exports.OPENAI_CONFIGS = exports.OMIT_SYSTEM_INDEX_PATTERN = exports.NO_TRANSFORMATION = exports.NO_TEMPLATES_FOUND_MSG = exports.NO_MODIFICATIONS_FOUND_TEXT = exports.NORMALIZATION_PROCESSOR_LINK = void 0;
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'opensearch-flow';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'OpenSearch Flow';

/**
 * BACKEND FLOW FRAMEWORK APIs
 */
const FLOW_FRAMEWORK_API_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_API_ROUTE_PREFIX = '/_plugins/_flow_framework';
const FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = `${FLOW_FRAMEWORK_API_ROUTE_PREFIX}/workflow`;
const FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = `${FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/_search`;
const FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = `${FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/state/_search`;

/**
 * BACKEND ML PLUGIN APIs
 */
const ML_API_ROUTE_PREFIX = exports.ML_API_ROUTE_PREFIX = '/_plugins/_ml';
const ML_MODEL_ROUTE_PREFIX = exports.ML_MODEL_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/models`;
const ML_CONNECTOR_ROUTE_PREFIX = exports.ML_CONNECTOR_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/connectors`;
const ML_SEARCH_MODELS_ROUTE = exports.ML_SEARCH_MODELS_ROUTE = `${ML_MODEL_ROUTE_PREFIX}/_search`;
const ML_SEARCH_CONNECTORS_ROUTE = exports.ML_SEARCH_CONNECTORS_ROUTE = `${ML_CONNECTOR_ROUTE_PREFIX}/_search`;

/**
 * OpenSearch APIs
 */
const SEARCH_PIPELINE_ROUTE = exports.SEARCH_PIPELINE_ROUTE = '/_search/pipeline';

/**
 * NODE APIs
 */
const BASE_NODE_API_PATH = exports.BASE_NODE_API_PATH = '/api/flow_framework';

// OpenSearch node APIs
const BASE_OPENSEARCH_NODE_API_PATH = exports.BASE_OPENSEARCH_NODE_API_PATH = `${BASE_NODE_API_PATH}/opensearch`;
const CAT_INDICES_NODE_API_PATH = exports.CAT_INDICES_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/catIndices`;
const GET_MAPPINGS_NODE_API_PATH = exports.GET_MAPPINGS_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/mappings`;
const GET_INDEX_NODE_API_PATH = exports.GET_INDEX_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getIndex`;
const SEARCH_INDEX_NODE_API_PATH = exports.SEARCH_INDEX_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/search`;
const INGEST_NODE_API_PATH = exports.INGEST_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/ingest`;
const BULK_NODE_API_PATH = exports.BULK_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/bulk`;
const SIMULATE_PIPELINE_NODE_API_PATH = exports.SIMULATE_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/simulatePipeline`;
const INGEST_PIPELINE_NODE_API_PATH = exports.INGEST_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getIngestPipeline`;
const SEARCH_PIPELINE_NODE_API_PATH = exports.SEARCH_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getSearchPipeline`;

// Flow Framework node APIs
const BASE_WORKFLOW_NODE_API_PATH = exports.BASE_WORKFLOW_NODE_API_PATH = `${BASE_NODE_API_PATH}/workflow`;
const GET_WORKFLOW_NODE_API_PATH = exports.GET_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}`;
const SEARCH_WORKFLOWS_NODE_API_PATH = exports.SEARCH_WORKFLOWS_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/search`;
const GET_WORKFLOW_STATE_NODE_API_PATH = exports.GET_WORKFLOW_STATE_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/state`;
const CREATE_WORKFLOW_NODE_API_PATH = exports.CREATE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/create`;
const UPDATE_WORKFLOW_NODE_API_PATH = exports.UPDATE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/update`;
const PROVISION_WORKFLOW_NODE_API_PATH = exports.PROVISION_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/provision`;
const DEPROVISION_WORKFLOW_NODE_API_PATH = exports.DEPROVISION_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/deprovision`;
const DELETE_WORKFLOW_NODE_API_PATH = exports.DELETE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/delete`;
const GET_PRESET_WORKFLOWS_NODE_API_PATH = exports.GET_PRESET_WORKFLOWS_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/presets`;

// ML Plugin node APIs
const BASE_MODEL_NODE_API_PATH = exports.BASE_MODEL_NODE_API_PATH = `${BASE_NODE_API_PATH}/model`;
const BASE_CONNECTOR_NODE_API_PATH = exports.BASE_CONNECTOR_NODE_API_PATH = `${BASE_NODE_API_PATH}/connector`;
const SEARCH_MODELS_NODE_API_PATH = exports.SEARCH_MODELS_NODE_API_PATH = `${BASE_MODEL_NODE_API_PATH}/search`;
const SEARCH_CONNECTORS_NODE_API_PATH = exports.SEARCH_CONNECTORS_NODE_API_PATH = `${BASE_CONNECTOR_NODE_API_PATH}/search`;

/**
 * Remote model dimensions. Used for attempting to pre-fill dimension size
 * based on the specified remote model from a remote service, if found
 */

// Amazon BedRock
const BEDROCK_CONFIGS = exports.BEDROCK_CONFIGS = {
  [`amazon.titan-embed-text-v1`]: {
    dimension: 1536,
    fieldName: 'embedding'
  },
  [`amazon.titan-embed-text-v2`]: {
    dimension: 1024,
    fieldName: 'embedding'
  },
  [`amazon.titan-embed-image-v1`]: {
    dimension: 1024,
    fieldName: 'embedding'
  },
  [`cohere.embed-english-v3`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`cohere.embed-multilingual-v3`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  }
};

// Cohere
const COHERE_CONFIGS = exports.COHERE_CONFIGS = {
  [`embed-english-v3.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-english-light-v3.0`]: {
    dimension: 384,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-v3.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-light-v3.0`]: {
    dimension: 384,
    fieldName: 'embeddings'
  },
  [`embed-english-v2.0`]: {
    dimension: 4096,
    fieldName: 'embeddings'
  },
  [`embed-english-light-v2.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-v2.0`]: {
    dimension: 768,
    fieldName: 'embeddings'
  }
};

// OpenAI
const OPENAI_CONFIGS = exports.OPENAI_CONFIGS = {
  [`text-embedding-3-small`]: {
    dimension: 1536,
    fieldName: 'embedding'
  },
  [`text-embedding-3-large`]: {
    dimension: 3072,
    fieldName: 'embedding'
  },
  [`text-embedding-ada-002`]: {
    dimension: 1536,
    fieldName: 'embedding'
  }
};

/**
 * Various constants pertaining to Workflow configs
 */

const UI_METADATA_SCHEMA_VERSION = exports.UI_METADATA_SCHEMA_VERSION = 1;

// frontend-specific workflow types, derived from the available preset templates
let WORKFLOW_TYPE = exports.WORKFLOW_TYPE = /*#__PURE__*/function (WORKFLOW_TYPE) {
  WORKFLOW_TYPE["SEMANTIC_SEARCH"] = "Semantic Search";
  WORKFLOW_TYPE["MULTIMODAL_SEARCH"] = "Multimodal Search";
  WORKFLOW_TYPE["HYBRID_SEARCH"] = "Hybrid Search";
  WORKFLOW_TYPE["RAG"] = "RAG with Lexical Retrieval";
  WORKFLOW_TYPE["VECTOR_SEARCH_WITH_RAG"] = "RAG with Vector Retrieval";
  WORKFLOW_TYPE["CUSTOM"] = "Custom Search";
  WORKFLOW_TYPE["UNKNOWN"] = "Unknown";
  return WORKFLOW_TYPE;
}({}); // If no datasource version is found, we default to 2.17.0
const MIN_SUPPORTED_VERSION = exports.MIN_SUPPORTED_VERSION = '2.17.0';
// Min version to support ML processors
const MINIMUM_FULL_SUPPORTED_VERSION = exports.MINIMUM_FULL_SUPPORTED_VERSION = '2.19.0';

// the names should be consistent with the underlying implementation. used when generating the
// final ingest/search pipeline configurations.
let PROCESSOR_TYPE = exports.PROCESSOR_TYPE = /*#__PURE__*/function (PROCESSOR_TYPE) {
  PROCESSOR_TYPE["ML"] = "ml_inference";
  PROCESSOR_TYPE["SPLIT"] = "split";
  PROCESSOR_TYPE["SORT"] = "sort";
  PROCESSOR_TYPE["TEXT_CHUNKING"] = "text_chunking";
  PROCESSOR_TYPE["NORMALIZATION"] = "normalization-processor";
  PROCESSOR_TYPE["COLLAPSE"] = "collapse";
  PROCESSOR_TYPE["RERANK"] = "rerank";
  PROCESSOR_TYPE["TEXT_EMBEDDING"] = "text_embedding";
  PROCESSOR_TYPE["TEXT_IMAGE_EMBEDDING"] = "text_image_embedding";
  PROCESSOR_TYPE["COPY"] = "copy";
  return PROCESSOR_TYPE;
}({});
let MODEL_TYPE = exports.MODEL_TYPE = /*#__PURE__*/function (MODEL_TYPE) {
  MODEL_TYPE["TEXT_EMBEDDING"] = "text_embedding";
  MODEL_TYPE["SPARSE_ENCODER"] = "sparse_encoder";
  return MODEL_TYPE;
}({});
/**
 * Various constants pertaining to the drag-and-drop UI components
 */
let COMPONENT_CATEGORY = exports.COMPONENT_CATEGORY = /*#__PURE__*/function (COMPONENT_CATEGORY) {
  COMPONENT_CATEGORY["INGEST"] = "Ingest";
  COMPONENT_CATEGORY["SEARCH"] = "Search";
  return COMPONENT_CATEGORY;
}({});
let NODE_CATEGORY = exports.NODE_CATEGORY = /*#__PURE__*/function (NODE_CATEGORY) {
  NODE_CATEGORY["CUSTOM"] = "custom";
  NODE_CATEGORY["INGEST_GROUP"] = "ingestGroup";
  NODE_CATEGORY["SEARCH_GROUP"] = "searchGroup";
  return NODE_CATEGORY;
}({});
/**
 * A base set of component classes / types.
 */
let COMPONENT_CLASS = exports.COMPONENT_CLASS = /*#__PURE__*/function (COMPONENT_CLASS) {
  COMPONENT_CLASS["INDEX"] = "index";
  COMPONENT_CLASS["KNN_INDEX"] = "knn_index";
  COMPONENT_CLASS["TRANSFORMER"] = "transformer";
  COMPONENT_CLASS["ML_TRANSFORMER"] = "ml_transformer";
  COMPONENT_CLASS["SEARCH_REQUEST"] = "search_request";
  COMPONENT_CLASS["DOCUMENT"] = "document";
  COMPONENT_CLASS["SEARCH_RESPONSE"] = "search_response";
  return COMPONENT_CLASS;
}({});
/**
 * LINKS
 */
const ML_INFERENCE_DOCS_LINK = exports.ML_INFERENCE_DOCS_LINK = 'https://opensearch.org/docs/latest/ingest-pipelines/processors/ml-inference/#configuration-parameters';
const ML_INFERENCE_RESPONSE_DOCS_LINK = exports.ML_INFERENCE_RESPONSE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/ml-inference-search-response/#request-fields';
const ML_CHOOSE_MODEL_LINK = exports.ML_CHOOSE_MODEL_LINK = 'https://opensearch.org/docs/latest/ml-commons-plugin/integrating-ml-models/#choosing-a-model';
const ML_REMOTE_MODEL_LINK = exports.ML_REMOTE_MODEL_LINK = 'https://opensearch.org/docs/latest/ml-commons-plugin/remote-models/index/';
const TEXT_CHUNKING_PROCESSOR_LINK = exports.TEXT_CHUNKING_PROCESSOR_LINK = 'https://opensearch.org/docs/latest/ingest-pipelines/processors/text-chunking/';
const CREATE_WORKFLOW_LINK = exports.CREATE_WORKFLOW_LINK = 'https://opensearch.org/docs/latest/automating-configurations/api/create-workflow/';
const WORKFLOW_TUTORIAL_LINK = exports.WORKFLOW_TUTORIAL_LINK = 'https://opensearch.org/docs/latest/automating-configurations/workflow-tutorial/';
const NORMALIZATION_PROCESSOR_LINK = exports.NORMALIZATION_PROCESSOR_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/normalization-processor/';
const GITHUB_FEEDBACK_LINK = exports.GITHUB_FEEDBACK_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/issues/new/choose';
const JSONPATH_DOCS_LINK = exports.JSONPATH_DOCS_LINK = 'https://www.npmjs.com/package/jsonpath';
const KNN_VECTOR_DOCS_LINK = exports.KNN_VECTOR_DOCS_LINK = 'https://opensearch.org/docs/latest/field-types/supported-field-types/knn-vector/';
const BULK_API_DOCS_LINK = exports.BULK_API_DOCS_LINK = 'https://opensearch.org/docs/latest/api-reference/document-apis/bulk/';
const SEARCH_PIPELINE_DOCS_LINK = exports.SEARCH_PIPELINE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/using-search-pipeline/';

/**
 * Text chunking algorithm constants
 */
let TEXT_CHUNKING_ALGORITHM = exports.TEXT_CHUNKING_ALGORITHM = /*#__PURE__*/function (TEXT_CHUNKING_ALGORITHM) {
  TEXT_CHUNKING_ALGORITHM["FIXED_TOKEN_LENGTH"] = "fixed_token_length";
  TEXT_CHUNKING_ALGORITHM["DELIMITER"] = "delimiter";
  return TEXT_CHUNKING_ALGORITHM;
}({});
const FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = exports.FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = ['token_limit', 'tokenizer', 'overlap_rate'];
const DELIMITER_OPTIONAL_FIELDS = exports.DELIMITER_OPTIONAL_FIELDS = ['delimiter'];
const SHARED_OPTIONAL_FIELDS = exports.SHARED_OPTIONAL_FIELDS = ['max_chunk_limit', 'description', 'tag'];

/**
 * DEFAULT FIELD VALUES
 */
const DEFAULT_TEXT_FIELD = exports.DEFAULT_TEXT_FIELD = 'my_text';
const DEFAULT_VECTOR_FIELD = exports.DEFAULT_VECTOR_FIELD = 'my_embedding';
const DEFAULT_IMAGE_FIELD = exports.DEFAULT_IMAGE_FIELD = 'my_image';
const DEFAULT_LLM_RESPONSE_FIELD = exports.DEFAULT_LLM_RESPONSE_FIELD = 'llm_response';

/**
 * QUERY PRESETS
 */
const VECTOR_FIELD_PATTERN = exports.VECTOR_FIELD_PATTERN = `{{vector_field}}`;
const TEXT_FIELD_PATTERN = exports.TEXT_FIELD_PATTERN = `{{text_field}}`;
const IMAGE_FIELD_PATTERN = exports.IMAGE_FIELD_PATTERN = `{{image_field}}`;
const LABEL_FIELD_PATTERN = exports.LABEL_FIELD_PATTERN = `{{label_field}}`;
const QUERY_TEXT_PATTERN = exports.QUERY_TEXT_PATTERN = `{{query_text}}`;
const QUERY_IMAGE_PATTERN = exports.QUERY_IMAGE_PATTERN = `{{query_image}}`;
const MODEL_ID_PATTERN = exports.MODEL_ID_PATTERN = `{{model_id}}`;
const VECTOR = exports.VECTOR = 'vector';
const VECTOR_PATTERN = exports.VECTOR_PATTERN = `{{${VECTOR}}}`;
const VECTOR_TEMPLATE_PLACEHOLDER = exports.VECTOR_TEMPLATE_PLACEHOLDER = `\$\{${VECTOR}\}`;
const DEFAULT_K = exports.DEFAULT_K = 10;
const DEFAULT_FETCH_SIZE = exports.DEFAULT_FETCH_SIZE = 10;
const FETCH_ALL_QUERY = exports.FETCH_ALL_QUERY = {
  query: {
    match_all: {}
  },
  size: DEFAULT_FETCH_SIZE
};
const FETCH_ALL_QUERY_LARGE = exports.FETCH_ALL_QUERY_LARGE = {
  query: {
    match_all: {}
  },
  size: 1000
};
const TERM_QUERY_TEXT = exports.TERM_QUERY_TEXT = {
  query: {
    term: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
const KNN_QUERY = exports.KNN_QUERY = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    knn: {
      [VECTOR_FIELD_PATTERN]: {
        vector: VECTOR_PATTERN,
        k: DEFAULT_K
      }
    }
  },
  size: 10
};
const SEMANTIC_SEARCH_QUERY_NEURAL = exports.SEMANTIC_SEARCH_QUERY_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural: {
      [VECTOR_FIELD_PATTERN]: {
        query_text: QUERY_TEXT_PATTERN,
        model_id: MODEL_ID_PATTERN,
        k: DEFAULT_K
      }
    }
  }
};
const MULTIMODAL_SEARCH_QUERY_NEURAL = exports.MULTIMODAL_SEARCH_QUERY_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural: {
      [VECTOR_FIELD_PATTERN]: {
        query_text: QUERY_TEXT_PATTERN,
        query_image: QUERY_IMAGE_PATTERN,
        model_id: MODEL_ID_PATTERN,
        k: DEFAULT_K
      }
    }
  }
};
const MULTIMODAL_SEARCH_QUERY_BOOL = exports.MULTIMODAL_SEARCH_QUERY_BOOL = {
  query: {
    bool: {
      must: [{
        match: {
          [TEXT_FIELD_PATTERN]: QUERY_TEXT_PATTERN
        }
      }, {
        match: {
          [IMAGE_FIELD_PATTERN]: QUERY_IMAGE_PATTERN
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_KNN = exports.HYBRID_SEARCH_QUERY_MATCH_KNN = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        knn: {
          [VECTOR_FIELD_PATTERN]: {
            vector: VECTOR_PATTERN,
            k: DEFAULT_K
          }
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_NEURAL = exports.HYBRID_SEARCH_QUERY_MATCH_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        neural: {
          [VECTOR_FIELD_PATTERN]: {
            query_text: QUERY_TEXT_PATTERN,
            model_id: MODEL_ID_PATTERN,
            k: DEFAULT_K
          }
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_TERM = exports.HYBRID_SEARCH_QUERY_MATCH_TERM = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        term: {
          [TEXT_FIELD_PATTERN]: {
            value: QUERY_TEXT_PATTERN
          }
        }
      }]
    }
  }
};
const QUERY_PRESETS = exports.QUERY_PRESETS = [{
  name: 'Fetch all',
  query: (0, _utils.customStringify)(FETCH_ALL_QUERY)
}, {
  name: 'Term',
  query: (0, _utils.customStringify)(TERM_QUERY_TEXT)
}, {
  name: 'Basic k-NN',
  query: (0, _utils.customStringify)(KNN_QUERY)
}, {
  name: WORKFLOW_TYPE.MULTIMODAL_SEARCH,
  query: (0, _utils.customStringify)(MULTIMODAL_SEARCH_QUERY_BOOL)
}, {
  name: `Hybrid search (match & k-NN queries)`,
  query: (0, _utils.customStringify)(HYBRID_SEARCH_QUERY_MATCH_KNN)
}, {
  name: `Hybrid search (match & term queries)`,
  query: (0, _utils.customStringify)(HYBRID_SEARCH_QUERY_MATCH_TERM)
}];

/**
 * DEFAULT TEMPLATE VAR NAMES
 */
const DEFAULT_PROMPT_RESULTS_FIELD = exports.DEFAULT_PROMPT_RESULTS_FIELD = 'results';
const DEFAULT_PROMPT_QUESTION_FIELD = exports.DEFAULT_PROMPT_QUESTION_FIELD = 'question';
const DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = exports.DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = 'textCategory';
const DEFAULT_PROMPT_ROLE_FIELD = exports.DEFAULT_PROMPT_ROLE_FIELD = 'role';

/**
 * PROMPT PRESETS. Based off of https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-templates-and-examples.html
 */
const GENERAL_SUMMARIZE_PROMPT = exports.GENERAL_SUMMARIZE_PROMPT = 'Read the following text: \
\n\n${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()} \
\n\nSummarize the text in one sentence.';
const GENERAL_QA_WITH_CONTEXT_PROMPT = exports.GENERAL_QA_WITH_CONTEXT_PROMPT = 'Read the following text, and answer the question at the end: \
\n\n${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()} \
\n\n${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}';
const GENERAL_QA_NO_CONTEXT_PROMPT = exports.GENERAL_QA_NO_CONTEXT_PROMPT = 'Answer the following question: \
${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}';
const GENERAL_TEXT_GENERATION_PROMPT = exports.GENERAL_TEXT_GENERATION_PROMPT = 'Please write a ${parameters.' + DEFAULT_PROMPT_TEXT_CATEGORY_FIELD + '.toString()} in the voice of ${parameters.' + DEFAULT_PROMPT_ROLE_FIELD + '.toString()}';
const CLAUDE_SUMMARIZE_PROMPT = exports.CLAUDE_SUMMARIZE_PROMPT = 'Human: read the following results inside the <text></text> XML tags:\n\n<text>\n\
${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + ".toString()}\n</text>\n\n\
Summarize the above results in one sentence. If you don't know the answer, just \
say I don't know.\
\n\nAssistant:";
const CLAUDE_QA_WITH_CONTEXT_PROMPT = exports.CLAUDE_QA_WITH_CONTEXT_PROMPT = 'Human: read the following results inside the <text></text> XML tags, and then answer the question:\
\n\n<text>\n\
${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()}\n\
</text>\n\n' + '${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}\n\nAssistant:';
const PROMPT_PRESETS = exports.PROMPT_PRESETS = [{
  name: 'Summarize text',
  prompt: GENERAL_SUMMARIZE_PROMPT
}, {
  name: 'Question-answer, with context',
  prompt: GENERAL_QA_WITH_CONTEXT_PROMPT
}, {
  name: 'Question-answer, without context',
  prompt: GENERAL_QA_NO_CONTEXT_PROMPT
}, {
  name: 'Text generation',
  prompt: GENERAL_TEXT_GENERATION_PROMPT
}, {
  name: 'Summarize text (Claude)',
  prompt: CLAUDE_SUMMARIZE_PROMPT
}, {
  name: 'Question-answer, with context (Claude)',
  prompt: CLAUDE_QA_WITH_CONTEXT_PROMPT
}];

/**
 * MISCELLANEOUS
 */
let PROCESSOR_CONTEXT = exports.PROCESSOR_CONTEXT = /*#__PURE__*/function (PROCESSOR_CONTEXT) {
  PROCESSOR_CONTEXT["INGEST"] = "ingest";
  PROCESSOR_CONTEXT["SEARCH_REQUEST"] = "search_request";
  PROCESSOR_CONTEXT["SEARCH_RESPONSE"] = "search_response";
  return PROCESSOR_CONTEXT;
}({});
const NO_TRANSFORMATION = exports.NO_TRANSFORMATION = 'No transformation';
let TRANSFORM_CONTEXT = exports.TRANSFORM_CONTEXT = /*#__PURE__*/function (TRANSFORM_CONTEXT) {
  TRANSFORM_CONTEXT["INPUT"] = "input";
  TRANSFORM_CONTEXT["OUTPUT"] = "output";
  return TRANSFORM_CONTEXT;
}({});
let TRANSFORM_TYPE = exports.TRANSFORM_TYPE = /*#__PURE__*/function (TRANSFORM_TYPE) {
  TRANSFORM_TYPE["STRING"] = "Custom string";
  TRANSFORM_TYPE["FIELD"] = "Data field";
  TRANSFORM_TYPE["EXPRESSION"] = "JSONPath expression";
  TRANSFORM_TYPE["TEMPLATE"] = "Prompt";
  return TRANSFORM_TYPE;
}({});
const INPUT_TRANSFORM_OPTIONS = exports.INPUT_TRANSFORM_OPTIONS = [{
  id: TRANSFORM_TYPE.FIELD,
  description: 'Use an existing field from your data as the model input field.'
}, {
  id: TRANSFORM_TYPE.EXPRESSION,
  description: 'Extract data from a JSON structure and map the extracted data to the model input field.'
}, {
  id: TRANSFORM_TYPE.TEMPLATE,
  description: 'Configure a prompt to map data to the model input field.'
}, {
  id: TRANSFORM_TYPE.STRING,
  description: 'Use a custom string in the model input field.'
}];
const OUTPUT_TRANSFORM_OPTIONS = exports.OUTPUT_TRANSFORM_OPTIONS = [{
  id: NO_TRANSFORMATION,
  description: ''
}, {
  id: TRANSFORM_TYPE.FIELD,
  description: 'Copy the model output into a new document field.'
}, {
  id: TRANSFORM_TYPE.EXPRESSION,
  description: 'Extract data from a JSON structure and map the extracted data to a new document field.'
}];
const DEFAULT_NEW_WORKFLOW_NAME = exports.DEFAULT_NEW_WORKFLOW_NAME = 'new_workflow';
const DEFAULT_NEW_WORKFLOW_DESCRIPTION = exports.DEFAULT_NEW_WORKFLOW_DESCRIPTION = 'My new workflow';
const DEFAULT_NEW_WORKFLOW_STATE_TYPE = exports.DEFAULT_NEW_WORKFLOW_STATE_TYPE = 'NOT_STARTED';
const DATE_FORMAT_PATTERN = exports.DATE_FORMAT_PATTERN = 'MM/DD/YY hh:mm A';
const EMPTY_FIELD_STRING = exports.EMPTY_FIELD_STRING = '--';
const OMIT_SYSTEM_INDEX_PATTERN = exports.OMIT_SYSTEM_INDEX_PATTERN = '*,-.*';
const INDEX_NOT_FOUND_EXCEPTION = exports.INDEX_NOT_FOUND_EXCEPTION = 'index_not_found_exception';
const ERROR_GETTING_WORKFLOW_MSG = exports.ERROR_GETTING_WORKFLOW_MSG = 'Failed to retrieve template';
const INVALID_DATASOURCE_MSG = exports.INVALID_DATASOURCE_MSG = 'No Living connections';
const NO_TEMPLATES_FOUND_MSG = exports.NO_TEMPLATES_FOUND_MSG = 'There are no templates';
const NO_MODIFICATIONS_FOUND_TEXT = exports.NO_MODIFICATIONS_FOUND_TEXT = 'Template does not contain any modifications';
const JSONPATH_ROOT_SELECTOR = exports.JSONPATH_ROOT_SELECTOR = '$';
const REQUEST_PREFIX = exports.REQUEST_PREFIX = '_request.';
const REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = exports.REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = '$._request.';
const WORKFLOW_NAME_RESTRICTIONS = exports.WORKFLOW_NAME_RESTRICTIONS = 'Invalid workflow name. Valid characters are a-z, A-Z, 0-9, -(hyphen), _(underscore).';
let SORT_ORDER = exports.SORT_ORDER = /*#__PURE__*/function (SORT_ORDER) {
  SORT_ORDER["ASC"] = "asc";
  SORT_ORDER["DESC"] = "desc";
  return SORT_ORDER;
}({});
const MAX_DOCS = exports.MAX_DOCS = 1000;
const MAX_DOCS_TO_IMPORT = exports.MAX_DOCS_TO_IMPORT = 100;
const MAX_STRING_LENGTH = exports.MAX_STRING_LENGTH = 100;
const MAX_DESCRIPTION_LENGTH = exports.MAX_DESCRIPTION_LENGTH = 1000;
const MAX_JSON_STRING_LENGTH = exports.MAX_JSON_STRING_LENGTH = 10000;
const MAX_TEMPLATE_STRING_LENGTH = exports.MAX_TEMPLATE_STRING_LENGTH = 10000;
const MAX_BYTES = exports.MAX_BYTES = 1048576; // OSD REST request payload size limit
const MAX_BYTES_FORMATTED = exports.MAX_BYTES_FORMATTED = '1,048,576';
const MAX_WORKFLOW_NAME_TO_DISPLAY = exports.MAX_WORKFLOW_NAME_TO_DISPLAY = 40;
const WORKFLOW_NAME_REGEXP = exports.WORKFLOW_NAME_REGEXP = RegExp('^[a-zA-Z0-9_-]*$');
const INDEX_NAME_REGEXP = exports.INDEX_NAME_REGEXP = WORKFLOW_NAME_REGEXP;
const EMPTY_MAP_ENTRY = exports.EMPTY_MAP_ENTRY = {
  key: '',
  value: ''
};
const EMPTY_INPUT_MAP_ENTRY = exports.EMPTY_INPUT_MAP_ENTRY = {
  key: '',
  value: {
    transformType: TRANSFORM_TYPE.FIELD,
    value: ''
  }
};
const EMPTY_OUTPUT_MAP_ENTRY = exports.EMPTY_OUTPUT_MAP_ENTRY = {
  ...EMPTY_INPUT_MAP_ENTRY,
  value: {
    ...EMPTY_INPUT_MAP_ENTRY.value,
    transformType: NO_TRANSFORMATION
  }
};
const MODEL_OUTPUT_SCHEMA_NESTED_PATH = exports.MODEL_OUTPUT_SCHEMA_NESTED_PATH = 'output.properties.inference_results.items.properties.output.items.properties.dataAsMap.properties';
const MODEL_OUTPUT_SCHEMA_FULL_PATH = exports.MODEL_OUTPUT_SCHEMA_FULL_PATH = 'output.properties';
let CONFIG_STEP = exports.CONFIG_STEP = /*#__PURE__*/function (CONFIG_STEP) {
  CONFIG_STEP["INGEST"] = "Ingest pipeline";
  CONFIG_STEP["SEARCH"] = "Search pipeline";
  return CONFIG_STEP;
}({});
let SOURCE_OPTIONS = exports.SOURCE_OPTIONS = /*#__PURE__*/function (SOURCE_OPTIONS) {
  SOURCE_OPTIONS["MANUAL"] = "manual";
  SOURCE_OPTIONS["UPLOAD"] = "upload";
  SOURCE_OPTIONS["EXISTING_INDEX"] = "existing_index";
  return SOURCE_OPTIONS;
}({});
let INSPECTOR_TAB_ID = exports.INSPECTOR_TAB_ID = /*#__PURE__*/function (INSPECTOR_TAB_ID) {
  INSPECTOR_TAB_ID["TEST"] = "test";
  INSPECTOR_TAB_ID["INGEST"] = "ingest";
  INSPECTOR_TAB_ID["ERRORS"] = "errors";
  INSPECTOR_TAB_ID["RESOURCES"] = "resources";
  return INSPECTOR_TAB_ID;
}({});
const INSPECTOR_TABS = exports.INSPECTOR_TABS = [{
  id: INSPECTOR_TAB_ID.TEST,
  name: 'Test flow',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.INGEST,
  name: 'Ingest response',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.ERRORS,
  name: 'Errors',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.RESOURCES,
  name: 'Resources',
  disabled: false
}];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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