"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OllyChatService = void 0;
var _constants = require("../../utils/constants");
var _get_agent = require("../../routes/get_agent");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const MEMORY_ID_FIELD = 'memory_id';
const INTERACTION_ID_FIELD = 'parent_interaction_id';
class OllyChatService {
  constructor(opensearchClientTransport) {
    this.opensearchClientTransport = opensearchClientTransport;
  }
  async getRootAgent() {
    return await (0, _get_agent.getAgentIdByConfigName)(_constants.ROOT_AGENT_CONFIG_ID, this.opensearchClientTransport);
  }
  async requestAgentRun(payload) {
    if (payload.memory_id) {
      OllyChatService.abortControllers.set(payload.memory_id, new AbortController());
    }
    const rootAgentId = await this.getRootAgent();
    return await this.callExecuteAgentAPI(payload, rootAgentId);
  }
  async callExecuteAgentAPI(payload, rootAgentId) {
    try {
      var _agentFrameworkRespon;
      const agentFrameworkResponse = await this.opensearchClientTransport.request({
        method: 'POST',
        path: `${_constants.ML_COMMONS_BASE_API}/agents/${rootAgentId}/_execute`,
        body: {
          parameters: payload
        }
      }, {
        /**
         * It is time-consuming for LLM to generate final answer
         * Give it a large timeout window
         */
        requestTimeout: 5 * 60 * 1000,
        /**
         * Do not retry
         */
        maxRetries: 0
      });
      const outputBody = (_agentFrameworkRespon = agentFrameworkResponse.body.inference_results) === null || _agentFrameworkRespon === void 0 || (_agentFrameworkRespon = _agentFrameworkRespon[0]) === null || _agentFrameworkRespon === void 0 ? void 0 : _agentFrameworkRespon.output;
      const conversationIdItem = outputBody === null || outputBody === void 0 ? void 0 : outputBody.find(item => item.name === MEMORY_ID_FIELD);
      const interactionIdItem = outputBody === null || outputBody === void 0 ? void 0 : outputBody.find(item => item.name === INTERACTION_ID_FIELD);
      return {
        /**
         * Interactions will be stored in Agent framework,
         * thus we do not need to return the latest message back.
         */
        messages: [],
        conversationId: (conversationIdItem === null || conversationIdItem === void 0 ? void 0 : conversationIdItem.result) || '',
        interactionId: (interactionIdItem === null || interactionIdItem === void 0 ? void 0 : interactionIdItem.result) || ''
      };
    } catch (error) {
      throw error;
    } finally {
      if (payload.memory_id) {
        OllyChatService.abortControllers.delete(payload.memory_id);
      }
    }
  }
  async requestLLM(payload) {
    var _input$context;
    const {
      input,
      conversationId
    } = payload;
    let llmInput = input.content;
    if ((_input$context = input.context) !== null && _input$context !== void 0 && _input$context.content) {
      var _input$context2;
      llmInput = `Based on the context: ${(_input$context2 = input.context) === null || _input$context2 === void 0 ? void 0 : _input$context2.content}, answer question: ${input.content}`;
    }
    const parametersPayload = {
      question: llmInput,
      verbose: false
    };
    if (input.promptPrefix) {
      parametersPayload['prompt.prefix'] = input.promptPrefix;
    }
    if (conversationId) {
      parametersPayload.memory_id = conversationId;
    }
    return await this.requestAgentRun(parametersPayload);
  }
  async regenerate(payload) {
    const {
      conversationId,
      interactionId
    } = payload;
    const parametersPayload = {
      memory_id: conversationId,
      regenerate_interaction_id: interactionId,
      verbose: false
    };
    return await this.requestAgentRun(parametersPayload);
  }
  abortAgentExecution(conversationId) {
    if (OllyChatService.abortControllers.has(conversationId)) {
      var _OllyChatService$abor;
      (_OllyChatService$abor = OllyChatService.abortControllers.get(conversationId)) === null || _OllyChatService$abor === void 0 || _OllyChatService$abor.abort();
    }
  }
}
exports.OllyChatService = OllyChatService;
_defineProperty(OllyChatService, "abortControllers", new Map());
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uc3RhbnRzIiwicmVxdWlyZSIsIl9nZXRfYWdlbnQiLCJfZGVmaW5lUHJvcGVydHkiLCJvYmoiLCJrZXkiLCJ2YWx1ZSIsIl90b1Byb3BlcnR5S2V5IiwiT2JqZWN0IiwiZGVmaW5lUHJvcGVydHkiLCJlbnVtZXJhYmxlIiwiY29uZmlndXJhYmxlIiwid3JpdGFibGUiLCJhcmciLCJfdG9QcmltaXRpdmUiLCJTdHJpbmciLCJpbnB1dCIsImhpbnQiLCJwcmltIiwiU3ltYm9sIiwidG9QcmltaXRpdmUiLCJ1bmRlZmluZWQiLCJyZXMiLCJjYWxsIiwiVHlwZUVycm9yIiwiTnVtYmVyIiwiTUVNT1JZX0lEX0ZJRUxEIiwiSU5URVJBQ1RJT05fSURfRklFTEQiLCJPbGx5Q2hhdFNlcnZpY2UiLCJjb25zdHJ1Y3RvciIsIm9wZW5zZWFyY2hDbGllbnRUcmFuc3BvcnQiLCJnZXRSb290QWdlbnQiLCJnZXRBZ2VudElkQnlDb25maWdOYW1lIiwiUk9PVF9BR0VOVF9DT05GSUdfSUQiLCJyZXF1ZXN0QWdlbnRSdW4iLCJwYXlsb2FkIiwibWVtb3J5X2lkIiwiYWJvcnRDb250cm9sbGVycyIsInNldCIsIkFib3J0Q29udHJvbGxlciIsInJvb3RBZ2VudElkIiwiY2FsbEV4ZWN1dGVBZ2VudEFQSSIsIl9hZ2VudEZyYW1ld29ya1Jlc3BvbiIsImFnZW50RnJhbWV3b3JrUmVzcG9uc2UiLCJyZXF1ZXN0IiwibWV0aG9kIiwicGF0aCIsIk1MX0NPTU1PTlNfQkFTRV9BUEkiLCJib2R5IiwicGFyYW1ldGVycyIsInJlcXVlc3RUaW1lb3V0IiwibWF4UmV0cmllcyIsIm91dHB1dEJvZHkiLCJpbmZlcmVuY2VfcmVzdWx0cyIsIm91dHB1dCIsImNvbnZlcnNhdGlvbklkSXRlbSIsImZpbmQiLCJpdGVtIiwibmFtZSIsImludGVyYWN0aW9uSWRJdGVtIiwibWVzc2FnZXMiLCJjb252ZXJzYXRpb25JZCIsInJlc3VsdCIsImludGVyYWN0aW9uSWQiLCJlcnJvciIsImRlbGV0ZSIsInJlcXVlc3RMTE0iLCJfaW5wdXQkY29udGV4dCIsImxsbUlucHV0IiwiY29udGVudCIsImNvbnRleHQiLCJfaW5wdXQkY29udGV4dDIiLCJwYXJhbWV0ZXJzUGF5bG9hZCIsInF1ZXN0aW9uIiwidmVyYm9zZSIsInByb21wdFByZWZpeCIsInJlZ2VuZXJhdGUiLCJyZWdlbmVyYXRlX2ludGVyYWN0aW9uX2lkIiwiYWJvcnRBZ2VudEV4ZWN1dGlvbiIsImhhcyIsIl9PbGx5Q2hhdFNlcnZpY2UkYWJvciIsImdldCIsImFib3J0IiwiZXhwb3J0cyIsIk1hcCJdLCJzb3VyY2VzIjpbIm9sbHlfY2hhdF9zZXJ2aWNlLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHsgQXBpUmVzcG9uc2UgfSBmcm9tICdAb3BlbnNlYXJjaC1wcm9qZWN0L29wZW5zZWFyY2gnO1xuaW1wb3J0IHsgT3BlblNlYXJjaENsaWVudCB9IGZyb20gJy4uLy4uLy4uLy4uLy4uL3NyYy9jb3JlL3NlcnZlcic7XG5pbXBvcnQgeyBJTWVzc2FnZSwgSUlucHV0IH0gZnJvbSAnLi4vLi4vLi4vY29tbW9uL3R5cGVzL2NoYXRfc2F2ZWRfb2JqZWN0X2F0dHJpYnV0ZXMnO1xuaW1wb3J0IHsgQ2hhdFNlcnZpY2UgfSBmcm9tICcuL2NoYXRfc2VydmljZSc7XG5pbXBvcnQgeyBNTF9DT01NT05TX0JBU0VfQVBJLCBST09UX0FHRU5UX0NPTkZJR19JRCB9IGZyb20gJy4uLy4uL3V0aWxzL2NvbnN0YW50cyc7XG5pbXBvcnQgeyBnZXRBZ2VudElkQnlDb25maWdOYW1lIH0gZnJvbSAnLi4vLi4vcm91dGVzL2dldF9hZ2VudCc7XG5cbmludGVyZmFjZSBBZ2VudFJ1blBheWxvYWQge1xuICBxdWVzdGlvbj86IHN0cmluZztcbiAgdmVyYm9zZT86IGJvb2xlYW47XG4gIG1lbW9yeV9pZD86IHN0cmluZztcbiAgcmVnZW5lcmF0ZV9pbnRlcmFjdGlvbl9pZD86IHN0cmluZztcbiAgJ3Byb21wdC5wcmVmaXgnPzogc3RyaW5nO1xufVxuXG5jb25zdCBNRU1PUllfSURfRklFTEQgPSAnbWVtb3J5X2lkJztcbmNvbnN0IElOVEVSQUNUSU9OX0lEX0ZJRUxEID0gJ3BhcmVudF9pbnRlcmFjdGlvbl9pZCc7XG5cbmV4cG9ydCBjbGFzcyBPbGx5Q2hhdFNlcnZpY2UgaW1wbGVtZW50cyBDaGF0U2VydmljZSB7XG4gIHN0YXRpYyBhYm9ydENvbnRyb2xsZXJzOiBNYXA8c3RyaW5nLCBBYm9ydENvbnRyb2xsZXI+ID0gbmV3IE1hcCgpO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgb3BlbnNlYXJjaENsaWVudFRyYW5zcG9ydDogT3BlblNlYXJjaENsaWVudFsndHJhbnNwb3J0J10pIHt9XG5cbiAgcHJpdmF0ZSBhc3luYyBnZXRSb290QWdlbnQoKTogUHJvbWlzZTxzdHJpbmc+IHtcbiAgICByZXR1cm4gYXdhaXQgZ2V0QWdlbnRJZEJ5Q29uZmlnTmFtZShST09UX0FHRU5UX0NPTkZJR19JRCwgdGhpcy5vcGVuc2VhcmNoQ2xpZW50VHJhbnNwb3J0KTtcbiAgfVxuXG4gIHByaXZhdGUgYXN5bmMgcmVxdWVzdEFnZW50UnVuKHBheWxvYWQ6IEFnZW50UnVuUGF5bG9hZCkge1xuICAgIGlmIChwYXlsb2FkLm1lbW9yeV9pZCkge1xuICAgICAgT2xseUNoYXRTZXJ2aWNlLmFib3J0Q29udHJvbGxlcnMuc2V0KHBheWxvYWQubWVtb3J5X2lkLCBuZXcgQWJvcnRDb250cm9sbGVyKCkpO1xuICAgIH1cblxuICAgIGNvbnN0IHJvb3RBZ2VudElkID0gYXdhaXQgdGhpcy5nZXRSb290QWdlbnQoKTtcbiAgICByZXR1cm4gYXdhaXQgdGhpcy5jYWxsRXhlY3V0ZUFnZW50QVBJKHBheWxvYWQsIHJvb3RBZ2VudElkKTtcbiAgfVxuXG4gIHByaXZhdGUgYXN5bmMgY2FsbEV4ZWN1dGVBZ2VudEFQSShwYXlsb2FkOiBBZ2VudFJ1blBheWxvYWQsIHJvb3RBZ2VudElkOiBzdHJpbmcpIHtcbiAgICB0cnkge1xuICAgICAgY29uc3QgYWdlbnRGcmFtZXdvcmtSZXNwb25zZSA9IChhd2FpdCB0aGlzLm9wZW5zZWFyY2hDbGllbnRUcmFuc3BvcnQucmVxdWVzdChcbiAgICAgICAge1xuICAgICAgICAgIG1ldGhvZDogJ1BPU1QnLFxuICAgICAgICAgIHBhdGg6IGAke01MX0NPTU1PTlNfQkFTRV9BUEl9L2FnZW50cy8ke3Jvb3RBZ2VudElkfS9fZXhlY3V0ZWAsXG4gICAgICAgICAgYm9keToge1xuICAgICAgICAgICAgcGFyYW1ldGVyczogcGF5bG9hZCxcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgLyoqXG4gICAgICAgICAgICogSXQgaXMgdGltZS1jb25zdW1pbmcgZm9yIExMTSB0byBnZW5lcmF0ZSBmaW5hbCBhbnN3ZXJcbiAgICAgICAgICAgKiBHaXZlIGl0IGEgbGFyZ2UgdGltZW91dCB3aW5kb3dcbiAgICAgICAgICAgKi9cbiAgICAgICAgICByZXF1ZXN0VGltZW91dDogNSAqIDYwICogMTAwMCxcbiAgICAgICAgICAvKipcbiAgICAgICAgICAgKiBEbyBub3QgcmV0cnlcbiAgICAgICAgICAgKi9cbiAgICAgICAgICBtYXhSZXRyaWVzOiAwLFxuICAgICAgICB9XG4gICAgICApKSBhcyBBcGlSZXNwb25zZTx7XG4gICAgICAgIGluZmVyZW5jZV9yZXN1bHRzOiBBcnJheTx7XG4gICAgICAgICAgb3V0cHV0OiBBcnJheTx7IG5hbWU6IHN0cmluZzsgcmVzdWx0Pzogc3RyaW5nIH0+O1xuICAgICAgICB9PjtcbiAgICAgIH0+O1xuICAgICAgY29uc3Qgb3V0cHV0Qm9keSA9IGFnZW50RnJhbWV3b3JrUmVzcG9uc2UuYm9keS5pbmZlcmVuY2VfcmVzdWx0cz8uWzBdPy5vdXRwdXQ7XG4gICAgICBjb25zdCBjb252ZXJzYXRpb25JZEl0ZW0gPSBvdXRwdXRCb2R5Py5maW5kKChpdGVtKSA9PiBpdGVtLm5hbWUgPT09IE1FTU9SWV9JRF9GSUVMRCk7XG4gICAgICBjb25zdCBpbnRlcmFjdGlvbklkSXRlbSA9IG91dHB1dEJvZHk/LmZpbmQoKGl0ZW0pID0+IGl0ZW0ubmFtZSA9PT0gSU5URVJBQ1RJT05fSURfRklFTEQpO1xuICAgICAgcmV0dXJuIHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIEludGVyYWN0aW9ucyB3aWxsIGJlIHN0b3JlZCBpbiBBZ2VudCBmcmFtZXdvcmssXG4gICAgICAgICAqIHRodXMgd2UgZG8gbm90IG5lZWQgdG8gcmV0dXJuIHRoZSBsYXRlc3QgbWVzc2FnZSBiYWNrLlxuICAgICAgICAgKi9cbiAgICAgICAgbWVzc2FnZXM6IFtdLFxuICAgICAgICBjb252ZXJzYXRpb25JZDogY29udmVyc2F0aW9uSWRJdGVtPy5yZXN1bHQgfHwgJycsXG4gICAgICAgIGludGVyYWN0aW9uSWQ6IGludGVyYWN0aW9uSWRJdGVtPy5yZXN1bHQgfHwgJycsXG4gICAgICB9O1xuICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICB0aHJvdyBlcnJvcjtcbiAgICB9IGZpbmFsbHkge1xuICAgICAgaWYgKHBheWxvYWQubWVtb3J5X2lkKSB7XG4gICAgICAgIE9sbHlDaGF0U2VydmljZS5hYm9ydENvbnRyb2xsZXJzLmRlbGV0ZShwYXlsb2FkLm1lbW9yeV9pZCk7XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgYXN5bmMgcmVxdWVzdExMTShwYXlsb2FkOiB7XG4gICAgbWVzc2FnZXM6IElNZXNzYWdlW107XG4gICAgaW5wdXQ6IElJbnB1dDtcbiAgICBjb252ZXJzYXRpb25JZD86IHN0cmluZztcbiAgfSk6IFByb21pc2U8e1xuICAgIG1lc3NhZ2VzOiBJTWVzc2FnZVtdO1xuICAgIGNvbnZlcnNhdGlvbklkOiBzdHJpbmc7XG4gICAgaW50ZXJhY3Rpb25JZDogc3RyaW5nO1xuICB9PiB7XG4gICAgY29uc3QgeyBpbnB1dCwgY29udmVyc2F0aW9uSWQgfSA9IHBheWxvYWQ7XG5cbiAgICBsZXQgbGxtSW5wdXQgPSBpbnB1dC5jb250ZW50O1xuICAgIGlmIChpbnB1dC5jb250ZXh0Py5jb250ZW50KSB7XG4gICAgICBsbG1JbnB1dCA9IGBCYXNlZCBvbiB0aGUgY29udGV4dDogJHtpbnB1dC5jb250ZXh0Py5jb250ZW50fSwgYW5zd2VyIHF1ZXN0aW9uOiAke2lucHV0LmNvbnRlbnR9YDtcbiAgICB9XG4gICAgY29uc3QgcGFyYW1ldGVyc1BheWxvYWQ6IFBpY2s8XG4gICAgICBBZ2VudFJ1blBheWxvYWQsXG4gICAgICAncXVlc3Rpb24nIHwgJ3ZlcmJvc2UnIHwgJ21lbW9yeV9pZCcgfCAncHJvbXB0LnByZWZpeCdcbiAgICA+ID0ge1xuICAgICAgcXVlc3Rpb246IGxsbUlucHV0LFxuICAgICAgdmVyYm9zZTogZmFsc2UsXG4gICAgfTtcblxuICAgIGlmIChpbnB1dC5wcm9tcHRQcmVmaXgpIHtcbiAgICAgIHBhcmFtZXRlcnNQYXlsb2FkWydwcm9tcHQucHJlZml4J10gPSBpbnB1dC5wcm9tcHRQcmVmaXg7XG4gICAgfVxuXG4gICAgaWYgKGNvbnZlcnNhdGlvbklkKSB7XG4gICAgICBwYXJhbWV0ZXJzUGF5bG9hZC5tZW1vcnlfaWQgPSBjb252ZXJzYXRpb25JZDtcbiAgICB9XG5cbiAgICByZXR1cm4gYXdhaXQgdGhpcy5yZXF1ZXN0QWdlbnRSdW4ocGFyYW1ldGVyc1BheWxvYWQpO1xuICB9XG5cbiAgYXN5bmMgcmVnZW5lcmF0ZShwYXlsb2FkOiB7XG4gICAgY29udmVyc2F0aW9uSWQ6IHN0cmluZztcbiAgICBpbnRlcmFjdGlvbklkOiBzdHJpbmc7XG4gIH0pOiBQcm9taXNlPHsgbWVzc2FnZXM6IElNZXNzYWdlW107IGNvbnZlcnNhdGlvbklkOiBzdHJpbmc7IGludGVyYWN0aW9uSWQ6IHN0cmluZyB9PiB7XG4gICAgY29uc3QgeyBjb252ZXJzYXRpb25JZCwgaW50ZXJhY3Rpb25JZCB9ID0gcGF5bG9hZDtcbiAgICBjb25zdCBwYXJhbWV0ZXJzUGF5bG9hZDogUGljazxcbiAgICAgIEFnZW50UnVuUGF5bG9hZCxcbiAgICAgICdyZWdlbmVyYXRlX2ludGVyYWN0aW9uX2lkJyB8ICd2ZXJib3NlJyB8ICdtZW1vcnlfaWQnXG4gICAgPiA9IHtcbiAgICAgIG1lbW9yeV9pZDogY29udmVyc2F0aW9uSWQsXG4gICAgICByZWdlbmVyYXRlX2ludGVyYWN0aW9uX2lkOiBpbnRlcmFjdGlvbklkLFxuICAgICAgdmVyYm9zZTogZmFsc2UsXG4gICAgfTtcblxuICAgIHJldHVybiBhd2FpdCB0aGlzLnJlcXVlc3RBZ2VudFJ1bihwYXJhbWV0ZXJzUGF5bG9hZCk7XG4gIH1cblxuICBhYm9ydEFnZW50RXhlY3V0aW9uKGNvbnZlcnNhdGlvbklkOiBzdHJpbmcpIHtcbiAgICBpZiAoT2xseUNoYXRTZXJ2aWNlLmFib3J0Q29udHJvbGxlcnMuaGFzKGNvbnZlcnNhdGlvbklkKSkge1xuICAgICAgT2xseUNoYXRTZXJ2aWNlLmFib3J0Q29udHJvbGxlcnMuZ2V0KGNvbnZlcnNhdGlvbklkKT8uYWJvcnQoKTtcbiAgICB9XG4gIH1cbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBU0EsSUFBQUEsVUFBQSxHQUFBQyxPQUFBO0FBQ0EsSUFBQUMsVUFBQSxHQUFBRCxPQUFBO0FBQWdFLFNBQUFFLGdCQUFBQyxHQUFBLEVBQUFDLEdBQUEsRUFBQUMsS0FBQSxJQUFBRCxHQUFBLEdBQUFFLGNBQUEsQ0FBQUYsR0FBQSxPQUFBQSxHQUFBLElBQUFELEdBQUEsSUFBQUksTUFBQSxDQUFBQyxjQUFBLENBQUFMLEdBQUEsRUFBQUMsR0FBQSxJQUFBQyxLQUFBLEVBQUFBLEtBQUEsRUFBQUksVUFBQSxRQUFBQyxZQUFBLFFBQUFDLFFBQUEsb0JBQUFSLEdBQUEsQ0FBQUMsR0FBQSxJQUFBQyxLQUFBLFdBQUFGLEdBQUE7QUFBQSxTQUFBRyxlQUFBTSxHQUFBLFFBQUFSLEdBQUEsR0FBQVMsWUFBQSxDQUFBRCxHQUFBLDJCQUFBUixHQUFBLGdCQUFBQSxHQUFBLEdBQUFVLE1BQUEsQ0FBQVYsR0FBQTtBQUFBLFNBQUFTLGFBQUFFLEtBQUEsRUFBQUMsSUFBQSxlQUFBRCxLQUFBLGlCQUFBQSxLQUFBLGtCQUFBQSxLQUFBLE1BQUFFLElBQUEsR0FBQUYsS0FBQSxDQUFBRyxNQUFBLENBQUFDLFdBQUEsT0FBQUYsSUFBQSxLQUFBRyxTQUFBLFFBQUFDLEdBQUEsR0FBQUosSUFBQSxDQUFBSyxJQUFBLENBQUFQLEtBQUEsRUFBQUMsSUFBQSwyQkFBQUssR0FBQSxzQkFBQUEsR0FBQSxZQUFBRSxTQUFBLDREQUFBUCxJQUFBLGdCQUFBRixNQUFBLEdBQUFVLE1BQUEsRUFBQVQsS0FBQSxLQVZoRTtBQUNBO0FBQ0E7QUFDQTtBQWlCQSxNQUFNVSxlQUFlLEdBQUcsV0FBVztBQUNuQyxNQUFNQyxvQkFBb0IsR0FBRyx1QkFBdUI7QUFFN0MsTUFBTUMsZUFBZSxDQUF3QjtFQUdsREMsV0FBV0EsQ0FBa0JDLHlCQUF3RCxFQUFFO0lBQUEsS0FBMURBLHlCQUF3RCxHQUF4REEseUJBQXdEO0VBQUc7RUFFeEYsTUFBY0MsWUFBWUEsQ0FBQSxFQUFvQjtJQUM1QyxPQUFPLE1BQU0sSUFBQUMsaUNBQXNCLEVBQUNDLCtCQUFvQixFQUFFLElBQUksQ0FBQ0gseUJBQXlCLENBQUM7RUFDM0Y7RUFFQSxNQUFjSSxlQUFlQSxDQUFDQyxPQUF3QixFQUFFO0lBQ3RELElBQUlBLE9BQU8sQ0FBQ0MsU0FBUyxFQUFFO01BQ3JCUixlQUFlLENBQUNTLGdCQUFnQixDQUFDQyxHQUFHLENBQUNILE9BQU8sQ0FBQ0MsU0FBUyxFQUFFLElBQUlHLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDaEY7SUFFQSxNQUFNQyxXQUFXLEdBQUcsTUFBTSxJQUFJLENBQUNULFlBQVksQ0FBQyxDQUFDO0lBQzdDLE9BQU8sTUFBTSxJQUFJLENBQUNVLG1CQUFtQixDQUFDTixPQUFPLEVBQUVLLFdBQVcsQ0FBQztFQUM3RDtFQUVBLE1BQWNDLG1CQUFtQkEsQ0FBQ04sT0FBd0IsRUFBRUssV0FBbUIsRUFBRTtJQUMvRSxJQUFJO01BQUEsSUFBQUUscUJBQUE7TUFDRixNQUFNQyxzQkFBc0IsR0FBSSxNQUFNLElBQUksQ0FBQ2IseUJBQXlCLENBQUNjLE9BQU8sQ0FDMUU7UUFDRUMsTUFBTSxFQUFFLE1BQU07UUFDZEMsSUFBSSxFQUFHLEdBQUVDLDhCQUFvQixXQUFVUCxXQUFZLFdBQVU7UUFDN0RRLElBQUksRUFBRTtVQUNKQyxVQUFVLEVBQUVkO1FBQ2Q7TUFDRixDQUFDLEVBQ0Q7UUFDRTtBQUNWO0FBQ0E7QUFDQTtRQUNVZSxjQUFjLEVBQUUsQ0FBQyxHQUFHLEVBQUUsR0FBRyxJQUFJO1FBQzdCO0FBQ1Y7QUFDQTtRQUNVQyxVQUFVLEVBQUU7TUFDZCxDQUNGLENBSUU7TUFDRixNQUFNQyxVQUFVLElBQUFWLHFCQUFBLEdBQUdDLHNCQUFzQixDQUFDSyxJQUFJLENBQUNLLGlCQUFpQixjQUFBWCxxQkFBQSxnQkFBQUEscUJBQUEsR0FBN0NBLHFCQUFBLENBQWdELENBQUMsQ0FBQyxjQUFBQSxxQkFBQSx1QkFBbERBLHFCQUFBLENBQW9EWSxNQUFNO01BQzdFLE1BQU1DLGtCQUFrQixHQUFHSCxVQUFVLGFBQVZBLFVBQVUsdUJBQVZBLFVBQVUsQ0FBRUksSUFBSSxDQUFFQyxJQUFJLElBQUtBLElBQUksQ0FBQ0MsSUFBSSxLQUFLaEMsZUFBZSxDQUFDO01BQ3BGLE1BQU1pQyxpQkFBaUIsR0FBR1AsVUFBVSxhQUFWQSxVQUFVLHVCQUFWQSxVQUFVLENBQUVJLElBQUksQ0FBRUMsSUFBSSxJQUFLQSxJQUFJLENBQUNDLElBQUksS0FBSy9CLG9CQUFvQixDQUFDO01BQ3hGLE9BQU87UUFDTDtBQUNSO0FBQ0E7QUFDQTtRQUNRaUMsUUFBUSxFQUFFLEVBQUU7UUFDWkMsY0FBYyxFQUFFLENBQUFOLGtCQUFrQixhQUFsQkEsa0JBQWtCLHVCQUFsQkEsa0JBQWtCLENBQUVPLE1BQU0sS0FBSSxFQUFFO1FBQ2hEQyxhQUFhLEVBQUUsQ0FBQUosaUJBQWlCLGFBQWpCQSxpQkFBaUIsdUJBQWpCQSxpQkFBaUIsQ0FBRUcsTUFBTSxLQUFJO01BQzlDLENBQUM7SUFDSCxDQUFDLENBQUMsT0FBT0UsS0FBSyxFQUFFO01BQ2QsTUFBTUEsS0FBSztJQUNiLENBQUMsU0FBUztNQUNSLElBQUk3QixPQUFPLENBQUNDLFNBQVMsRUFBRTtRQUNyQlIsZUFBZSxDQUFDUyxnQkFBZ0IsQ0FBQzRCLE1BQU0sQ0FBQzlCLE9BQU8sQ0FBQ0MsU0FBUyxDQUFDO01BQzVEO0lBQ0Y7RUFDRjtFQUVBLE1BQU04QixVQUFVQSxDQUFDL0IsT0FJaEIsRUFJRTtJQUFBLElBQUFnQyxjQUFBO0lBQ0QsTUFBTTtNQUFFbkQsS0FBSztNQUFFNkM7SUFBZSxDQUFDLEdBQUcxQixPQUFPO0lBRXpDLElBQUlpQyxRQUFRLEdBQUdwRCxLQUFLLENBQUNxRCxPQUFPO0lBQzVCLEtBQUFGLGNBQUEsR0FBSW5ELEtBQUssQ0FBQ3NELE9BQU8sY0FBQUgsY0FBQSxlQUFiQSxjQUFBLENBQWVFLE9BQU8sRUFBRTtNQUFBLElBQUFFLGVBQUE7TUFDMUJILFFBQVEsR0FBSSx5QkFBc0IsQ0FBQUcsZUFBQSxHQUFFdkQsS0FBSyxDQUFDc0QsT0FBTyxjQUFBQyxlQUFBLHVCQUFiQSxlQUFBLENBQWVGLE9BQVEsc0JBQXFCckQsS0FBSyxDQUFDcUQsT0FBUSxFQUFDO0lBQ2pHO0lBQ0EsTUFBTUcsaUJBR0wsR0FBRztNQUNGQyxRQUFRLEVBQUVMLFFBQVE7TUFDbEJNLE9BQU8sRUFBRTtJQUNYLENBQUM7SUFFRCxJQUFJMUQsS0FBSyxDQUFDMkQsWUFBWSxFQUFFO01BQ3RCSCxpQkFBaUIsQ0FBQyxlQUFlLENBQUMsR0FBR3hELEtBQUssQ0FBQzJELFlBQVk7SUFDekQ7SUFFQSxJQUFJZCxjQUFjLEVBQUU7TUFDbEJXLGlCQUFpQixDQUFDcEMsU0FBUyxHQUFHeUIsY0FBYztJQUM5QztJQUVBLE9BQU8sTUFBTSxJQUFJLENBQUMzQixlQUFlLENBQUNzQyxpQkFBaUIsQ0FBQztFQUN0RDtFQUVBLE1BQU1JLFVBQVVBLENBQUN6QyxPQUdoQixFQUFvRjtJQUNuRixNQUFNO01BQUUwQixjQUFjO01BQUVFO0lBQWMsQ0FBQyxHQUFHNUIsT0FBTztJQUNqRCxNQUFNcUMsaUJBR0wsR0FBRztNQUNGcEMsU0FBUyxFQUFFeUIsY0FBYztNQUN6QmdCLHlCQUF5QixFQUFFZCxhQUFhO01BQ3hDVyxPQUFPLEVBQUU7SUFDWCxDQUFDO0lBRUQsT0FBTyxNQUFNLElBQUksQ0FBQ3hDLGVBQWUsQ0FBQ3NDLGlCQUFpQixDQUFDO0VBQ3REO0VBRUFNLG1CQUFtQkEsQ0FBQ2pCLGNBQXNCLEVBQUU7SUFDMUMsSUFBSWpDLGVBQWUsQ0FBQ1MsZ0JBQWdCLENBQUMwQyxHQUFHLENBQUNsQixjQUFjLENBQUMsRUFBRTtNQUFBLElBQUFtQixxQkFBQTtNQUN4RCxDQUFBQSxxQkFBQSxHQUFBcEQsZUFBZSxDQUFDUyxnQkFBZ0IsQ0FBQzRDLEdBQUcsQ0FBQ3BCLGNBQWMsQ0FBQyxjQUFBbUIscUJBQUEsZUFBcERBLHFCQUFBLENBQXNERSxLQUFLLENBQUMsQ0FBQztJQUMvRDtFQUNGO0FBQ0Y7QUFBQ0MsT0FBQSxDQUFBdkQsZUFBQSxHQUFBQSxlQUFBO0FBQUF6QixlQUFBLENBekhZeUIsZUFBZSxzQkFDOEIsSUFBSXdELEdBQUcsQ0FBQyxDQUFDIn0=