"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alertingPlugin;
var _constants = require("../../utils/constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

function alertingPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.alerting = components.clientAction.namespaceFactory();
  const alerting = Client.prototype.alerting.prototype;
  alerting.searchMonitors = ca({
    url: {
      fmt: `${_constants.API.ALERTING_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.searchAlerts = ca({
    url: {
      fmt: `${_constants.API.ALERTING_BASE}/alerts?size=${_constants.MAX_ALERTS}&monitorId=<%=monitorId%>&sortString=start_time&sortOrder=desc&searchString=start_time:[<%=startTime%>%20TO%20<%=endTime%>]`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        },
        startTime: {
          type: 'number',
          required: true
        },
        endTime: {
          type: 'number',
          required: true
        }
      }
    },
    method: 'GET'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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