"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupIndexRoutes = setupIndexRoutes;
var _constants = require("../utils/constants");
var _configSchema = require("@osd/config-schema");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupIndexRoutes(services, router) {
  const {
    indexService
  } = services;
  router.get({
    path: _constants.API.INDICES_BASE,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, indexService.getIndices);
  router.get({
    path: _constants.API.ALIASES_BASE,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, indexService.getAliases);
  router.post({
    path: `${_constants.API.INDICES_BASE}`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, indexService.getIndexFields);
  router.post({
    path: _constants.API.UPDATE_ALIASES,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, indexService.updateAliases);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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