"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled = false) {
  const {
    dataStreamService
  } = services;
  let getDataStreamsQuerySchema = {
    search: _configSchema.schema.maybe(_configSchema.schema.string())
  };
  if (dataSourceEnabled) {
    getDataStreamsQuerySchema = {
      ...getDataStreamsQuerySchema,
      dataSourceId: _configSchema.schema.string()
    };
  }
  router.get({
    path: _constants.NODE_API._DATA_STREAMS,
    validate: {
      query: _configSchema.schema.object(getDataStreamsQuerySchema)
    }
  }, dataStreamService.getDataStreams);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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