stripFortranLabels=function(fileroot){
    require(stringr)
    scratch_dir  <- "Scratch"
    output_dir <-"Fixed"
    inputfile=paste0(fileroot,".f")
    output_fortran_file=paste(fileroot,".f",sep="")
     code_lines <- readLines(con = inputfile)
#     code_lines <- substring(readLines(con = inputfile), 1, 72)
#    writeLines(code_lines, con = file.path(scratch_dir, "temp.f"))

    system(paste("cp", inputfile," ", file.path(scratch_dir,"temp.f"),sep=" "))
cat("Running gfortran to detect warning lines on unused labels\n")
system2(command = "gfortran",
        args = c("-Wunused", "-c", file.path(scratch_dir, "temp.f"), "-o", file.path(scratch_dir, "temp.o")),
        stderr = file.path(scratch_dir, "gfortran.out"))
cat("Scanning gfortran output for warnings on unusued labels\n")
warnings <- readLines(file.path(scratch_dir, "gfortran.out"))
line_numbers <- grep('/temp.f', warnings)
label_warning_line_numbers <- grep(pattern = "^Warning: Label [0-9]+ at", warnings)
just_warnings <- sum(grepl('Warning:', warnings))

nW <- length(label_warning_line_numbers)
for (i in seq_len(nW)) {
    offending_line <- as.integer(stringr::str_extract(warnings[line_numbers[i]], pattern = "([0-9]+)"))
    code_line <- code_lines[offending_line]
    offending_label <- stringr::str_extract(warnings[label_warning_line_numbers[i]],
                                            pattern = "([0-9]+)")
    code_lines[offending_line] <- sub(pattern = offending_label,
                                      replacement = str_pad("", width = nchar(offending_label)),
                                      x = code_lines[offending_line])
}
writeLines(code_lines, con = file.path(output_dir, output_fortran_file))
}
