"""
disk and partition functions for dmm.
"""

import pathlib
from command_runner import command_runner

def run_parted_commands(disk, commands):
    """
    Iterate through parted commands and return an error if applicable.
    """
    for partedcmd in commands:
        ecode, result = command_runner("parted -s -- %s %s" % (disk, partedcmd))
        if ecode != 0:
            return ecode, result


def losetup(diskimg, mountpoint, loopdev):
    """
    Sets up a loopback device.
    """
    ecode, result = command_runner("losetup -P /dev/%s %s" % (loopdev, diskimg))
    return ecode, result


def losetup_teardown(loopdev):
    """
    Unmounts a loopback device.
    """
    ecode, result = command_runner("losetup -d /dev/%s" % (loopdev))
    return ecode, result


def create_filesystems(partitions):
    """
    Creates a new filesystem on a device.
    """
    for partition in partitions:
        ecode, result = command_runner("mkfs.%s %s %s" % (partition['fstype'], partition['options'], partition['partition']))
        if ecode != 0:
            return ecode, result


def mount(filesystems):
    """
    Mounts filesystems
    """
    for filesystem in filesystems:
        path = pathlib.Path(filesystem['mountpoint'])
        path.mkdir(parents=True, exist_ok=True)
        ecode, result = command_runner("mount -t %s %s %s %s" % (filesystem['fstype'], filesystem['mountopts'],
                  filesystem['source'], filesystem['mountpoint']))
        if ecode != 0:
            return ecode, result

def umount(mounts):
    """
    Unmounts filesystems
    """
    for mount in mounts:
        path = pathlib.Path(mount['mountpoint'])
        ecode, result = command_runner("umount %s" % (mount['mountpoint']))
        if ecode != 0:
            return ecode, result
