---
id: bindings
title: Bindings
sidebar_label: Bindings
slug: /community/bindings
---

As a C library, bindings can be made to call H3 functions from different programming languages. This page lists different bindings currently available. Contributions to this list are welcome, please feel free to open a [pull request](https://github.com/uber/h3/tree/master/website/docs/community/bindings.md).

## Athena

- [daniel-cortez-stevenson/aws-athena-udfs-h3](https://github.com/daniel-cortez-stevenson/aws-athena-udfs-h3)

## Azure Data Explorer

- [Functions for Working with H3 Indexes](https://docs.microsoft.com/en-us/azure/data-explorer/kusto/query/geo-point-to-h3cell-function)

## BigQuery

- [CARTO Analytics Toolbox](https://github.com/CartoDB/analytics-toolbox-core#bigquery)

## C&#35;

- [entrepreneur-interet-general/h3.standard](https://github.com/entrepreneur-interet-general/H3.Standard)
- [richardvasquez/h3net](https://github.com/RichardVasquez/h3net) - A translation instead of a binding
- [pocketken/H3.net](https://github.com/pocketken/H3.net) - A translation instead of a binding

## ClickHouse

- [Functions for Working with H3 Indexes](https://clickhouse.tech/docs/en/sql-reference/functions/geo/h3/)

## Clojure 

- [Factual/geo](https://github.com/Factual/geo)

## Dart 

- [festelo/h3_flutter](https://github.com/festelo/h3_flutter)
- [codewithsam110g/h3_flutter_plus](https://github.com/codewithsam110g/h3_flutter_bindings)

## Databricks

- [H3 geospatial functions](https://docs.databricks.com/sql/language-manual/sql-ref-h3-geospatial-functions.html)

## Delphi

- [SkybuckFlying/h3_delphi](https://github.com/SkybuckFlying/h3_delphi)

## DuckDB

- [isaacbrodsky/h3-duckdb](https://github.com/isaacbrodsky/h3-duckdb)

## ECL

- [hpcc-systems/HPCC-Platform](https://github.com/hpcc-systems/HPCC-Platform/tree/master/plugins/h3)

## Erlang

- [helium/erlang-h3](https://github.com/helium/erlang-h3)

## Go

- [uber/h3-go](https://github.com/uber/h3-go)

## Java

- [uber/h3-java](https://github.com/uber/h3-java)

## JavaScript

- [uber/h3-js](https://github.com/uber/h3-js)
- [dfellis/h3-node](https://github.com/dfellis/h3-node)
- [realPrimoh/h3-reactnative](https://github.com/realPrimoh/h3-reactnative)

## Julia

- [wookay/H3.jl](https://github.com/wookay/H3.jl)

## Kinetica

- [H3 Functions](https://docs.kinetica.com/7.1/sql/query/#h3-functions)

## OCaml

- [travisbrady/ocaml-h3](https://github.com/travisbrady/ocaml-h3)

## Perl

- [mrdvt92/perl-Geo-H3](https://metacpan.org/pod/Geo::H3)

## PHP

- [neatlife/php-h3](https://github.com/neatlife/php-h3)
- [abler98/h3-php](https://github.com/abler98/h3-php)

## PostgreSQL

- [zachasme/h3-pg](https://github.com/zachasme/h3-pg)

## Presto

- [foursquare/h3-presto](https://github.com/foursquare/h3-presto)

## Python

- [uber/h3-py](https://github.com/uber/h3-py)
- [DahnJ/H3-Pandas](https://github.com/DahnJ/H3-Pandas)
- [filimoa/h3-polars](https://github.com/Filimoa/polars-h3)

## R

- [scottmmjackson/h3r](https://github.com/scottmmjackson/h3r)
- [crazycapivara/h3-r](https://github.com/crazycapivara/h3-r)
- [obrl-soil/h3jsr](https://github.com/obrl-soil/h3jsr)

## Ruby

- [seanhandley/h3_ruby](https://github.com/seanhandley/h3_ruby)

## Rust

- [rustyconover/libh3-sys](https://github.com/rustyconover/libh3-sys)
- [rustyconover/libh3](https://github.com/rustyconover/libh3)
- [nmandery/h3ron](https://github.com/nmandery/h3ron)
- [HydroniumLabs/h3o](https://github.com/HydroniumLabs/h3o) - A translation instead of a binding

## Snowflake

- [CARTO Analytics Toolbox](https://github.com/CartoDB/analytics-toolbox-core#snowflake)

## SQLite3

- [isaacbrodsky/h3-sqlite3](https://github.com/isaacbrodsky/h3-sqlite3)

## SQL Server

- [tbbuck/H3.net.SqlClr](https://github.com/tbbuck/H3.net.SqlClr)

## Spark

- [jchotard/h3spark](https://github.com/JosephChotard/h3spark) (4.x)
- [kevinschaich/h3-pyspark](https://github.com/kevinschaich/h3-pyspark) (3.x)

## Swift
- [JeremyEspresso/swift-h3](https://github.com/JeremyEspresso/swift-h3) (4.x)
- [pawelmajcher/SwiftyH3](https://github.com/pawelmajcher/SwiftyH3) (4.x)

