//#define XERR __FILE__
#include "main.ih"

int main(int argc, char **argv)
try
{
    if (argc == 1)
    {
        cout << "arg1 filename: sent to MemoryStream\n"
                "arg1 ID: read the memorystream in another process, "
                                                "send it to cout\n";
        return 1;
    }

    if (not isdigit(argv[1][0]))
    {
        ifstream in{ argv[1] };
        MemoryStream ms{ "1MB", true };
        ms << in.rdbuf();
        cout << "offset at " << ms.tellp() << endl;
        ms.info(cout);

        ofstream out { "1.cp" };
        ms.seekg(0);
        out << ms.rdbuf();
 
        out = ofstream{ "3.cp" };
        ms.seekg(0);
        out << ms.rdbuf();
       
        cout << "ID = " << ms.id() << endl;
        cout << "? ";
        cin.ignore(100, '\n');
    }
    else
    {
        MemoryStream ms{ stoi(argv[1]) };
        ms.clear();
        ms.seekg(0);

        cout << "\nINFO:\n";
        ms.info(cout);

        ofstream out{ "2.cp" };
        out << ms.rdbuf();
    }
}
catch (exception const &exc)
{
    cerr << exc.what() << '\n';
}
catch (...)
{
    cerr << "exception\n";
}

