/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SafeTransferListener
extends AbstractTransferListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeTransferListener.class);
    private final TransferListener listener;

    public static TransferListener wrap(RepositorySystemSession session2) {
        TransferListener listener = session2.getTransferListener();
        if (listener == null) {
            return null;
        }
        return new SafeTransferListener(listener);
    }

    protected SafeTransferListener(RepositorySystemSession session2) {
        this(session2.getTransferListener());
    }

    private SafeTransferListener(TransferListener listener) {
        this.listener = listener;
    }

    private void logError(TransferEvent event2, Throwable e2) {
        LOGGER.debug("Failed to dispatch transfer event '{}' to {}", event2, this.listener.getClass().getCanonicalName(), e2);
    }

    @Override
    public void transferInitiated(TransferEvent event2) throws TransferCancelledException {
        Objects.requireNonNull(event2, "event cannot be null");
        if (this.listener != null) {
            try {
                this.listener.transferInitiated(event2);
            }
            catch (LinkageError | RuntimeException e2) {
                this.logError(event2, e2);
            }
        }
    }

    @Override
    public void transferStarted(TransferEvent event2) throws TransferCancelledException {
        Objects.requireNonNull(event2, "event cannot be null");
        if (this.listener != null) {
            try {
                this.listener.transferStarted(event2);
            }
            catch (LinkageError | RuntimeException e2) {
                this.logError(event2, e2);
            }
        }
    }

    @Override
    public void transferProgressed(TransferEvent event2) throws TransferCancelledException {
        Objects.requireNonNull(event2, "event cannot be null");
        if (this.listener != null) {
            try {
                this.listener.transferProgressed(event2);
            }
            catch (LinkageError | RuntimeException e2) {
                this.logError(event2, e2);
            }
        }
    }

    @Override
    public void transferCorrupted(TransferEvent event2) throws TransferCancelledException {
        Objects.requireNonNull(event2, "event cannot be null");
        if (this.listener != null) {
            try {
                this.listener.transferCorrupted(event2);
            }
            catch (LinkageError | RuntimeException e2) {
                this.logError(event2, e2);
            }
        }
    }

    @Override
    public void transferSucceeded(TransferEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        if (this.listener != null) {
            try {
                this.listener.transferSucceeded(event2);
            }
            catch (LinkageError | RuntimeException e2) {
                this.logError(event2, e2);
            }
        }
    }

    @Override
    public void transferFailed(TransferEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        if (this.listener != null) {
            try {
                this.listener.transferFailed(event2);
            }
            catch (LinkageError | RuntimeException e2) {
                this.logError(event2, e2);
            }
        }
    }
}

