<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Kontoinställningar',
    'sidebar_personalization' => 'Personalisering',
    'sidebar_settings_storage' => 'Lagring',
    'sidebar_settings_export' => 'Exportera',
    'sidebar_settings_users' => 'Användare',
    'sidebar_settings_subscriptions' => 'Prenumeration',
    'sidebar_settings_import' => 'Importera data',
    'sidebar_settings_tags' => 'Tag management',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'DAV resurser',
    'sidebar_settings_security' => 'Säkerhet',
    'sidebar_settings_auditlogs' => 'Granskningsloggar',

    'title_general' => 'Allmän information',
    'title_i18n' => 'Internationella inställningar',
    'title_layout' => 'Layout',

    'me_title' => 'Me as a contact',
    'me_help' => 'Detta är den kontakt som representerar <em>du</em> i Monica',
    'me_select' => 'Välj en kontakt',
    'me_no_contact' => 'Ingen kontakt vald ännu.',
    'me_select_click' => 'Klicka här för att välja en kontakt.',
    'me_remove_contact' => 'Ta bort associationen',
    'me_choose' => 'Välj själv',
    'me_choose_placeholder' => 'Välj själv',

    'export_title' => 'Exportera dina kontouppgifter',
    'export_be_patient' => 'Click the button to start the export. It might take several minutes to process the export – please be patient and do not spam the button.',
    'export_title_sql' => 'Export to SQL',
    'export_sql_explanation' => 'Exporting your data in SQL format allows you to take your data and import it to your own Monica instance. This is only valuable if you do have your own server.',
    'export_sql_cta' => 'Export to SQL',
    'export_sql_link_instructions' => 'Note: <a href=":url">read the instructions</a> to learn more about importing this file to your instance.',
    'export_title_json' => 'Export to Json',
    'export_submitted' => 'Your export has been submitted, it will be available in a few moment…',
    'export_json_explanation' => 'Exporting your data in Json format for backup.',
    'export_json_beta' => 'Json export is in preview mode. Tell us what you think about it:',
    'export_json_cta' => 'Export to Json',
    'export_header_type' => 'Type',
    'export_header_timestamp' => 'Creation date',
    'export_header_status' => 'Status',
    'export_header_actions' => 'Actions',
    'export_last_title' => 'Last exports',
    'export_empty_title' => 'No exports yet',
    'export_type_json' => 'Json export',
    'export_type_sql' => 'SQL export',
    'export_status_todo' => 'Submitted',
    'export_status_doing' => 'Doing',
    'export_status_done' => 'Done',
    'export_status_failed' => 'Failed',
    'export_not_done' => 'Download impossible, this export is not done yet.',

    'firstname' => 'Förnamn',
    'lastname' => 'Efternamn',
    'name_order' => 'Namn order',
    'name_order_firstname_lastname' => '<First name> <Last name> – John Doe',
    'name_order_lastname_firstname' => '<Last name> <First name> – Doe John',
    'name_order_firstname_lastname_nickname' => '<First name> <Last name> (<Nickname>) – John Doe (Rambo)',
    'name_order_firstname_nickname_lastname' => '<First name> (<Nickname>) <Last name> – John (Rambo) Doe',
    'name_order_lastname_firstname_nickname' => '<Last name> <First name> (<Nickname>) – Doe John (Rambo)',
    'name_order_lastname_nickname_firstname' => '<Last name> (<Nickname>) <First name> – Doe (Rambo) John',
    'name_order_nickname_firstname_lastname' => '<Nickname> (<First name> <Last name>) – Rambo (John Doe)',
    'name_order_nickname_lastname_firstname' => '<Nickname> (<Last name> <First name>) – Rambo (Doe John)',
    'name_order_nickname' => '<Nickname> – Rambo',
    'currency' => 'Valuta',
    'name' => 'Ditt namn: :name',
    'email' => 'E-postadress',
    'email_placeholder' => 'Ange e-postadress',
    'email_help' => 'This is the email used to login, and this is where Monica will send your reminders.',
    'timezone' => 'Tidszon',
    'temperature_scale' => 'Temperaturområde',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Design',
    'layout_small' => 'Max 1200 pixlar brett',
    'layout_big' => 'Full bredd på webbläsaren',
    'save' => 'Uppdatera preferenser',
    'delete_title' => 'Radera ditt konto',
    'delete_desc' => 'Do you wish to delete your account? Deletion is permanent and all of your data will be erased permanently. If you have a subscription, it will be cancelled immediately.',
    'delete_other_desc' => 'Your data in the main database will be deleted immediately. As described in our privacy policy, we carry out securely encrypted backups of the database every day.  These backups are kept for 30 days after which they are completely deleted. We cannot delete specific data from the backups we hold any earlier than this.  All of your data will be completely deleted no later than 31 days after your account’s deletion.',
    'reset_desc' => 'Do you wish to reset your account? This will remove all your contacts, and all of the data associated with them. Your account will not be deleted.',
    'reset_title' => 'Återställ ditt konto',
    'reset_cta' => 'Återställ konto',
    'reset_notice' => 'Are you sure to reset your account? This is permanent and cannot be undone.',
    'reset_success' => 'Your account has been reset successfully.',
    'delete_notice' => 'Are you sure you want to delete your account? This is permanent and cannot be undone. All of your data will be deleted and will not be recoverable.',
    'delete_cta' => 'Ta bort konto',
    'settings_success' => 'Inställningar uppdaterades!',
    'locale' => 'Språk som används i appen',
    'locale_help' => 'Vill du hjälpa till att översätta Monica eller lägga till ett nytt språk? Följ <a href=":url" target="_blank" lang="en">denna länk för mer information</a>.',
    'locale_ar' => 'Arabiska',
    'locale_cs' => 'Tjeckiska',
    'locale_de' => 'Tyska',
    'locale_el' => 'Greek',
    'locale_en' => 'Engelska',
    'locale_en-GB' => 'Engelska (Storbritannien)',
    'locale_es' => 'Spanska',
    'locale_fr' => 'Franska',
    'locale_he' => 'Hebreiska',
    'locale_hr' => 'Kroatiska',
    'locale_id' => 'Indonesian',
    'locale_it' => 'Italienska',
    'locale_ja' => 'Japanska',
    'locale_nl' => 'Nederländska',
    'locale_pt' => 'Portugisiska',
    'locale_pt-BR' => 'Portuguese, Brazil',
    'locale_ru' => 'Ryska',
    'locale_sv' => 'Swedish',
    'locale_vi' => 'Vietnamese',
    'locale_zh' => 'Kinesiska, förenklad',
    'locale_zh-TW' => 'Kinesiska Traditionell',
    'locale_tr' => 'Turkiska',

    'security_title' => 'Säkerhet',
    'security_help' => 'Ändra säkerhetsfrågor för ditt konto.',
    'password_change' => 'Change your password',
    'password_current' => 'Nuvarande lösenord',
    'password_current_placeholder' => 'Ange ditt nuvarande lösenord',
    'password_new1' => 'Nytt lösenord',
    'password_new1_placeholder' => 'Enter your new password',
    'password_new2' => 'Confirm your new password',
    'password_new2_placeholder' => 'Retype your new password',
    'password_btn' => 'Ändra lösenord',
    '2fa_title' => 'Tvåfaktorsautentisering',
    '2fa_otp_title' => 'Mobilapplikation för tvåfaktorsautentisering',
    '2fa_enable_title' => 'Aktivera tvåfaktorsautentisering',
    '2fa_enable_description' => 'Enable Two Factor Authentication to increase the security of your account.',
    '2fa_enable_otp' => 'Open up your Two Factor Authentication mobile app and scan the following QR barcode:',
    '2fa_enable_otp_help' => 'If your Two Factor Authentication mobile app does not support QR barcodes, enter in the following code:',
    '2fa_enable_otp_validate' => 'Please validate the new device you’ve just set up:',
    '2fa_enable_success' => 'Tvåfaktorsautentisering aktiverat',
    '2fa_enable_error' => 'Fel vid försök att aktivera tvåfaktorsautentisering',
    '2fa_enable_error_already_set' => 'Tvåfaktorsautentisering är redan aktiverat',
    '2fa_disable_title' => 'Inaktivera tvåfaktorsautentisering',
    '2fa_disable_description' => 'Disable Two Factor Authentication for your account. Be careful, your account will be much less secure!',
    '2fa_disable_success' => 'Tvåfaktorsautentisering inaktiverad',
    '2fa_disable_error' => 'Fel vid försök att inaktivera tvåfaktorsautentisering',

    'webauthn_title' => 'Säkerhetsnyckel — WebAuthn protokoll',
    'webauthn_enable_description' => 'Lägg till en ny säkerhetsnyckel',
    'webauthn_key_name_help' => 'Ge din nyckel ett namn.',
    'webauthn_key_name' => 'Nyckelnamn:',
    'webauthn_success' => 'Din nyckel är upptäckt och validerad.',
    'webauthn_last_use' => 'Senaste användning: {timestamp}',
    'webauthn_delete_confirmation' => 'Är du säker på att du vill ta bort denna nyckel?',
    'webauthn_delete_success' => 'Nyckel borttagen',
    'webauthn_insertKey' => 'Infoga din säkerhetsnyckel.',
    'webauthn_buttonAdvise' => 'Om din säkerhetsnyckel har en knapp trycker du på den.',
    'webauthn_noButtonAdvise' => 'Om det inte gör det, ta bort det och sätt in det igen.',
    'webauthn_not_supported' => 'Din webbläsare stöder för närvarande inte WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn stöder endast säkra anslutningar. Ladda denna sida med https schema.',
    'webauthn_error_already_used' => 'Denna nyckel är redan registrerad. Det är inte nödvändigt att registrera den igen.',
    'webauthn_error_not_allowed' => 'Operationen misslyckad, antingen väntade du för länge eller så var det inte tillåtet.',

    'recovery_title' => 'Återställningskoder',
    'recovery_show' => 'Hämta återställningskoder',
    'recovery_copy_help' => 'Kopiera till Urklipp',
    'recovery_help_intro' => 'Detta är dina återställningskoder:',
    'recovery_help_information' => 'Du kan använda varje återställningskod en gång.',
    'recovery_clipboard' => 'Codes copied to the clipboard.',
    'recovery_generate' => 'Generate new codes…',
    'recovery_generate_help' => 'Generating new codes will invalidate previously generated codes.',
    'recovery_already_used_help' => 'This code has already been used.',

    'users_list_title' => 'Användare med åtkomst till ditt konto',
    'users_list_add_user' => 'Bjud in en ny användare',
    'users_list_you' => 'Det är du',
    'users_list_invitations_title' => 'Väntande inbjudningar',
    'users_list_invitations_explanation' => 'Nedan är de personer som du har bjudit in till Monica som samarbetspartner.',
    'users_list_invitations_invited_by' => 'inbjuden av :name',
    'users_list_invitations_sent_date' => 'skickad :date',
    'users_blank_title' => 'Du är den enda som har tillgång till detta konto.',
    'users_blank_add_title' => 'Vill du bjuda in någon annan?',
    'users_blank_description' => 'Denna person kommer att ha samma åtkomst som du har, och kommer att kunna lägga till, redigera eller ta bort kontaktuppgifter.',
    'users_blank_cta' => 'Bjud in någon',
    'users_add_title' => 'Invite a new user to your account by email',
    'users_add_description' => 'This person will have the same access as you do, including inviting or deleting other users, including you. Make sure you trust this person before giving them access.',
    'users_add_email_field' => 'Ange e-post för den person du vill bjuda in',
    'users_add_confirmation' => 'I confirm that I want to invite this user to my account. I understand that this person will have access to ALL of my data and see exactly what I see.',
    'users_add_cta' => 'Bjud in användare via e-post',
    'users_accept_title' => 'Acceptera inbjudan och skapa ett nytt konto',
    'users_error_please_confirm' => 'Bekräfta att du vill bjuda in denna användare innan du fortsätter med inbjudan',
    'users_error_email_already_taken' => 'Denna e-postadress är redan upptagen. Välj en annan',
    'users_error_already_invited' => 'Du har redan bjudit in den här användaren. Välj en annan e-postadress.',
    'users_error_email_not_similar' => 'Detta är inte e-postmeddelandet för den person som har bjudit in dig.',
    'users_invitation_deleted_confirmation_message' => 'Inbjudan har tagits bort',
    'users_invitations_delete_confirmation' => 'Är du säker du vill ta bort denna inbjudan?',
    'users_list_delete_confirmation' => 'Är du säker på att ta bort denna användare från ditt konto?',
    'users_invitation_need_subscription' => 'För att lägga till fler användare krävs en prenumeration.',

    'subscriptions_account_current_plan' => 'Din nuvarande plan',
    'subscriptions_account_current_legacy' => 'Current plan, not selectable anymore:',
    'subscriptions_account_current_paid_plan' => 'Du är på :name plan. Tack så mycket för att vara en prenumerant.',

    'subscriptions_account_next_billing_title' => 'Next bill',
    'subscriptions_account_next_billing' => 'Din prenumeration förnyas automatiskt den <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'We’ll bill you <strong>:price</strong> for another <strong>month</strong>.',
    'subscriptions_account_bill_annual' => 'We’ll bill you <strong>:price</strong> for another <strong>year</strong>.',
    'subscriptions_account_change' => 'Change plan',

    'subscriptions_account_cancel_title' => 'Cancel subscription',
    'subscriptions_account_cancel_action' => 'Cancel subscription',
    'subscriptions_account_cancel' => 'Du kan <a href=":url">avbryta prenumerationen</a> när som helst.',
    'subscriptions_account_free_plan' => 'Du är på den fria planen.',
    'subscriptions_account_free_plan_upgrade' => 'Du kan uppgradera ditt konto till :name plan, vilket kostar $:price per månad. Här är fördelarna:',
    'subscriptions_account_free_plan_benefits_users' => 'Obegränsat antal användare',
    'subscriptions_account_free_plan_benefits_reminders' => 'Påminnelse via e-post',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Importera dina kontakter med vCard',
    'subscriptions_account_free_plan_benefits_support' => 'Support the project in the long run, so we can introduce more great features.',
    'subscriptions_account_upgrade' => 'Uppgradera ditt konto',
    'subscriptions_account_upgrade_title' => 'Uppgradera Monica idag och ha mer meningsfulla relationer.',
    'subscriptions_account_upgrade_choice' => 'Välj en plan nedan och gå över :customers personer som uppgraderat sin Monica.',
    'subscriptions_account_update_title' => 'Update Monica subscription',
    'subscriptions_account_update_description' => 'You can change your subscription’s frequency here.',
    'subscriptions_account_update_information' => 'You will be billed immediately for the new amount. Your subscription will extend to the new period, depending on your choice.',
    'subscriptions_account_invoices' => 'Fakturor',
    'subscriptions_account_invoices_download' => 'Hämta',
    'subscriptions_account_invoices_subscription' => 'Prenumeration från :startDate till :endDate',
    'subscriptions_account_payment' => 'Vilket betalningsalternativ passar dig bäst?',
    'subscriptions_account_confirm_payment' => 'Din betalning är för närvarande ofullständig, vänligen <a href=":url">bekräfta din betalning</a>.',
    'subscriptions_downgrade_title' => 'Nedgradera ditt konto till den kostnadsfria planen',
    'subscriptions_downgrade_limitations' => 'Den fria planen har begränsningar. För att kunna nedgradera måste du klara checklistan nedan:',
    'subscriptions_downgrade_rule_users' => 'Du måste ha endast 1 användare på ditt konto',
    'subscriptions_downgrade_rule_users_constraint' => 'Du har för närvarande <a href=":url">1 användare</a> på ditt konto.|Du har <a href=":url">:count användare</a> på ditt konto.',
    'subscriptions_downgrade_rule_invitations' => 'You must not have any pending invitations',
    'subscriptions_downgrade_rule_invitations_constraint' => 'You currently have <a href=":url">1 pending invitation</a>.|You currently have <a href=":url">:count pending invitations</a>.',
    'subscriptions_downgrade_rule_contacts' => 'Du får inte ha fler än :number aktiva kontakter',
    'subscriptions_downgrade_rule_contacts_constraint' => 'Du har för närvarande <a href=":url">1 kontakt</a>.|Du har <a href=":url">:count kontakter</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'We can also <a href=":url">archive all your contacts for you</a> – that would clear this rule and let you proceed with your account’s downgrade process.',
    'subscriptions_downgrade_cta' => 'Nedgradera',
    'subscriptions_downgrade_success' => 'Du är tillbaka till den fria planen!',
    'subscriptions_downgrade_thanks' => 'Thanks so much for trying the paid plan. We keep adding new features on Monica all the time – so you might want to come back in the future to see if you might be interested in taking a subscription again.',
    'subscriptions_back' => 'Tillbaka till inställningar',
    'subscriptions_upgrade_title' => 'Uppgradera ditt konto',
    'subscriptions_upgrade_choose' => 'Du valde :plan plan.',
    'subscriptions_upgrade_infos' => 'Vi kunde inte vara lyckligare. Ange din betalningsinformation nedan.',
    'subscriptions_upgrade_name' => 'Namn på kort',
    'subscriptions_upgrade_zip' => 'Postnummer',
    'subscriptions_upgrade_credit' => 'Kortuppgifter',
    'subscriptions_upgrade_submit' => 'Betala {amount}',
    'subscriptions_upgrade_charge' => 'We’ll charge your card :price now. The next charge will be on :date. If you ever change your mind, you can cancel at any time, no questions asked.',
    'subscriptions_upgrade_charge_handled' => 'Betalningen hanteras av <a href=":url">Stripe</a>. Ingen kortinformation berör vår server.',
    'subscriptions_upgrade_success' => 'Tack! Du prenumererar nu.',
    'subscriptions_upgrade_thanks' => 'Välkommen till gemenskapen av människor som försöker göra världen till en bättre plats.',

    'subscriptions_payment_confirm_title' => 'Bekräfta din betalning med :amount',
    'subscriptions_payment_confirm_information' => 'Extra bekräftelse krävs för att behandla din betalning. Vänligen bekräfta din betalning genom att fylla i dina betalningsuppgifter nedan.',
    'subscriptions_payment_succeeded_title' => 'Betalning lyckad',
    'subscriptions_payment_succeeded' => 'Denna betalning har redan bekräftats.',
    'subscriptions_payment_cancelled_title' => 'Betalning avbruten',
    'subscriptions_payment_cancelled' => 'Denna betalning avbröts.',
    'subscriptions_payment_error_name' => 'Ange ditt namn.',
    'subscriptions_payment_success' => 'Betalningen var framgångsrik.',

    'subscriptions_pdf_title' => 'Ditt :name månatliga abonnemang',
    'subscriptions_plan_frequency_year' => ':amount / year',
    'subscriptions_plan_frequency_month' => ':amount / month',
    'subscriptions_plan_choose' => 'Välj denna plan',
    'subscriptions_plan_year_title' => 'Betala årligen',
    'subscriptions_plan_year_bonus' => 'Du behöver inte oroa dig i ett helt år',
    'subscriptions_plan_month_title' => 'Betala månadsvis',
    'subscriptions_plan_month_bonus' => 'Ingen bindningstid',
    'subscriptions_plan_include1' => 'Inkluderat med din uppgradering:',
    'subscriptions_plan_include2' => 'Obegränsat antal kontakter • Obegränsat antal användare • Påminnelser via e-post • Importera med vCard • Anpassning av kontaktbladet',
    'subscriptions_plan_include3' => '100% av vinsten går utvecklingen av detta stora open source-projekt.',
    'subscriptions_help_title' => 'Ytterligare detaljer som du kan vara nyfiken på',
    'subscriptions_help_opensource_title' => 'Vad är ett projekt med öppen källkod?',
    'subscriptions_help_opensource_desc' => 'Monica is an open source project.  This means it is built by a community who wants to build a great tool for the greater good. Being open source means the code is publicly available on GitHub, and everyone can inspect it, modify it or enhance it. All the money we raise is dedicated to building better features, paying for more powerful servers, and paying other costs. Thanks for your help. We couldn’t do it without you.',
    'subscriptions_help_limits_title' => 'Is there a limit to the number of contacts we can have on the free plan?',
    'subscriptions_help_limits_plan' => 'Ja. Fria planer låter dig hantera :number kontakter.',
    'subscriptions_help_discounts_title' => 'Har du rabatter för ideella organisationer och utbildning?',
    'subscriptions_help_discounts_desc' => 'Vi gör! Monica är gratis för studenter, och gratis för ideella organisationer och välgörenhetsorganisationer. Kontakta bara <a href=":support">supporten</a> med ett bevis på din status så tillämpar vi denna speciella status på ditt konto.',
    'subscriptions_help_change_title' => 'Vad händer om jag ändrar mig?',
    'subscriptions_help_change_desc' => 'You can cancel anytime, no questions asked, and all by yourself – no need to contact support. However, you will not be refunded for the current period.',

    'stripe_error_card' => 'Ditt kort avvisades. Avvisa meddelande är: :message',
    'stripe_error_api_connection' => 'Nätverkskommunikation med Stripe misslyckades. Försök igen senare.',
    'stripe_error_rate_limit' => 'För många förfrågningar med Stripe just nu. Försök igen senare.',
    'stripe_error_invalid_request' => 'Ogiltiga parametrar. Försök igen senare.',
    'stripe_error_authentication' => 'Fel autentisering med Stripe',

    'import_title' => 'Importera kontakter till ditt konto',
    'import_cta' => 'Ladda upp kontakter',
    'import_stat' => 'Du har importerat :number filer hittills.',
    'import_result_stat' => 'Uppladdad vCard med 1 kontakt (:total_import importerad, :total_skipped hoppas över)|Uppladdad vCard med :total_contacts kontakter (:total_imported importerad, :total_skipped hoppas över)',
    'import_view_report' => 'Visa rapport',
    'import_in_progress' => 'Importen pågår. Ladda om sidan om en minut.',
    'import_upload_title' => 'Importera dina kontakter från en vCard-fil',
    'import_upload_rules_desc' => 'Vi har dock vissa regler:',
    'import_upload_rule_format' => 'Vi stödjer <code>.vcard</code> och <code>.vcf</code> -filer.',
    'import_upload_rule_vcard' => 'We support the vCard 3.0 format, which is the default format for macOS’s Contacts.app and Google Contacts.',
    'import_upload_rule_instructions' => 'Export instructions for <a href=":url1" target="_blank" rel="noopener noreferrer">macOS Contacts.app</a> and <a href=":url2" target="_blank" rel="noopener noreferrer">Google Contacts</a>.',
    'import_upload_rule_multiple' => 'If your contacts have multiple email addresses or phone numbers, only the first entry will be saved.',
    'import_upload_rule_limit' => 'Files are limited to 10 MB.',
    'import_upload_rule_time' => 'It might take up to a minute to upload the contacts and process them. Please be patient.',
    'import_upload_rule_cant_revert' => 'Please make sure data is accurate before uploading, as you can’t undo the upload.',
    'import_upload_form_file' => 'Din <code>.vcf</code> eller <code>.vCard</code> -fil:',
    'import_upload_behaviour' => 'Import beteende:',
    'import_upload_behaviour_add' => 'Add new contacts and skip existing',
    'import_upload_behaviour_replace' => 'Ersätt befintliga kontakter',
    'import_upload_behaviour_help' => 'Replacing will replace all data found in the vCard, but will keep existing contact fields.',
    'import_report_title' => 'Importerar rapport',
    'import_report_date' => 'Datum för importen',
    'import_report_type' => 'Typ av import',
    'import_report_number_contacts' => 'Antal kontakter i filen',
    'import_report_number_contacts_imported' => 'Antal importerade kontakter',
    'import_report_number_contacts_skipped' => 'Antal överhoppade kontakter',
    'import_report_status_imported' => 'Importerad',
    'import_report_status_skipped' => 'Hoppat över',
    'import_vcard_parse_error' => 'Fel vid tolkning av vCard-post',
    'import_vcard_contact_exist' => 'Kontakten existerar redan',
    'import_vcard_contact_no_firstname' => 'No first name (mandatory)',
    'import_vcard_file_not_found' => 'Filen hittades inte',
    'import_vcard_unknown_entry' => 'Okänt kontaktnamn',
    'import_vcard_file_no_entries' => 'Filen innehåller inga poster',
    'import_blank_title' => 'Du har inte importerat några kontakter än.',
    'import_blank_question' => 'Vill du importera kontakter nu?',
    'import_blank_description' => 'Vi kan importera vCard-filer som du kan få från Google Kontakter eller din kontakthanterare.',
    'import_blank_cta' => 'Import vCard',
    'import_need_subscription' => 'För att importera data krävs ett abonnemang.',

    'tags_list_title' => 'Taggar',
    'tags_list_description' => 'Du kan organisera dina kontakter genom att konfigurera taggar. Taggar fungerar som mappar, men du kan lägga till fler än en tagg till en kontakt. För att lägga till en ny tagg, lägg till den på själva kontakten.',
    'tags_list_contact_number' => '1 kontakt|:count kontakter',
    'tags_list_delete_success' => 'Taggen har tagits bort',
    'tags_list_edit_success' => 'The tag has been successfully updated',
    'tags_list_delete_confirmation' => 'Är du säker på att du vill ta bort taggen? Inga kontakter kommer att tas bort, bara taggen.',
    'tags_blank_title' => 'Taggar är ett bra sätt att kategorisera dina kontakter.',
    'tags_blank_description' => 'Tags work like folders, but you can add more than one tag to a contact. Go to a contact and tag a friend, right below the name. Once a contact is tagged, come back here to manage all the tags in your account.',

    'api_title' => 'API åtkomst',
    'api_description' => 'API: et kan användas för att manipulera Monicas data från en extern applikation, som till exempel en mobilapp.',
    'api_help' => 'Att använda API:et är obligatoriskt. Du kan antingen skapa en personlig åtkomst-token (Bearer-autentisering) eller auktorisera en OAuth klient att skapa den åt dig. Se <a href=":url">API-dokumentation</a>.',
    'api_endpoint' => 'API slutpunkt för denna Monica instans är:',

    'api_personal_access_tokens' => 'Personliga åtkomsttokens',
    'api_pao_description' => 'Se till att du ger denna token till en källa du litar på – eftersom de ger dig tillgång till alla dina data.',
    'api_token_title' => 'Personliga åtkomst-Tokens',
    'api_token_create_new' => 'Skapa ny token',
    'api_token_not_created' => 'Du har inte skapat några personliga åtkomsttokens.',
    'api_token_name' => 'Token namn',
    'api_token_expire' => 'Förfaller vid {date}',
    'api_token_delete' => 'Radera',
    'api_token_create' => 'Skapa token',
    'api_token_scopes' => 'Omfattningar',
    'api_token_help' => 'Här är din nya personliga tillgång token. Detta är den enda gången det kommer att visas så förlora inte det! Du kan nu använda denna token för att göra API-förfrågningar.',

    'api_oauth_clients' => 'Dina OAuth klienter',
    'api_oauth_clients_desc' => 'Det här avsnittet låter dig registrera dina egna OAuth klienter.',
    'api_oauth_clients_desc2' => 'Använd detta klient-id för att begära en ny token, och konvertera behörighetskoder till åtkomsttokens. Se <a href="{url}">Laravel Passport dokumentation</a> för mer information.',
    'api_oauth_title' => 'OAuth klienter',
    'api_oauth_create_new' => 'Skapa ny klient',
    'api_oauth_edit' => 'Redigera klient',
    'api_oauth_not_created' => 'Du har inte skapat några OAuth klienter.',
    'api_oauth_clientid' => 'Klient ID',
    'api_oauth_name' => 'Namn',
    'api_oauth_name_help' => 'Något som dina användare kommer att känna igen och lita på.',
    'api_oauth_secret' => 'Hemlighet',
    'api_oauth_create' => 'Skapa klient',
    'api_oauth_redirecturl' => 'Omdirigera URL',
    'api_oauth_redirecturl_help' => 'Din applikations auktorisering callback URL.',

    'api_authorized_clients' => 'Lista över auktoriserade kunder',
    'api_authorized_clients_desc' => 'I det här avsnittet listas alla klienter som du har behörighet att komma åt dina applikationsdata. Du kan när som helst återkalla denna behörighet.',
    'api_authorized_clients_title' => 'Auktoriserade program',
    'api_authorized_clients_none' => 'There are no authorized clients yet.',
    'api_authorized_clients_name' => 'Namn',
    'api_authorized_clients_scopes' => 'Omfattningar',

    'personalization_tab_title' => 'Anpassa ditt konto',

    'personalization_title' => 'Here you will find different settings to configure your account. These features are intended for “power users” who want maximum control over Monica.',
    'personalization_contact_field_type_title' => 'Typ av kontaktfält',
    'personalization_contact_field_type_add' => 'Lägg till ny fälttyp',
    'personalization_contact_field_type_description' => 'You can configure all the different types of contact fields that you can associate to all your contacts. For example, if a new social network appears in the future, you will be able to add this new way of communicating with your contacts right here.',
    'personalization_contact_field_type_table_name' => 'Namn',
    'personalization_contact_field_type_table_protocol' => 'Protokoll',
    'personalization_contact_field_type_table_actions' => 'Åtgärder',
    'personalization_contact_field_type_modal_title' => 'Lägg till en ny typ av kontaktfält',
    'personalization_contact_field_type_modal_edit_title' => 'Redigera en befintlig typ av kontaktfält',
    'personalization_contact_field_type_modal_delete_title' => 'Ta bort en befintlig kontakttyp',
    'personalization_contact_field_type_modal_delete_description' => 'Are you sure you want to delete this contact field type? Deleting this type of contact field will delete ALL the data with this type for all of your contacts.',
    'personalization_contact_field_type_modal_name' => 'Namn',
    'personalization_contact_field_type_modal_protocol' => 'Protokoll (valfritt)',
    'personalization_contact_field_type_modal_protocol_help' => 'Varje ny kontakttyp kan klickas. Om ett protokoll är inställt, kommer vi att använda det för att utlösa åtgärden som är inställd.',
    'personalization_contact_field_type_modal_icon' => 'Ikon (valfritt)',
    'personalization_contact_field_type_modal_icon_help' => 'Du kan associera en ikon med den här kontaktfälttypen. Du måste lägga till en referens till en typsnitts-ikon.',
    'personalization_contact_field_type_delete_success' => 'The contact field type has been successfully deleted.',
    'personalization_contact_field_type_add_success' => 'Kontakttypen har lagts till.',
    'personalization_contact_field_type_edit_success' => 'Kontakttypen har uppdaterats.',

    'personalization_genders_title' => 'Könsidentitet',
    'personalization_genders_add' => 'Lägg till ny könstyp',
    'personalization_genders_desc' => 'Du kan definiera så många kön som du behöver. Du behöver minst en könstyp på ditt konto.',
    'personalization_genders_modal_add' => 'Lägg till könstyp',
    'personalization_genders_modal_edit' => 'Uppdatera könstyp',
    'personalization_genders_modal_name' => 'Namn',
    'personalization_genders_modal_name_help' => 'Namnet som används för att visa kön på en kontaktsida.',
    'personalization_genders_modal_sex' => 'Kön',
    'personalization_genders_modal_sex_help' => 'Används för att definiera relationerna och under VCard-import/exportprocessen.',
    'personalization_genders_modal_default' => 'Välj standard kön för en ny kontakt',
    'personalization_genders_modal_delete' => 'Ta bort könstyp',
    'personalization_genders_modal_delete_desc' => 'Are you sure you want to delete the gender “{name}”?',
    'personalization_genders_modal_delete_question' => 'You currently have {count} contact with this gender. If you delete this gender, what gender should this contact have?|You currently have {count} contacts with this gender. If you delete this gender, what gender should these contacts have?',
    'personalization_genders_modal_delete_question_default' => 'This gender is the default one. If you delete this gender, which one will be the new default?',
    'personalization_genders_modal_error' => 'Please choose a gender from the list.',
    'personalization_genders_list_contact_number' => '{count} kontakt|{count} kontakter',
    'personalization_genders_table_name' => 'Namn',
    'personalization_genders_table_sex' => 'Kön',
    'personalization_genders_table_default' => 'Standard',
    'personalization_genders_default' => 'Förvalt kön',
    'personalization_genders_make_default' => 'Ändra standard kön',
    'personalization_genders_select_default' => 'Välj standard kön',
    'personalization_genders_m' => 'Man',
    'personalization_genders_f' => 'Kvinna',
    'personalization_genders_o' => 'Annat',
    'personalization_genders_u' => 'Okänd',
    'personalization_genders_n' => 'Inget eller ej tillämpligt',

    'personalization_reminder_rule_save' => 'Ändringen har sparats',
    'personalization_reminder_rule_title' => 'Påminnelse regler',
    'personalization_reminder_rule_line' => '{count} dag före|{count} dagar före',
    'personalization_reminder_rule_desc' => 'For every reminder that you set, Monica can send you an email a number of days before the event happens.  You can adjust these notification settings here. These notifications only apply to monthly and yearly reminders.',

    'personalization_module_save' => 'Ändringen har sparats',
    'personalization_module_title' => 'Funktioner',
    'personalization_module_desc' => 'You may not need all of Monica’s features. Below you can toggle specific features that are used on a contact sheet. This change will affect ALL your contacts. Turning off a feature does not delete any data, it simply hides the feature.',

    'personalisation_paid_upgrade' => 'Detta är en premiumfunktion som kräver att en betald prenumeration är aktiv. Uppgradera ditt konto genom att besöka <a href=":url">Inställningar > Prenumeration</a>.',
    'personalisation_paid_upgrade_vue' => 'Detta är en premiumfunktion som kräver att en betald prenumeration är aktiv. Uppgradera ditt konto genom att besöka <a href="{url}">Inställningar > Prenumeration</a>.',

    'reminder_time_to_send' => 'Time of the day reminders will be sent',
    'reminder_time_to_send_help' => 'Your next reminder is scheduled to be sent on <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Kategorier av aktivitetstyper',
    'personalization_activity_type_category_add' => 'Lägg till en ny kategori för aktivitetstyp',
    'personalization_activity_type_category_table_name' => 'Namn',
    'personalization_activity_type_category_description' => 'An activity with one of your contacts can have a type and a category type. Your account comes with a set of predefined category types by default, but you can customize these here.',
    'personalization_activity_type_category_table_actions' => 'Åtgärder',
    'personalization_activity_type_category_modal_add' => 'Lägg till en ny kategori för aktivitetstyp',
    'personalization_activity_type_category_modal_edit' => 'Redigera kategori för aktivitetstyp',
    'personalization_activity_type_category_modal_question' => 'What should we name this new category?',
    'personalization_activity_type_add_button' => 'Lägg till en ny aktivitetstyp',
    'personalization_activity_type_modal_add' => 'Lägg till en ny aktivitetstyp',
    'personalization_activity_type_modal_question' => 'What should we name this new activity type?',
    'personalization_activity_type_modal_edit' => 'Redigera en aktivitetstyp',
    'personalization_activity_type_category_modal_delete' => 'Ta bort en kategori av aktivitetstyper',
    'personalization_activity_type_category_modal_delete_desc' => 'Are you sure you want to delete this category? Deleting it will delete all associated activity types. Activities that belong to this category will not be affected by this deletion.',
    'personalization_activity_type_modal_delete' => 'Ta bort en aktivitetstyp',
    'personalization_activity_type_modal_delete_desc' => 'Är du säker på att du vill ta bort denna aktivitetstyp? Aktiviteter som tillhör denna kategori kommer inte att påverkas av denna borttagning.',
    'personalization_activity_type_modal_delete_error' => 'Vi kan inte hitta denna typ av aktivitet.',
    'personalization_activity_type_category_modal_delete_error' => 'Vi kan inte hitta denna kategori av aktivitetstyper.',

    'personalization_life_event_category_title' => 'Livshändelse kategorier',
    'personalization_live_event_category_table_name' => 'Namn',
    'personalization_life_event_category_description' => 'A life event can have a type and a category. Your account comes with a set of predefined categories and types by default, but you can customize life event types here.',
    'personalization_live_event_category_table_actions' => 'Åtgärder',
    'personalization_life_event_type_add_button' => 'Lägg till en ny livshändelstyp',
    'personalization_life_event_type_modal_add' => 'Lägg till en ny livshändelstyp',
    'personalization_life_event_type_modal_question' => 'What should we name this new life event type?',
    'personalization_life_event_type_modal_edit' => 'Redigera en livshändelsetyp',
    'personalization_life_event_type_modal_delete' => 'Ta bort en livshändelstyp',
    'personalization_life_event_type_modal_delete_desc' => 'Är du säker på att du vill ta bort denna livshändelstyp? Livshändelser som tillhör denna typ kommer att raderas genom att utföra denna åtgärd.',
    'personalization_life_event_type_modal_delete_error' => 'Vi kan inte hitta denna typ av händelser i livet.',

    'personalization_life_event_category_work_education' => 'Arbete & utbildning',
    'personalization_life_event_category_family_relationships' => 'Familj & relationer',
    'personalization_life_event_category_home_living' => 'Hem & Boende',
    'personalization_life_event_category_travel_experiences' => 'Resor & upplevelser',
    'personalization_life_event_category_health_wellness' => 'Hälsa och hälsa',

    'personalization_life_event_type_new_job' => 'Nytt jobb',
    'personalization_life_event_type_retirement' => 'Pensionering',
    'personalization_life_event_type_new_school' => 'Ny skola',
    'personalization_life_event_type_study_abroad' => 'Studera utomlands',
    'personalization_life_event_type_volunteer_work' => 'Volontärarbete',
    'personalization_life_event_type_published_book_or_paper' => 'Publicerat en bok eller ett papper',
    'personalization_life_event_type_military_service' => 'Militär tjänst',
    'personalization_life_event_type_first_met' => 'Första möte',
    'personalization_life_event_type_new_relationship' => 'Ny relation',
    'personalization_life_event_type_engagement' => 'Förlovning',
    'personalization_life_event_type_marriage' => 'Äktenskap',
    'personalization_life_event_type_anniversary' => 'Årsdag',
    'personalization_life_event_type_expecting_a_baby' => 'Väntar barn',
    'personalization_life_event_type_new_child' => 'Nytt barn',
    'personalization_life_event_type_new_family_member' => 'Ny familjemedlem',
    'personalization_life_event_type_new_pet' => 'Nytt husdjur',
    'personalization_life_event_type_end_of_relationship' => 'Slut på relationen',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Bortgång av närstående',
    'personalization_life_event_type_moved' => 'Flyttad',
    'personalization_life_event_type_bought_a_home' => 'Köpte hus',
    'personalization_life_event_type_home_improvement' => 'Förbättring av hemmet',
    'personalization_life_event_type_holidays' => 'Semester',
    'personalization_life_event_type_new_vehicle' => 'Nytt fordon',
    'personalization_life_event_type_new_roommate' => 'Ny rumskompis',
    'personalization_life_event_type_overcame_an_illness' => 'Övervann en sjukdom',
    'personalization_life_event_type_quit_a_habit' => 'Avsluta en vana',
    'personalization_life_event_type_new_eating_habits' => 'Nya matvanor',
    'personalization_life_event_type_weight_loss' => 'Viktminskning',
    'personalization_life_event_type_wear_glass_or_contact' => 'Started wearing glasses or contacts',
    'personalization_life_event_type_broken_bone' => 'Broke a bone',
    'personalization_life_event_type_removed_braces' => 'Had braces removed',
    'personalization_life_event_type_surgery' => 'Had surgery',
    'personalization_life_event_type_dentist' => 'Had dental treatment',
    'personalization_life_event_type_new_sport' => 'Started playing a new sport',
    'personalization_life_event_type_new_hobby' => 'Took up a new hobby',
    'personalization_life_event_type_new_instrument' => 'Started learning a new instrument',
    'personalization_life_event_type_new_language' => 'Started learning a new language',
    'personalization_life_event_type_tattoo_or_piercing' => 'Tatuering eller piercingar',
    'personalization_life_event_type_new_license' => 'Ny licens',
    'personalization_life_event_type_travel' => 'Resor',
    'personalization_life_event_type_achievement_or_award' => 'Prestation eller belöning',
    'personalization_life_event_type_changed_beliefs' => 'Ändrad trosuppfattning',
    'personalization_life_event_type_first_word' => 'Första ordet',
    'personalization_life_event_type_first_kiss' => 'Första kyssen',

    'storage_title' => 'Lagringsutrymme',
    'storage_account_info' => 'Your account limit is :accountLimit MB. Your current usage is :currentAccountSize MB (about :percentUsage%).',
    'storage_upgrade_notice' => 'Uppgradera ditt konto för att kunna ladda upp dokument och foton.',
    'storage_description' => 'Här kan du se alla dokument och foton som laddats upp om dina kontakter.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Här hittar du alla inställningar för att använda WebDAV resurser för CardDAV och CalDAV export.',
    'dav_copy_help' => 'Kopiera till Urklipp',
    'dav_clipboard_copied' => 'Värdet har kopierats till Urklipp',
    'dav_url_base' => 'Bas-url för alla CardDAV och CalDAV resurser:',
    'dav_connect_help' => 'Du kan ansluta dina kontakter och/eller kalendrar med denna bas-url på din telefon eller dator.',
    'dav_connect_help2' => 'Använd din inloggning (e-post) och skapa en API-token som lösenord för att autentisera.',
    'dav_url_carddav' => 'CardDAV url för kontakter källa:',
    'dav_url_caldav_birthdays' => 'CalDAV url för födelsedagsresurser:',
    'dav_url_caldav_tasks' => 'CalDAV url för uppgiftskällor:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Exportera alla kontakter i en fil',
    'dav_caldav_birthdays_export' => 'Exportera alla födelsedagar i en fil',
    'dav_caldav_tasks_export' => 'Exportera alla uppgifter i en fil',

    'archive_title' => 'Archive all of the contacts in your account',
    'archive_desc' => 'This will archive all of the contacts in your account.',
    'archive_cta' => 'Archive all of your contacts',

    'logs_title' => 'Everything that has happened to this account',
    'logs_actor' => 'Actor',
    'logs_timestamp' => 'Timestamp',
    'logs_description' => 'Description',
    'logs_subject' => 'Subject',
    'logs_size' => 'Size (Kb)',
    'logs_object' => 'Object',
];
