/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.Normalizer;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Comment;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Document;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.DocumentType;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Element;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Node;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.PseudoTextElement;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.TextNode;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.XmlDeclaration;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseSettings;

public abstract class Evaluator {
    protected Evaluator() {
    }

    /*
     * WARNING - void declaration
     */
    public Predicate<Element> asPredicate(Element root) {
        void var1_1;
        return arg_0 -> this.lambda$asPredicate$0((Element)var1_1, arg_0);
    }

    public abstract boolean matches(Element var1, Element var2);

    protected void reset() {
    }

    protected int cost() {
        return 5;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$asPredicate$0(Element root, Element element) {
        void var2_2;
        void var1_1;
        return this.matches((Element)var1_1, (Element)var2_2);
    }

    public static final class MatchText
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            if (element instanceof PseudoTextElement) {
                return true;
            }
            Object object = element.textNodes();
            object = object.iterator();
            while (object.hasNext()) {
                void var3_3;
                TextNode textNode = (TextNode)object.next();
                PseudoTextElement pel = new PseudoTextElement(xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.Tag.valueOf(element.tagName(), element.tag().namespace(), ParseSettings.preserveCase), element.baseUri(), element.attributes());
                textNode.replaceWith(pel);
                pel.appendChild((Node)var3_3);
            }
            return false;
        }

        @Override
        protected final int cost() {
            return -1;
        }

        public final String toString() {
            return ":matchText";
        }
    }

    public static final class MatchesWholeOwnText
    extends Evaluator {
        private final Pattern pattern;

        /*
         * WARNING - void declaration
         */
        public MatchesWholeOwnText(Pattern pattern) {
            void var1_1;
            this.pattern = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            Matcher matcher = this.pattern.matcher(var2_2.wholeOwnText());
            return matcher.find();
        }

        @Override
        protected final int cost() {
            return 7;
        }

        public final String toString() {
            return String.format(":matchesWholeOwnText(%s)", this.pattern);
        }
    }

    public static final class MatchesWholeText
    extends Evaluator {
        private final Pattern pattern;

        /*
         * WARNING - void declaration
         */
        public MatchesWholeText(Pattern pattern) {
            void var1_1;
            this.pattern = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            Matcher matcher = this.pattern.matcher(var2_2.wholeText());
            return matcher.find();
        }

        @Override
        protected final int cost() {
            return 8;
        }

        public final String toString() {
            return String.format(":matchesWholeText(%s)", this.pattern);
        }
    }

    public static final class MatchesOwn
    extends Evaluator {
        private final Pattern pattern;

        /*
         * WARNING - void declaration
         */
        public MatchesOwn(Pattern pattern) {
            void var1_1;
            this.pattern = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            Matcher matcher = this.pattern.matcher(var2_2.ownText());
            return matcher.find();
        }

        @Override
        protected final int cost() {
            return 7;
        }

        public final String toString() {
            return String.format(":matchesOwn(%s)", this.pattern);
        }
    }

    public static final class Matches
    extends Evaluator {
        private final Pattern pattern;

        /*
         * WARNING - void declaration
         */
        public Matches(Pattern pattern) {
            void var1_1;
            this.pattern = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            Matcher matcher = this.pattern.matcher(var2_2.text());
            return matcher.find();
        }

        @Override
        protected final int cost() {
            return 8;
        }

        public final String toString() {
            return String.format(":matches(%s)", this.pattern);
        }
    }

    public static final class ContainsOwnText
    extends Evaluator {
        private final String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsOwnText(String searchText) {
            void var1_1;
            this.searchText = Normalizer.lowerCase(StringUtil.normaliseWhitespace((String)var1_1));
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return Normalizer.lowerCase(element.ownText()).contains(this.searchText);
        }

        public final String toString() {
            return String.format(":containsOwn(%s)", this.searchText);
        }
    }

    public static final class ContainsData
    extends Evaluator {
        private final String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsData(String searchText) {
            void var1_1;
            this.searchText = Normalizer.lowerCase((String)var1_1);
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return Normalizer.lowerCase(element.data()).contains(this.searchText);
        }

        public final String toString() {
            return String.format(":containsData(%s)", this.searchText);
        }
    }

    public static final class ContainsWholeOwnText
    extends Evaluator {
        private final String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsWholeOwnText(String searchText) {
            void var1_1;
            this.searchText = var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.wholeOwnText().contains(this.searchText);
        }

        public final String toString() {
            return String.format(":containsWholeOwnText(%s)", this.searchText);
        }
    }

    public static final class ContainsWholeText
    extends Evaluator {
        private final String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsWholeText(String searchText) {
            void var1_1;
            this.searchText = var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.wholeText().contains(this.searchText);
        }

        @Override
        protected final int cost() {
            return 10;
        }

        public final String toString() {
            return String.format(":containsWholeText(%s)", this.searchText);
        }
    }

    public static final class ContainsText
    extends Evaluator {
        private final String searchText;

        /*
         * WARNING - void declaration
         */
        public ContainsText(String searchText) {
            void var1_1;
            this.searchText = Normalizer.lowerCase(StringUtil.normaliseWhitespace((String)var1_1));
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return Normalizer.lowerCase(element.text()).contains(this.searchText);
        }

        @Override
        protected final int cost() {
            return 10;
        }

        public final String toString() {
            return String.format(":contains(%s)", this.searchText);
        }
    }

    public static abstract class IndexEvaluator
    extends Evaluator {
        final int index;

        /*
         * WARNING - void declaration
         */
        public IndexEvaluator(int index) {
            void var1_1;
            this.index = var1_1;
        }
    }

    public static final class IsEmpty
    extends Evaluator {
        @Override
        public final boolean matches(Element root, Element el) {
            for (Node n = el.firstChild(); n != null; n = n.nextSibling()) {
                if (!(n instanceof TextNode ? !((TextNode)n).isBlank() : !(n instanceof Comment) && !(n instanceof XmlDeclaration) && !(n instanceof DocumentType))) continue;
                return false;
            }
            return true;
        }

        public final String toString() {
            return ":empty";
        }
    }

    public static final class IsOnlyOfType
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var3_3;
            Element p = element.parent();
            if (p == null || p instanceof Document) {
                return false;
            }
            int pos = 0;
            for (Element next = p.firstElementChild(); next != null; next = next.nextElementSibling()) {
                if (next.normalName().equals(element.normalName())) {
                    ++pos;
                }
                if (pos > 1) break;
            }
            return var3_3 == true;
        }

        public final String toString() {
            return ":only-of-type";
        }
    }

    public static final class IsOnlyChild
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            void var1_1;
            Element p = element.parent();
            return p != null && !(var1_1 instanceof Document) && var2_2.siblingElements().isEmpty();
        }

        public final String toString() {
            return ":only-child";
        }
    }

    public static final class IsRoot
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var1_1;
            void var2_2;
            Element r;
            Element element2 = r = root instanceof Document ? root.firstElementChild() : r;
            return var2_2 == var1_1;
        }

        @Override
        protected final int cost() {
            return 1;
        }

        public final String toString() {
            return ":root";
        }
    }

    public static final class IsFirstChild
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var1_1;
            void var2_2;
            Element p = element.parent();
            return p != null && !(p instanceof Document) && var2_2 == var1_1.firstElementChild();
        }

        public final String toString() {
            return ":first-child";
        }
    }

    public static class IsNthLastOfType
    extends CssNthEvaluator {
        /*
         * WARNING - void declaration
         */
        public IsNthLastOfType(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected int calculatePosition(Element root, Element element) {
            void var1_2;
            root = element.parent();
            if (root == null) {
                return 0;
            }
            int pos = 0;
            for (Element next = element; next != null; next = next.nextElementSibling()) {
                if (!next.normalName().equals(element.normalName())) continue;
                ++pos;
            }
            return (int)var1_2;
        }

        @Override
        protected String getPseudoClass() {
            return "nth-last-of-type";
        }
    }

    public static class IsNthOfType
    extends CssNthEvaluator {
        /*
         * WARNING - void declaration
         */
        public IsNthOfType(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected int calculatePosition(Element root, Element element) {
            void var3_3;
            Element parent = element.parent();
            if (parent == null) {
                return 0;
            }
            int pos = 0;
            int size = parent.childNodeSize();
            for (int i = 0; i < size; ++i) {
                Node node = parent.childNode(i);
                if (node.normalName().equals(element.normalName())) {
                    ++pos;
                }
                if (node == element) break;
            }
            return (int)var3_3;
        }

        @Override
        protected String getPseudoClass() {
            return "nth-of-type";
        }
    }

    public static final class IsNthLastChild
    extends CssNthEvaluator {
        /*
         * WARNING - void declaration
         */
        public IsNthLastChild(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int calculatePosition(Element root, Element element) {
            void var2_2;
            if (element.parent() == null) {
                return 0;
            }
            return element.parent().childrenSize() - var2_2.elementSiblingIndex();
        }

        @Override
        protected final String getPseudoClass() {
            return "nth-last-child";
        }
    }

    public static final class IsNthChild
    extends CssNthEvaluator {
        /*
         * WARNING - void declaration
         */
        public IsNthChild(int a, int b) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        protected final int calculatePosition(Element root, Element element) {
            return element.elementSiblingIndex() + 1;
        }

        @Override
        protected final String getPseudoClass() {
            return "nth-child";
        }
    }

    public static abstract class CssNthEvaluator
    extends Evaluator {
        protected final int a;
        protected final int b;

        /*
         * WARNING - void declaration
         */
        public CssNthEvaluator(int a, int b) {
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(Element root, Element element) {
            void var1_2;
            void var2_3;
            void var3_4;
            Element p = element.parent();
            if (p == null || var3_4 instanceof Document) {
                return false;
            }
            int pos = this.calculatePosition(root, (Element)var2_3);
            if (this.a == 0) {
                return pos == this.b;
            }
            return (pos - this.b) * this.a >= 0 && (var1_2 - this.b) % this.a == false;
        }

        public String toString() {
            if (this.a == 0) {
                return String.format(":%s(%d)", this.getPseudoClass(), this.b);
            }
            if (this.b == 0) {
                return String.format(":%s(%dn)", this.getPseudoClass(), this.a);
            }
            return String.format(":%s(%dn%+d)", this.getPseudoClass(), this.a, this.b);
        }

        protected abstract String getPseudoClass();

        protected abstract int calculatePosition(Element var1, Element var2);
    }

    public static final class IsLastOfType
    extends IsNthLastOfType {
        public IsLastOfType() {
            super(0, 1);
        }

        @Override
        public final String toString() {
            return ":last-of-type";
        }
    }

    public static final class IsFirstOfType
    extends IsNthOfType {
        public IsFirstOfType() {
            super(0, 1);
        }

        @Override
        public final String toString() {
            return ":first-of-type";
        }
    }

    public static final class IsLastChild
    extends Evaluator {
        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var1_1;
            void var2_2;
            Element p = element.parent();
            return p != null && !(p instanceof Document) && var2_2 == var1_1.lastElementChild();
        }

        public final String toString() {
            return ":last-child";
        }
    }

    public static final class IndexEquals
    extends IndexEvaluator {
        /*
         * WARNING - void declaration
         */
        public IndexEquals(int index) {
            super((int)var1_1);
            void var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.elementSiblingIndex() == this.index;
        }

        public final String toString() {
            return String.format(":eq(%d)", this.index);
        }
    }

    public static final class IndexGreaterThan
    extends IndexEvaluator {
        /*
         * WARNING - void declaration
         */
        public IndexGreaterThan(int index) {
            super((int)var1_1);
            void var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.elementSiblingIndex() > this.index;
        }

        public final String toString() {
            return String.format(":gt(%d)", this.index);
        }
    }

    public static final class IndexLessThan
    extends IndexEvaluator {
        /*
         * WARNING - void declaration
         */
        public IndexLessThan(int index) {
            super((int)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return root != element && var2_2.elementSiblingIndex() < this.index;
        }

        public final String toString() {
            return String.format(":lt(%d)", this.index);
        }
    }

    public static final class AllElements
    extends Evaluator {
        @Override
        public final boolean matches(Element root, Element element) {
            return true;
        }

        @Override
        protected final int cost() {
            return 10;
        }

        public final String toString() {
            return "*";
        }
    }

    public static abstract class AttributeKeyPair
    extends Evaluator {
        final String key;
        final String value;

        /*
         * WARNING - void declaration
         */
        public AttributeKeyPair(String key, String value) {
            this((String)var1_1, (String)var2_2, true);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public AttributeKeyPair(String key, String value, boolean trimValue) {
            void var1_2;
            void var2_3;
            void var3_4;
            Validate.notEmpty(key);
            Validate.notEmpty(value);
            this.key = Normalizer.normalize(key);
            boolean isStringLiteral = value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"");
            if (isStringLiteral) {
                value = value.substring(1, value.length() - 1);
            }
            this.value = var3_4 != false ? Normalizer.normalize(value) : Normalizer.normalize((String)var2_3, (boolean)var1_2);
        }
    }

    public static final class AttributeWithValueMatching
    extends Evaluator {
        final String key;
        final Pattern pattern;

        /*
         * WARNING - void declaration
         */
        public AttributeWithValueMatching(String key, Pattern pattern) {
            void var2_2;
            void var1_1;
            this.key = Normalizer.normalize((String)var1_1);
            this.pattern = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return element.hasAttr(this.key) && this.pattern.matcher(var2_2.attr(this.key)).find();
        }

        @Override
        protected final int cost() {
            return 8;
        }

        public final String toString() {
            return String.format("[%s~=%s]", this.key, this.pattern.toString());
        }
    }

    public static final class AttributeWithValueContaining
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueContaining(String key, String value) {
            super((String)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return element.hasAttr(this.key) && Normalizer.lowerCase(var2_2.attr(this.key)).contains(this.value);
        }

        @Override
        protected final int cost() {
            return 6;
        }

        public final String toString() {
            return String.format("[%s*=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueEnding
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueEnding(String key, String value) {
            super((String)var1_1, (String)var2_2, false);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return element.hasAttr(this.key) && Normalizer.lowerCase(var2_2.attr(this.key)).endsWith(this.value);
        }

        @Override
        protected final int cost() {
            return 4;
        }

        public final String toString() {
            return String.format("[%s$=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueStarting
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueStarting(String key, String value) {
            super((String)var1_1, (String)var2_2, false);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return element.hasAttr(this.key) && Normalizer.lowerCase(var2_2.attr(this.key)).startsWith(this.value);
        }

        @Override
        protected final int cost() {
            return 4;
        }

        public final String toString() {
            return String.format("[%s^=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueNot
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValueNot(String key, String value) {
            super((String)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return !this.value.equalsIgnoreCase(var2_2.attr(this.key));
        }

        @Override
        protected final int cost() {
            return 3;
        }

        public final String toString() {
            return String.format("[%s!=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValue
    extends AttributeKeyPair {
        /*
         * WARNING - void declaration
         */
        public AttributeWithValue(String key, String value) {
            super((String)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return element.hasAttr(this.key) && this.value.equalsIgnoreCase(var2_2.attr(this.key).trim());
        }

        @Override
        protected final int cost() {
            return 3;
        }

        public final String toString() {
            return String.format("[%s=%s]", this.key, this.value);
        }
    }

    public static final class AttributeStarting
    extends Evaluator {
        private final String keyPrefix;

        /*
         * WARNING - void declaration
         */
        public AttributeStarting(String keyPrefix) {
            void var1_1;
            Validate.notNull(keyPrefix);
            this.keyPrefix = Normalizer.lowerCase((String)var1_1);
        }

        @Override
        public final boolean matches(Element root, Element element) {
            Object object = element.attributes().asList();
            object = object.iterator();
            while (object.hasNext()) {
                xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Attribute attribute = (xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Attribute)object.next();
                if (!Normalizer.lowerCase(attribute.getKey()).startsWith(this.keyPrefix)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected final int cost() {
            return 6;
        }

        public final String toString() {
            return String.format("[^%s]", this.keyPrefix);
        }
    }

    public static final class Attribute
    extends Evaluator {
        private final String key;

        /*
         * WARNING - void declaration
         */
        public Attribute(String key) {
            void var1_1;
            this.key = var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.hasAttr(this.key);
        }

        @Override
        protected final int cost() {
            return 2;
        }

        public final String toString() {
            return String.format("[%s]", this.key);
        }
    }

    public static final class Class
    extends Evaluator {
        private final String className;

        /*
         * WARNING - void declaration
         */
        public Class(String className) {
            void var1_1;
            this.className = var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.hasClass(this.className);
        }

        @Override
        protected final int cost() {
            return 6;
        }

        public final String toString() {
            return String.format(".%s", this.className);
        }
    }

    public static final class Id
    extends Evaluator {
        private final String id;

        /*
         * WARNING - void declaration
         */
        public Id(String id) {
            void var1_1;
            this.id = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Element root, Element element) {
            void var2_2;
            return this.id.equals(var2_2.id());
        }

        @Override
        protected final int cost() {
            return 2;
        }

        public final String toString() {
            return String.format("#%s", this.id);
        }
    }

    public static final class TagEndsWith
    extends Evaluator {
        private final String tagName;

        /*
         * WARNING - void declaration
         */
        public TagEndsWith(String tagName) {
            void var1_1;
            this.tagName = var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.normalName().endsWith(this.tagName);
        }

        public final String toString() {
            return String.format("%s", this.tagName);
        }
    }

    public static final class TagStartsWith
    extends Evaluator {
        private final String tagName;

        /*
         * WARNING - void declaration
         */
        public TagStartsWith(String tagName) {
            void var1_1;
            this.tagName = var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.normalName().startsWith(this.tagName);
        }

        public final String toString() {
            return String.format("%s", this.tagName);
        }
    }

    public static final class Tag
    extends Evaluator {
        private final String tagName;

        /*
         * WARNING - void declaration
         */
        public Tag(String tagName) {
            void var1_1;
            this.tagName = var1_1;
        }

        @Override
        public final boolean matches(Element root, Element element) {
            return element.nameIs(this.tagName);
        }

        @Override
        protected final int cost() {
            return 1;
        }

        public final String toString() {
            return String.format("%s", this.tagName);
        }
    }
}

