/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import java.util.Arrays;
import java.util.BitSet;

public class ImmutableBitSet {
    public static final ImmutableBitSet EMPTY = new ImmutableBitSet(new long[0]);
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private final long[] words;

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private ImmutableBitSet(long[] words) {
        this.words = words;
    }

    public static ImmutableBitSet valueOf(BitSet bitSet) {
        long[] words = bitSet.toLongArray();
        return words.length == 0 ? EMPTY : new ImmutableBitSet(words);
    }

    public boolean get(int bitIndex) {
        int wordIndex = ImmutableBitSet.wordIndex(bitIndex);
        return wordIndex < this.words.length && (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean contains(ImmutableBitSet set) {
        if (this.words.length < set.words.length) {
            return false;
        }
        for (int i = 0; i < set.words.length; ++i) {
            if (this.words[i] == (set.words[i] | this.words[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.words);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImmutableBitSet)) {
            return false;
        }
        ImmutableBitSet set = (ImmutableBitSet)obj;
        if (this == obj) {
            return true;
        }
        return Arrays.equals(this.words, set.words);
    }
}

