/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.util;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class BootstrapUtils {
    private static final Logger log = Logger.getLogger(BootstrapUtils.class);
    private static final int CP_CACHE_FORMAT_ID = 2;
    private static Pattern splitByWs;

    public static String[] splitByWhitespace(String s) {
        if (s == null) {
            return null;
        }
        if (splitByWs == null) {
            splitByWs = Pattern.compile("\\s+");
        }
        return splitByWs.split(s);
    }

    public static ArtifactKey[] parseDependencyCondition(String s) {
        String[] strArr = BootstrapUtils.splitByWhitespace(s);
        if (strArr == null) {
            return null;
        }
        ArtifactKey[] keys = new ArtifactKey[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            keys[i] = GACT.fromString(strArr[i]);
        }
        return keys;
    }

    public static void exportModel(ApplicationModel model, boolean test) throws AppModelResolverException, IOException {
        Path serializedModel = BootstrapUtils.serializeAppModel(model, test);
        System.setProperty(test ? "quarkus-internal-test.serialized-app-model.path" : "quarkus-internal.serialized-app-model.path", serializedModel.toString());
    }

    public static Path serializeAppModel(ApplicationModel model, boolean test) throws AppModelResolverException, IOException {
        Path serializedModel = File.createTempFile("quarkus-" + (test ? "test-" : "") + "app-model", ".dat").toPath();
        BootstrapUtils.serializeAppModel(model, serializedModel);
        return serializedModel;
    }

    public static void serializeAppModel(ApplicationModel model, Path serializedModel) throws IOException {
        Files.createDirectories(serializedModel.getParent(), new FileAttribute[0]);
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(serializedModel, new OpenOption[0]));){
            out.writeObject(model);
        }
    }

    public static Path serializeQuarkusModel(ApplicationModel model) throws IOException {
        Path serializedModel = File.createTempFile("quarkus-model", ".dat").toPath();
        BootstrapUtils.serializeAppModel(model, serializedModel);
        return serializedModel;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ApplicationModel deserializeQuarkusModel(Path modelPath) throws AppModelResolverException {
        if (Files.exists(modelPath, new LinkOption[0])) {
            try (InputStream existing = Files.newInputStream(modelPath, new OpenOption[0]);){
                ApplicationModel applicationModel;
                try (ObjectInputStream object = new ObjectInputStream(existing);){
                    ApplicationModel model = (ApplicationModel)object.readObject();
                    IoUtils.recursiveDelete(modelPath);
                    applicationModel = model;
                }
                return applicationModel;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new AppModelResolverException("Failed to deserialize quarkus model", e);
            }
        }
        throw new AppModelResolverException("Unable to locate quarkus model");
    }

    public static Path resolveSerializedAppModelPath(Path projectBuildDir) {
        return BootstrapUtils.getBootstrapBuildDir(projectBuildDir).resolve("dev-app-model.dat");
    }

    public static Path getSerializedTestAppModelPath(Path projectBuildDir) {
        return BootstrapUtils.getBootstrapBuildDir(projectBuildDir).resolve("test-app-model.dat");
    }

    private static Path getBootstrapBuildDir(Path projectBuildDir) {
        return projectBuildDir.resolve("quarkus").resolve("bootstrap");
    }

    public static void writeAppModelWithWorkspaceId(ApplicationModel appModel, int workspaceId, Path file) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            out.writeInt(2);
            out.writeInt(workspaceId);
            out.writeObject(appModel);
        }
        log.debugf("Serialized application model to %s", (Object)file);
    }

    public static ApplicationModel readAppModelWithWorkspaceId(Path file, int workspaceId) throws ClassNotFoundException, IOException {
        try (ObjectInputStream reader = new ObjectInputStream(Files.newInputStream(file, new OpenOption[0]));){
            if (reader.readInt() == 2) {
                if (reader.readInt() == workspaceId) {
                    ApplicationModel appModel = (ApplicationModel)reader.readObject();
                    log.debugf("Loaded application model %s from %s", (Object)appModel, (Object)file);
                    for (ResolvedDependency d : appModel.getDependencies(8)) {
                        for (Path p : d.getResolvedPaths()) {
                            if (Files.exists(p, new LinkOption[0])) continue;
                            throw new IOException("Cached artifact does not exist: " + String.valueOf(p));
                        }
                    }
                    ApplicationModel applicationModel = appModel;
                    return applicationModel;
                }
                log.debugf("Application model saved in %s has a different workspace ID", (Object)file);
            } else {
                log.debugf("Unsupported application model serialization format in %s", (Object)file);
            }
        }
        return null;
    }
}

