/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import java.util.ArrayList;
import java.util.Set;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.hibernate.bytecode.internal.bytebuddy.BytecodeProviderImpl;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyProxyHelper;

final class ProxyBuildingHelper
implements AutoCloseable {
    private static final ElementMatcher<? super MethodDescription.InDefinedShape> NO_ARG_CONSTRUCTOR = ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesNoArguments());
    private final TypePool typePool;
    private ByteBuddyProxyHelper byteBuddyProxyHelper;
    private BytecodeProviderImpl bytecodeProvider;

    public ProxyBuildingHelper(TypePool typePool) {
        this.typePool = typePool;
    }

    public DynamicType.Unloaded<?> buildUnloadedProxy(String mappedClassName, Set<String> interfaceNames) {
        ArrayList<TypeDescription> interfaces = new ArrayList<TypeDescription>();
        boolean i = false;
        for (String name : interfaceNames) {
            interfaces.add(this.typePool.describe(name).resolve());
        }
        return this.getByteBuddyProxyHelper().buildUnloadedProxy(this.typePool, (TypeDefinition)this.typePool.describe(mappedClassName).resolve(), interfaces);
    }

    private ByteBuddyProxyHelper getByteBuddyProxyHelper() {
        if (this.byteBuddyProxyHelper == null) {
            this.bytecodeProvider = new BytecodeProviderImpl(ClassFileVersion.JAVA_V11);
            this.byteBuddyProxyHelper = this.bytecodeProvider.getByteBuddyProxyHelper();
        }
        return this.byteBuddyProxyHelper;
    }

    public boolean isProxiable(String managedClassOrPackageName) {
        TypePool.Resolution mappedClassResolution = this.typePool.describe(managedClassOrPackageName);
        if (!mappedClassResolution.isResolved()) {
            return false;
        }
        TypeDescription mappedClass = mappedClassResolution.resolve();
        return !mappedClass.isFinal() && !((MethodList)mappedClass.getDeclaredMethods().filter(NO_ARG_CONSTRUCTOR)).isEmpty();
    }

    @Override
    public void close() {
        if (this.bytecodeProvider != null) {
            this.bytecodeProvider.resetCaches();
            this.bytecodeProvider = null;
            this.byteBuddyProxyHelper = null;
        }
    }
}

