/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.ResultMapper;

abstract class CharReplacementResultMapper
implements ResultMapper {
    CharReplacementResultMapper() {
    }

    @Override
    public String map(Object result, Expression expression) {
        return this.escape(result.toString());
    }

    String escape(String value) {
        if (value.length() == 0) {
            return value;
        }
        for (int i = 0; i < value.length(); ++i) {
            String replacement = this.replacementFor(value.charAt(i));
            if (replacement == null) continue;
            StringBuilder builder = new StringBuilder(replacement.length() + (value.length() - 1));
            builder.append(value, 0, i);
            builder.append(replacement);
            return this.doEscape(value, i, builder);
        }
        return value.toString();
    }

    private String doEscape(String value, int index, StringBuilder builder) {
        int length = value.length();
        while (++index < length) {
            char c = value.charAt(index);
            String replacement = this.replacementFor(c);
            if (replacement != null) {
                builder.append(replacement);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    protected abstract String replacementFor(char var1);
}

