/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.block;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.AbstractDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDisk;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskKeyStore;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs3.engine.control.group.GroupAttrName;
import org.apache.commons.jcs3.engine.control.group.GroupId;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class BlockDiskCache<K, V>
extends AbstractDiskCache<K, V>
implements IRequireScheduler {
    private static final Log log = LogManager.getLog(BlockDiskCache.class);
    private final String logCacheName;
    private final String fileName;
    private BlockDisk dataFile;
    private final BlockDiskCacheAttributes blockDiskCacheAttributes;
    private final File rootDirectory;
    private BlockDiskKeyStore<K> keyStore;
    private final ReentrantReadWriteLock storageLock = new ReentrantReadWriteLock();
    private ScheduledFuture<?> future;

    public BlockDiskCache(BlockDiskCacheAttributes cacheAttributes) {
        this(cacheAttributes, new StandardSerializer());
    }

    public BlockDiskCache(BlockDiskCacheAttributes cacheAttributes, IElementSerializer elementSerializer) {
        super(cacheAttributes);
        this.setElementSerializer(elementSerializer);
        this.blockDiskCacheAttributes = cacheAttributes;
        this.logCacheName = "Region [" + this.getCacheName() + "] ";
        log.info("{0}: Constructing BlockDiskCache with attributes {1}", this.logCacheName, cacheAttributes);
        this.fileName = this.getCacheName().replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        this.rootDirectory = cacheAttributes.getDiskPath();
        log.info("{0}: Cache file root directory: [{1}]", this.logCacheName, this.rootDirectory);
        try {
            this.dataFile = this.blockDiskCacheAttributes.getBlockSizeBytes() > 0 ? new BlockDisk(new File(this.rootDirectory, this.fileName + ".data"), this.blockDiskCacheAttributes.getBlockSizeBytes(), this.getElementSerializer()) : new BlockDisk(new File(this.rootDirectory, this.fileName + ".data"), this.getElementSerializer());
            this.keyStore = new BlockDiskKeyStore(this.blockDiskCacheAttributes, this);
            boolean alright = this.verifyDisk();
            if (this.keyStore.isEmpty() || !alright) {
                this.reset();
            }
            this.setAlive(true);
            log.info("{0}: Block Disk Cache is alive.", this.logCacheName);
        }
        catch (IOException e) {
            log.error("{0}: Failure initializing for fileName: {1} and root directory: {2}", this.logCacheName, this.fileName, this.rootDirectory, e);
        }
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutor) {
        if (this.blockDiskCacheAttributes.getKeyPersistenceIntervalSeconds() > 0L) {
            this.future = scheduledExecutor.scheduleAtFixedRate(this.keyStore::saveKeys, this.blockDiskCacheAttributes.getKeyPersistenceIntervalSeconds(), this.blockDiskCacheAttributes.getKeyPersistenceIntervalSeconds(), TimeUnit.SECONDS);
        }
    }

    protected boolean verifyDisk() {
        boolean alright = false;
        this.storageLock.readLock().lock();
        try {
            this.keyStore.entrySet().stream().limit(100L).forEach(entry -> {
                try {
                    Object data = this.dataFile.read((int[])entry.getValue());
                    if (data == null) {
                        throw new IOException("Data is null");
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new RuntimeException(this.logCacheName + " Couldn't find data for key [" + entry.getKey() + "]", e);
                }
            });
            alright = true;
        }
        catch (Exception e) {
            log.warn("{0}: Problem verifying disk.", this.logCacheName, e);
            alright = false;
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return alright;
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet<K> keys = new HashSet<K>();
        this.storageLock.readLock().lock();
        try {
            keys.addAll(this.keyStore.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return keys;
    }

    @Override
    public Map<K, ICacheElement<K, V>> processGetMatching(String pattern) {
        HashSet<K> keyArray = null;
        this.storageLock.readLock().lock();
        try {
            keyArray = new HashSet<K>(this.keyStore.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        Set matchingKeys = this.getKeyMatcher().getMatchingKeysFromArray(pattern, keyArray);
        return matchingKeys.stream().collect(Collectors.toMap(key -> key, this::processGet)).entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public int getSize() {
        return this.keyStore.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ICacheElement<K, V> processGet(K key) {
        if (!this.isAlive()) {
            log.debug("{0}: No longer alive so returning null for key = {1}", this.logCacheName, key);
            return null;
        }
        log.debug("{0}: Trying to get from disk: {1}", this.logCacheName, key);
        ICacheElement object = null;
        try {
            this.storageLock.readLock().lock();
            try {
                int[] ded = this.keyStore.get(key);
                if (ded != null) {
                    object = (ICacheElement)this.dataFile.read(ded);
                }
            }
            finally {
                this.storageLock.readLock().unlock();
            }
        }
        catch (IOException ioe) {
            log.error("{0}: Failure getting from disk--IOException, key = {1}", this.logCacheName, key, ioe);
            this.reset();
        }
        catch (Exception e) {
            log.error("{0}: Failure getting from disk, key = {1}", this.logCacheName, key, e);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processUpdate(ICacheElement<K, V> element) {
        if (!this.isAlive()) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> this.logCacheName;
            supplierArray[1] = element::getKey;
            log.debug("{0}: No longer alive; aborting put of key = {1}", supplierArray);
            return;
        }
        int[] old = null;
        this.storageLock.writeLock().lock();
        try {
            old = this.keyStore.get(element.getKey());
            if (old != null) {
                this.dataFile.freeBlocks(old);
            }
            int[] blocks = this.dataFile.write(element);
            this.keyStore.put(element.getKey(), blocks);
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> this.logCacheName;
            supplierArray[1] = () -> this.fileName;
            supplierArray[2] = element::getKey;
            log.debug("{0}: Put to file [{1}] key [{2}]", supplierArray);
        }
        catch (IOException e) {
            log.error("{0}: Failure updating element, key: {1} old: {2}", this.logCacheName, element.getKey(), Arrays.toString(old), e);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> this.logCacheName;
        supplierArray[1] = element::getKey;
        log.debug("{0}: Storing element on disk, key: {1}", supplierArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processRemove(K key) {
        if (!this.isAlive()) {
            log.debug("{0}: No longer alive so returning false for key = {1}", this.logCacheName, key);
            return false;
        }
        boolean reset = false;
        boolean removed = false;
        this.storageLock.writeLock().lock();
        try {
            removed = key instanceof String && key.toString().endsWith(":") ? this.performPartialKeyRemoval((String)key) : (key instanceof GroupAttrName && ((GroupAttrName)key).attrName == null ? this.performGroupRemoval(((GroupAttrName)key).groupId) : this.performSingleKeyRemoval(key));
        }
        catch (Exception e) {
            log.error("{0}: Problem removing element.", this.logCacheName, e);
            reset = true;
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (reset) {
            this.reset();
        }
        return removed;
    }

    private boolean performGroupRemoval(GroupId key) {
        List<Object> itemsToRemove = this.keyStore.keySet().stream().filter(k -> k instanceof GroupAttrName && ((GroupAttrName)k).groupId.equals(key)).collect(Collectors.toList());
        itemsToRemove.forEach(this::performSingleKeyRemoval);
        return !itemsToRemove.isEmpty();
    }

    private boolean performPartialKeyRemoval(String key) {
        List<Object> itemsToRemove = this.keyStore.keySet().stream().filter(k -> k instanceof String && k.toString().startsWith(key)).collect(Collectors.toList());
        itemsToRemove.forEach(this::performSingleKeyRemoval);
        return !itemsToRemove.isEmpty();
    }

    private boolean performSingleKeyRemoval(K key) {
        boolean removed;
        int[] ded = this.keyStore.remove(key);
        boolean bl = removed = ded != null;
        if (removed) {
            this.dataFile.freeBlocks(ded);
        }
        log.debug("{0}: Disk removal: Removed from key hash, key [{1}] removed = {2}", this.logCacheName, key, removed);
        return removed;
    }

    @Override
    protected void processRemoveAll() {
        this.reset();
    }

    @Override
    public void processDispose() {
        Thread t = new Thread(this::disposeInternal, "BlockDiskCache-DisposalThread");
        t.start();
        try {
            t.join(60000L);
        }
        catch (InterruptedException ex) {
            log.error("{0}: Interrupted while waiting for disposal thread to finish.", this.logCacheName, ex);
        }
    }

    protected void disposeInternal() {
        if (!this.isAlive()) {
            log.error("{0}: Not alive and dispose was called, filename: {1}", this.logCacheName, this.fileName);
            return;
        }
        this.storageLock.writeLock().lock();
        try {
            this.setAlive(false);
            this.keyStore.saveKeys();
            if (this.future != null) {
                this.future.cancel(true);
            }
            try {
                log.debug("{0}: Closing files, base filename: {1}", this.logCacheName, this.fileName);
                this.dataFile.close();
            }
            catch (IOException e) {
                log.error("{0}: Failure closing files in dispose, filename: {1}", this.logCacheName, this.fileName, e);
            }
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        log.info("{0}: Shutdown complete.", this.logCacheName);
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.blockDiskCacheAttributes;
    }

    private void reset() {
        log.info("{0}: Resetting cache", this.logCacheName);
        try {
            this.storageLock.writeLock().lock();
            this.keyStore.reset();
            if (this.dataFile != null) {
                this.dataFile.reset();
            }
        }
        catch (IOException e) {
            log.error("{0}: Failure resetting state", this.logCacheName, e);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    protected void freeBlocks(int[] blocksToFree) {
        this.dataFile.freeBlocks(blocksToFree);
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Block Disk Cache");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Boolean>("Is Alive", this.isAlive()));
        elems.add(new StatElement<Integer>("Key Map Size", this.keyStore.size()));
        if (this.dataFile != null) {
            try {
                elems.add(new StatElement<Long>("Data File Length", this.dataFile.length()));
            }
            catch (IOException e) {
                log.error(e);
            }
            elems.add(new StatElement<Integer>("Block Size Bytes", this.dataFile.getBlockSizeBytes()));
            elems.add(new StatElement<Integer>("Number Of Blocks", this.dataFile.getNumberOfBlocks()));
            elems.add(new StatElement<Long>("Average Put Size Bytes", this.dataFile.getAveragePutSizeBytes()));
            elems.add(new StatElement<Integer>("Empty Blocks", this.dataFile.getEmptyBlocks()));
        }
        IStats sStats = super.getStatistics();
        elems.addAll(sStats.getStatElements());
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    protected String getDiskLocation() {
        return this.dataFile.getFilePath();
    }
}

