/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.LocalizableReport;
import com.adobe.epubcheck.messages.LocaleHolder;
import com.adobe.epubcheck.messages.LocalizedMessageDictionary;
import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.messages.MessageDictionary;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.messages.OverriddenMessageDictionary;
import com.adobe.epubcheck.messages.Severity;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.ReportingLevel;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public abstract class MasterReport
implements LocalizableReport {
    public static Set<MessageId> allReportedMessageIds = new HashSet<MessageId>();
    private int errorCount;
    private int warningCount;
    private int fatalErrorCount;
    private int usageCount;
    private int infoCount = 0;
    private int reportingLevel = 2;
    private String ePubName;
    private MessageDictionary dictionary = new LocalizedMessageDictionary();
    private Messages messages = Messages.getInstance();
    @JsonProperty
    String customMessageFileName = null;

    @Override
    public MessageDictionary getDictionary() {
        return this.dictionary;
    }

    protected MasterReport() {
        this(true);
    }

    protected MasterReport(boolean setLocale) {
        if (setLocale) {
            LocaleHolder.set(Locale.getDefault());
        }
    }

    @Override
    public void setLocale(Locale locale) {
        this.dictionary = new LocalizedMessageDictionary(locale);
        this.messages = Messages.getInstance(locale);
        LocaleHolder.set(locale);
    }

    @Override
    public Locale getLocale() {
        return this.messages.getLocale();
    }

    public Messages getMessages() {
        return this.messages;
    }

    @Override
    public void setOverrideFile(File overrideFile) {
        this.dictionary = new OverriddenMessageDictionary(overrideFile, this);
    }

    private void reportMessageId(MessageId id) {
        allReportedMessageIds.add(id);
    }

    @Override
    public void message(MessageId id, EPUBLocation location, Object ... args) {
        Message message = this.getDictionary().getMessage(id);
        assert (message != null);
        Severity severity = message.getSeverity();
        if (ReportingLevel.getReportingLevel(severity) >= this.getReportingLevel()) {
            if (severity.equals((Object)Severity.ERROR)) {
                ++this.errorCount;
            } else if (severity.equals((Object)Severity.WARNING)) {
                ++this.warningCount;
            } else if (severity.equals((Object)Severity.FATAL)) {
                ++this.fatalErrorCount;
            } else if (severity.equals((Object)Severity.USAGE)) {
                ++this.usageCount;
            } else if (severity.equals((Object)Severity.INFO)) {
                ++this.infoCount;
            }
            this.message(message, location, args);
        }
        this.reportMessageId(id);
    }

    @Override
    public void setCustomMessageFile(String customMessageFileName) {
        this.customMessageFileName = customMessageFileName;
    }

    @Override
    public String getCustomMessageFile() {
        return this.customMessageFileName;
    }

    @Override
    public int getReportingLevel() {
        return this.reportingLevel;
    }

    @Override
    public void setReportingLevel(int reportingLevel) {
        if (reportingLevel >= 1 && reportingLevel <= 5) {
            this.reportingLevel = reportingLevel;
        } else {
            System.err.printf("Attempted to set invalid reporting level: %1d", reportingLevel);
        }
    }

    @Override
    public String getEpubFileName() {
        return this.ePubName;
    }

    @Override
    public void setEpubFileName(String value) {
        this.ePubName = value;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public int getFatalErrorCount() {
        return this.fatalErrorCount;
    }

    @Override
    public int getInfoCount() {
        return this.infoCount;
    }

    @Override
    public int getUsageCount() {
        return this.usageCount;
    }

    @Override
    public void close() {
    }
}

