/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.ValueRestrictDatatype;
import java.math.BigDecimal;
import org.relaxng.datatype.DatatypeException;

class ScaleRestrictDatatype
extends ValueRestrictDatatype {
    private final int scale;

    ScaleRestrictDatatype(DatatypeBase datatypeBase, int n) {
        super(datatypeBase);
        this.scale = n;
    }

    @Override
    void checkRestriction(Object object) throws DatatypeException {
        int n = ((BigDecimal)object).scale();
        if (n > this.scale) {
            String string;
            switch (this.scale) {
                case 0: {
                    string = ScaleRestrictDatatype.localizer().message("scale_0_violation");
                    break;
                }
                case 1: {
                    string = ScaleRestrictDatatype.localizer().message("scale_1_violation", n);
                    break;
                }
                default: {
                    string = ScaleRestrictDatatype.localizer().message("scale_violation", this.scale, n);
                }
            }
            throw new DatatypeException(string);
        }
    }
}

