/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.hof.FunctionLiteral;
import net.sf.saxon.functions.hof.PartialApply;
import net.sf.saxon.functions.hof.UnresolvedXQueryFunctionItem;
import net.sf.saxon.functions.hof.UserFunctionReference;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.functions.registry.XPath31FunctionSet;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyFunctionTypeWithAssertions;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

public class ParserExtension {
    private void needExtension(XPathParser p, String what) throws XPathException {
        p.grumble(what + " require support for Saxon extensions, available in Saxon-PE or higher");
    }

    private void needUpdate(XPathParser p, String what) throws XPathException {
        p.grumble(what + " requires support for XQuery Update, available in Saxon-EE or higher");
    }

    public Expression parseNamedFunctionReference(XPathParser p) throws XPathException {
        BuiltInFunctionSet.Entry details;
        StructuredQName functionName;
        int arity;
        StaticContext env;
        int offset;
        block9: {
            Tokenizer t = p.getTokenizer();
            String fname = t.currentTokenValue;
            offset = t.currentTokenStartOffset;
            env = p.getStaticContext();
            p.nextToken();
            p.expect(209);
            NumericValue number = NumericValue.parseNumber(t.currentTokenValue);
            if (!(number instanceof IntegerValue)) {
                p.grumble("Number following '#' must be an integer");
            }
            if (number.compareTo(0L) < 0 || number.compareTo(Integer.MAX_VALUE) > 0) {
                p.grumble("Number following '#' is out of range", "FOAR0002");
            }
            arity = (int)number.longValue();
            p.nextToken();
            functionName = null;
            try {
                functionName = p.getQNameParser().parse(fname, env.getDefaultFunctionNamespace());
                if (functionName.getPrefix().equals("") && XPathParser.isReservedFunctionName31(functionName.getLocalPart())) {
                    p.grumble("The unprefixed function name '" + functionName.getLocalPart() + "' is reserved in XPath 3.1");
                }
            }
            catch (XPathException e) {
                p.grumble(e.getMessage(), e.getErrorCodeLocalPart());
                if ($assertionsDisabled || functionName != null) break block9;
                throw new AssertionError();
            }
        }
        Function fcf = null;
        try {
            FunctionLibrary lib = env.getFunctionLibrary();
            SymbolicName.F sn = new SymbolicName.F(functionName, arity);
            fcf = lib.getFunctionItem(sn, env);
            if (fcf == null) {
                p.grumble("Function " + functionName.getEQName() + "#" + arity + " not found", "XPST0017", offset);
            }
        }
        catch (XPathException e) {
            p.grumble(e.getMessage(), "XPST0017", offset);
        }
        if (functionName.hasURI("http://www.w3.org/2005/xpath-functions") && fcf instanceof SystemFunction && (details = ((SystemFunction)fcf).getDetails()) != null && (details.properties & 0x583C) != 0) {
            SystemFunction lookup = XPath31FunctionSet.getInstance().makeFunction("function-lookup", 2);
            lookup.setRetainedStaticContext(env.makeRetainedStaticContext());
            return lookup.makeFunctionCall(Literal.makeLiteral(new QNameValue(functionName, BuiltInAtomicType.QNAME)), Literal.makeLiteral(Int64Value.makeIntegerValue(arity)));
        }
        Expression ref = ParserExtension.makeNamedFunctionReference(functionName, fcf);
        p.setLocation(ref, offset);
        return ref;
    }

    private static Expression makeNamedFunctionReference(StructuredQName functionName, Function fcf) {
        if (fcf instanceof UserFunction && !functionName.hasURI("http://www.w3.org/1999/XSL/Transform")) {
            return new UserFunctionReference((UserFunction)fcf);
        }
        if (fcf instanceof UnresolvedXQueryFunctionItem) {
            return ((UnresolvedXQueryFunctionItem)fcf).getFunctionReference();
        }
        return new FunctionLiteral(fcf);
    }

    public ItemType parseFunctionItemType(XPathParser p, AnnotationList annotations) throws XPathException {
        Tokenizer t = p.getTokenizer();
        p.nextToken();
        ArrayList<SequenceType> argTypes = new ArrayList<SequenceType>(3);
        if (t.currentToken == 207 || t.currentToken == 17) {
            p.nextToken();
            p.expect(204);
            p.nextToken();
            if (annotations.isEmpty()) {
                return AnyFunctionType.getInstance();
            }
            return new AnyFunctionTypeWithAssertions(annotations, p.getStaticContext().getConfiguration());
        }
        while (t.currentToken != 204) {
            SequenceType arg = p.parseSequenceType();
            argTypes.add(arg);
            if (t.currentToken == 204) break;
            if (t.currentToken == 7) {
                p.nextToken();
                continue;
            }
            p.grumble("Expected ',' or ')' after function argument type, found '" + Token.tokens[t.currentToken] + '\'');
        }
        p.nextToken();
        if (t.currentToken == 71) {
            p.nextToken();
            SequenceType resultType = p.parseSequenceType();
            SequenceType[] argArray = new SequenceType[argTypes.size()];
            argArray = argTypes.toArray(argArray);
            return new SpecificFunctionType(argArray, resultType, annotations);
        }
        if (!argTypes.isEmpty()) {
            p.grumble("Result type must be given if an argument type is given: expected 'as (type)'");
            return null;
        }
        p.grumble("function() is no longer allowed for a general function type: must be function(*)");
        return null;
    }

    public ItemType parseExtendedItemType(XPathParser p) throws XPathException {
        return null;
    }

    public Expression parseTypePattern(XPathParser p) throws XPathException {
        this.needExtension(p, "type-based patterns");
        return null;
    }

    public Expression parseDotFunction(XPathParser p) throws XPathException {
        this.needExtension(p, "Dot functions");
        return null;
    }

    public Expression parseUnderscoreFunction(XPathParser p) throws XPathException {
        this.needExtension(p, "Underscore functions");
        return null;
    }

    public Expression bindNumericParameterReference(XPathParser p) throws XPathException {
        this.needExtension(p, "Underscore functions");
        return null;
    }

    public Expression makeCurriedFunction(XPathParser parser, int offset, StructuredQName name, Expression[] args, IntSet placeMarkers) throws XPathException {
        SymbolicName.F sn;
        StaticContext env = parser.getStaticContext();
        FunctionLibrary lib = env.getFunctionLibrary();
        Function target = lib.getFunctionItem(sn = new SymbolicName.F(name, args.length), env);
        if (target == null) {
            ArrayList<String> reasons = new ArrayList<String>();
            return parser.reportMissingFunction(offset, name, args, reasons);
        }
        Expression targetExp = ParserExtension.makeNamedFunctionReference(name, target);
        parser.setLocation(targetExp, offset);
        return ParserExtension.curryFunction(targetExp, args, placeMarkers);
    }

    public static Expression curryFunction(Expression functionExp, Expression[] args, IntSet placeMarkers) {
        IntIterator ii = placeMarkers.iterator();
        while (ii.hasNext()) {
            args[ii.next()] = null;
        }
        return new PartialApply(functionExp, args);
    }

    public Expression createDynamicCurriedFunction(XPathParser p, Expression functionItem, ArrayList<Expression> args, IntSet placeMarkers) {
        Expression[] arguments = new Expression[args.size()];
        arguments = args.toArray(arguments);
        Expression result = ParserExtension.curryFunction(functionItem, arguments, placeMarkers);
        p.setLocation(result, p.getTokenizer().currentTokenStartOffset);
        return result;
    }

    public void handleExternalFunctionDeclaration(XQueryParser p, XQueryFunction func) throws XPathException {
        this.needExtension(p, "External function declarations");
    }

    public void parseTypeAliasDeclaration(XQueryParser p) throws XPathException {
        this.needExtension(p, "Type alias declarations");
    }

    public void parseRevalidationDeclaration(XQueryParser p) throws XPathException {
        this.needUpdate(p, "A revalidation declaration");
    }

    public void parseUpdatingFunctionDeclaration(XQueryParser p) throws XPathException {
        this.needUpdate(p, "An updating function");
    }

    protected Expression parseExtendedExprSingle(XPathParser p) throws XPathException {
        return null;
    }

    protected Expression parseForMemberExpression(XPathParser p) throws XPathException {
        return null;
    }

    public static class TemporaryXSLTVariableBinding
    implements LocalBinding {
        SourceBinding declaration;

        public TemporaryXSLTVariableBinding(SourceBinding decl) {
            this.declaration = decl;
        }

        @Override
        public SequenceType getRequiredType() {
            return this.declaration.getInferredType(true);
        }

        @Override
        public Sequence evaluateVariable(XPathContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGlobal() {
            return false;
        }

        @Override
        public boolean isAssignable() {
            return false;
        }

        @Override
        public int getLocalSlotNumber() {
            return 0;
        }

        @Override
        public StructuredQName getVariableQName() {
            return this.declaration.getVariableQName();
        }

        @Override
        public void addReference(VariableReference ref, boolean isLoopingReference) {
        }

        @Override
        public IntegerValue[] getIntegerBoundsForVariable() {
            return null;
        }

        @Override
        public void setIndexedVariable() {
        }

        @Override
        public boolean isIndexedVariable() {
            return false;
        }
    }
}

