/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.resource;

import com.projectlibre1.menu.HyperLinkToolTip;
import com.projectlibre1.pm.graphic.IconManager;
import com.projectlibre1.util.ClassLoaderUtils;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JToolTip;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.JToolbarButton;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceFormatException;
import org.apache.batik.util.gui.resource.ResourceManager;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class ButtonFactory
extends ResourceManager {
    private static final String ICON_SUFFIX = ".icon";
    private static final String TITLE_SUFFIX = ".title";
    private static final String TEXT_SUFFIX = ".text";
    private static final String MNEMONIC_SUFFIX = ".mnemonic";
    private static final String ACTION_SUFFIX = ".action";
    private static final String SELECTED_SUFFIX = ".selected";
    public static final String TOOLTIP_SUFFIX = ".tooltip";
    public static final String HELP_SUFFIX = ".help";
    public static final String DEMO_SUFFIX = ".demo";
    public static final String DOC_SUFFIX = ".doc";
    private ActionMap actions;
    protected ClassLoader classLoader;

    public ButtonFactory(ActionMap actionMap, ResourceBundle ... resourceBundleArray) {
        super(resourceBundleArray);
        this.actions = actionMap;
        this.classLoader = ClassLoaderUtils.getLocalClassLoader();
    }

    public JButton createJButton(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JButton jButton;
        try {
            jButton = new JButton(this.getString(string + TEXT_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            jButton = new JButton();
        }
        this.initializeButton(jButton, string);
        return jButton;
    }

    public AbstractButton createJToolbarButton(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JToolbarButton jToolbarButton = new JToolbarButton(){

            @Override
            public Point getToolTipLocation(MouseEvent mouseEvent) {
                if (this.getToolTipText().startsWith("<html>")) {
                    return new Point(0, this.getHeight() - 2);
                }
                return super.getToolTipLocation(mouseEvent);
            }

            @Override
            public JToolTip createToolTip() {
                if (this.getToolTipText().startsWith("<html>")) {
                    HyperLinkToolTip hyperLinkToolTip = new HyperLinkToolTip();
                    hyperLinkToolTip.setComponent(this);
                    return hyperLinkToolTip;
                }
                return super.createToolTip();
            }
        };
        this.initializeButton(jToolbarButton, string);
        return jToolbarButton;
    }

    public AbstractCommandButton createRibbonButton(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        Object object;
        String string2;
        ResizableIcon resizableIcon = null;
        try {
            string2 = this.getString(string + ICON_SUFFIX);
            resizableIcon = IconManager.getRibbonIcon(string2);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        string2 = null;
        try {
            string2 = this.getString(string + TEXT_SUFFIX);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        JCommandButton jCommandButton = null;
        if (resizableIcon != null && string2 != null) {
            jCommandButton = new JCommandButton(string2, resizableIcon);
        } else if (resizableIcon != null) {
            jCommandButton = new JCommandButton(resizableIcon);
        } else if (string2 != null) {
            jCommandButton = new JCommandButton(string2);
        }
        try {
            object = this.actions.getAction(this.getString(string + ACTION_SUFFIX));
            if (object == null) {
                throw new MissingListenerException("", "Action", string + ACTION_SUFFIX);
            }
            jCommandButton.addActionListener((ActionListener)object);
            jCommandButton.setText(this.getString(string + TEXT_SUFFIX));
            if (object instanceof JComponentModifier) {
                ((JComponentModifier)object).addJComponent(jCommandButton);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            object = this.getStringOrNull(string + TOOLTIP_SUFFIX);
            if (object != null) {
                String string3 = this.getStringOrNull(string + HELP_SUFFIX);
                String string4 = this.getStringOrNull(string + DEMO_SUFFIX);
                String string5 = this.getStringOrNull(string + DOC_SUFFIX);
                if (string5 != null) {
                    object = HyperLinkToolTip.helpTipText((String)object, string3, string4, string5);
                }
                jCommandButton.setActionRichTooltip(new RichTooltip(" ", (String)object));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jCommandButton;
    }

    public JRadioButton createJRadioButton(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JRadioButton jRadioButton = new JRadioButton(this.getString(string + TEXT_SUFFIX));
        this.initializeButton(jRadioButton, string);
        try {
            jRadioButton.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jRadioButton;
    }

    public JCheckBox createJCheckBox(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JCheckBox jCheckBox = new JCheckBox(this.getString(string + TEXT_SUFFIX));
        this.initializeButton(jCheckBox, string);
        try {
            jCheckBox.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jCheckBox;
    }

    protected void initializeButton(AbstractButton abstractButton, String string) throws ResourceFormatException, MissingListenerException {
        Object object;
        Object object2;
        try {
            object2 = this.actions.getAction(this.getString(string + ACTION_SUFFIX));
            if (object2 == null) {
                throw new MissingListenerException("", "Action", string + ACTION_SUFFIX);
            }
            abstractButton.setAction((Action)object2);
            abstractButton.setText(this.getString(string + TEXT_SUFFIX));
            if (object2 instanceof JComponentModifier) {
                ((JComponentModifier)object2).addJComponent(abstractButton);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            object2 = this.getString(string + ICON_SUFFIX);
            object = this.classLoader.getResource((String)object2);
            if (object != null) {
                abstractButton.setIcon(new ImageIcon((URL)object));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            object2 = this.getString(string + MNEMONIC_SUFFIX);
            if (((String)object2).length() != 1) {
                throw new ResourceFormatException("Malformed mnemonic", this.bundleNames, string + MNEMONIC_SUFFIX);
            }
            abstractButton.setMnemonic(((String)object2).charAt(0));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            object2 = this.getStringOrNull(string + TOOLTIP_SUFFIX);
            if (object2 != null) {
                object = this.getStringOrNull(string + HELP_SUFFIX);
                String string2 = this.getStringOrNull(string + DEMO_SUFFIX);
                String string3 = this.getStringOrNull(string + DOC_SUFFIX);
                if (string3 != null) {
                    object2 = HyperLinkToolTip.helpTipText((String)object2, (String)object, string2, string3);
                }
                abstractButton.setToolTipText((String)object2);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

