/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.clustering;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;

public class DynamicResourceClusteringPolicy
implements IResourceClusteringPolicy {
    public static final String MINIMUM_FREE_MEMORY = "org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy.minimumFreeMemory";
    public static final String MINIMUM_CLUSTER_SIZE = "org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy.minimumClusterSize";
    public static final String MINIMUM_PERCENT_FREE_MEMORY = "org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy.minimumPercentFreeMemory";
    private static final Logger LOGGER = Logger.getLogger(DynamicResourceClusteringPolicy.class);
    private static final long MINIMUM_10MB_FREE_MEMORY = 0xA00000L;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy.minimumFreeMemory")
    private long minimumFreeMemory = 0xA00000L;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy.minimumClusterSize")
    private int minimumClusterSize = 20;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy.minimumPercentFreeMemory")
    private long minimumPercentFreeMemory = 15L;
    private static boolean hasLoggedAboutIncreasingHeap = false;

    @Override
    public boolean continueProcessing(ResourceSet resourceSet, URI next, int alreadyProcessed) {
        long totalMemory;
        if (next != null && resourceSet.getResource(next, false) != null) {
            return true;
        }
        if (alreadyProcessed == 0) {
            return true;
        }
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory > (totalMemory = Runtime.getRuntime().totalMemory()) + this.minimumFreeMemory) {
            return true;
        }
        long freeMemory = Runtime.getRuntime().freeMemory();
        if (freeMemory < this.minimumFreeMemory) {
            this.logClusterCapped(resourceSet, alreadyProcessed, freeMemory, totalMemory);
            return false;
        }
        if (alreadyProcessed < this.minimumClusterSize) {
            return true;
        }
        if (freeMemory < maxMemory / 100L * this.minimumPercentFreeMemory) {
            this.logClusterCapped(resourceSet, alreadyProcessed, freeMemory, totalMemory);
            return false;
        }
        return true;
    }

    protected void logClusterCapped(ResourceSet resourceSet, int alreadyProcessed, long freeMemory, long totalMemory) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Cluster capped at " + alreadyProcessed + "/" + resourceSet.getResources().size() + " processed/loaded resources; " + (freeMemory >> 20) + "/" + (totalMemory >> 20) + " free/total memory"));
        }
        if (!hasLoggedAboutIncreasingHeap) {
            hasLoggedAboutIncreasingHeap = true;
            LOGGER.warn((Object)("Your total heap size (" + (totalMemory >> 20) + "m) is too small (free: " + (freeMemory >> 20) + "m, max: " + (Runtime.getRuntime().maxMemory() >> 20) + "m). Please increase the maximum heap for your running JVM!"));
        }
    }

    public long getMinimumFreeMemory() {
        return this.minimumFreeMemory;
    }

    public void setMinimumFreeMemory(long minimumFreeMemory) {
        this.minimumFreeMemory = minimumFreeMemory;
    }

    public int getMinimumClusterSize() {
        return this.minimumClusterSize;
    }

    public void setMinimumClusterSize(int minimumClusterSize) {
        this.minimumClusterSize = minimumClusterSize;
    }

    public long getMinimumPercentFreeMemory() {
        return this.minimumPercentFreeMemory;
    }

    public void setMinimumPercentFreeMemory(long minimumPercentFreeMemory) {
        this.minimumPercentFreeMemory = minimumPercentFreeMemory;
    }
}

