/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2;

import com.google.common.annotations.Beta;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionFinder;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Exceptions;
import org.eclipse.xtext.util.PolymorphicDispatcher;

@Beta
public abstract class AbstractJavaFormatter
extends AbstractFormatter2 {
    private PolymorphicDispatcher<Void> dispatcher = this.createPolymorhicDispatcher();

    @Override
    public void format(Object child, IFormattableDocument document) {
        this.formatUsingPolymorphicDispatcher(child, document);
    }

    protected void formatUsingPolymorphicDispatcher(Object child, IFormattableDocument document) {
        if (child instanceof XtextResource) {
            this._format((XtextResource)((Object)child), document);
            return;
        }
        if (child == null) {
            this._format((Void)null, document);
            return;
        }
        try {
            this.dispatcher.invoke(new Object[]{child, document});
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    protected PolymorphicDispatcher<Void> createPolymorhicDispatcher() {
        return new PolymorphicDispatcher(Collections.singletonList(this), m -> "format".equals(m.getName()) && m.getParameterCount() == 2 && m.getParameterTypes()[0] != Object.class && m.getParameterTypes()[1] == IFormattableDocument.class || "_format".equals(m.getName()) && m.getParameterCount() == 2 && m.getParameterTypes()[1] == IFormattableDocument.class, (PolymorphicDispatcher.ErrorHandler)new EObjectErrorHandler());
    }

    protected ISemanticRegionsFinder allRegionsFor(EObject semanticElement) {
        return this.textRegionExtensions.allRegionsFor(semanticElement);
    }

    protected Iterable<ISemanticRegion> allSemanticRegions(EObject semanticElement) {
        return this.textRegionExtensions.allSemanticRegions(semanticElement);
    }

    protected EObject grammarElement(EObject semanticElement) {
        return this.textRegionExtensions.grammarElement(semanticElement);
    }

    protected ISemanticRegionFinder immediatelyFollowing(EObject semanticElement) {
        return this.textRegionExtensions.immediatelyFollowing(semanticElement);
    }

    protected ISemanticRegionFinder immediatelyPreceding(EObject semanticElement) {
        return this.textRegionExtensions.immediatelyPreceding(semanticElement);
    }

    protected boolean isMultiline(EObject semanticElement) {
        return this.textRegionExtensions.isMultiline(semanticElement);
    }

    protected IHiddenRegion nextHiddenRegion(EObject semanticElement) {
        return this.textRegionExtensions.nextHiddenRegion(semanticElement);
    }

    protected IHiddenRegion previousHiddenRegion(EObject semanticElement) {
        return this.textRegionExtensions.previousHiddenRegion(semanticElement);
    }

    protected ISemanticRegionsFinder regionFor(EObject semanticElement) {
        return this.textRegionExtensions.regionFor(semanticElement);
    }

    protected IEObjectRegion regionForEObject(EObject semanticElement) {
        return this.textRegionExtensions.regionForEObject(semanticElement);
    }

    protected Iterable<ISemanticRegion> semanticRegions(EObject semanticElement) {
        return this.textRegionExtensions.semanticRegions(semanticElement);
    }

    protected void autowrap(IHiddenRegionFormatter hrf) {
        hrf.autowrap();
    }

    protected void noAutowrap(IHiddenRegionFormatter hrf) {
        hrf.noAutowrap();
    }

    protected void highPriority(IHiddenRegionFormatter hrf) {
        hrf.highPriority();
    }

    protected void lowPriority(IHiddenRegionFormatter hrf) {
        hrf.lowPriority();
    }

    protected void noIndentation(IHiddenRegionFormatter hrf) {
        hrf.noIndentation();
    }

    protected void indent(IHiddenRegionFormatter hrf) {
        hrf.indent();
    }

    protected void newLine(IHiddenRegionFormatter hrf) {
        hrf.newLine();
    }

    protected void noSpace(IHiddenRegionFormatter hrf) {
        hrf.noSpace();
    }

    protected void oneSpace(IHiddenRegionFormatter hrf) {
        hrf.oneSpace();
    }

    public class EObjectErrorHandler
    implements PolymorphicDispatcher.ErrorHandler<Void> {
        public Void handle(Object[] params, Throwable e) {
            if (e instanceof NoSuchMethodException && params.length == 2 && params[0] instanceof EObject && params[1] instanceof IFormattableDocument) {
                AbstractJavaFormatter.this._format((EObject)params[0], (IFormattableDocument)params[1]);
                return null;
            }
            return (Void)Exceptions.throwUncheckedException((Throwable)e);
        }
    }
}

