/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl;

import java.io.IOException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class ConfigUtil {
    private static String encode(String value) {
        return value.replace("\\", "\\\\").replace("*", "\\*").replace("(", "\\(").replace(")", "\\)");
    }

    public static Configuration getOrCreateConfiguration(ConfigurationAdmin ca, String pid, boolean createIfNeeded) throws IOException, InvalidSyntaxException {
        String filter = "(service.pid=" + ConfigUtil.encode(pid) + ")";
        Configuration[] configs = ca.listConfigurations(filter);
        if (configs != null && configs.length > 0) {
            return configs[0];
        }
        if (!createIfNeeded) {
            return null;
        }
        int pos = pid.indexOf(126);
        if (pos != -1) {
            String factoryPid = pid.substring(0, pos);
            String alias = pid.substring(pos + 1);
            return ca.getFactoryConfiguration(factoryPid, alias, "?");
        }
        return ca.getConfiguration(pid, "?");
    }
}

