/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.lang.reflect.Method;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAnnotationValidator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.BasicEAnnotationValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DateConversionDelegateFactory
implements EDataType.Internal.ConversionDelegate.Factory {
    public static final String ANNOTATION_URI = "http:///org/eclipse/emf/ecore/util/DateConversionDelegate";
    private static final TimeZone GMT;
    private static final List<String> STYLES;
    private static final Map<String, Map<String, Set<String>>> LOCALES;
    private static final Map<String, CalendarBuilder> CALENDAR_BUILDERS;
    public static Set<String> CALENDAR_TYPES;

    static {
        Locale[] availableLocales;
        GMT = TimeZone.getTimeZone("GMT");
        STYLES = Collections.unmodifiableList(Arrays.asList("FULL", "LONG", "MEDIUM", "SHORT"));
        TreeMap<String, Map<String, Set<String>>> locales = new TreeMap<String, Map<String, Set<String>>>();
        Locale[] localeArray = availableLocales = Locale.getAvailableLocales();
        int n = availableLocales.length;
        int n2 = 0;
        while (n2 < n) {
            String country;
            TreeSet<String> variants;
            Locale locale = localeArray[n2];
            String language = locale.getLanguage();
            TreeMap countries = (TreeMap)locales.get(language);
            if (countries == null) {
                countries = new TreeMap();
                locales.put(language, countries);
            }
            if ((variants = (TreeSet<String>)countries.get(country = locale.getCountry())) == null) {
                variants = new TreeSet<String>();
                countries.put(country, variants);
            }
            String variant = locale.getVariant();
            variants.add(variant);
            ++n2;
        }
        LOCALES = locales;
        HashMap<String, CalendarBuilder> calendarBuilders = new HashMap<String, CalendarBuilder>();
        calendarBuilders.put("gregory", new CalendarBuilder());
        try {
            final Class<?> calendarBuilderClass = Class.forName("java.util.Calendar$Builder");
            final Method setCalendarTypeMethod = calendarBuilderClass.getMethod("setCalendarType", String.class);
            final Method setInstantMethod = calendarBuilderClass.getMethod("setInstant", Long.TYPE);
            final Method buildMethod = calendarBuilderClass.getMethod("build", new Class[0]);
            Set availableCalendarTypes = (Set)Calendar.class.getMethod("getAvailableCalendarTypes", new Class[0]).invoke(null, new Object[0]);
            for (final String calendarType : availableCalendarTypes) {
                try {
                    Object builder = calendarBuilderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    setCalendarTypeMethod.invoke(builder, calendarType);
                    setInstantMethod.invoke(builder, System.currentTimeMillis());
                    buildMethod.invoke(builder, new Object[0]);
                    calendarBuilders.put(calendarType, new CalendarBuilder(){

                        public Calendar create(long timeInstant) {
                            try {
                                Object builder = calendarBuilderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                setCalendarTypeMethod.invoke(builder, calendarType);
                                setInstantMethod.invoke(builder, timeInstant);
                                return (Calendar)buildMethod.invoke(builder, new Object[0]);
                            }
                            catch (Exception exception) {
                                throw new IllegalArgumentException(exception);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CALENDAR_BUILDERS = calendarBuilders;
        CALENDAR_TYPES = Collections.unmodifiableSet(new TreeSet<String>(CALENDAR_BUILDERS.keySet()));
    }

    public static CalendarBuilder getCalendarBuilder(String calendarType) {
        CalendarBuilder calendarBuilder = CALENDAR_BUILDERS.get(calendarType);
        return calendarBuilder;
    }

    public EDataType.Internal.ConversionDelegate createConversionDelegate(EDataType eDataType) {
        String format = EcoreUtil.getAnnotation(eDataType, ANNOTATION_URI, "format");
        if (format != null) {
            try {
                return DateConversionDelegateFactory.createConversionDelegate(eDataType, format);
            }
            catch (Exception exception) {
                EcorePlugin.INSTANCE.log(exception);
                return null;
            }
        }
        return null;
    }

    private static EDataType.Internal.ConversionDelegate createConversionDelegate(EDataType eDataType, String format) throws Exception {
        if (format != null) {
            URI formatURI = URI.createURI((String)format);
            Class<?> instanceClass = eDataType.getInstanceClass();
            if (instanceClass == Long.TYPE || instanceClass == Long.class) {
                if ("Long".equals(formatURI.authority())) {
                    return LongAsLongConversionDelegate.INSTANCE;
                }
                DateFormat dateFormat = DateConversionDelegateFactory.getDateFormat(formatURI);
                return new LongAsDateConversionDelegate(dateFormat);
            }
            if (instanceClass == java.util.Date.class) {
                if ("Long".equals(formatURI.authority())) {
                    return DateAsLongConversionDelegate.INSTANCE;
                }
                DateFormat dateFormat = DateConversionDelegateFactory.getDateFormat(formatURI);
                return new DateConversionDelegate(dateFormat);
            }
            if (instanceClass == Date.class) {
                if ("Long".equals(formatURI.authority())) {
                    return SQLDateAsLongConversionDelegate.INSTANCE;
                }
                DateFormat dateFormat = DateConversionDelegateFactory.getDateFormat(formatURI);
                return new SQLDateConversionDelegate(dateFormat);
            }
            if (instanceClass == Calendar.class) {
                CalendarBuilder calendarBuilder;
                String calendarType = formatURI.query();
                if (calendarType == null) {
                    calendarType = "gregory";
                }
                if ((calendarBuilder = CALENDAR_BUILDERS.get(calendarType)) == null) {
                    AnnotationValidator.INSTANCE.throwIllegalArgumentException(2, calendarType, CALENDAR_BUILDERS.keySet());
                }
                if ("Long".equals(formatURI.authority())) {
                    return new CalendarAsLongConversionDelegate(calendarBuilder);
                }
                DateFormat dateFormat = DateConversionDelegateFactory.getDateFormat(formatURI);
                return new CalendarConversionDelegate(dateFormat, calendarBuilder);
            }
            if (instanceClass == GregorianCalendar.class) {
                CalendarBuilder calendarBuilder = CALENDAR_BUILDERS.get("gregory");
                if ("Long".equals(formatURI.authority())) {
                    return new CalendarAsLongConversionDelegate(calendarBuilder);
                }
                DateFormat dateFormat = DateConversionDelegateFactory.getDateFormat(formatURI);
                return new CalendarConversionDelegate(dateFormat, calendarBuilder);
            }
            if (instanceClass != null && XMLGregorianCalendar.class.isAssignableFrom(instanceClass) && XMLGregorianCalendarConversionDelegate.DATATYPE_FACTORY != null) {
                if ("Long".equals(formatURI.authority())) {
                    return XMLGregorianCalendarAsLongConversionDelegate.INSTANCE;
                }
                DateFormat dateFormat = DateConversionDelegateFactory.getDateFormat(formatURI);
                return new XMLGregorianCalendarConversionDelegate(dateFormat);
            }
            AnnotationValidator.INSTANCE.throwIllegalArgumentException(15, eDataType.getInstanceTypeName(), Arrays.asList(Long.TYPE, Long.class, java.util.Date.class, Date.class, Calendar.class, XMLGregorianCalendar.class));
        }
        return null;
    }

    public static DateFormat getDateFormat(URI formatURI) throws IllegalArgumentException {
        String style = formatURI.authority();
        if ("SimpleDateFormat".equals(style)) {
            String formatPattern;
            int segmentCount = formatURI.segmentCount();
            String string = formatPattern = segmentCount == 0 ? "" : URI.decode((String)formatURI.segment(0));
            if (formatPattern.trim().length() == 0) {
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(3, new Object[0]);
            }
            Locale locale = DateConversionDelegateFactory.getLocale(1, "SimpleDateFormat", formatURI);
            try {
                return DateConversionDelegateFactory.normalizeTimeZone(new SimpleDateFormat(formatPattern, locale));
            }
            catch (IllegalArgumentException exception) {
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(14, formatPattern, exception);
                return null;
            }
        }
        if ("DateFormat".equals(style)) {
            String dateStyleValue;
            int dateStyle;
            int segmentCount = formatURI.segmentCount();
            if (segmentCount < 1) {
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(4, new Object[0]);
            }
            if ((dateStyle = STYLES.indexOf(dateStyleValue = formatURI.segment(0))) == -1) {
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(5, "DateFormat", dateStyleValue);
            }
            Locale locale = DateConversionDelegateFactory.getLocale(1, "DateFormat", formatURI);
            return DateConversionDelegateFactory.normalizeTimeZone(DateFormat.getDateInstance(dateStyle, locale));
        }
        if ("TimeFormat".equals(style)) {
            String timeStyleValue;
            int timeStyle;
            int segmentCount = formatURI.segmentCount();
            if (segmentCount < 1) {
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(6, new Object[0]);
            }
            if ((timeStyle = STYLES.indexOf(timeStyleValue = formatURI.segment(0))) == -1) {
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(7, "TimeFormat", timeStyleValue);
            }
            Locale locale = DateConversionDelegateFactory.getLocale(1, "TimeFormat", formatURI);
            return DateConversionDelegateFactory.normalizeTimeZone(DateFormat.getTimeInstance(timeStyle, locale));
        }
        if ("DateTimeFormat".equals(style)) {
            String timeStyleValue;
            int timeStyle;
            String dateStyleValue;
            int dateStyle;
            int segmentCount = formatURI.segmentCount();
            if (segmentCount < 2) {
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(8, new Object[0]);
            }
            if ((dateStyle = STYLES.indexOf(dateStyleValue = formatURI.segment(0))) == -1) {
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(5, "DateTimeFormat", dateStyleValue);
            }
            if ((timeStyle = STYLES.indexOf(timeStyleValue = formatURI.segment(1))) == -1) {
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(7, "DateTimeFormat", timeStyleValue);
            }
            Locale locale = DateConversionDelegateFactory.getLocale(2, "DateTimeFormat", formatURI);
            return DateConversionDelegateFactory.normalizeTimeZone(DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale));
        }
        AnnotationValidator.INSTANCE.throwIllegalArgumentException(9, style, Arrays.asList("Long", "SimpleDataFormat", "DateFormat", "DateTimeFormat", "TimeFormat"));
        return null;
    }

    private static DateFormat normalizeTimeZone(DateFormat dateFormat) {
        dateFormat.setTimeZone(GMT);
        return dateFormat;
    }

    private static Locale getLocale(int start, String style, URI formatURI) throws IllegalArgumentException {
        String variant;
        String country;
        String language;
        int segmentCount = formatURI.segmentCount();
        int size = segmentCount - start;
        if (size < 2 && !"SimpleDateFormat".equals(style)) {
            AnnotationValidator.INSTANCE.throwIllegalArgumentException(10, style);
        }
        if (start < segmentCount) {
            language = formatURI.segment(start);
            Map<String, Set<String>> countries = LOCALES.get(language);
            if (countries == null) {
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(11, language, LOCALES.keySet());
            }
        } else {
            language = "";
        }
        if (start + 1 < segmentCount) {
            country = formatURI.segment(start + 1);
            Map<String, Set<String>> countries = LOCALES.get(language);
            if (!countries.containsKey(country)) {
                TreeSet<String> validCountries = new TreeSet<String>(countries.keySet());
                validCountries.remove("");
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(12, country, language, validCountries);
            }
        } else {
            country = "";
        }
        if (start + 2 < segmentCount) {
            variant = formatURI.segment(start + 2);
            Map<String, Set<String>> countries = LOCALES.get(language);
            Set<String> variants = countries.get(country);
            if (!variants.contains(variant) || "".equals(variant)) {
                TreeSet<String> validVariants = new TreeSet<String>(variants);
                validVariants.remove("");
                AnnotationValidator.INSTANCE.throwIllegalArgumentException(13, variant, language, country, validVariants);
            }
        } else {
            variant = "";
        }
        Locale locale = new Locale(language, country, variant);
        return locale;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationValidator
    extends BasicEAnnotationValidator {
        public static final AnnotationValidator INSTANCE = new AnnotationValidator();
        public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecore.annotation.date.time.conversion.delegate";
        public static final int INVALID = 1;
        public static final int INVALID_CALENDAR_TYPE = 2;
        public static final int INVALID_MISSING_SIMPLE_DATE_FORMAT = 3;
        public static final int INVALID_MISSING_DATE_FORMAT = 4;
        public static final int INVALID_DATE_STYLE = 5;
        public static final int INVALID_MISSING_TIME_FORMAT = 6;
        public static final int INVALID_TIME_STYLE = 7;
        public static final int INVALID_MISSING_DATE_TIME_FORMAT = 8;
        public static final int INVALID_STYLE = 9;
        public static final int INVALID_MISSING_LOCALE = 10;
        public static final int INVALID_LANGUAGE = 11;
        public static final int INVALID_COUNTRY = 12;
        public static final int INVALID_VARIANT = 13;
        public static final int INVALID_SIMPLE_DATE_FORMAT = 14;
        public static final int INVALID_INSTANCE_TYPE = 15;

        static {
            if (!EAnnotationValidator.Registry.INSTANCE.containsKey(DateConversionDelegateFactory.ANNOTATION_URI)) {
                EAnnotationValidator.Registry.INSTANCE.put(DateConversionDelegateFactory.ANNOTATION_URI, INSTANCE);
            }
            PropertySwitch.VALID_KEYS.isEmpty();
        }

        public AnnotationValidator() {
            super(DateConversionDelegateFactory.ANNOTATION_URI, "DateConversionDelegate", DIAGNOSTIC_SOURCE);
        }

        private String getAvailableChoices(Collection<?> choices, boolean inclusive, String quote, int limit) {
            return EObjectValidator.INSTANCE.getAvailableChoices(choices, inclusive, quote, limit);
        }

        public void throwIllegalArgumentException(int code, Object ... substitutions) throws IllegalArgumentException {
            switch (code) {
                case 2: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidCalendarType_diagnostic", substitutions[0], this.getAvailableChoices((Collection)substitutions[1], false, "", Integer.MAX_VALUE)), code);
                }
                case 3: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidMissingSimpleDateFormat_diagnostic", new Object[0]), code);
                }
                case 4: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidMissingDateFormat_diagnostic", new Object[0]), code);
                }
                case 5: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidDateStyle_diagnostic", substitutions[0], substitutions[1], this.getAvailableChoices(STYLES, false, "", Integer.MAX_VALUE)), code);
                }
                case 6: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidMissingTimeFormat_diagnostic", new Object[0]), code);
                }
                case 7: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidTimeStyle_diagnostic", substitutions[0], substitutions[1], this.getAvailableChoices(STYLES, false, "", Integer.MAX_VALUE)), code);
                }
                case 8: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidMissingDateTimeFormat_diagnostic", new Object[0]), code);
                }
                case 9: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidStyle_diagnostic", substitutions[0], this.getAvailableChoices((Collection)substitutions[1], false, "", Integer.MAX_VALUE)), code);
                }
                case 10: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidMissingLocale_diagnostic", substitutions[0]), code);
                }
                case 11: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidLanguage_diagnostic", substitutions[0], this.getAvailableChoices((Collection)substitutions[1], false, "", 10)), code);
                }
                case 12: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidCountry_diagnostic", substitutions[0], substitutions[1], this.getAvailableChoices((Collection)substitutions[2], false, "", 10)), code);
                }
                case 13: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidVariant_diagnostic", substitutions[0], substitutions[1], substitutions[2], this.getAvailableChoices((Collection)substitutions[3], false, "", 10)), code);
                }
                case 14: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidSimpleDateFormat_diagnostic", substitutions[0], ((Throwable)substitutions[1]).getLocalizedMessage()), (Throwable)substitutions[1], code);
                }
                case 15: {
                    throw new IllegalDateConversionArgumentException(this.getString(this.getResourceLocator(), "_UI_DateFormatInvalidInstanceType_diagnostic", substitutions[0], this.getAvailableChoices((Collection)substitutions[1], false, "'", 10)), code);
                }
            }
        }

        @Override
        protected ResourceLocator getResourceLocator() {
            return this.getEcoreResourceLocator();
        }

        @Override
        protected boolean isValidLocation(EAnnotation eAnnotation, EModelElement eModelElement) {
            return eModelElement instanceof EDataType;
        }

        @Override
        protected List<EClass> getPropertyClasses(EModelElement eModelElement) {
            final ArrayList result = new ArrayList();
            new PropertySwitch(){

                protected void addFeatures(EClass eClass) {
                    result.add(eClass);
                }
            }.doSwitch(eModelElement);
            return result.isEmpty() ? Collections.emptyList() : Collections.singletonList((EClass)result.get(0));
        }

        private static class IllegalDateConversionArgumentException
        extends IllegalArgumentException {
            private static final long serialVersionUID = 1L;
            private final int code;

            public IllegalDateConversionArgumentException(String message, int code) {
                super(message);
                this.code = code;
            }

            public IllegalDateConversionArgumentException(String message, Throwable cause, int code) {
                super(message, cause);
                this.code = code;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static abstract class PropertySwitch
        extends EcoreSwitch<Void> {
            private static final String ANNOTATION_NS_URI = "http:///org/eclipse/emf/ecore/util/DateConversionDelegateAnnotation";
            private static final Map<EAttribute, Set<String>> VALID_KEYS = new HashMap<EAttribute, Set<String>>();
            private static final EClass ANNOTATION_DATA_TYPE_CLASS;

            static {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(ANNOTATION_NS_URI);
                if (ePackage == null) {
                    ePackage = AnnotationValidator.loadEPackage(String.valueOf(EcorePlugin.INSTANCE.getBaseURL().toString()) + "model/DateConversionDelegateFactory.ecore");
                }
                if (ePackage == null) {
                    ANNOTATION_DATA_TYPE_CLASS = null;
                } else {
                    ANNOTATION_DATA_TYPE_CLASS = (EClass)ePackage.getEClassifier("DataType");
                    VALID_KEYS.put((EAttribute)ANNOTATION_DATA_TYPE_CLASS.getEStructuralFeature("format"), EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.keySet());
                    final EDataType conversionFormatType = (EDataType)ePackage.getEClassifier("WellFormedConversionFormat");
                    EValidator.Registry.INSTANCE.put(ePackage, new EObjectValidator(){

                        @Override
                        public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
                            BasicEAnnotationValidator.ValidationContext validationContext;
                            boolean result = super.validate(eDataType, value, diagnostics, context);
                            if (result && eDataType == conversionFormatType && value != null && (validationContext = (BasicEAnnotationValidator.ValidationContext)context.get("EANNOTATION_VALIDATION_CONTEXT")) != null) {
                                result = false;
                                String reason = null;
                                int code = 0;
                                try {
                                    DateConversionDelegateFactory.createConversionDelegate((EDataType)validationContext.getEModelElement(), value.toString());
                                    result = true;
                                }
                                catch (IllegalDateConversionArgumentException exception) {
                                    reason = exception.getLocalizedMessage();
                                    code = exception.code;
                                }
                                catch (Exception exception) {
                                    reason = exception.getLocalizedMessage();
                                    code = 1;
                                }
                                if (!result && diagnostics != null) {
                                    diagnostics.add((Diagnostic)this.createDiagnostic(4, "org.eclipse.emf.ecore", code, "_UI_DateFormatNotWellFormed_diagnostic", new Object[]{value, reason}, new Object[]{value, eDataType}, context));
                                }
                            }
                            return result;
                        }
                    });
                }
            }

            private PropertySwitch() {
            }

            protected abstract void addFeatures(EClass var1);

            @Override
            public Void caseEDataType(EDataType eDataTYpe) {
                if (ANNOTATION_DATA_TYPE_CLASS != null) {
                    this.addFeatures(ANNOTATION_DATA_TYPE_CLASS);
                }
                return null;
            }
        }
    }

    private static class CalendarAsLongConversionDelegate
    implements EDataType.Internal.ConversionDelegate {
        private final CalendarBuilder calendarBuilder;

        public CalendarAsLongConversionDelegate(CalendarBuilder calendarBuilder) {
            this.calendarBuilder = calendarBuilder;
        }

        public String convertToString(Object value) {
            if (value == null) {
                return null;
            }
            return Long.toString(((Calendar)value).getTime().getTime());
        }

        public Object createFromString(String literal) {
            if (literal == null) {
                return null;
            }
            long time = Long.parseLong(literal);
            return this.calendarBuilder.create(time);
        }
    }

    public static class CalendarBuilder {
        public Calendar create(long timeInstant) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(new java.util.Date(timeInstant));
            return gregorianCalendar;
        }

        public Calendar create(java.util.Date date) {
            return this.create(date.getTime());
        }
    }

    private static class CalendarConversionDelegate
    implements EDataType.Internal.ConversionDelegate {
        private final DateFormat dateFormat;
        private final CalendarBuilder calendarBuilder;

        public CalendarConversionDelegate(DateFormat dateFormat, CalendarBuilder calendarBuilder) {
            this.dateFormat = dateFormat;
            this.calendarBuilder = calendarBuilder;
        }

        public synchronized String convertToString(Object value) {
            if (value == null) {
                return null;
            }
            this.dateFormat.setTimeZone(GMT);
            return this.dateFormat.format(((Calendar)value).getTime());
        }

        public synchronized Object createFromString(String literal) {
            if (literal == null) {
                return null;
            }
            try {
                this.dateFormat.setTimeZone(GMT);
                java.util.Date date = this.dateFormat.parse(literal);
                return this.calendarBuilder.create(date.getTime());
            }
            catch (ParseException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
    }

    private static class DateAsLongConversionDelegate
    implements EDataType.Internal.ConversionDelegate {
        private static final DateAsLongConversionDelegate INSTANCE = new DateAsLongConversionDelegate();

        private DateAsLongConversionDelegate() {
        }

        public String convertToString(Object value) {
            if (value == null) {
                return null;
            }
            return Long.toString(((java.util.Date)value).getTime());
        }

        public Object createFromString(String literal) {
            if (literal == null) {
                return null;
            }
            return new java.util.Date(Long.parseLong(literal));
        }
    }

    private static class DateConversionDelegate
    implements EDataType.Internal.ConversionDelegate {
        private final DateFormat dateFormat;

        public DateConversionDelegate(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public synchronized String convertToString(Object value) {
            if (value == null) {
                return null;
            }
            this.dateFormat.setTimeZone(GMT);
            return this.dateFormat.format(value);
        }

        public synchronized Object createFromString(String literal) {
            if (literal == null) {
                return null;
            }
            try {
                this.dateFormat.setTimeZone(GMT);
                return this.dateFormat.parse(literal);
            }
            catch (ParseException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
    }

    private static class LongAsDateConversionDelegate
    implements EDataType.Internal.ConversionDelegate {
        private final DateFormat dateFormat;

        public LongAsDateConversionDelegate(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public synchronized String convertToString(Object value) {
            if (value == null) {
                return null;
            }
            this.dateFormat.setTimeZone(GMT);
            return this.dateFormat.format(new java.util.Date((Long)value));
        }

        public synchronized Object createFromString(String literal) {
            if (literal == null) {
                return null;
            }
            try {
                this.dateFormat.setTimeZone(GMT);
                return this.dateFormat.parse(literal).getTime();
            }
            catch (ParseException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
    }

    private static class LongAsLongConversionDelegate
    implements EDataType.Internal.ConversionDelegate {
        private static final LongAsLongConversionDelegate INSTANCE = new LongAsLongConversionDelegate();

        private LongAsLongConversionDelegate() {
        }

        public String convertToString(Object value) {
            if (value == null) {
                return null;
            }
            return Long.toString((Long)value);
        }

        public Object createFromString(String literal) {
            if (literal == null) {
                return null;
            }
            return Long.parseLong(literal);
        }
    }

    private static class SQLDateAsLongConversionDelegate
    implements EDataType.Internal.ConversionDelegate {
        private static final SQLDateAsLongConversionDelegate INSTANCE = new SQLDateAsLongConversionDelegate();

        private SQLDateAsLongConversionDelegate() {
        }

        public String convertToString(Object value) {
            if (value == null) {
                return null;
            }
            return Long.toString(((java.util.Date)value).getTime());
        }

        public Object createFromString(String literal) {
            if (literal == null) {
                return null;
            }
            return new Date(Long.parseLong(literal));
        }
    }

    private static class SQLDateConversionDelegate
    implements EDataType.Internal.ConversionDelegate {
        private final DateFormat dateFormat;

        public SQLDateConversionDelegate(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public synchronized String convertToString(Object value) {
            if (value == null) {
                return null;
            }
            this.dateFormat.setTimeZone(GMT);
            return this.dateFormat.format(value);
        }

        public synchronized Object createFromString(String literal) {
            if (literal == null) {
                return null;
            }
            try {
                this.dateFormat.setTimeZone(GMT);
                java.util.Date date = this.dateFormat.parse(literal);
                return new Date(date.getTime());
            }
            catch (ParseException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
    }

    private static class XMLGregorianCalendarAsLongConversionDelegate
    implements EDataType.Internal.ConversionDelegate {
        private static final XMLGregorianCalendarAsLongConversionDelegate INSTANCE = new XMLGregorianCalendarAsLongConversionDelegate();
        private static final DatatypeFactory DATATYPE_FACTORY;

        static {
            DatatypeFactory datatypeFactory = null;
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                // empty catch block
            }
            DATATYPE_FACTORY = datatypeFactory;
        }

        public String convertToString(Object value) {
            if (value == null) {
                return null;
            }
            return Long.toString(((XMLGregorianCalendar)value).toGregorianCalendar().getTime().getTime());
        }

        public Object createFromString(String literal) {
            if (literal == null) {
                return null;
            }
            long time = Long.parseLong(literal);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(new java.util.Date(time));
            return DATATYPE_FACTORY.newXMLGregorianCalendar(gregorianCalendar);
        }
    }

    private static class XMLGregorianCalendarConversionDelegate
    implements EDataType.Internal.ConversionDelegate {
        private static final DatatypeFactory DATATYPE_FACTORY;
        private final DateFormat dateFormat;

        static {
            DatatypeFactory datatypeFactory = null;
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                // empty catch block
            }
            DATATYPE_FACTORY = datatypeFactory;
        }

        public XMLGregorianCalendarConversionDelegate(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public synchronized String convertToString(Object value) {
            if (value == null) {
                return null;
            }
            this.dateFormat.setTimeZone(GMT);
            return this.dateFormat.format(((XMLGregorianCalendar)value).toGregorianCalendar().getTime());
        }

        public synchronized Object createFromString(String literal) {
            if (literal == null) {
                return null;
            }
            try {
                this.dateFormat.setTimeZone(GMT);
                java.util.Date date = this.dateFormat.parse(literal);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                return DATATYPE_FACTORY.newXMLGregorianCalendar(gregorianCalendar);
            }
            catch (ParseException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
    }
}

