/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.security.AllPermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisions;
import org.eclipse.osgi.internal.container.NamespaceList;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public final class ModuleRevisionBuilder {
    private static final Class<?> SINGLETON_MAP_CLASS = Collections.singletonMap(null, null).getClass();
    private static final Class<?> UNMODIFIABLE_MAP_CLASS = Collections.unmodifiableMap(Collections.emptyMap()).getClass();
    private String symbolicName = null;
    private Version version = Version.emptyVersion;
    private int types = 0;
    private final NamespaceList.Builder<GenericInfo> capabilityInfos = NamespaceList.Builder.create(GenericInfo.GETNAMESPACE);
    private final NamespaceList.Builder<GenericInfo> requirementInfos = NamespaceList.Builder.create(GenericInfo.GETNAMESPACE);
    private long id = -1L;

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void setTypes(int types) {
        this.types = types;
    }

    public void setId(long id) {
        if (id < 1L) {
            throw new IllegalArgumentException("ID must be >=1.");
        }
        this.id = id;
    }

    void setInternalId(long id) {
        this.id = id;
    }

    public void addCapability(String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        this.addGenericInfo(this.capabilityInfos, namespace, directives, attributes);
    }

    public List<GenericInfo> getCapabilities() {
        return this.getCapabilities(null);
    }

    public List<GenericInfo> getCapabilities(String namespace) {
        return this.capabilityInfos.getNamespaceElements(namespace);
    }

    public void addRequirement(String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        this.addGenericInfo(this.requirementInfos, namespace, directives, attributes);
    }

    public List<GenericInfo> getRequirements() {
        return this.getRequirements(null);
    }

    NamespaceList.Builder<GenericInfo> getRequirementsBuilder() {
        return this.requirementInfos;
    }

    public List<GenericInfo> getRequirements(String namespace) {
        return this.requirementInfos.getNamespaceElements(namespace);
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version;
    }

    public int getTypes() {
        return this.types;
    }

    public long getId() {
        return this.id;
    }

    ModuleRevision addRevision(Module module, Object revisionInfo) {
        ModuleRevisions revisions = module.getRevisions();
        ModuleRevision revision = new ModuleRevision(this.symbolicName, this.version, this.types, this.capabilityInfos, this.requirementInfos, revisions, revisionInfo);
        revisions.addRevision(revision);
        module.getContainer().getAdaptor().associateRevision(revision, revisionInfo);
        try {
            this.checkFrameworkExtensionPermission(module, revision);
            module.getContainer().checkAdminPermission(module.getBundle(), "lifecycle");
        }
        catch (SecurityException e) {
            revisions.removeRevision(revision);
            throw e;
        }
        return revision;
    }

    private void checkFrameworkExtensionPermission(Module module, ModuleRevision revision) {
        if (System.getSecurityManager() == null) {
            return;
        }
        if ((revision.getTypes() & 1) != 0) {
            Collection<Object> systemNames = Collections.emptyList();
            Module systemModule = module.getContainer().getModule(0L);
            if (systemModule != null) {
                ModuleRevision systemRevision = systemModule.getCurrentRevision();
                List<ModuleCapability> hostCapabilities = systemRevision.getModuleCapabilities("osgi.wiring.host");
                for (ModuleCapability hostCapability : hostCapabilities) {
                    Object hostNames = hostCapability.getAttributes().get("osgi.wiring.host");
                    if (hostNames instanceof Collection) {
                        systemNames = (Collection)hostNames;
                        continue;
                    }
                    if (!(hostNames instanceof String)) continue;
                    systemNames = Arrays.asList(hostNames);
                }
            }
            List<ModuleRequirement> hostRequirements = revision.getModuleRequirements("osgi.wiring.host");
            for (ModuleRequirement hostRequirement : hostRequirements) {
                FilterImpl f = null;
                String filterSpec = hostRequirement.getDirectives().get("filter");
                if (filterSpec == null) continue;
                try {
                    f = FilterImpl.newInstance(filterSpec);
                    String hostName = f.getPrimaryKeyValue("osgi.wiring.host");
                    if (hostName == null || !systemNames.contains(hostName)) continue;
                    Bundle b = module.getBundle();
                    if (b != null && !b.hasPermission(new AllPermission())) {
                        SecurityException se = new SecurityException("Must have AllPermission granted to install an extension bundle: " + b);
                        BundleException be = new BundleException(se.getMessage(), 6, se);
                        se.initCause(be);
                        throw se;
                    }
                    module.getContainer().checkAdminPermission(module.getBundle(), "extensionLifecycle");
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
            }
        }
    }

    private void addGenericInfo(NamespaceList.Builder<GenericInfo> infos, String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        infos.add(new GenericInfo(namespace, directives, attributes, true));
    }

    void basicAddCapability(String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        ModuleRevisionBuilder.basicAddGenericInfo(this.capabilityInfos, namespace, directives, attributes);
    }

    void basicAddRequirement(String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        ModuleRevisionBuilder.basicAddGenericInfo(this.requirementInfos, namespace, directives, attributes);
    }

    private static void basicAddGenericInfo(NamespaceList.Builder<GenericInfo> infos, String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        infos.add(new GenericInfo(namespace, ModuleRevisionBuilder.unmodifiableMap(directives), ModuleRevisionBuilder.unmodifiableMap(attributes), false));
    }

    static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        int size = map.size();
        if (size == 0) {
            return Collections.emptyMap();
        }
        if (size == 1) {
            if (map.getClass() != SINGLETON_MAP_CLASS) {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                map = Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        } else if (map.getClass() != UNMODIFIABLE_MAP_CLASS) {
            map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    void clear() {
        this.capabilityInfos.clear();
        this.requirementInfos.clear();
        this.id = -1L;
        this.symbolicName = null;
        this.version = Version.emptyVersion;
        this.types = 0;
    }

    public static class GenericInfo {
        static final Function<GenericInfo, String> GETNAMESPACE = new Function<GenericInfo, String>(){

            @Override
            public String apply(GenericInfo info) {
                return info.getNamespace();
            }
        };
        final String namespace;
        final Map<String, String> directives;
        final Map<String, Object> attributes;
        final boolean mutable;

        GenericInfo(String namespace, Map<String, String> directives, Map<String, Object> attributes, boolean mutable) {
            this.namespace = namespace;
            this.directives = directives;
            this.attributes = attributes;
            this.mutable = mutable;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Map<String, String> getDirectives() {
            return this.directives;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }
    }
}

