/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.dataformat.xml.XmlNameProcessor;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Pattern;

public final class XmlNameProcessors {
    private XmlNameProcessors() {
    }

    public static XmlNameProcessor newPassthroughProcessor() {
        return new PassthroughProcessor();
    }

    public static XmlNameProcessor newReplacementProcessor(String replacement) {
        return new ReplaceNameProcessor(replacement);
    }

    public static XmlNameProcessor newReplacementProcessor() {
        return XmlNameProcessors.newReplacementProcessor("_");
    }

    public static XmlNameProcessor newBase64Processor(String prefix) {
        return new Base64NameProcessor(prefix);
    }

    public static XmlNameProcessor newBase64Processor() {
        return XmlNameProcessors.newBase64Processor("base64_tag_");
    }

    public static XmlNameProcessor newAlwaysOnBase64Processor() {
        return new AlwaysOnBase64NameProcessor();
    }

    static class AlwaysOnBase64NameProcessor
    implements XmlNameProcessor {
        private static final long serialVersionUID = 1L;
        private static final Base64.Decoder BASE64_DECODER = Base64.getUrlDecoder();
        private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();

        @Override
        public void encodeName(XmlNameProcessor.XmlName name) {
            name.localPart = new String(BASE64_ENCODER.encode(name.localPart.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }

        @Override
        public void decodeName(XmlNameProcessor.XmlName name) {
            name.localPart = new String(BASE64_DECODER.decode(name.localPart), StandardCharsets.UTF_8);
        }
    }

    static class Base64NameProcessor
    implements XmlNameProcessor {
        private static final long serialVersionUID = 1L;
        private static final Base64.Decoder BASE64_DECODER = Base64.getUrlDecoder();
        private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
        private static final Pattern VALID_XML_NAME = Pattern.compile("[a-zA-Z_:]([a-zA-Z0-9_:.-])*");
        private final String _prefix;

        public Base64NameProcessor(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public void encodeName(XmlNameProcessor.XmlName name) {
            if (!VALID_XML_NAME.matcher(name.localPart).matches()) {
                name.localPart = this._prefix + new String(BASE64_ENCODER.encode(name.localPart.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            }
        }

        @Override
        public void decodeName(XmlNameProcessor.XmlName name) {
            if (name.localPart.startsWith(this._prefix)) {
                String localName = name.localPart;
                localName = localName.substring(this._prefix.length());
                name.localPart = new String(BASE64_DECODER.decode(localName), StandardCharsets.UTF_8);
            }
        }
    }

    static class ReplaceNameProcessor
    implements XmlNameProcessor {
        private static final long serialVersionUID = 1L;
        private static final Pattern BEGIN_MATCHER = Pattern.compile("^[^a-zA-Z_:]");
        private static final Pattern MAIN_MATCHER = Pattern.compile("[^a-zA-Z0-9_:-]");
        private final String _replacement;

        public ReplaceNameProcessor(String replacement) {
            this._replacement = replacement;
        }

        @Override
        public void encodeName(XmlNameProcessor.XmlName name) {
            String newLocalPart = name.localPart;
            newLocalPart = BEGIN_MATCHER.matcher(newLocalPart).replaceAll(this._replacement);
            name.localPart = MAIN_MATCHER.matcher(newLocalPart).replaceAll(this._replacement);
        }

        @Override
        public void decodeName(XmlNameProcessor.XmlName name) {
        }
    }

    static class PassthroughProcessor
    implements XmlNameProcessor {
        private static final long serialVersionUID = 1L;

        @Override
        public void encodeName(XmlNameProcessor.XmlName name) {
        }

        @Override
        public void decodeName(XmlNameProcessor.XmlName name) {
        }
    }
}

