/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IFormattableSubDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.ISubFormatter;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.formatting2.ArrayBracketsFormattingReplacer;
import org.eclipse.xtext.xbase.formatting2.IndentOnceAutowrapFormatter;
import org.eclipse.xtext.xbase.formatting2.ObjectEntry;
import org.eclipse.xtext.xbase.formatting2.SeparatorEntry;
import org.eclipse.xtext.xbase.formatting2.SeparatorRegions;
import org.eclipse.xtext.xbase.formatting2.XbaseFormatterPreferenceKeys;
import org.eclipse.xtext.xbase.formatting2.XtypeFormatter;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XbaseFormatter
extends XtypeFormatter {
    @Inject
    @Extension
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private XbaseGrammarAccess grammar;

    protected void _format(XCollectionLiteral literal, @Extension IFormattableDocument document) {
        ISemanticRegion _keyword_3;
        ISemanticRegion _keyword_1;
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.append(this.regionFor(literal).keyword("#"), _function);
        ISemanticRegion _elvis = null;
        ISemanticRegion _keyword = this.regionFor(literal).keyword("[");
        _elvis = _keyword != null ? _keyword : (_keyword_1 = this.regionFor(literal).keyword("{"));
        ISemanticRegion open = _elvis;
        ISemanticRegion _elvis_1 = null;
        ISemanticRegion _keyword_2 = this.regionFor(literal).keyword("]");
        _elvis_1 = _keyword_2 != null ? _keyword_2 : (_keyword_3 = this.regionFor(literal).keyword("}"));
        ISemanticRegion close = _elvis_1;
        this.formatCommaSeparatedList((Collection<? extends EObject>)literal.getElements(), open, close, document);
    }

    protected void formatCommaSeparatedList(Collection<? extends EObject> elements, ISemanticRegion open, ISemanticRegion close, @Extension IFormattableDocument format) {
        if (close != null && open != null) {
            boolean _isEmpty = elements.isEmpty();
            if (_isEmpty) {
                Procedures.Procedure1 _function = it -> it.noSpace();
                format.append(open, _function);
            } else {
                boolean _isMultiline = close.getPreviousHiddenRegion().isMultiline();
                if (_isMultiline) {
                    Procedures.Procedure1 _function_1 = it -> it.newLine();
                    format.append(open, _function_1);
                    for (EObject eObject : elements) {
                        format.format((Object)eObject);
                        Procedures.Procedure1 _function_2 = it -> it.noSpace();
                        Procedures.Procedure1 _function_3 = it -> it.newLine();
                        format.append(format.prepend(this.immediatelyFollowing(eObject).keyword(","), _function_2), _function_3);
                    }
                    Procedures.Procedure1 procedure1 = it -> it.newLine();
                    format.append((EObject)IterableExtensions.lastOrNull(elements), procedure1);
                    Procedures.Procedure1 _function_3 = it -> it.indent();
                    format.interior(open, close, _function_3);
                } else {
                    IHiddenRegion _previousHiddenRegion = close.getPreviousHiddenRegion();
                    IndentOnceAutowrapFormatter indentOnceAutowrapFormatter = new IndentOnceAutowrapFormatter(_previousHiddenRegion);
                    ITextRegionAccess _textRegionAccess = this.getTextRegionAccess();
                    int _endOffset = open.getEndOffset();
                    int _offset = close.getOffset();
                    int _endOffset_1 = open.getEndOffset();
                    int _minus = _offset - _endOffset_1;
                    TextSegment region = new TextSegment(_textRegionAccess, _endOffset, _minus);
                    SeparatorRegions<EObject, ISemanticRegion> items = new SeparatorRegions<EObject, ISemanticRegion>((ITextSegment)region);
                    for (EObject eObject : elements) {
                        items.appendWithTrailingSeparator(eObject, this.immediatelyFollowing(eObject).keyword(","));
                    }
                    for (ObjectEntry objectEntry : items) {
                        SeparatorEntry _leadingSeparator = objectEntry.getLeadingSeparator();
                        ISemanticRegion _separator = null;
                        if (_leadingSeparator != null) {
                            _separator = (ISemanticRegion)_leadingSeparator.getSeparator();
                        }
                        ISemanticRegion sep = _separator;
                        boolean _prependNewLineIfMultiline = this.prependNewLineIfMultiline((EObject)objectEntry.getObject());
                        if (_prependNewLineIfMultiline) {
                            if (sep == null) {
                                Procedures.Procedure1 _function_4 = it -> {
                                    it.noSpace();
                                    it.autowrap(ele_1.getRegion().getLength());
                                    it.setOnAutowrap((IAutowrapFormatter)indent);
                                };
                                format.append(open, _function_4);
                            } else {
                                Procedures.Procedure1 _function_5 = it -> {
                                    it.oneSpace();
                                    it.autowrap(ele_1.getRegion().getLength());
                                    it.setOnAutowrap((IAutowrapFormatter)indent);
                                };
                                format.append(sep, _function_5);
                            }
                        } else {
                            Procedures.Procedure1 _function_6 = it -> it.oneSpace();
                            format.append(sep, _function_6);
                        }
                        Procedures.Procedure1 _function_7 = it -> it.noSpace();
                        format.prepend(sep, _function_7);
                        format.format((Object)((EObject)objectEntry.getObject()));
                    }
                    Procedures.Procedure1 procedure1 = it -> it.noSpace();
                    format.prepend(close, procedure1);
                }
            }
        }
    }

    protected void _format(JvmGenericArrayTypeReference array, @Extension IFormattableDocument document) {
        List _ruleCallsTo = this.regionFor((EObject)array).ruleCallsTo(new AbstractRule[]{this.grammar.getArrayBracketsRule()});
        for (ISemanticRegion region : _ruleCallsTo) {
            ArrayBracketsFormattingReplacer _arrayBracketsFormattingReplacer = new ArrayBracketsFormattingReplacer(region);
            document.addReplacer((ITextReplacer)_arrayBracketsFormattingReplacer);
        }
        document.format((Object)array.getComponentType());
    }

    protected void _format(JvmTypeConstraint constraint, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.format((Object)((JvmTypeReference)document.prepend((EObject)constraint.getTypeReference(), _function)));
    }

    protected void _format(XVariableDeclaration expr, @Extension IFormattableDocument format) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.append(this.regionFor(expr).keyword("val"), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        format.append(this.regionFor(expr).keyword("var"), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        format.append((EObject)expr.getType(), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        format.surround(this.regionFor(expr).keyword("="), _function_3);
        format.format((Object)expr.getType());
        format.format((Object)expr.getRight());
    }

    protected void _format(XAssignment expr, @Extension IFormattableDocument format) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.surround(this.regionFor(expr).ruleCallTo((AbstractRule)this.grammar.getOpSingleAssignRule()), _function);
        ISemanticRegionsFinder _regionFor = this.regionFor(expr);
        String _xifexpression = null;
        boolean _isExplicitStatic = expr.isExplicitStatic();
        _xifexpression = _isExplicitStatic ? "::" : ".";
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        format.surround(_regionFor.keyword(_xifexpression), _function_1);
        format.format((Object)expr.getAssignable());
        format.format((Object)expr.getValue());
    }

    protected void formatFeatureCallParams(List<XExpression> params, ISemanticRegion open, ISemanticRegion close, @Extension IFormattableDocument format) {
        XClosure builder = this.builder(params);
        Iterable<XExpression> explicitParams = this.explicitParams(params);
        this.formatCommaSeparatedList(IterableExtensions.toList(explicitParams), open, close, format);
        this.formatBuilderWithLeadingGap(builder, format);
    }

    protected void formatBuilderWithLeadingGap(XClosure closure, @Extension IFormattableDocument format) {
        if (closure != null) {
            int offset = this.previousHiddenRegion(closure).getOffset();
            int _offset = this.nextHiddenRegion(closure).getOffset();
            int length = _offset - offset;
            ISubFormatter _function = doc -> {
                IFormattableSubDocument it = doc.requireFitsInLine();
                Procedures.Procedure1 _function_1 = it_1 -> it_1.noSpace();
                it.prepend((EObject)closure, _function_1);
                it.format((Object)closure);
            };
            ISubFormatter _function_1 = it -> {
                Procedures.Procedure1 _function_2 = it_1 -> it_1.oneSpace();
                it.prepend((EObject)closure, _function_2);
                it.format((Object)closure);
            };
            format.formatConditionally(offset, length, new ISubFormatter[]{_function, _function_1});
        }
    }

    protected XClosure builder(List<XExpression> params) {
        boolean _tripleNotEquals;
        XClosure _xifexpression = null;
        XExpression _lastOrNull = (XExpression)IterableExtensions.lastOrNull(params);
        boolean bl = _tripleNotEquals = _lastOrNull != null;
        if (_tripleNotEquals) {
            XClosure _xblockexpression = null;
            EObject grammarElement = this.grammarElement((EObject)IterableExtensions.lastOrNull(params));
            XClosure _xifexpression_1 = null;
            if (Objects.equals(grammarElement, this.grammar.getXMemberFeatureCallAccess().getMemberCallArgumentsXClosureParserRuleCall_1_1_4_0()) || Objects.equals(grammarElement, this.grammar.getXFeatureCallAccess().getFeatureCallArgumentsXClosureParserRuleCall_4_0()) || Objects.equals(grammarElement, this.grammar.getXConstructorCallAccess().getArgumentsXClosureParserRuleCall_5_0())) {
                XExpression _lastOrNull_1 = (XExpression)IterableExtensions.lastOrNull(params);
                _xifexpression_1 = (XClosure)_lastOrNull_1;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected Iterable<XExpression> explicitParams(List<XExpression> params) {
        List<XExpression> _xblockexpression = null;
        XClosure builder = this.builder(params);
        Iterable<XExpression> _xifexpression = null;
        if (builder != null) {
            int _size = params.size();
            int _minus = _size - 1;
            _xifexpression = IterableExtensions.take(params, (int)_minus);
        } else {
            _xifexpression = params;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected void _format(XConstructorCall expr, @Extension IFormattableDocument format) {
        boolean _not;
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.prepend(this.regionFor(expr).feature((EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR), _function);
        boolean _isEmpty = expr.getTypeArguments().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            format.surround(this.regionFor(expr).keyword("<"), _function_1);
            EList<JvmTypeReference> _typeArguments = expr.getTypeArguments();
            for (JvmTypeReference arg : _typeArguments) {
                format.format((Object)arg);
                Procedures.Procedure1 _function_2 = it -> it.noSpace();
                Procedures.Procedure1 _function_3 = it -> it.oneSpace();
                format.append(format.prepend(this.immediatelyFollowing((EObject)arg).keyword(","), _function_2), _function_3);
            }
            Procedures.Procedure1 _function_2 = it -> it.noSpace();
            format.prepend(this.regionFor(expr).keyword(">"), _function_2);
        }
        ISemanticRegion open = this.regionFor(expr).keyword("(");
        ISemanticRegion close = this.regionFor(expr).keyword(")");
        Procedures.Procedure1 _function_3 = it -> it.noSpace();
        format.prepend(open, _function_3);
        this.formatFeatureCallParams((List<XExpression>)expr.getArguments(), open, close, format);
    }

    protected void formatFeatureCallTypeParameters(XAbstractFeatureCall expr, @Extension IFormattableDocument format) {
        boolean _not;
        boolean _isEmpty = expr.getTypeArguments().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Procedures.Procedure1 _function = it -> it.noSpace();
            format.append(this.regionFor(expr).keyword("<"), _function);
            EList<JvmTypeReference> _typeArguments = expr.getTypeArguments();
            for (JvmTypeReference arg : _typeArguments) {
                format.format((Object)arg);
                Procedures.Procedure1 _function_1 = it -> it.noSpace();
                Procedures.Procedure1 _function_2 = it -> it.oneSpace();
                format.append(format.prepend(this.immediatelyFollowing((EObject)arg).keyword(","), _function_1), _function_2);
            }
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            format.surround(this.regionFor(expr).keyword(">"), _function_1);
        }
    }

    protected void _format(XFeatureCall expr, @Extension IFormattableDocument format) {
        this.formatFeatureCallTypeParameters(expr, format);
        boolean _isExplicitOperationCall = expr.isExplicitOperationCall();
        if (_isExplicitOperationCall) {
            Procedures.Procedure1 _function = it -> it.noSpace();
            ISemanticRegion open = format.prepend(this.regionFor(expr).keyword(this.grammar.getXFeatureCallAccess().getExplicitOperationCallLeftParenthesisKeyword_3_0_0()), _function);
            ISemanticRegion close = this.regionFor(expr).keyword(this.grammar.getXFeatureCallAccess().getRightParenthesisKeyword_3_2());
            this.formatFeatureCallParams((List<XExpression>)expr.getFeatureCallArguments(), open, close, format);
        } else {
            EList<XExpression> _featureCallArguments = expr.getFeatureCallArguments();
            for (XExpression arg : _featureCallArguments) {
                this.format(arg, format);
            }
        }
    }

    protected void _format(XMemberFeatureCall expr, @Extension IFormattableDocument format) {
        XExpression top = expr;
        IEObjectRegion _regionForEObject = this.regionForEObject(expr);
        SeparatorRegions<XMemberFeatureCall, ISemanticRegion> calls = new SeparatorRegions<XMemberFeatureCall, ISemanticRegion>((ITextSegment)_regionForEObject);
        while (top instanceof XMemberFeatureCall) {
            boolean _isExplicitStatic;
            String _switchResult = null;
            XMemberFeatureCall it2 = top;
            boolean _matched = false;
            boolean _isNullSafe = it2.isNullSafe();
            if (_isNullSafe) {
                _matched = true;
                _switchResult = "?.";
            }
            if (!_matched && (_isExplicitStatic = it2.isExplicitStatic())) {
                _matched = true;
                _switchResult = "::";
            }
            if (!_matched) {
                _switchResult = ".";
            }
            String op = _switchResult;
            ISemanticRegion separator = this.regionFor(top).keyword(op);
            calls.prependWithLeadingSeparator((XMemberFeatureCall)top, separator);
            top = top.getMemberCallTarget();
        }
        format.format((Object)top);
        IHiddenRegion _nextHiddenRegion = this.nextHiddenRegion(expr);
        IndentOnceAutowrapFormatter indentOnce = new IndentOnceAutowrapFormatter(_nextHiddenRegion);
        for (ObjectEntry entry : calls) {
            boolean _not;
            XMemberFeatureCall call = (XMemberFeatureCall)entry.getObject();
            ISemanticRegion operator = (ISemanticRegion)entry.getLeadingSeparator().getSeparator();
            this.formatFeatureCallTypeParameters(call, format);
            ISemanticRegion feature = this.regionFor(call).feature((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
            if (feature == null) continue;
            int _length = entry.getRegion().getLength();
            int _length_1 = feature.getLength();
            int _multiply = _length_1 * 2;
            int autowrapLength = Math.min(_length, _multiply);
            Procedures.Procedure1 _function = it -> it.noSpace();
            Procedures.Procedure1 _function_1 = it -> {
                it.noSpace();
                it.autowrap(autowrapLength);
                it.setOnAutowrap((IAutowrapFormatter)indentOnce);
            };
            format.append(format.prepend(operator, _function), _function_1);
            boolean _isExplicitOperationCall = call.isExplicitOperationCall();
            if (_isExplicitOperationCall) {
                Procedures.Procedure1 _function_2 = it -> it.noSpace();
                ISemanticRegion open = format.prepend(this.regionFor(call).keyword(this.grammar.getXMemberFeatureCallAccess().getExplicitOperationCallLeftParenthesisKeyword_1_1_3_0_0()), _function_2);
                ISemanticRegion close = this.regionFor(call).keyword(this.grammar.getXMemberFeatureCallAccess().getRightParenthesisKeyword_1_1_3_2());
                this.formatFeatureCallParams((List<XExpression>)call.getMemberCallArguments(), open, close, format);
                continue;
            }
            boolean _isEmpty = call.getMemberCallArguments().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            this.formatBuilderWithLeadingGap(this.builder((List<XExpression>)call.getMemberCallArguments()), format);
        }
    }

    protected AbstractRule binaryOperationPrecedence(EObject op) {
        ISemanticRegion node = this.regionFor(op).feature((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
        if (node != null && node.getGrammarElement() instanceof RuleCall) {
            EObject _grammarElement = node.getGrammarElement();
            return ((RuleCall)_grammarElement).getRule();
        }
        return null;
    }

    protected void _format(XBinaryOperation expr, @Extension IFormattableDocument format) {
        AbstractRule precendece = this.binaryOperationPrecedence(expr);
        IEObjectRegion _regionForEObject = this.regionForEObject(expr);
        SeparatorRegions<XBinaryOperation, ISemanticRegion> calls = new SeparatorRegions<XBinaryOperation, ISemanticRegion>((ITextSegment)_regionForEObject);
        XExpression top = expr;
        while (Objects.equals(this.binaryOperationPrecedence(top), precendece)) {
            calls.prependWithLeadingSeparator((XBinaryOperation)top, this.regionFor(top).feature((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE));
            top = top.getLeftOperand();
        }
        this.format(top, format);
        IHiddenRegion _nextHiddenRegion = this.nextHiddenRegion(expr);
        IndentOnceAutowrapFormatter indent = new IndentOnceAutowrapFormatter(_nextHiddenRegion);
        for (ObjectEntry ele : calls) {
            SeparatorEntry _leadingSeparator = ele.getLeadingSeparator();
            ISemanticRegion _separator = null;
            if (_leadingSeparator != null) {
                _separator = (ISemanticRegion)_leadingSeparator.getSeparator();
            }
            ISemanticRegion sep = _separator;
            boolean _prependNewLineIfMultiline = this.prependNewLineIfMultiline((EObject)ele.getObject());
            if (_prependNewLineIfMultiline) {
                Procedures.Procedure1 _function = it -> {
                    it.oneSpace();
                    it.autowrap(ele.getRegion().getLength());
                    it.setOnAutowrap((IAutowrapFormatter)indent);
                };
                format.append(sep, _function);
            } else {
                Procedures.Procedure1 _function_1 = it -> it.oneSpace();
                format.append(sep, _function_1);
            }
            Procedures.Procedure1 _function_2 = it -> it.oneSpace();
            format.prepend(sep, _function_2);
            format.format((Object)((XBinaryOperation)ele.getObject()).getRightOperand());
        }
    }

    protected boolean prependNewLineIfMultiline(EObject obj) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (obj instanceof XMemberFeatureCall) {
            _matched = true;
            _switchResult = this.prependNewLineIfMultiline(this.builder((List<XExpression>)((XMemberFeatureCall)obj).getMemberCallArguments()));
        }
        if (!_matched && obj instanceof XClosure) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched && obj instanceof XBlockExpression) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched) {
            _switchResult = true;
        }
        return _switchResult;
    }

    protected void _format(XSynchronizedExpression expr, @Extension IFormattableDocument format) {
        EObject _eContainer = expr.eContainer();
        if (_eContainer instanceof XVariableDeclaration) {
            Procedures.Procedure1 _function = it -> it.indent();
            format.surround((EObject)expr, _function);
        }
        boolean multiline = this.isMultiline(expr.getExpression()) || this.previousHiddenRegion(expr.getExpression()).isMultiline();
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        format.surround((EObject)expr.getParam(), _function_1);
        if (expr.getExpression() instanceof XBlockExpression || multiline) {
            format.append(this.regionFor(expr).keyword("synchronized"), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisML);
        } else {
            format.append(this.regionFor(expr).keyword("synchronized"), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisSL);
        }
        format.format((Object)expr.getParam());
        this.formatBody(expr.getExpression(), false, format);
    }

    protected void _format(XIfExpression expr, @Extension IFormattableDocument format) {
        boolean _tripleEquals;
        EObject _eContainer = expr.eContainer();
        if (_eContainer instanceof XVariableDeclaration) {
            Procedures.Procedure1 _function = it -> it.indent();
            format.surround((EObject)expr, _function);
        }
        boolean multiline = this.isMultilineOrInNewLine(expr.getThen()) || this.isMultilineOrInNewLine(expr.getElse());
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        format.surround((EObject)expr.getIf(), _function_1);
        if (expr.getThen() instanceof XBlockExpression || multiline) {
            format.append(this.regionFor(expr).keyword("if"), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisML);
        } else {
            format.append(this.regionFor(expr).keyword("if"), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisSL);
        }
        format.format((Object)expr.getIf());
        XExpression _else = expr.getElse();
        boolean bl = _tripleEquals = _else == null;
        if (_tripleEquals) {
            this.formatBody(expr.getThen(), multiline, format);
        } else {
            this.formatBodyInline(expr.getThen(), multiline, format);
            if (expr.getElse() instanceof XIfExpression || !multiline) {
                Procedures.Procedure1 _function_2 = it -> it.oneSpace();
                format.prepend((EObject)expr.getElse(), _function_2);
                format.format((Object)expr.getElse());
            } else {
                this.formatBody(expr.getElse(), multiline, format);
            }
        }
    }

    protected void _format(XForLoopExpression expr, @Extension IFormattableDocument format) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.append(this.regionFor(expr).keyword("for"), _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        format.append((EObject)((JvmFormalParameter)format.prepend((EObject)expr.getDeclaredParam(), _function_1)), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        Procedures.Procedure1 _function_4 = it -> it.noSpace();
        format.format((Object)((XExpression)format.append((EObject)((XExpression)format.prepend((EObject)expr.getForExpression(), _function_3)), _function_4)));
        this.formatBody(expr.getEachExpression(), true, format);
    }

    protected void _format(XBasicForLoopExpression expr, @Extension IFormattableDocument format) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.append(this.regionFor(expr).keyword("for"), _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        format.append(this.regionFor(expr).keyword("("), _function_1);
        Consumer<ISemanticRegion> _function_2 = it -> {
            Procedures.Procedure1 _function_3 = it_1 -> it_1.noSpace();
            Procedures.Procedure1 _function_4 = it_1 -> {
                it_1.noSpace();
                it_1.lowPriority();
            };
            format.append(format.prepend(it, _function_3), _function_4);
        };
        this.regionFor(expr).keywords(new String[]{";"}).forEach(_function_2);
        Consumer<ISemanticRegion> _function_3 = it -> {
            Procedures.Procedure1 _function_4 = it_1 -> it_1.noSpace();
            Procedures.Procedure1 _function_5 = it_1 -> it_1.oneSpace();
            format.append(format.prepend(it, _function_4), _function_5);
        };
        this.regionFor(expr).keywords(new String[]{","}).forEach(_function_3);
        Procedures.Procedure1 _function_4 = it -> it.noSpace();
        format.prepend(this.regionFor(expr).keyword(")"), _function_4);
        Consumer<XExpression> _function_5 = it -> format.format(it);
        expr.getInitExpressions().forEach(_function_5);
        Procedures.Procedure1 _function_6 = it -> it.oneSpace();
        format.prepend((EObject)expr.getExpression(), _function_6);
        format.format((Object)expr.getExpression());
        Procedures.Procedure1 _function_7 = it -> it.oneSpace();
        format.prepend((EObject)((XExpression)IterableExtensions.head(expr.getUpdateExpressions())), _function_7);
        Consumer<XExpression> _function_8 = it -> format.format(it);
        expr.getUpdateExpressions().forEach(_function_8);
        this.formatBody(expr.getEachExpression(), true, format);
    }

    protected void _format(XWhileExpression expr, @Extension IFormattableDocument format) {
        format.append(this.regionFor(expr).keyword("while"), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisML);
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        format.format((Object)((XExpression)format.append((EObject)((XExpression)format.prepend((EObject)expr.getPredicate(), _function)), _function_1)));
        this.formatBody(expr.getBody(), true, format);
    }

    protected void _format(XDoWhileExpression expr, @Extension IFormattableDocument format) {
        format.append(this.regionFor(expr).keyword("while"), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisML);
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        format.format((Object)((XExpression)format.append((EObject)((XExpression)format.prepend((EObject)expr.getPredicate(), _function)), _function_1)));
        this.formatBodyInline(expr.getBody(), true, format);
    }

    protected void _format(XBlockExpression expr, @Extension IFormattableDocument format) {
        boolean _tripleEquals;
        ISemanticRegion open = this.regionFor(expr).keyword("{");
        ISemanticRegion close = this.regionFor(expr).keyword("}");
        EObject _eContainer = expr.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals) {
            Procedures.Procedure1 _function = it -> it.noSpace();
            format.surround((EObject)expr, _function);
        }
        if (open != null && close != null) {
            boolean _isSingleLineBlock = this.isSingleLineBlock(expr);
            if (_isSingleLineBlock) {
                ISubFormatter _function_1 = f -> this.formatExpressionsSingleline((Collection<? extends XExpression>)expr.getExpressions(), open, close, (IFormattableDocument)f.requireFitsInLine());
                ISubFormatter _function_2 = f -> this.formatExpressionsMultiline((Collection<? extends XExpression>)expr.getExpressions(), open, close, (IFormattableDocument)f);
                format.formatConditionally((EObject)expr, new ISubFormatter[]{_function_1, _function_2});
            } else {
                this.formatExpressionsMultiline((Collection<? extends XExpression>)expr.getExpressions(), open, close, format);
            }
        }
    }

    protected boolean isSingleLineBlock(XBlockExpression expr) {
        return false;
    }

    protected void _format(XTypeLiteral expr, @Extension IFormattableDocument format) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        format.append(this.regionFor(expr).keyword("typeof"), _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        format.append(format.prepend(this.regionFor(expr).feature((EStructuralFeature)XbasePackage.Literals.XTYPE_LITERAL__TYPE), _function_1), _function_2);
        List _ruleCallsTo = this.regionFor(expr).ruleCallsTo(new AbstractRule[]{this.grammar.getArrayBracketsRule()});
        for (ISemanticRegion region : _ruleCallsTo) {
            Procedures.Procedure1 _function_3 = it -> it.noSpace();
            format.append(region, _function_3);
            ArrayBracketsFormattingReplacer _arrayBracketsFormattingReplacer = new ArrayBracketsFormattingReplacer(region);
            format.addReplacer((ITextReplacer)_arrayBracketsFormattingReplacer);
        }
    }

    protected void _format(XThrowExpression expr, @Extension IFormattableDocument format) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.prepend((EObject)expr.getExpression(), _function);
        format.format((Object)expr.getExpression());
    }

    protected void _format(XReturnExpression expr, @Extension IFormattableDocument format) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        format.prepend((EObject)expr.getExpression(), _function);
        format.format((Object)expr.getExpression());
    }

    protected void _format(XTryCatchFinallyExpression expr, @Extension IFormattableDocument format) {
        EObject _eContainer = expr.eContainer();
        if (_eContainer instanceof XVariableDeclaration) {
            Procedures.Procedure1 _function = it -> it.indent();
            format.surround((EObject)expr, _function);
        }
        this.formatBodyInline(expr.getExpression(), true, format);
        EList<XCatchClause> _catchClauses = expr.getCatchClauses();
        for (XCatchClause cc : _catchClauses) {
            format.append(this.regionFor(cc).keyword("catch"), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.whitespaceBetweenKeywordAndParenthesisML);
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            Procedures.Procedure1 _function_2 = it -> it.noSpace();
            format.format((Object)((JvmFormalParameter)format.append((EObject)((JvmFormalParameter)format.prepend((EObject)cc.getDeclaredParam(), _function_1)), _function_2)));
            if (!Objects.equals(cc, IterableExtensions.lastOrNull(expr.getCatchClauses())) || expr.getFinallyExpression() != null) {
                this.formatBodyInline(cc.getExpression(), true, format);
                continue;
            }
            this.formatBody(cc.getExpression(), true, format);
        }
        this.formatBody(expr.getFinallyExpression(), true, format);
    }

    protected void _format(JvmFormalParameter expr, @Extension IFormattableDocument format) {
        JvmTypeReference _parameterType = expr.getParameterType();
        if (_parameterType != null) {
            Procedures.Procedure1 _function = it -> it.oneSpace();
            format.append((EObject)_parameterType, _function);
        }
        format.format((Object)expr.getParameterType());
    }

    protected void _format(XExpression expr, @Extension IFormattableDocument format) {
        EList _eContents = expr.eContents();
        for (EObject obj : _eContents) {
            boolean _matched = false;
            if (!(obj instanceof XExpression)) continue;
            _matched = true;
            format.format((Object)((XExpression)obj));
        }
    }

    protected void _format(XSwitchExpression expr, @Extension IFormattableDocument format) {
        Functions.Function1 _function = it -> {
            XExpression _then = it.getThen();
            return _then instanceof XBlockExpression;
        };
        boolean containsBlockExpr = IterableExtensions.exists(expr.getCases(), (Functions.Function1)_function);
        boolean switchSL = !containsBlockExpr && !this.isMultiline(expr);
        boolean caseSL = !containsBlockExpr && (!expr.getCases().isEmpty() || expr.getDefault() != null) && !IterableExtensions.exists(expr.getCases(), it -> this.isMultiline((EObject)it)) && !this.isMultilineOrInNewLine(expr.getDefault());
        ISemanticRegion open = this.regionFor(expr).keyword("{");
        ISemanticRegion close = this.regionFor(expr).keyword("}");
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        format.append(this.regionFor(expr).keyword("switch"), _function_1);
        if (switchSL) {
            boolean _tripleNotEquals;
            Procedures.Procedure1 _function_2 = it -> it.oneSpace();
            format.prepend(open, _function_2);
            Procedures.Procedure1 _function_3 = it -> it.oneSpace();
            format.append(open, _function_3);
            EList<XCasePart> _cases = expr.getCases();
            for (XCasePart c : _cases) {
                boolean _tripleEquals;
                format.format((Object)c.getCase());
                format.format((Object)c.getThen());
                XExpression _then = c.getThen();
                boolean bl = _tripleEquals = _then == null;
                if (_tripleEquals) {
                    Procedures.Procedure1 _function_4 = it -> it.oneSpace();
                    format.append((EObject)c, _function_4);
                    continue;
                }
                Procedures.Procedure1 _function_5 = it -> it.oneSpace();
                Procedures.Procedure1 _function_6 = it -> it.oneSpace();
                format.append((EObject)((XExpression)format.prepend((EObject)c.getThen(), _function_5)), _function_6);
            }
            XExpression _default = expr.getDefault();
            boolean bl = _tripleNotEquals = _default != null;
            if (_tripleNotEquals) {
                Procedures.Procedure1 _function_4 = it -> it.noSpace();
                format.append(this.regionFor(expr).keyword("default"), _function_4);
                Procedures.Procedure1 _function_5 = it -> it.oneSpace();
                format.format((Object)((XExpression)format.surround((EObject)expr.getDefault(), _function_5)));
            }
        } else if (caseSL) {
            boolean _tripleNotEquals_1;
            Procedures.Procedure1 _function_8;
            boolean _not;
            format.prepend(open, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
            boolean _isEmpty = expr.getCases().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Procedures.Procedure1 _function_6 = it -> it.newLine();
                format.append(open, _function_6);
            }
            Procedures.Procedure1 _function_7 = it -> it.indent();
            format.interior(open, close, _function_7);
            EList<XCasePart> _cases_1 = expr.getCases();
            for (XCasePart c_1 : _cases_1) {
                boolean _notEquals;
                format.format((Object)c_1.getCase());
                format.format((Object)c_1.getThen());
                _function_8 = it -> it.oneSpace();
                format.prepend((EObject)c_1.getThen(), _function_8);
                XCasePart _lastOrNull = (XCasePart)IterableExtensions.lastOrNull(expr.getCases());
                boolean bl2 = _notEquals = !Objects.equals(c_1, _lastOrNull);
                if (!_notEquals) continue;
                Procedures.Procedure1 _function_9 = it -> it.newLine();
                format.append((EObject)c_1, _function_9);
            }
            XExpression _default_1 = expr.getDefault();
            boolean bl3 = _tripleNotEquals_1 = _default_1 != null;
            if (_tripleNotEquals_1) {
                _function_8 = it -> it.newLine();
                Procedures.Procedure1 _function_9 = it -> it.noSpace();
                format.append(format.prepend(this.regionFor(expr).keyword("default"), _function_8), _function_9);
                Procedures.Procedure1 _function_10 = it -> it.oneSpace();
                format.format((Object)((XExpression)format.prepend((EObject)expr.getDefault(), _function_10)));
            }
            Procedures.Procedure1 _function_11 = it -> it.newLine();
            format.prepend(close, _function_11);
        } else {
            boolean _tripleNotEquals_2;
            Procedures.Procedure1 _function_14;
            Procedures.Procedure1 _function_12 = it -> it.newLine();
            format.append(format.prepend(open, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine), _function_12);
            if (!expr.getCases().isEmpty() || expr.getDefault() != null) {
                Procedures.Procedure1 _function_13 = it -> it.indent();
                format.interior(open, close, _function_13);
            }
            EList<XCasePart> _cases_2 = expr.getCases();
            for (XCasePart c_2 : _cases_2) {
                format.format((Object)c_2.getCase());
                this.formatBodyParagraph(c_2.getThen(), format);
                _function_14 = it -> it.noSpace();
                Procedures.Procedure1 _function_15 = it -> it.newLine();
                format.append(format.prepend(this.regionFor(c_2).feature((EStructuralFeature)XbasePackage.Literals.XCASE_PART__FALL_THROUGH), _function_14), _function_15);
            }
            XExpression _default_2 = expr.getDefault();
            boolean bl = _tripleNotEquals_2 = _default_2 != null;
            if (_tripleNotEquals_2) {
                _function_14 = it -> it.noSpace();
                format.append(this.regionFor(expr).keyword("default"), _function_14);
                this.formatBodyParagraph(expr.getDefault(), format);
            }
        }
        EList<XCasePart> _cases_3 = expr.getCases();
        for (XCasePart c_3 : _cases_3) {
            boolean _tripleNotEquals_4;
            boolean _tripleNotEquals_3;
            if (c_3.getTypeGuard() != null && c_3.getCase() != null) {
                Procedures.Procedure1 _function_15 = it -> it.oneSpace();
                format.append((EObject)c_3.getTypeGuard(), _function_15);
                Procedures.Procedure1 _function_16 = it -> it.oneSpace();
                Procedures.Procedure1 _function_17 = it -> it.noSpace();
                format.append((EObject)((XExpression)format.prepend((EObject)c_3.getCase(), _function_16)), _function_17);
                continue;
            }
            JvmTypeReference _typeGuard = c_3.getTypeGuard();
            boolean bl = _tripleNotEquals_3 = _typeGuard != null;
            if (_tripleNotEquals_3) {
                Procedures.Procedure1 _function_18 = it -> it.noSpace();
                format.append((EObject)c_3.getTypeGuard(), _function_18);
                continue;
            }
            XExpression _case = c_3.getCase();
            boolean bl4 = _tripleNotEquals_4 = _case != null;
            if (!_tripleNotEquals_4) continue;
            Procedures.Procedure1 _function_19 = it -> it.oneSpace();
            Procedures.Procedure1 _function_20 = it -> it.noSpace();
            format.append((EObject)((XExpression)format.prepend((EObject)c_3.getCase(), _function_19)), _function_20);
        }
    }

    protected ISemanticRegion formatClosureParams(XClosure expr, ISemanticRegion open, @Extension IFormattableDocument format, Procedures.Procedure1<? super IHiddenRegionFormatter> init) {
        boolean _isExplicitSyntax = expr.isExplicitSyntax();
        if (_isExplicitSyntax) {
            ISemanticRegion last = this.regionFor(expr).feature((EStructuralFeature)XbasePackage.Literals.XCLOSURE__EXPLICIT_SYNTAX);
            boolean _isEmpty = expr.getDeclaredFormalParameters().isEmpty();
            if (_isEmpty) {
                Procedures.Procedure1 _function = it -> it.noSpace();
                format.append(open, _function);
            } else {
                boolean _not;
                EList<JvmFormalParameter> _declaredFormalParameters = expr.getDeclaredFormalParameters();
                for (JvmFormalParameter param : _declaredFormalParameters) {
                    format.format((Object)param);
                    Procedures.Procedure1 _function_1 = it -> it.noSpace();
                    Procedures.Procedure1 _function_2 = it -> it.oneSpace();
                    format.append(format.prepend(this.immediatelyFollowing((EObject)param).keyword(","), _function_1), _function_2);
                }
                format.append(open, init);
                boolean _isEmpty_1 = expr.getDeclaredFormalParameters().isEmpty();
                boolean bl = _not = !_isEmpty_1;
                if (_not) {
                    format.prepend(last, init);
                }
            }
            return last;
        }
        return open;
    }

    protected void _format(XClosure expr, @Extension IFormattableDocument format) {
        XExpression _expression;
        ISemanticRegion _keyword_3;
        ISemanticRegion _keyword_1;
        ISemanticRegion _elvis = null;
        ISemanticRegion _keyword = this.regionFor(expr).keyword("[");
        _elvis = _keyword != null ? _keyword : (_keyword_1 = this.immediatelyPreceding(expr).keyword("("));
        ISemanticRegion open = _elvis;
        ISemanticRegion _elvis_1 = null;
        ISemanticRegion _keyword_2 = this.regionFor(expr).keyword("]");
        _elvis_1 = _keyword_2 != null ? _keyword_2 : (_keyword_3 = this.immediatelyFollowing(expr).keyword(")"));
        ISemanticRegion close = _elvis_1;
        Object _switchResult = null;
        XExpression x = _expression = expr.getExpression();
        boolean _matched = false;
        if (x instanceof XBlockExpression) {
            _matched = true;
            _switchResult = ((XBlockExpression)x).getExpressions();
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.newArrayList((Object[])new XExpression[]{x});
        }
        EList<XExpression> children = _switchResult;
        if (open != null && close != null) {
            boolean _isEmpty = children.isEmpty();
            if (_isEmpty) {
                boolean _containsComment = open.getNextHiddenRegion().containsComment();
                if (_containsComment) {
                    Procedures.Procedure1 _function = it -> {
                        it.newLine();
                        it.indent();
                    };
                    format.append(open, _function);
                } else {
                    Procedures.Procedure1 _function_1 = it -> it.noSpace();
                    format.append(open, _function_1);
                }
            } else {
                boolean _isMultiline = close.getPreviousHiddenRegion().isMultiline();
                if (_isMultiline) {
                    Procedures.Procedure1 _function_2 = it -> it.oneSpace();
                    ISemanticRegion last = this.formatClosureParams(expr, open, format, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2);
                    this.formatExpressionsMultiline((Collection<? extends XExpression>)children, last, close, format);
                } else {
                    int offset = open.getPreviousHiddenRegion().getNextSemanticRegion().getEndOffset();
                    int _offset = close.getOffset();
                    int length = _offset - offset;
                    ISubFormatter _function_3 = doc -> {
                        IFormattableSubDocument it = doc.requireFitsInLine();
                        Procedures.Procedure1 _function_4 = it_1 -> it_1.noSpace();
                        ISemanticRegion last_1 = this.formatClosureParams(expr, open, (IFormattableDocument)it, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_4);
                        Procedures.Procedure1 _function_5 = it_1 -> it_1.noSpace();
                        it.append(last_1, _function_5);
                        for (XExpression c : children) {
                            it.format((Object)c);
                            ISemanticRegion semicolon = this.immediatelyFollowing(c).keyword(";");
                            if (semicolon != null) {
                                Procedures.Procedure1 _function_6 = it_1 -> it_1.noSpace();
                                Procedures.Procedure1 _function_7 = it_1 -> {
                                    XExpression _lastOrNull = (XExpression)IterableExtensions.lastOrNull((Iterable)children);
                                    boolean _equals = Objects.equals(c, _lastOrNull);
                                    if (_equals) {
                                        it_1.noSpace();
                                    } else {
                                        it_1.oneSpace();
                                    }
                                };
                                it.append(it.prepend(semicolon, _function_6), _function_7);
                                continue;
                            }
                            Procedures.Procedure1 _function_8 = it_1 -> {
                                XExpression _lastOrNull = (XExpression)IterableExtensions.lastOrNull((Iterable)children);
                                boolean _equals = Objects.equals(c, _lastOrNull);
                                if (_equals) {
                                    it_1.noSpace();
                                } else {
                                    it_1.oneSpace();
                                }
                            };
                            it.append((EObject)c, _function_8);
                        }
                    };
                    ISubFormatter _function_4 = doc -> {
                        Procedures.Procedure1 _function_5 = it -> it.oneSpace();
                        ISemanticRegion last_1 = this.formatClosureParams(expr, open, (IFormattableDocument)doc, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_5);
                        this.formatExpressionsMultiline((Collection<? extends XExpression>)children, last_1, close, (IFormattableDocument)doc);
                    };
                    format.formatConditionally(offset, length, new ISubFormatter[]{_function_3, _function_4});
                }
            }
        }
    }

    protected void formatBody(XExpression expr, boolean forceMultiline, @Extension IFormattableDocument doc) {
        if (expr == null) {
            return;
        }
        if (expr instanceof XBlockExpression) {
            doc.prepend((EObject)((XBlockExpression)expr), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
        } else if (forceMultiline || this.previousHiddenRegion(expr).isMultiline()) {
            Procedures.Procedure1 _function = it -> it.newLine();
            Procedures.Procedure1 _function_1 = it -> it.indent();
            doc.surround((EObject)((XExpression)doc.prepend((EObject)expr, _function)), _function_1);
        } else {
            Procedures.Procedure1 _function_2 = it -> it.oneSpace();
            doc.prepend((EObject)expr, _function_2);
        }
        doc.format((Object)expr);
    }

    protected void formatBodyInline(XExpression expr, boolean forceMultiline, @Extension IFormattableDocument doc) {
        if (expr == null) {
            return;
        }
        if (expr instanceof XBlockExpression) {
            doc.append((EObject)((XBlockExpression)doc.prepend((EObject)((XBlockExpression)expr), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine)), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
        } else if (forceMultiline || this.previousHiddenRegion(expr).isMultiline()) {
            Procedures.Procedure1 _function = it -> it.newLine();
            Procedures.Procedure1 _function_1 = it -> it.indent();
            Procedures.Procedure1 _function_2 = it -> it.newLine();
            doc.append((EObject)((XExpression)doc.surround((EObject)((XExpression)doc.prepend((EObject)expr, _function)), _function_1)), _function_2);
        } else {
            Procedures.Procedure1 _function_3 = it -> it.oneSpace();
            doc.surround((EObject)expr, _function_3);
        }
        doc.format((Object)expr);
    }

    protected void formatBodyParagraph(XExpression expr, @Extension IFormattableDocument doc) {
        if (expr == null) {
            return;
        }
        if (expr instanceof XBlockExpression) {
            Procedures.Procedure1 _function = it -> it.newLine();
            doc.append((EObject)((XBlockExpression)doc.prepend((EObject)((XBlockExpression)expr), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine)), _function);
        } else {
            Procedures.Procedure1 _function_1 = it -> it.newLine();
            Procedures.Procedure1 _function_2 = it -> it.indent();
            Procedures.Procedure1 _function_3 = it -> it.newLine();
            doc.append((EObject)((XExpression)doc.surround((EObject)((XExpression)doc.prepend((EObject)expr, _function_1)), _function_2)), _function_3);
        }
        doc.format((Object)expr);
    }

    protected void _format(XInstanceOfExpression expr, @Extension IFormattableDocument doc) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        doc.surround(this.regionFor(expr).keyword("instanceof"), _function);
        doc.format((Object)expr.getExpression());
        doc.format((Object)expr.getType());
    }

    protected void _format(XCastedExpression expr, @Extension IFormattableDocument doc) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        doc.surround(this.regionFor(expr).keyword("as"), _function);
        doc.format((Object)expr.getTarget());
        doc.format((Object)expr.getType());
    }

    protected void _format(XPostfixOperation expr, @Extension IFormattableDocument doc) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        doc.prepend(this.regionFor(expr).feature((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE), _function);
        doc.format((Object)expr.getOperand());
    }

    protected void formatExpressionsMultiline(Collection<? extends XExpression> expressions, ISemanticRegion open, ISemanticRegion close, @Extension IFormattableDocument format) {
        Procedures.Procedure1 _function = it -> it.indent();
        format.interior(open, close, _function);
        boolean _isEmpty = expressions.isEmpty();
        if (_isEmpty) {
            Procedures.Procedure1 procedure1 = it -> it.newLine();
            format.append(open, procedure1);
        } else {
            format.append(open, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.blankLinesAroundExpression);
            for (XExpression xExpression : expressions) {
                format.format((Object)xExpression);
                ISemanticRegion sem = this.immediatelyFollowing(xExpression).keyword(";");
                if (sem != null) {
                    Procedures.Procedure1 _function_2 = it -> it.noSpace();
                    format.append(format.prepend(sem, _function_2), (Procedures.Procedure1)XbaseFormatterPreferenceKeys.blankLinesAroundExpression);
                    continue;
                }
                format.append((EObject)xExpression, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.blankLinesAroundExpression);
            }
        }
    }

    protected void formatExpressionsSingleline(Collection<? extends XExpression> expressions, ISemanticRegion open, ISemanticRegion close, @Extension IFormattableDocument format) {
        boolean _isEmpty = expressions.isEmpty();
        if (_isEmpty) {
            Procedures.Procedure1 _function = it -> it.noSpace();
            format.append(open, _function);
        } else {
            Procedures.Procedure1 _function_1 = it -> it.oneSpace();
            format.append(open, _function_1);
            for (XExpression xExpression : expressions) {
                format.format((Object)xExpression);
                ISemanticRegion sem = this.immediatelyFollowing(xExpression).keyword(";");
                if (sem != null) {
                    Procedures.Procedure1 _function_2 = it -> it.noSpace();
                    Procedures.Procedure1 _function_3 = it -> it.oneSpace();
                    format.append(format.prepend(sem, _function_2), _function_3);
                    continue;
                }
                Procedures.Procedure1 _function_4 = it -> it.oneSpace();
                format.append((EObject)xExpression, _function_4);
            }
        }
    }

    protected boolean isMultilineOrInNewLine(EObject obj) {
        return obj != null && (this.isMultiline(obj) || this.previousHiddenRegion(obj).isMultiline());
    }

    @Override
    @XbaseGenerated
    public void format(Object expr, IFormattableDocument format) {
        if (expr instanceof JvmTypeParameter) {
            this._format((JvmTypeParameter)expr, format);
            return;
        }
        if (expr instanceof JvmFormalParameter) {
            this._format((JvmFormalParameter)expr, format);
            return;
        }
        if (expr instanceof XtextResource) {
            this._format((XtextResource)expr, format);
            return;
        }
        if (expr instanceof XAssignment) {
            this._format((XAssignment)expr, format);
            return;
        }
        if (expr instanceof XBinaryOperation) {
            this._format((XBinaryOperation)expr, format);
            return;
        }
        if (expr instanceof XDoWhileExpression) {
            this._format((XDoWhileExpression)expr, format);
            return;
        }
        if (expr instanceof XFeatureCall) {
            this._format((XFeatureCall)expr, format);
            return;
        }
        if (expr instanceof XMemberFeatureCall) {
            this._format((XMemberFeatureCall)expr, format);
            return;
        }
        if (expr instanceof XPostfixOperation) {
            this._format((XPostfixOperation)expr, format);
            return;
        }
        if (expr instanceof XWhileExpression) {
            this._format((XWhileExpression)expr, format);
            return;
        }
        if (expr instanceof XFunctionTypeRef) {
            this._format((XFunctionTypeRef)expr, format);
            return;
        }
        if (expr instanceof JvmGenericArrayTypeReference) {
            this._format((JvmGenericArrayTypeReference)expr, format);
            return;
        }
        if (expr instanceof JvmParameterizedTypeReference) {
            this._format((JvmParameterizedTypeReference)expr, format);
            return;
        }
        if (expr instanceof JvmWildcardTypeReference) {
            this._format((JvmWildcardTypeReference)expr, format);
            return;
        }
        if (expr instanceof XBasicForLoopExpression) {
            this._format((XBasicForLoopExpression)expr, format);
            return;
        }
        if (expr instanceof XBlockExpression) {
            this._format((XBlockExpression)expr, format);
            return;
        }
        if (expr instanceof XCastedExpression) {
            this._format((XCastedExpression)expr, format);
            return;
        }
        if (expr instanceof XClosure) {
            this._format((XClosure)expr, format);
            return;
        }
        if (expr instanceof XCollectionLiteral) {
            this._format((XCollectionLiteral)expr, format);
            return;
        }
        if (expr instanceof XConstructorCall) {
            this._format((XConstructorCall)expr, format);
            return;
        }
        if (expr instanceof XForLoopExpression) {
            this._format((XForLoopExpression)expr, format);
            return;
        }
        if (expr instanceof XIfExpression) {
            this._format((XIfExpression)expr, format);
            return;
        }
        if (expr instanceof XInstanceOfExpression) {
            this._format((XInstanceOfExpression)expr, format);
            return;
        }
        if (expr instanceof XReturnExpression) {
            this._format((XReturnExpression)expr, format);
            return;
        }
        if (expr instanceof XSwitchExpression) {
            this._format((XSwitchExpression)expr, format);
            return;
        }
        if (expr instanceof XSynchronizedExpression) {
            this._format((XSynchronizedExpression)expr, format);
            return;
        }
        if (expr instanceof XThrowExpression) {
            this._format((XThrowExpression)expr, format);
            return;
        }
        if (expr instanceof XTryCatchFinallyExpression) {
            this._format((XTryCatchFinallyExpression)expr, format);
            return;
        }
        if (expr instanceof XTypeLiteral) {
            this._format((XTypeLiteral)expr, format);
            return;
        }
        if (expr instanceof XVariableDeclaration) {
            this._format((XVariableDeclaration)expr, format);
            return;
        }
        if (expr instanceof JvmTypeConstraint) {
            this._format((JvmTypeConstraint)expr, format);
            return;
        }
        if (expr instanceof XExpression) {
            this._format((XExpression)expr, format);
            return;
        }
        if (expr instanceof XImportDeclaration) {
            this._format((XImportDeclaration)expr, format);
            return;
        }
        if (expr instanceof XImportSection) {
            this._format((XImportSection)expr, format);
            return;
        }
        if (expr instanceof EObject) {
            this._format((EObject)expr, format);
            return;
        }
        if (expr == null) {
            this._format(null, format);
            return;
        }
        if (expr != null) {
            this._format(expr, format);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr, format).toString());
    }

    @Pure
    public XbaseGrammarAccess getGrammar() {
        return this.grammar;
    }
}

