/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.http.HttpMethod;
import org.openhab.core.io.net.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP {
    public static final String CONTENT_TYPE_JSON = "application/json";
    private static Logger logger = LoggerFactory.getLogger(HTTP.class);

    public static String sendHttpGetRequest(String url) {
        return HTTP.sendHttpGetRequest(url, 5000);
    }

    public static String sendHttpGetRequest(String url, int timeout) {
        String response = null;
        try {
            return HttpUtil.executeUrl((String)HttpMethod.GET.name(), (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
            return response;
        }
    }

    public static String sendHttpGetRequest(String url, Map<String, String> headers, int timeout) {
        try {
            Properties headerProperties = new Properties();
            headerProperties.putAll(headers);
            return HttpUtil.executeUrl((String)HttpMethod.GET.name(), (String)url, (Properties)headerProperties, null, null, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static String sendHttpPutRequest(String url) {
        return HTTP.sendHttpPutRequest(url, 1000);
    }

    public static String sendHttpPutRequest(String url, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)HttpMethod.PUT.name(), (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpPutRequest(String url, String contentType, String content) {
        return HTTP.sendHttpPutRequest(url, contentType, content, 1000);
    }

    public static String sendHttpPutRequest(String url, String contentType, String content, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)HttpMethod.PUT.name(), (String)url, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), (String)contentType, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpPutRequest(String url, String contentType, String content, Map<String, String> headers, int timeout) {
        try {
            Properties headerProperties = new Properties();
            headerProperties.putAll(headers);
            return HttpUtil.executeUrl((String)HttpMethod.PUT.name(), (String)url, (Properties)headerProperties, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), (String)contentType, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static String sendHttpPostRequest(String url) {
        return HTTP.sendHttpPostRequest(url, 1000);
    }

    public static String sendHttpPostRequest(String url, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)HttpMethod.POST.name(), (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpPostRequest(String url, String contentType, String content) {
        return HTTP.sendHttpPostRequest(url, contentType, content, 1000);
    }

    public static String sendHttpPostRequest(String url, String contentType, String content, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)HttpMethod.POST.name(), (String)url, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), (String)contentType, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpPostRequest(String url, String contentType, String content, Map<String, String> headers, int timeout) {
        try {
            Properties headerProperties = new Properties();
            headerProperties.putAll(headers);
            return HttpUtil.executeUrl((String)HttpMethod.POST.name(), (String)url, (Properties)headerProperties, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), (String)contentType, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static String sendHttpDeleteRequest(String url) {
        return HTTP.sendHttpDeleteRequest(url, 1000);
    }

    public static String sendHttpDeleteRequest(String url, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)HttpMethod.DELETE.name(), (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpDeleteRequest(String url, Map<String, String> headers, int timeout) {
        try {
            Properties headerProperties = new Properties();
            headerProperties.putAll(headers);
            return HttpUtil.executeUrl((String)HttpMethod.DELETE.name(), (String)url, (Properties)headerProperties, null, null, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
            return null;
        }
    }
}

