/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.dispatch.internal;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ConfigDispatcher.class})
public class ConfigDispatcher {
    private final Logger logger = LoggerFactory.getLogger(ConfigDispatcher.class);
    private final Gson gson = new Gson();
    public static final String SERVICE_CONTEXT_MARKER = "#";
    public static final String SERVICECFG_PROG_ARGUMENT = "openhab.servicecfg";
    public static final String SERVICE_PID_NAMESPACE = "org.openhab";
    public static final String SERVICE_CFG_FILE = "services.cfg";
    private static final String PID_MARKER = "pid:";
    private static final String EXCLUSIVE_PID_STORE_FILE = "configdispatcher_pid_list.json";
    private static final String DEFAULT_PID_DELIMITER = ":";
    private static final String DEFAULT_VALUE_DELIMITER = "=";
    private static final String DEFAULT_LIST_STARTING_CHARACTER = "[";
    private static final String DEFAULT_LIST_ENDING_CHARACTER = "]";
    private static final String DEFAULT_LIST_DELIMITER = ",";
    private ExclusivePIDMap exclusivePIDMap;
    private final ConfigurationAdmin configAdmin;
    private File exclusivePIDStore;

    @Activate
    public ConfigDispatcher(@Reference ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this.exclusivePIDStore = bundleContext.getDataFile(EXCLUSIVE_PID_STORE_FILE);
        this.loadExclusivePIDList();
        this.readDefaultConfig();
    }

    private void loadExclusivePIDList() {
        try {
            try {
                Throwable throwable = null;
                Object var2_5 = null;
                try (FileReader reader = new FileReader(this.exclusivePIDStore);){
                    this.exclusivePIDMap = (ExclusivePIDMap)this.gson.fromJson((Reader)reader, ExclusivePIDMap.class);
                    this.exclusivePIDMap.initializeProcessPIDMapping();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (JsonIOException | JsonSyntaxException e) {
                this.logger.error("Error parsing exclusive pids from '{}': {}", (Object)this.exclusivePIDStore.getAbsolutePath(), (Object)e.getMessage());
                if (this.exclusivePIDMap == null) {
                    this.exclusivePIDMap = new ExclusivePIDMap();
                }
            }
            catch (IOException e) {
                this.logger.debug("Error loading exclusive pids from '{}': {}", (Object)this.exclusivePIDStore.getAbsolutePath(), (Object)e.getMessage());
                if (this.exclusivePIDMap == null) {
                    this.exclusivePIDMap = new ExclusivePIDMap();
                }
            }
        }
        finally {
            if (this.exclusivePIDMap == null) {
                this.exclusivePIDMap = new ExclusivePIDMap();
            }
        }
    }

    private void storeCurrentExclusivePIDList() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileWriter writer = new FileWriter(this.exclusivePIDStore);){
                this.exclusivePIDMap.setCurrentExclusivePIDList();
                this.gson.toJson((Object)this.exclusivePIDMap, (Appendable)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonIOException | IOException e) {
            this.logger.error("Error storing exclusive PID list in bundle data file: {}", (Object)e.getMessage());
        }
    }

    private Configuration getConfigurationWithContext(String pidWithContext) throws IOException, InvalidSyntaxException {
        String context;
        if (!pidWithContext.contains(SERVICE_CONTEXT_MARKER)) {
            throw new IllegalArgumentException("Given PID should be followed by a context");
        }
        String pid = pidWithContext.split(SERVICE_CONTEXT_MARKER)[0];
        Configuration[] configs = this.configAdmin.listConfigurations("(&(service.factoryPid=" + pid + ")(openhab.servicecontext=" + (context = pidWithContext.split(SERVICE_CONTEXT_MARKER)[1]) + "))");
        if (configs == null || configs.length == 0) {
            return null;
        }
        Configuration configuration = configs[0];
        if (configs.length > 1) {
            this.logger.error("More than one configuration with PID '{}' exists, using entry '{}'.", (Object)pidWithContext, configuration.getProperties().get("service.pid"));
        }
        return configuration;
    }

    private void processOrphanExclusivePIDs() {
        for (String orphanPID : this.exclusivePIDMap.getOrphanPIDs()) {
            try {
                Configuration configuration = orphanPID.contains(SERVICE_CONTEXT_MARKER) ? this.getConfigurationWithContext(orphanPID) : this.configAdmin.getConfiguration(orphanPID, null);
                if (configuration != null) {
                    configuration.delete();
                }
                this.logger.debug("Deleting configuration for orphan pid {}", (Object)orphanPID);
            }
            catch (IOException | InvalidSyntaxException e) {
                this.logger.error("Error deleting configuration for orphan pid {}.", (Object)orphanPID);
            }
        }
    }

    private String getDefaultServiceConfigPath() {
        String progArg = System.getProperty(SERVICECFG_PROG_ARGUMENT);
        if (progArg != null) {
            return progArg;
        }
        return SERVICE_CFG_FILE;
    }

    private void readDefaultConfig() {
        String defaultCfgPath = this.getDefaultServiceConfigPath();
        try {
            this.internalProcessConfigFile(new File(defaultCfgPath));
        }
        catch (IOException e) {
            this.logger.warn("Could not process default config file '{}': {}", (Object)defaultCfgPath, (Object)e.getMessage());
        }
    }

    public void processConfigFile(File dir) {
        if (dir.isDirectory() && dir.exists()) {
            File[] files = dir.listFiles();
            Arrays.sort(files, Comparator.comparingLong(File::lastModified));
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    this.internalProcessConfigFile(file);
                }
                catch (IOException e) {
                    this.logger.warn("Could not process config file '{}': {}", (Object)file.getName(), (Object)e.getMessage());
                }
                ++n2;
            }
        } else {
            try {
                this.internalProcessConfigFile(dir);
            }
            catch (IOException e) {
                this.logger.warn("Could not process config file '{}': {}", (Object)dir.getName(), (Object)e.getMessage());
            }
        }
        this.processOrphanExclusivePIDs();
        this.storeCurrentExclusivePIDList();
    }

    private String substringBefore(String str, String separator) {
        int index = str.indexOf(separator);
        return index == -1 ? str : str.substring(0, index);
    }

    private String substringBeforeLast(String str, String separator) {
        int index = str.lastIndexOf(separator);
        return index == -1 ? str : str.substring(0, index);
    }

    private String pidFromFilename(File configFile) {
        String filenameWithoutExt = this.substringBeforeLast(configFile.getName(), ".");
        if (filenameWithoutExt.contains(".")) {
            return filenameWithoutExt;
        }
        return "org.openhab." + filenameWithoutExt;
    }

    private void internalProcessConfigFile(File configFile) throws IOException {
        String exclusivePID;
        if (configFile.isDirectory() || !configFile.getName().endsWith(".cfg")) {
            this.logger.debug("Ignoring file '{}'", (Object)configFile.getName());
            return;
        }
        this.logger.debug("Processing config file '{}'", (Object)configFile.getName());
        HashMap<Configuration, Dictionary> configsToUpdate = new HashMap<Configuration, Dictionary>();
        HashMap<Configuration, Dictionary> configMap = new HashMap<Configuration, Dictionary>();
        String pid = this.pidFromFilename(configFile);
        String context = null;
        List<String> lines = Files.readAllLines(configFile.toPath(), StandardCharsets.UTF_8);
        String string = exclusivePID = !lines.isEmpty() ? this.getPIDFromLine(lines.get(0)) : null;
        if (exclusivePID != null) {
            if (this.exclusivePIDMap.contains(exclusivePID)) {
                this.logger.warn("The file {} subsequently defines the exclusive PID '{}'. Overriding existing configuration now.", (Object)configFile.getAbsolutePath(), (Object)exclusivePID);
            }
            pid = exclusivePID;
            if (exclusivePID.contains(SERVICE_CONTEXT_MARKER)) {
                pid = exclusivePID.split(SERVICE_CONTEXT_MARKER)[0];
                context = exclusivePID.split(SERVICE_CONTEXT_MARKER)[1];
            }
            lines = lines.subList(1, lines.size());
            this.exclusivePIDMap.setProcessedPID(exclusivePID, configFile.getAbsolutePath());
        } else if (this.exclusivePIDMap.contains(pid)) {
            this.exclusivePIDMap.removeExclusivePID(pid);
        }
        Configuration configuration = null;
        if (context != null) {
            try {
                configuration = this.getConfigurationWithContext(exclusivePID);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                this.logger.error("Failed to lookup config for file '{}' for PID '{}' with context '{}'", new Object[]{configFile.getName(), pid, context});
            }
            if (configuration == null) {
                this.logger.debug("Creating factory configuration for PID '{}' with context '{}'", (Object)pid, (Object)context);
                configuration = this.configAdmin.createFactoryConfiguration(pid, null);
            } else {
                this.logger.warn("Configuration for '{}' already exists, updating it with file '{}'.", (Object)exclusivePID, (Object)configFile.getName());
            }
        } else {
            configuration = this.configAdmin.getConfiguration(pid, null);
        }
        if (context == null && this.exclusivePIDMap.contains(pid)) {
            configMap.put(configuration, new Properties());
        } else if (context != null && this.exclusivePIDMap.contains(exclusivePID)) {
            Properties properties = new Properties();
            ((Dictionary)properties).put("openhab.servicecontext", context);
            configMap.put(configuration, properties);
        }
        for (String string2 : lines) {
            Dictionary configProperties;
            ParseLineResult parsedLine = this.parseLine(configFile.getPath(), string2);
            if (parsedLine.isEmpty()) continue;
            if (this.exclusivePIDMap.contains(pid) && parsedLine.pid != null && !pid.equals(parsedLine.pid)) {
                this.logger.error("Error parsing config file {}. Exclusive PID {} found but line starts with {}.", new Object[]{configFile.getName(), pid, parsedLine.pid});
                return;
            }
            if (!this.exclusivePIDMap.contains(pid) && parsedLine.pid != null && this.exclusivePIDMap.contains(parsedLine.pid)) {
                this.logger.error("Error parsing config file {}. The PID {} is exclusive but defined in another file, skipping the line.", (Object)configFile.getName(), (Object)parsedLine.pid);
                continue;
            }
            if (parsedLine.pid != null) {
                pid = parsedLine.pid;
                configuration = this.configAdmin.getConfiguration(pid, null);
            }
            if ((configProperties = (Dictionary)configMap.get(configuration)) == null) {
                configProperties = configuration.getProperties() != null ? configuration.getProperties() : new Properties();
                configMap.put(configuration, configProperties);
            }
            if (parsedLine.value == null || parsedLine.value.equals(configProperties.get(parsedLine.property))) continue;
            configProperties.put(parsedLine.property, parsedLine.value);
            configsToUpdate.put(configuration, configProperties);
        }
        for (Map.Entry entry : configsToUpdate.entrySet()) {
            ((Configuration)entry.getKey()).update((Dictionary)entry.getValue());
        }
        this.storeCurrentExclusivePIDList();
    }

    public void fileRemoved(String path) {
        this.exclusivePIDMap.setFileRemoved(path);
        this.processOrphanExclusivePIDs();
        this.storeCurrentExclusivePIDList();
    }

    private String getPIDFromLine(String line) {
        if (line.startsWith(PID_MARKER)) {
            return line.substring(PID_MARKER.length()).trim();
        }
        return null;
    }

    private ParseLineResult parseLine(String filePath, String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith(SERVICE_CONTEXT_MARKER) || trimmedLine.isEmpty()) {
            return new ParseLineResult();
        }
        Object pid = null;
        String key = this.substringBefore(trimmedLine, DEFAULT_VALUE_DELIMITER);
        if (key.contains(DEFAULT_PID_DELIMITER)) {
            pid = this.substringBefore(key, DEFAULT_PID_DELIMITER);
            trimmedLine = trimmedLine.substring(((String)pid).length() + 1);
            if (!((String)(pid = ((String)pid).trim())).contains(".")) {
                pid = "org.openhab." + (String)pid;
            }
        }
        if (!trimmedLine.isEmpty() && trimmedLine.substring(1).contains(DEFAULT_VALUE_DELIMITER)) {
            String property = this.substringBefore(trimmedLine, DEFAULT_VALUE_DELIMITER);
            String value = trimmedLine.substring(property.length() + 1).trim();
            if (value.startsWith(DEFAULT_LIST_STARTING_CHARACTER) && value.endsWith(DEFAULT_LIST_ENDING_CHARACTER)) {
                this.logger.debug("Found list in value '{}'", (Object)value);
                List<String> values = Arrays.stream(value.replace(DEFAULT_LIST_STARTING_CHARACTER, "").replace(DEFAULT_LIST_ENDING_CHARACTER, "").split(DEFAULT_LIST_DELIMITER)).map(String::trim).filter(v -> !v.isEmpty()).toList();
                return new ParseLineResult((String)pid, property.trim(), values);
            }
            return new ParseLineResult((String)pid, property.trim(), value);
        }
        this.logger.warn("Could not parse line '{}'", (Object)line);
        return new ParseLineResult();
    }

    public static class ExclusivePIDMap {
        private List<String> exclusivePIDs = new ArrayList<String>();
        private transient Map<String, String> processedPIDMapping = new HashMap<String, String>();

        ExclusivePIDMap() {
        }

        public void setProcessedPID(String pid, String pathToFile) {
            this.processedPIDMapping.put(pid, pathToFile);
        }

        public void removeExclusivePID(String pid) {
            this.processedPIDMapping.remove(pid);
        }

        public void setFileRemoved(String absolutePath) {
            for (Map.Entry<String, String> entry : this.processedPIDMapping.entrySet()) {
                if (!entry.getValue().equals(absolutePath)) continue;
                entry.setValue(null);
                return;
            }
        }

        public void initializeProcessPIDMapping() {
            this.processedPIDMapping = new HashMap<String, String>();
            for (String pid : this.exclusivePIDs) {
                this.processedPIDMapping.put(pid, null);
            }
        }

        public List<String> getOrphanPIDs() {
            return this.processedPIDMapping.entrySet().stream().filter(e -> e.getValue() == null).map(Map.Entry::getKey).toList();
        }

        public void setCurrentExclusivePIDList() {
            this.exclusivePIDs = this.processedPIDMapping.entrySet().stream().filter(e -> e.getValue() != null).map(Map.Entry::getKey).toList();
        }

        public boolean contains(String pid) {
            return this.processedPIDMapping.containsKey(pid);
        }
    }

    @NonNullByDefault
    private static class ParseLineResult {
        public @Nullable String pid;
        public @Nullable String property;
        public @Nullable Object value;

        public ParseLineResult() {
            this(null, null, null);
        }

        public ParseLineResult(@Nullable String pid, @Nullable String property, @Nullable Object value) {
            this.pid = pid;
            this.property = property;
            this.value = value;
        }

        public boolean isEmpty() {
            return this.pid == null && this.property == null && this.value == null;
        }
    }
}

