/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;

public class MediaTypeRegistry {
    public static final int TEXT_PLAIN = 0;
    public static final int APPLICATION_LINK_FORMAT = 40;
    public static final int APPLICATION_XML = 41;
    public static final int APPLICATION_OCTET_STREAM = 42;
    public static final int APPLICATION_XMPP_XML = 46;
    public static final int APPLICATION_EXI = 47;
    public static final int APPLICATION_JSON = 50;
    public static final int APPLICATION_CBOR = 60;
    public static final int APPLICATION_SENML_JSON = 110;
    public static final int APPLICATION_SENML_CBOR = 112;
    public static final int APPLICATION_VND_OMA_LWM2M_TLV = 11542;
    public static final int APPLICATION_VND_OMA_LWM2M_JSON = 11543;
    public static final int MAX_TYPE = 65535;
    public static final int UNDEFINED = -1;
    private static final HashMap<Integer, String[]> registry = new HashMap();

    public static Set<Integer> getAllMediaTypes() {
        return registry.keySet();
    }

    public static boolean isPrintable(int mediaType) {
        switch (mediaType) {
            case -1: 
            case 0: 
            case 40: 
            case 41: 
            case 46: 
            case 50: 
            case 110: 
            case 11543: {
                return true;
            }
        }
        return false;
    }

    public static int parse(String type) {
        if (type == null) {
            return -1;
        }
        for (Integer key : registry.keySet()) {
            if (!registry.get(key)[0].equalsIgnoreCase(type)) continue;
            return key;
        }
        return -1;
    }

    public static Integer[] parseWildcard(String regex) {
        regex = regex.trim().substring(0, regex.indexOf(42)).trim().concat(".*");
        Pattern pattern = Pattern.compile(regex);
        LinkedList<Integer> matches = new LinkedList<Integer>();
        for (Integer mediaType : registry.keySet()) {
            String mime = registry.get(mediaType)[0];
            if (!pattern.matcher(mime).matches()) continue;
            matches.add(mediaType);
        }
        return matches.toArray(new Integer[0]);
    }

    public static String toFileExtension(int mediaType) {
        String[] texts = registry.get(mediaType);
        if (texts != null) {
            return texts[1];
        }
        return "unknown_" + mediaType;
    }

    public static String toString(int mediaType) {
        if (mediaType == -1) {
            return "undefined";
        }
        String[] texts = registry.get(mediaType);
        if (texts != null) {
            return texts[0];
        }
        return "unknown/" + mediaType;
    }

    private static void add(int mediaType, String string, String extension) {
        registry.put(mediaType, new String[]{string, extension});
    }

    static {
        MediaTypeRegistry.add(-1, "unknown", "???");
        MediaTypeRegistry.add(0, "text/plain", "txt");
        MediaTypeRegistry.add(40, "application/link-format", "wlnk");
        MediaTypeRegistry.add(41, "application/xml", "xml");
        MediaTypeRegistry.add(42, "application/octet-stream", "bin");
        MediaTypeRegistry.add(46, "application/xmpp+xml", "xmpp");
        MediaTypeRegistry.add(47, "application/exi", "exi");
        MediaTypeRegistry.add(50, "application/json", "json");
        MediaTypeRegistry.add(60, "application/cbor", "cbor");
        MediaTypeRegistry.add(110, "application/senml+json", "json");
        MediaTypeRegistry.add(112, "application/senml+cbor", "cbor");
        MediaTypeRegistry.add(11542, "application/vnd.oma.lwm2m+tlv", "tlv");
        MediaTypeRegistry.add(11543, "application/vnd.oma.lwm2m+json", "json");
    }
}

