/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Workspace;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.MainClassNamespace;
import aQute.bnd.result.Result;
import aQute.bnd.service.externalplugin.ExternalPluginNamespace;
import aQute.bnd.service.progress.ProgressPlugin;
import aQute.bnd.service.progress.TaskManager;
import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.command.Command;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Capability;

public class WorkspaceExternalPluginHandler
implements AutoCloseable {
    final Workspace workspace;

    WorkspaceExternalPluginHandler(Workspace workspace) {
        this.workspace = workspace;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <T, R> Result<R> call(String pluginName, Class<T> c, FunctionWithException<T, Result<R>> f) {
        try {
            String filter = ExternalPluginNamespace.filter(pluginName, c);
            Optional<Capability> optCap = this.workspace.findProviders("bnd.external.plugin", filter).findAny();
            if (!optCap.isPresent()) {
                return Result.err("no such plugin %s for type %s", pluginName, c.getName());
            }
            Capability cap = optCap.get();
            Result<File> bundle = this.workspace.getBundle(cap.getResource());
            if (bundle.isErr()) {
                return bundle.asError();
            }
            Object object = cap.getAttributes().get("implementation");
            if (object == null || !(object instanceof String)) {
                return Result.err("no proper class attribute in plugin capability %s is %s", pluginName, object);
            }
            String className = (String)object;
            URL url = bundle.unwrap().toURI().toURL();
            try (URLClassLoader cl = new URLClassLoader(new URL[]{url}, WorkspaceExternalPluginHandler.class.getClassLoader());){
                Class<?> impl = cl.loadClass(className);
                T instance = c.cast(impl.newInstance());
                try {
                    Result<R> result = f.apply(instance);
                    return result;
                }
                catch (Exception e) {
                    Result result2 = Result.err("external plugin '%s' failed with: %s", pluginName, Exceptions.causes(e));
                    cl.close();
                    return result2;
                }
            }
        }
        catch (ClassNotFoundException e2) {
            return Result.err("no such class %s in %s for plugin %s", e2.getMessage(), pluginName);
        }
        catch (Exception e3) {
            return Result.err("could not instantiate class %s in %s for plugin %s: %s", e3.getMessage(), pluginName, Exceptions.causes(e3));
        }
    }

    public Result<Integer> call(String mainClass, VersionRange range, Processor context, Map<String, String> attrs, List<String> args, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        ArrayList<File> cp = new ArrayList<File>();
        try {
            Parameters cpp = new Parameters(attrs.get("classpath"));
            for (Map.Entry<String, Attrs> e : cpp.entrySet()) {
                String v = e.getValue().getVersion();
                MavenVersion mv = MavenVersion.parseMavenString(v);
                Result<File> result = this.workspace.getBundle(e.getKey(), mv.getOSGiVersion(), null);
                if (result.isErr()) {
                    return result.asError();
                }
                cp.add(result.unwrap());
            }
            String filter = MainClassNamespace.filter(mainClass, range);
            Optional<Capability> optCap = this.workspace.findProviders("bnd.mainclass", filter).findAny();
            if (optCap.isPresent()) {
                Capability cap = optCap.get();
                Result<File> bundle = this.workspace.getBundle(cap.getResource());
                if (bundle.isErr()) {
                    return bundle.asError();
                }
                cp.add(bundle.unwrap());
            } else if (cp.isEmpty()) {
                return Result.err("no bundle found with main class %s", mainClass);
            }
            Command c = new Command();
            c.setTrace();
            File cwd = context.getBase();
            String workingdir = attrs.get("workingdir");
            if (workingdir != null) {
                cwd = context.getFile(workingdir);
                cwd.mkdirs();
                if (!cwd.isDirectory()) {
                    return Result.err("Working dir set to %s but cannot make it a directory", cwd);
                }
            }
            c.setCwd(cwd);
            c.setTimeout(1L, TimeUnit.MINUTES);
            c.add(context.getProperty("java", IO.getJavaExecutablePath("java")));
            c.add("-cp");
            String classpath = Strings.join(File.pathSeparator, cp);
            c.add(classpath);
            c.add(mainClass);
            for (String arg : args) {
                c.add(arg);
            }
            int exitCode = TaskManager.with(this.getTask(c), () -> {
                PrintWriter lstdout = IO.writer(stdout == null ? System.out : stdout);
                PrintWriter lstderr = IO.writer(stderr == null ? System.err : stderr);
                try {
                    Integer n = c.execute(stdin, (Appendable)lstdout, (Appendable)lstderr);
                    return n;
                }
                finally {
                    lstdout.flush();
                    lstderr.flush();
                }
            });
            return Result.ok(exitCode);
        }
        catch (Exception e) {
            return Result.err("Failed with: %s", Exceptions.causes(e));
        }
    }

    private ProgressPlugin.Task getTask(final Command c) {
        return new ProgressPlugin.Task(){
            private boolean canceled;

            @Override
            public void worked(int units) {
            }

            @Override
            public void done(String message, Throwable e) {
            }

            @Override
            public boolean isCanceled() {
                return this.canceled;
            }

            @Override
            public void abort() {
                this.canceled = true;
                c.cancel();
            }
        };
    }

    @Override
    public void close() {
    }
}

