/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;

public class MaxFragmentLengthExtension
extends HelloExtension {
    public static final int CODE_BITS = 8;
    private final Length fragmentLength;

    public MaxFragmentLengthExtension(int fragmentLengthCode) {
        this(Length.fromCode(fragmentLengthCode));
    }

    public MaxFragmentLengthExtension(Length fragmentLength) {
        super(HelloExtension.ExtensionType.MAX_FRAGMENT_LENGTH);
        if (fragmentLength == null) {
            throw new NullPointerException("Length must not be null");
        }
        this.fragmentLength = fragmentLength;
    }

    public Length getFragmentLength() {
        return this.fragmentLength;
    }

    @Override
    public int getLength() {
        return 5;
    }

    static final MaxFragmentLengthExtension fromExtensionDataReader(DatagramReader extensionDataReader, InetSocketAddress peerAddress) throws HandshakeException {
        int code = extensionDataReader.read(8);
        Length length = Length.fromCode(code);
        if (length != null) {
            return new MaxFragmentLengthExtension(length);
        }
        throw new HandshakeException(String.format("Peer uses unknown code [%d] in %s extension", code, HelloExtension.ExtensionType.MAX_FRAGMENT_LENGTH.name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, peerAddress));
    }

    @Override
    protected void addExtensionData(DatagramWriter writer) {
        writer.write(1, 16);
        writer.write(this.fragmentLength.code, 8);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\t\t\tCode: ").append(this.fragmentLength.code()).append(" (").append(this.fragmentLength.length()).append(" bytes)");
        return sb.toString();
    }

    public static enum Length {
        BYTES_512(1, 512),
        BYTES_1024(2, 1024),
        BYTES_2048(3, 2048),
        BYTES_4096(4, 4096);

        private int code;
        private int length;

        private Length(int code, int length) {
            this.code = code;
            this.length = length;
        }

        public int code() {
            return this.code;
        }

        public int length() {
            return this.length;
        }

        public static Length fromCode(int code) {
            switch (code) {
                case 1: {
                    return BYTES_512;
                }
                case 2: {
                    return BYTES_1024;
                }
                case 3: {
                    return BYTES_2048;
                }
                case 4: {
                    return BYTES_4096;
                }
            }
            return null;
        }
    }
}

