/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtent2Di
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    public XrExtent2Di(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrExtent2Di.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int width() {
        return XrExtent2Di.nwidth(this.address());
    }

    @NativeType(value="int32_t")
    public int height() {
        return XrExtent2Di.nheight(this.address());
    }

    public XrExtent2Di width(@NativeType(value="int32_t") int value) {
        XrExtent2Di.nwidth(this.address(), value);
        return this;
    }

    public XrExtent2Di height(@NativeType(value="int32_t") int value) {
        XrExtent2Di.nheight(this.address(), value);
        return this;
    }

    public XrExtent2Di set(int width, int height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public XrExtent2Di set(XrExtent2Di src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrExtent2Di malloc() {
        return (XrExtent2Di)XrExtent2Di.wrap(XrExtent2Di.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrExtent2Di calloc() {
        return (XrExtent2Di)XrExtent2Di.wrap(XrExtent2Di.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrExtent2Di create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrExtent2Di)XrExtent2Di.wrap(XrExtent2Di.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrExtent2Di create(long address) {
        return (XrExtent2Di)XrExtent2Di.wrap(XrExtent2Di.class, (long)address);
    }

    @Nullable
    public static XrExtent2Di createSafe(long address) {
        return address == 0L ? null : (XrExtent2Di)XrExtent2Di.wrap(XrExtent2Di.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrExtent2Di.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrExtent2Di.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrExtent2Di.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtent2Di.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrExtent2Di.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrExtent2Di.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrExtent2Di.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrExtent2Di malloc(MemoryStack stack) {
        return (XrExtent2Di)XrExtent2Di.wrap(XrExtent2Di.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrExtent2Di calloc(MemoryStack stack) {
        return (XrExtent2Di)XrExtent2Di.wrap(XrExtent2Di.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrExtent2Di.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrExtent2Di.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = XrExtent2Di.__struct((Struct.Member[])new Struct.Member[]{XrExtent2Di.__member((int)4), XrExtent2Di.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrExtent2Di, Buffer>
    implements NativeResource {
        private static final XrExtent2Di ELEMENT_FACTORY = XrExtent2Di.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrExtent2Di getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int width() {
            return XrExtent2Di.nwidth(this.address());
        }

        @NativeType(value="int32_t")
        public int height() {
            return XrExtent2Di.nheight(this.address());
        }

        public Buffer width(@NativeType(value="int32_t") int value) {
            XrExtent2Di.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="int32_t") int value) {
            XrExtent2Di.nheight(this.address(), value);
            return this;
        }
    }
}

