/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.IgnoreFilter;
import org.apache.derby.iapi.sql.compile.ScopeFilter;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptorList;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class DeleteNode
extends DMLModStatementNode {
    private static final String COLUMNNAME = "###RowLocationToDelete";
    private boolean deferred;
    private FromTable targetTable;
    private FormatableBitSet readColsBitSet;
    private ConstantAction[] dependentConstantActions;
    private boolean cascadeDelete;
    private StatementNode[] dependentNodes;

    DeleteNode(TableName targetTableName, ResultSetNode queryExpression, MatchingClauseNode matchingClause, ContextManager cm) {
        super(queryExpression, matchingClause, cm);
        this.targetTableName = targetTableName;
    }

    @Override
    String statementToString() {
        return "DELETE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        this.getCompilerContext().pushCurrentPrivType(0);
        try {
            FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
            ResultColumn rowLocationColumn = null;
            TableName cursorTargetTableName = null;
            CurrentOfNode currentOfNode = null;
            IgnoreFilter ignorePermissions = new IgnoreFilter();
            this.getCompilerContext().addPrivilegeFilter(ignorePermissions);
            DataDictionary dataDictionary = this.getDataDictionary();
            if (!this.inMatchingClause()) {
                super.bindTables(dataDictionary);
            }
            SanityManager.ASSERT((this.resultSet != null && this.resultSet instanceof SelectNode ? 1 : 0) != 0, (String)"Delete must have a select result set");
            SelectNode sel = (SelectNode)this.resultSet;
            this.targetTable = (FromTable)sel.fromList.elementAt(0);
            if (this.targetTable instanceof CurrentOfNode) {
                currentOfNode = (CurrentOfNode)this.targetTable;
                cursorTargetTableName = this.inMatchingClause() ? this.targetTableName : currentOfNode.getBaseCursorTargetTableName();
                SanityManager.ASSERT((cursorTargetTableName != null ? 1 : 0) != 0);
            }
            if (this.targetTable instanceof FromVTI) {
                this.targetVTI = (FromVTI)this.targetTable;
                this.targetVTI.setTarget();
            } else if (this.targetTableName == null) {
                SanityManager.ASSERT((cursorTargetTableName != null ? 1 : 0) != 0);
                this.targetTableName = cursorTargetTableName;
            } else if (cursorTargetTableName != null && !this.targetTableName.equals(cursorTargetTableName)) {
                throw StandardException.newException((String)"42X28", (Object[])new Object[]{this.targetTableName, currentOfNode.getCursorName()});
            }
            this.verifyTargetTable();
            SanityManager.ASSERT((this.resultSet.getResultColumns() == null ? 1 : 0) != 0, (String)"resultColumns is expected to be null until bind time");
            if (this.targetTable instanceof FromVTI) {
                this.getResultColumnList();
                this.resultColumnList = this.targetTable.getResultColumnsForList(null, this.resultColumnList, null);
                this.resultSet.setResultColumns(this.resultColumnList);
            } else {
                int i;
                this.resultColumnList = new ResultColumnList(this.getContextManager());
                FromBaseTable fbt = this.getResultColumnList(this.resultColumnList);
                this.readColsBitSet = this.getReadMap(dataDictionary, this.targetTableDescriptor);
                this.resultColumnList = fbt.addColsToList(this.resultColumnList, this.readColsBitSet);
                int size = this.targetTableDescriptor.getMaxColumnID();
                for (i = 1; i <= size && this.readColsBitSet.get(i); ++i) {
                }
                if (i > size) {
                    this.readColsBitSet = null;
                }
                CurrentRowLocationNode rowLocationNode = new CurrentRowLocationNode(this.getContextManager());
                rowLocationColumn = new ResultColumn(COLUMNNAME, (ValueNode)rowLocationNode, this.getContextManager());
                rowLocationColumn.markGenerated();
                this.resultColumnList.addResultColumn(rowLocationColumn);
                this.correlateAddedColumns(this.resultColumnList, this.targetTable);
                ResultColumnList originalRCL = this.resultSet.getResultColumns();
                if (originalRCL != null) {
                    originalRCL.appendResultColumns(this.resultColumnList, false);
                    this.resultColumnList = originalRCL;
                }
                this.resultSet.setResultColumns(this.resultColumnList);
            }
            this.getCompilerContext().removePrivilegeFilter(ignorePermissions);
            ScopeFilter scopeFilter = new ScopeFilter(this.getCompilerContext(), "whereScope", 1);
            this.getCompilerContext().addPrivilegeFilter(scopeFilter);
            super.bindExpressions();
            this.getCompilerContext().removePrivilegeFilter(scopeFilter);
            this.resultSet.getResultColumns().bindUntypedNullsToResultColumns(this.resultColumnList);
            if (!(this.targetTable instanceof FromVTI)) {
                rowLocationColumn.bindResultColumnToExpression();
                this.bindConstraints(dataDictionary, this.getOptimizerFactory(), this.targetTableDescriptor, null, this.resultColumnList, null, this.readColsBitSet, true, new boolean[1]);
                if (this.resultSet.subqueryReferencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                    this.deferred = true;
                }
            } else {
                this.deferred = VTIDeferModPolicy.deferIt(3, this.targetVTI, null, sel.getWhereClause());
            }
            SanityManager.ASSERT((fromList.size() == 0 ? 1 : 0) != 0, (String)("fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()"));
            if (this.fkTableNames != null) {
                String currentTargetTableName = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
                if (!this.isDependentTable) {
                    this.dependentTables = new HashSet();
                }
                if (this.dependentTables.add(currentTargetTableName)) {
                    this.cascadeDelete = true;
                    int noDependents = this.fkTableNames.length;
                    this.dependentNodes = new StatementNode[noDependents];
                    for (int i = 0; i < noDependents; ++i) {
                        this.dependentNodes[i] = this.getDependentTableNode(this.fkSchemaNames[i], this.fkTableNames[i], this.fkRefActions[i], this.fkColDescriptors[i]);
                        this.dependentNodes[i].bindStatement();
                    }
                }
            } else if (this.isDependentTable) {
                String currentTargetTableName = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
                this.dependentTables.add(currentTargetTableName);
            }
            this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
            this.getCompilerContext().addRequiredTablePriv(this.targetTableDescriptor);
            this.getCompilerContext().popCurrentPrivType();
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
    }

    @Override
    int getPrivType() {
        return 4;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        if (this.targetTableDescriptor != null) {
            int lckMode = this.resultSet.updateTargetLockMode();
            long heapConglomId = this.targetTableDescriptor.getHeapConglomerateId();
            TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
            StaticCompiledOpenConglomInfo[] indexSCOCIs = new StaticCompiledOpenConglomInfo[this.indexConglomerateNumbers.length];
            for (int index = 0; index < indexSCOCIs.length; ++index) {
                indexSCOCIs[index] = tc.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[index]);
            }
            if (this.targetTableDescriptor.getLockGranularity() == 'T') {
                lckMode = 7;
            }
            ResultDescription resultDescription = null;
            if (this.isDependentTable) {
                resultDescription = this.makeResultDescription();
            }
            return this.getGenericConstantActionFactory().getDeleteConstantAction(heapConglomId, this.targetTableDescriptor.getTableType(), tc.getStaticCompiledConglomInfo(heapConglomId), this.indicesToMaintain, this.indexConglomerateNumbers, indexSCOCIs, this.deferred, false, this.targetTableDescriptor.getUUID(), lckMode, null, null, null, 0L, null, null, resultDescription, this.getFKInfo(), this.getTriggerInfo(), this.readColsBitSet == null ? (FormatableBitSet)null : new FormatableBitSet(this.readColsBitSet), DeleteNode.getReadColMap(this.targetTableDescriptor.getNumberOfColumns(), this.readColsBitSet), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.readColsBitSet == null ? this.targetTableDescriptor.getNumberOfColumns() : this.readColsBitSet.getNumBitsSet(), null, this.resultSet.isOneRowResultSet(), this.dependentConstantActions, this.inMatchingClause());
        }
        return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(3, this.deferred);
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        int numResultSets;
        String parentResultSetId;
        int argCount;
        String resultSetGetter;
        this.generateCodeForTemporaryTable(acb);
        if (!this.isDependentTable) {
            this.generateParameterValueSet(acb);
        }
        acb.pushGetResultSetFactoryExpression(mb);
        acb.newRowLocationScanResultSetName();
        if (this.inMatchingClause()) {
            this.matchingClause.generateResultSetField(acb, mb);
        } else {
            this.resultSet.generate(acb, mb);
        }
        if (this.targetTableDescriptor != null) {
            acb.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.CursorResultSet", acb.getRowLocationScanResultSetName());
            if (this.cascadeDelete || this.isDependentTable) {
                resultSetGetter = "getDeleteCascadeResultSet";
                argCount = 4;
            } else {
                resultSetGetter = "getDeleteResultSet";
                argCount = 1;
            }
        } else {
            argCount = 1;
            resultSetGetter = "getDeleteVTIResultSet";
        }
        if (this.isDependentTable) {
            mb.push(acb.addItem(this.makeConstantAction()));
        } else if (this.cascadeDelete) {
            mb.push(-1);
        }
        String resultSetArrayType = "org.apache.derby.iapi.sql.ResultSet[]";
        if (this.cascadeDelete) {
            parentResultSetId = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            LocalField arrayField = acb.newFieldDeclaration(2, resultSetArrayType);
            mb.pushNewArray("org.apache.derby.iapi.sql.ResultSet", this.dependentNodes.length);
            mb.setField(arrayField);
            for (int index = 0; index < this.dependentNodes.length; ++index) {
                this.dependentNodes[index].setRefActionInfo(this.fkIndexConglomNumbers[index], this.fkColArrays[index], parentResultSetId, true);
                mb.getField(arrayField);
                if (mb.statementNumHitLimit(10)) {
                    MethodBuilder dmb = acb.newGeneratedFun("org.apache.derby.iapi.sql.ResultSet", 2);
                    this.dependentNodes[index].generate(acb, dmb);
                    dmb.methodReturn();
                    dmb.complete();
                    mb.pushThis();
                    mb.callMethod((short)182, null, dmb.getName(), "org.apache.derby.iapi.sql.ResultSet", 0);
                } else {
                    this.dependentNodes[index].generate(acb, mb);
                }
                mb.setArrayElement(index);
            }
            mb.getField(arrayField);
        } else if (this.isDependentTable) {
            mb.pushNull(resultSetArrayType);
        }
        if (this.cascadeDelete || this.isDependentTable) {
            parentResultSetId = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            mb.push(parentResultSetId);
        }
        mb.callMethod((short)185, null, resultSetGetter, "org.apache.derby.iapi.sql.ResultSet", argCount);
        if (!this.isDependentTable && this.cascadeDelete && (numResultSets = acb.getRowCount()) > 0) {
            MethodBuilder constructor = acb.getConstructor();
            constructor.pushThis();
            constructor.pushNewArray("org.apache.derby.iapi.sql.execute.CursorResultSet", numResultSets);
            constructor.putField("org.apache.derby.impl.sql.execute.BaseActivation", "raParentResultSets", "org.apache.derby.iapi.sql.execute.CursorResultSet[]");
            constructor.endStatement();
        }
    }

    @Override
    protected final int getStatementType() {
        return 4;
    }

    public FormatableBitSet getReadMap(DataDictionary dd, TableDescriptor baseTable) throws StandardException {
        boolean[] needsDeferredProcessing = new boolean[]{this.requiresDeferredProcessing()};
        ArrayList<ConglomerateDescriptor> conglomerates = new ArrayList<ConglomerateDescriptor>();
        this.relevantTriggers = new TriggerDescriptorList();
        FormatableBitSet columnMap = DeleteNode.getDeleteReadMap(baseTable, conglomerates, this.relevantTriggers, needsDeferredProcessing);
        this.markAffectedIndexes(conglomerates);
        this.adjustDeferredFlag(needsDeferredProcessing[0]);
        return columnMap;
    }

    private StatementNode getDependentTableNode(String schemaName, String tableName, int refAction, ColumnDescriptorList cdl) throws StandardException {
        DMLModStatementNode node = null;
        if (refAction == 0) {
            node = this.getEmptyDeleteNode(schemaName, tableName);
        }
        if (refAction == 3) {
            node = this.getEmptyUpdateNode(schemaName, tableName, cdl);
        }
        if (node != null) {
            node.isDependentTable = true;
            node.dependentTables = this.dependentTables;
        }
        return node;
    }

    private DeleteNode getEmptyDeleteNode(String schemaName, String targetTableName) throws StandardException {
        ValueNode whereClause = null;
        TableName tableName = new TableName(schemaName, targetTableName, this.getContextManager());
        FromList fromList = new FromList(this.getContextManager());
        FromBaseTable fromTable = new FromBaseTable(tableName, null, 2, null, this.getContextManager());
        FormatableProperties targetProperties = new FormatableProperties();
        targetProperties.put("index", "null");
        fromTable.setTableProperties(targetProperties);
        fromList.addFromTable(fromTable);
        SelectNode rs = new SelectNode(null, fromList, whereClause, null, null, null, null, this.getContextManager());
        return new DeleteNode(tableName, rs, null, this.getContextManager());
    }

    private UpdateNode getEmptyUpdateNode(String schemaName, String targetTableName, ColumnDescriptorList cdl) throws StandardException {
        ValueNode whereClause = null;
        TableName tableName = new TableName(schemaName, targetTableName, this.getContextManager());
        FromList fromList = new FromList(this.getContextManager());
        FromBaseTable fromTable = new FromBaseTable(tableName, null, 2, null, this.getContextManager());
        FormatableProperties targetProperties = new FormatableProperties();
        targetProperties.put("index", "null");
        fromTable.setTableProperties(targetProperties);
        fromList.addFromTable(fromTable);
        SelectNode sn = new SelectNode(this.getSetClause(cdl), fromList, whereClause, null, null, null, null, this.getContextManager());
        return new UpdateNode(tableName, sn, null, this.getContextManager());
    }

    private ResultColumnList getSetClause(ColumnDescriptorList cdl) throws StandardException {
        ResultColumnList columnList = new ResultColumnList(this.getContextManager());
        UntypedNullConstantNode valueNode = new UntypedNullConstantNode(this.getContextManager());
        for (int index = 0; index < cdl.size(); ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            if (!cd.getType().isNullable()) continue;
            ResultColumn resultColumn = new ResultColumn(cd, (ValueNode)valueNode, this.getContextManager());
            columnList.addResultColumn(resultColumn);
        }
        return columnList;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        IgnoreFilter ignorePermissions = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignorePermissions);
        if (this.cascadeDelete) {
            for (int index = 0; index < this.dependentNodes.length; ++index) {
                this.dependentNodes[index].optimizeStatement();
            }
        }
        super.optimizeStatement();
        this.getCompilerContext().removePrivilegeFilter(ignorePermissions);
    }

    private static FormatableBitSet getDeleteReadMap(TableDescriptor baseTable, List<ConglomerateDescriptor> conglomerates, TriggerDescriptorList relevantTriggers, boolean[] needsDeferredProcessing) throws StandardException {
        int columnCount = baseTable.getMaxColumnID();
        FormatableBitSet columnMap = new FormatableBitSet(columnCount + 1);
        DMLModStatementNode.getXAffectedIndexes(baseTable, null, columnMap, conglomerates);
        baseTable.getAllRelevantTriggers(4, null, relevantTriggers);
        if (relevantTriggers.size() > 0) {
            needsDeferredProcessing[0] = true;
            boolean needToIncludeAllColumns = false;
            for (TriggerDescriptor trd : relevantTriggers) {
                if (!trd.getReferencingNew() && !trd.getReferencingOld()) continue;
                needToIncludeAllColumns = true;
                break;
            }
            if (needToIncludeAllColumns) {
                for (int i = 1; i <= columnCount; ++i) {
                    columnMap.set(i);
                }
            }
        }
        return columnMap;
    }

    private void correlateAddedColumns(ResultColumnList rcl, FromTable fromTable) throws StandardException {
        String correlationName = fromTable.getCorrelationName();
        if (correlationName == null) {
            return;
        }
        TableName correlationNameNode = this.makeTableName(null, correlationName);
        for (ResultColumn column : rcl) {
            ValueNode expression = column.getExpression();
            if (expression == null || !(expression instanceof ColumnReference)) continue;
            ColumnReference reference = (ColumnReference)expression;
            reference.setQualifiedTableName(correlationNameNode);
        }
    }
}

