/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.Version;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.Util;

public class UnicastTestTcp {
    protected boolean oob = false;
    protected boolean dont_bundle = true;
    protected int num_threads = 1;
    protected int num_msgs = 100000;
    protected int msg_size = 1000;
    protected InetSocketAddress local;
    protected InetSocketAddress remote;
    protected PhysicalAddress destination;
    protected Socket sock;
    protected DataOutputStream output;
    protected final Lock output_lock = new ReentrantLock();
    protected ServerSocket srv_sock;
    protected Acceptor acceptor;
    protected long start = 0L;
    protected long stop = 0L;
    protected long total_time = 0L;
    protected long msgs_per_sec;
    protected long print;
    protected AtomicLong current_value = new AtomicLong(0L);
    protected AtomicLong total_bytes = new AtomicLong(0L);
    protected static final boolean TCP_NODELAY = false;
    protected static final int SOCK_SEND_BUF_SIZE = 200000;
    protected static final int SOCK_RECV_BUF_SIZE = 200000;
    protected static final byte START = 1;
    protected static final byte DATA = 2;

    public void init(String local_addr, String remote_addr, int local_port, int remote_port) throws Exception {
        this.local = new InetSocketAddress(local_addr, local_port);
        this.remote = new InetSocketAddress(remote_addr, remote_port);
        this.destination = new IpAddress(this.remote.getAddress(), this.remote.getPort());
        this.srv_sock = Util.createServerSocket(new DefaultSocketFactory(), "server", this.local.getAddress(), this.local.getPort(), this.local.getPort(), 0);
        System.out.println("Listening on " + this.srv_sock.getLocalSocketAddress());
        this.acceptor = new Acceptor();
        this.acceptor.start();
        this.sock = new Socket();
        this.sock.setSendBufferSize(200000);
        this.sock.setReceiveBufferSize(200000);
        try {
            this.sock.connect(this.remote);
            this.output = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            System.out.println("Connected to " + this.sock.getRemoteSocketAddress());
        }
        catch (Throwable t) {
            System.out.println("Failed connecting to " + this.remote + ": will only act as server");
        }
    }

    public void eventLoop() throws Exception {
        block10: while (true) {
            System.out.print("[1] Send msgs \n[6]Set sender threads (" + this.num_threads + ") [7] Set num msgs (" + this.num_msgs + ") [8] Set msg size (" + Util.printBytes(this.msg_size) + ")\n[o] Toggle OOB (" + this.oob + ") [b] Toggle dont_bundle (" + this.dont_bundle + ")\n[q] Quit\n");
            System.out.flush();
            int c = System.in.read();
            switch (c) {
                case -1: {
                    continue block10;
                }
                case 49: {
                    this.sendMessages();
                    continue block10;
                }
                case 54: {
                    this.setSenderThreads();
                    continue block10;
                }
                case 55: {
                    this.setNumMessages();
                    continue block10;
                }
                case 56: {
                    this.setMessageSize();
                    continue block10;
                }
                case 111: {
                    this.oob = !this.oob;
                    System.out.println("oob=" + this.oob);
                    continue block10;
                }
                case 98: {
                    this.dont_bundle = !this.dont_bundle;
                    System.out.println("dont_bundle = " + this.dont_bundle);
                    continue block10;
                }
                case 113: {
                    Util.close((Closeable)this.srv_sock);
                    Util.close((Closeable)this.sock);
                    return;
                }
            }
        }
    }

    void sendMessages() throws Exception {
        if (this.num_threads > 1 && this.num_msgs % this.num_threads != 0) {
            System.err.println("num_msgs (" + this.num_msgs + " ) has to be divisible by num_threads (" + this.num_threads + ")");
            return;
        }
        System.out.println("sending " + this.num_msgs + " messages (" + Util.printBytes(this.msg_size) + ") to " + this.remote + ": oob=" + this.oob + ", " + this.num_threads + " sender thread(s)");
        ByteBuffer buf = ByteBuffer.allocate(9).put((byte)1).putLong(this.num_msgs);
        BytesMessage msg = new BytesMessage((Address)this.destination, buf.array());
        UnicastTestTcp.writeMessage(msg, this.output);
        int msgs_per_sender = this.num_msgs / this.num_threads;
        Sender[] senders = new Sender[this.num_threads];
        for (int i = 0; i < senders.length; ++i) {
            senders[i] = new Sender(msgs_per_sender, this.msg_size, this.num_msgs / 10);
        }
        for (Sender sender : senders) {
            sender.start();
        }
        for (Sender sender : senders) {
            sender.join();
        }
        this.output.flush();
        System.out.println("done sending " + this.num_msgs + " to " + this.remote);
    }

    void setSenderThreads() throws Exception {
        int threads = Util.readIntFromStdin("Number of sender threads: ");
        int old = this.num_threads;
        this.num_threads = threads;
        System.out.println("sender threads set to " + this.num_threads + " (from " + old + ")");
    }

    void setNumMessages() throws Exception {
        this.num_msgs = Util.readIntFromStdin("Number of messages: ");
        System.out.println("Set num_msgs=" + this.num_msgs);
    }

    void setMessageSize() throws Exception {
        this.msg_size = Util.readIntFromStdin("Message size: ");
        System.out.println("set msg_size=" + this.msg_size);
    }

    public static void main(String[] args) {
        String local_addr = "localhost";
        String remote_addr = "localhost";
        int local_port = 8000;
        int remote_port = 9000;
        for (int i = 0; i < args.length; ++i) {
            if ("-local_addr".equals(args[i])) {
                local_addr = args[++i];
                continue;
            }
            if ("-remote_addr".equals(args[i])) {
                remote_addr = args[++i];
                continue;
            }
            if ("-local_port".equals(args[i])) {
                local_port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-remote_port".equals(args[i])) {
                remote_port = Integer.parseInt(args[++i]);
                continue;
            }
            UnicastTestTcp.help();
            return;
        }
        try {
            UnicastTestTcp test = new UnicastTestTcp();
            test.init(local_addr, remote_addr, local_port, remote_port);
            test.eventLoop();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("UnicastTest [-help] [-local_addr add] [-remote_addr addr] [-local_port port] [-remote_port port]");
    }

    public void receive(Message msg) {
        byte[] buf = msg.getArray();
        byte type = buf[msg.getOffset()];
        switch (type) {
            case 1: {
                ByteBuffer tmp = ByteBuffer.wrap(buf, 1 + msg.getOffset(), 8);
                this.num_msgs = (int)tmp.getLong();
                this.print = this.num_msgs / 10;
                this.current_value.set(0L);
                this.total_bytes.set(0L);
                this.start = System.currentTimeMillis();
                break;
            }
            case 2: {
                long new_val = this.current_value.incrementAndGet();
                this.total_bytes.addAndGet(msg.getLength() - 4);
                if (this.print > 0L && new_val % this.print == 0L) {
                    System.out.println("received " + new_val);
                }
                if (new_val < (long)this.num_msgs) break;
                long time = System.currentTimeMillis() - this.start;
                double msgs_sec = (double)this.current_value.get() / ((double)time / 1000.0);
                double throughput = (double)this.total_bytes.get() / ((double)time / 1000.0);
                System.out.println(String.format("\nreceived %d messages in %d ms (%.2f msgs/sec), throughput=%s", this.current_value.get(), time, msgs_sec, Util.printBytes(throughput)));
                break;
            }
            default: {
                System.err.println("Type " + type + " is invalid");
            }
        }
    }

    protected static final void writeMessage(Message msg, DataOutputStream out) throws Exception {
        int flags = 0;
        if (msg.getDest() == null) {
            flags = (byte)(flags + 2);
        }
        out.writeShort(Version.version);
        out.writeByte(flags);
        msg.writeTo(out);
    }

    protected static final Message readMessage(DataInput in) throws Exception {
        short ver = in.readShort();
        byte flags = in.readByte();
        BytesMessage msg = new BytesMessage();
        msg.readFrom(in);
        return msg;
    }

    private class Sender
    extends Thread {
        protected final int number_of_msgs;
        protected final int do_print;
        protected final byte[] buf;

        public Sender(int num_msgs, int msg_size, int print) {
            this.number_of_msgs = num_msgs;
            this.do_print = print;
            this.buf = ByteBuffer.allocate(4 + msg_size).put((byte)2).array();
        }

        @Override
        public void run() {
            for (int i = 1; i <= this.number_of_msgs; ++i) {
                try {
                    BytesMessage msg = new BytesMessage((Address)UnicastTestTcp.this.destination, this.buf);
                    if (UnicastTestTcp.this.oob) {
                        msg.setFlag(Message.Flag.OOB);
                    }
                    if (UnicastTestTcp.this.dont_bundle) {
                        msg.setFlag(Message.Flag.DONT_BUNDLE);
                    }
                    if (i > 0 && this.do_print > 0 && i % this.do_print == 0) {
                        System.out.println("-- sent " + i);
                    }
                    UnicastTestTcp.this.output_lock.lock();
                    try {
                        UnicastTestTcp.writeMessage(msg, UnicastTestTcp.this.output);
                        continue;
                    }
                    finally {
                        UnicastTestTcp.this.output_lock.unlock();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected class Acceptor
    extends Thread {
        protected Acceptor() {
        }

        @Override
        public void run() {
            while (!UnicastTestTcp.this.srv_sock.isClosed()) {
                Socket client_sock = null;
                DataInputStream in = null;
                try {
                    client_sock = UnicastTestTcp.this.srv_sock.accept();
                    client_sock.setTcpNoDelay(false);
                    client_sock.setReceiveBufferSize(200000);
                    client_sock.setSendBufferSize(200000);
                    in = new DataInputStream(new BufferedInputStream(client_sock.getInputStream()));
                    while (!client_sock.isClosed()) {
                        this.handleRequest(in);
                    }
                }
                catch (Exception e) {
                    Util.close(client_sock);
                    Util.close(in);
                }
            }
        }

        protected void handleRequest(DataInputStream in) throws Exception {
            Message msg = UnicastTestTcp.readMessage(in);
            UnicastTestTcp.this.receive(msg);
        }
    }
}

