/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;

public class PortMapper {
    private final ConcurrentHashMap<String, InetSocketAddress> _dir = new ConcurrentHashMap(8);
    private final Set<String> _eepsites = new ConcurrentHashSet<String>(4);
    public static final String PROP_PREFER_HTTPS = "routerconsole.preferHTTPS";
    public static final String SVC_CONSOLE = "console";
    public static final String SVC_HTTPS_CONSOLE = "https_console";
    public static final String SVC_HTTP_PROXY = "HTTP";
    public static final String SVC_HTTPS_PROXY = "HTTPS";
    public static final String SVC_EEPSITE = "eepsite";
    public static final String SVC_HTTPS_EEPSITE = "https_eepsite";
    public static final String SVC_IRC = "irc";
    public static final String SVC_SOCKS = "socks";
    public static final String SVC_TAHOE = "tahoe-lafs";
    public static final String SVC_SMTP = "SMTP";
    public static final String SVC_POP = "POP3";
    public static final String SVC_SAM = "SAM";
    public static final String SVC_SAM_UDP = "SAM-UDP";
    public static final String SVC_SAM_SSL = "SAM-SSL";
    public static final String SVC_BOB = "BOB";
    public static final String SVC_I2CP = "I2CP";
    public static final String SVC_I2CP_SSL = "I2CP-SSL";
    public static final String SVC_HTTP_I2PCONTROL = "http_i2pcontrol";
    public static final String SVC_HTTPS_I2PCONTROL = "https_i2pcontrol";
    public static final String SVC_I2PSNARK = "i2psnark";
    public static final String SVC_I2PTUNNEL = "i2ptunnel";
    public static final String SVC_IMAGEGEN = "imagegen";
    public static final String SVC_SUSIDNS = "susidns";
    public static final String SVC_SUSIMAIL = "susimail";
    public static final String SVC_JSONRPC = "jsonrpc";
    public static final String SVC_LOGS = "logs";
    public static final int DEFAULT_CONSOLE_PORT = 7657;
    public static final int DEFAULT_HTTPS_CONSOLE_PORT = 7667;
    public static final String DEFAULT_HOST = "127.0.0.1";

    public PortMapper(I2PAppContext context) {
    }

    public boolean register(String service, int port) {
        return this.register(service, DEFAULT_HOST, port);
    }

    public boolean register(String service, String host, int port) {
        boolean rv;
        if (port <= 0 || port > 65535) {
            return false;
        }
        boolean bl = rv = this._dir.putIfAbsent(service, InetSocketAddress.createUnresolved(host, port)) == null;
        if (service.equals(SVC_EEPSITE) || service.equals(SVC_HTTPS_EEPSITE)) {
            rv = this._eepsites.add(PortMapper.toURL(service, host, port));
        }
        return rv;
    }

    public boolean isRegistered(String service) {
        return this._dir.containsKey(service);
    }

    public void unregister(String service) {
        this._dir.remove(service);
    }

    public void unregister(String service, int port) {
        if (service.equals(SVC_EEPSITE) || service.equals(SVC_HTTPS_EEPSITE)) {
            String end = ":" + port + '/';
            Iterator<String> iter = this._eepsites.iterator();
            while (iter.hasNext()) {
                if (!iter.next().endsWith(end)) continue;
                iter.remove();
            }
        }
        if (this.getPort(service) == port) {
            this._dir.remove(service);
        }
    }

    public int getPort(String service) {
        int port = this.getPort(service, -1);
        return port;
    }

    public int getPort(String service, int def) {
        InetSocketAddress ia = this._dir.get(service);
        if (ia == null) {
            return def;
        }
        return ia.getPort();
    }

    public String getHost(String service, String def) {
        InetSocketAddress ia = this._dir.get(service);
        if (ia == null) {
            return def;
        }
        return ia.getHostName();
    }

    public String getActualHost(String service, String def) {
        InetSocketAddress ia = this._dir.get(service);
        if (ia == null) {
            return def;
        }
        return PortMapper.convertWildcard(ia.getHostName(), def);
    }

    private static String convertWildcard(String ip, String def) {
        String rv;
        block4: {
            block5: {
                rv = ip;
                if (!rv.equals("0.0.0.0")) break block5;
                rv = Addresses.getAnyAddress();
                if (rv != null) break block4;
                rv = def;
                SortedSet<String> addrs = Addresses.getAddresses(true, false);
                for (String addr : addrs) {
                    if (addr.startsWith("127.") || addr.equals("0.0.0.0")) continue;
                    rv = addr;
                    break block4;
                }
                break block4;
            }
            if (rv.equals("::") || rv.equals("0:0:0:0:0:0:0:0")) {
                rv = def;
                SortedSet<String> addrs = Addresses.getAddresses(false, true);
                for (String addr : addrs) {
                    if (addr.contains(".")) continue;
                    return rv;
                }
                addrs = Addresses.getAddresses(true, true);
                for (String addr : addrs) {
                    if (addr.contains(".") || addr.equals("::") || addr.equals("0:0:0:0:0:0:0:0")) continue;
                    rv = addr;
                    break;
                }
            }
        }
        return rv;
    }

    public String getConsoleURL() {
        return this.getConsoleURL(I2PAppContext.getGlobalContext().getBooleanPropertyDefaultTrue(PROP_PREFER_HTTPS));
    }

    public String getConsoleURL(boolean preferHTTPS) {
        return preferHTTPS ? this.getHTTPSConsoleURL() : this.getHTTPConsoleURL();
    }

    private String getHTTPConsoleURL() {
        boolean httpsOnly;
        String unset = "*unset*";
        String httpHost = this.getActualHost(SVC_CONSOLE, unset);
        String httpsHost = this.getActualHost(SVC_HTTPS_CONSOLE, unset);
        int httpPort = this.getPort(SVC_CONSOLE, 7657);
        int httpsPort = this.getPort(SVC_HTTPS_CONSOLE);
        boolean bl = httpsOnly = httpsPort > 0 && httpHost.equals(unset) && !httpsHost.equals(unset);
        if (httpsOnly) {
            if (httpsHost.contains(":")) {
                return "https://[" + httpsHost + "]:" + httpsPort + '/';
            }
            return "https://" + httpsHost + ':' + httpsPort + '/';
        }
        if (httpHost.equals(unset)) {
            httpHost = DEFAULT_HOST;
        }
        if (httpHost.contains(":")) {
            return "http://[" + httpHost + "]:" + httpPort + '/';
        }
        return "http://" + httpHost + ':' + httpPort + '/';
    }

    private String getHTTPSConsoleURL() {
        boolean httpOnly;
        String unset = "*unset*";
        String httpHost = this.getActualHost(SVC_CONSOLE, unset);
        String httpsHost = this.getActualHost(SVC_HTTPS_CONSOLE, unset);
        int httpPort = this.getPort(SVC_CONSOLE);
        int httpsPort = this.getPort(SVC_HTTPS_CONSOLE, 7667);
        boolean bl = httpOnly = httpPort > 0 && httpsHost.equals(unset) && !httpHost.equals(unset);
        if (httpOnly) {
            if (httpHost.contains(":")) {
                return "http://[" + httpHost + "]:" + httpPort + '/';
            }
            return "http://" + httpHost + ':' + httpPort + '/';
        }
        if (httpsHost.equals(unset)) {
            return "http://127.0.0.1:7657/";
        }
        if (httpsHost.contains(":")) {
            return "https://[" + httpsHost + "]:" + httpsPort + '/';
        }
        return "https://" + httpsHost + ':' + httpsPort + '/';
    }

    public List<String> getEepsiteURLs() {
        if (this._eepsites.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this._eepsites);
    }

    private static String toURL(String svc, String host, int port) {
        StringBuilder buf = new StringBuilder(64);
        buf.append(svc.equals(SVC_HTTPS_EEPSITE) ? "https://" : "http://");
        host = PortMapper.convertWildcard(host, DEFAULT_HOST);
        if (host.contains(":")) {
            buf.append('[');
        }
        buf.append(host);
        if (host.contains(":")) {
            buf.append(']');
        }
        buf.append(':').append(port).append('/');
        return buf.toString();
    }

    public void renderStatusHTML(Writer out) throws IOException {
        ArrayList services = new ArrayList(this._dir.keySet());
        out.write("<h2 id=\"debug_portmapper\">Port Mapper</h2><table id=\"portmapper\"><tr><th>Service<th>Host<th>Port\n");
        Collections.sort(services, Collator.getInstance());
        for (String s : services) {
            InetSocketAddress ia = this._dir.get(s);
            if (ia == null) continue;
            out.write("<tr><td>" + s + "<td>" + PortMapper.convertWildcard(ia.getHostName(), DEFAULT_HOST) + "<td>" + ia.getPort() + '\n');
        }
        if (!this._eepsites.isEmpty()) {
            out.write("<tr><td colspan=\"3\">&nbsp;</tr><tr><th>Eepsite<th>URL<th>\n");
            for (String url : this._eepsites) {
                String s = url.startsWith("https://") ? SVC_HTTPS_EEPSITE : SVC_EEPSITE;
                out.write("<tr><td>" + s + "<td><a href=\"" + url + "\">" + url + "</a><td>\n");
            }
        }
        out.write("</table>\n");
    }
}

