/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.util.ArrayList;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.java.impl.JavaObjectView;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.NodeObjectsView;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

public class JavaOpenNodeAction
extends HeapViewerNodeAction.Provider {
    @Override
    public boolean supportsView(HeapContext context, String viewID) {
        return (viewID.startsWith("java_") || viewID.startsWith("diff_java_")) && JavaHeapFragment.getJavaContext(context) != null;
    }

    @Override
    public HeapViewerNodeAction[] getActions(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
        ClassNode classNode;
        HeapContext javaContext = JavaHeapFragment.getJavaContext(context);
        ArrayList<NodeObjectsView.OpenAction> actionsList = new ArrayList<NodeObjectsView.OpenAction>(2);
        HeapViewerNode nodeCopy = node.createCopy();
        actionsList.add(new OpenNodeAction(nodeCopy, javaContext, actions));
        Instance instance = HeapViewerNode.getValue(node, DataType.INSTANCE, javaContext.getFragment().getHeap());
        ClassNode classNode2 = classNode = instance == null ? null : new ClassNode(instance.getJavaClass());
        if (classNode != null) {
            actionsList.add(new OpenClassAction(classNode, javaContext, actions));
        }
        return actionsList.toArray(new HeapViewerNodeAction[0]);
    }

    private static NodeObjectsView createView(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
        return new JavaObjectView(node, context, actions);
    }

    private static class OpenClassAction
    extends NodeObjectsView.OpenAction {
        private OpenClassAction(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
            super(Bundle.JavaOpenNodeAction_OpenClassTab(), 1, node, context, actions);
        }

        @Override
        public NodeObjectsView createView(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
            return JavaOpenNodeAction.createView(node, context, actions);
        }
    }

    private static class OpenNodeAction
    extends NodeObjectsView.DefaultOpenAction {
        private OpenNodeAction(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
            super(node, context, actions);
        }

        @Override
        public NodeObjectsView createView(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
            return JavaOpenNodeAction.createView(node, context, actions);
        }
    }
}

