/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing.converter;

import java.util.StringTokenizer;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import org.jfree.layouting.input.style.keys.font.FontEffects;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.font.FontVariant;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.line.VerticalAlign;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextTransform;
import org.jfree.layouting.input.style.keys.text.UnicodeBidi;
import org.jfree.layouting.input.swing.Converter;
import org.jfree.layouting.input.swing.ConverterAttributeSet;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class CharacterConverter
implements Converter {
    public static final String TEXT_DECORATION_KEY = "text-decoration";
    public static final String NONE_TEXT_DECORATION = "none";
    public static final String UNDERLINE_TEXT_DECORATION = "underline";
    public static final String LINETHROUGH_TEXT_DECORATION = "line-through";
    public static final String RTF_CAPS = "caps";
    public static final String RTF_SMALLCAPS = "scaps";
    public static final String RTF_OUTLINE = "outl";
    public static final String RTF_SHADOW = "shad";
    public static final String RTF_Hidden = "v";
    public static final String RTF_STRIKETRHOUGH = "strike";
    public static final String RTF_DELETED = "deleted";

    private Object mergeTextDecorationValues(Object object, Object object2) {
        if (object2 == null) {
            return object;
        }
        String string = (String)object;
        string = string + ' ' + object2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (NONE_TEXT_DECORATION.equals(string2)) {
                bl = true;
                continue;
            }
            if (UNDERLINE_TEXT_DECORATION.equals(string2)) {
                bl3 = true;
                continue;
            }
            if (!LINETHROUGH_TEXT_DECORATION.equals(string2)) continue;
            bl2 = true;
        }
        if (bl3 && bl2) {
            return "underline line-through";
        }
        if (bl3) {
            return UNDERLINE_TEXT_DECORATION;
        }
        if (bl2) {
            return LINETHROUGH_TEXT_DECORATION;
        }
        return NONE_TEXT_DECORATION;
    }

    @Override
    public ConverterAttributeSet convertToCSS(Object object, Object object2, ConverterAttributeSet converterAttributeSet, Element element) {
        if (object instanceof StyleConstants.CharacterConstants) {
            StyleConstants.CharacterConstants characterConstants = (StyleConstants.CharacterConstants)object;
            return this.handleCharacterConstants(characterConstants, object2, converterAttributeSet);
        }
        if (object instanceof String) {
            String string = (String)object;
            ConverterAttributeSet converterAttributeSet2 = new ConverterAttributeSet();
            if (string.equals(RTF_SMALLCAPS)) {
                Boolean bl = (Boolean)object2;
                if (Boolean.TRUE.equals(bl)) {
                    converterAttributeSet2.addAttribute(FontStyleKeys.FONT_VARIANT.getName(), FontVariant.SMALL_CAPS);
                }
            } else if (string.equals(RTF_CAPS)) {
                Boolean bl = (Boolean)object2;
                if (Boolean.TRUE.equals(bl)) {
                    converterAttributeSet2.addAttribute(TextStyleKeys.TEXT_TRANSFORM.getName(), TextTransform.CAPITALIZE);
                }
            } else if (string.equals(RTF_OUTLINE)) {
                Boolean bl = (Boolean)object2;
                if (Boolean.TRUE.equals(bl)) {
                    converterAttributeSet2.addAttribute(FontStyleKeys.FONT_EFFECT, FontEffects.OUTLINE);
                }
            } else if (string.equals(RTF_STRIKETRHOUGH)) {
                Object object3 = converterAttributeSet.getAttribute(TEXT_DECORATION_KEY);
                converterAttributeSet2.addAttribute(TEXT_DECORATION_KEY, this.mergeTextDecorationValues(object3, LINETHROUGH_TEXT_DECORATION));
            } else {
                DebugLog.log((Object)("Unkown type of character attribute" + string));
                return null;
            }
            return converterAttributeSet2;
        }
        return null;
    }

    private ConverterAttributeSet handleCharacterConstants(StyleConstants.CharacterConstants characterConstants, Object object, ConverterAttributeSet converterAttributeSet) {
        ConverterAttributeSet converterAttributeSet2 = new ConverterAttributeSet();
        if (characterConstants == StyleConstants.Underline) {
            Boolean bl = (Boolean)object;
            if (Boolean.TRUE.equals(bl)) {
                Object object2 = converterAttributeSet.getAttribute(TEXT_DECORATION_KEY);
                converterAttributeSet2.addAttribute(TEXT_DECORATION_KEY, this.mergeTextDecorationValues(object2, UNDERLINE_TEXT_DECORATION));
            } else {
                converterAttributeSet2.addAttribute(TEXT_DECORATION_KEY, NONE_TEXT_DECORATION);
            }
        } else if (characterConstants == StyleConstants.StrikeThrough) {
            Boolean bl = (Boolean)object;
            if (Boolean.TRUE.equals(bl)) {
                Object object3 = converterAttributeSet.getAttribute(TEXT_DECORATION_KEY);
                converterAttributeSet2.addAttribute(TEXT_DECORATION_KEY, this.mergeTextDecorationValues(object3, LINETHROUGH_TEXT_DECORATION));
            } else {
                converterAttributeSet2.addAttribute(TEXT_DECORATION_KEY, NONE_TEXT_DECORATION);
            }
        } else if (characterConstants == StyleConstants.Superscript) {
            Boolean bl = (Boolean)object;
            if (Boolean.TRUE.equals(bl)) {
                converterAttributeSet2.addAttribute(LineStyleKeys.VERTICAL_ALIGN.getName(), VerticalAlign.SUPER);
            }
        } else if (characterConstants == StyleConstants.Subscript) {
            Boolean bl = (Boolean)object;
            if (Boolean.TRUE.equals(bl)) {
                converterAttributeSet2.addAttribute(LineStyleKeys.VERTICAL_ALIGN.getName(), VerticalAlign.SUB);
            }
        } else if (characterConstants == StyleConstants.BidiLevel) {
            Boolean bl = (Boolean)object;
            if (Boolean.TRUE.equals(bl)) {
                converterAttributeSet2.addAttribute(TextStyleKeys.UNICODE_BIDI.getName(), UnicodeBidi.EMBED);
            } else {
                converterAttributeSet2.addAttribute(TextStyleKeys.UNICODE_BIDI.getName(), UnicodeBidi.NORMAL);
            }
        } else {
            DebugLog.log((Object)("Unkown type of character attribute" + characterConstants));
            return null;
        }
        return converterAttributeSet;
    }
}

