/* SPDX-FileCopyrightText: 2013 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <glib-object.h>
#include <gmodule.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_SEARCH_SETTINGS             (gtk_source_search_settings_get_type ())
#define GTK_SOURCE_SEARCH_SETTINGS(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_SEARCH_SETTINGS, GtkSourceSearchSettings))
#define GTK_SOURCE_SEARCH_SETTINGS_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_SOURCE_TYPE_SEARCH_SETTINGS, GtkSourceSearchSettingsClass))
#define GTK_SOURCE_IS_SEARCH_SETTINGS(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_SOURCE_TYPE_SEARCH_SETTINGS))
#define GTK_SOURCE_IS_SEARCH_SETTINGS_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_SEARCH_SETTINGS))
#define GTK_SOURCE_SEARCH_SETTINGS_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_SOURCE_TYPE_SEARCH_SETTINGS, GtkSourceSearchSettingsClass))

typedef struct _GtkSourceSearchSettings         GtkSourceSearchSettings;
typedef struct _GtkSourceSearchSettingsClass    GtkSourceSearchSettingsClass;
typedef struct _GtkSourceSearchSettingsPrivate  GtkSourceSearchSettingsPrivate;

struct _GtkSourceSearchSettings
{
	GObject parent;

	GtkSourceSearchSettingsPrivate *priv;
};

struct _GtkSourceSearchSettingsClass
{
	GObjectClass parent_class;

	gpointer padding[1];
};

G_MODULE_EXPORT
GType			 gtk_source_search_settings_get_type			(void) G_GNUC_CONST;

G_MODULE_EXPORT
GtkSourceSearchSettings *gtk_source_search_settings_new				(void);

G_MODULE_EXPORT
void			 gtk_source_search_settings_set_search_text		(GtkSourceSearchSettings *settings,
										 const gchar		 *search_text);

G_MODULE_EXPORT
const gchar		*gtk_source_search_settings_get_search_text		(GtkSourceSearchSettings *settings);

G_MODULE_EXPORT
void			 gtk_source_search_settings_set_case_sensitive		(GtkSourceSearchSettings *settings,
										 gboolean		  case_sensitive);

G_MODULE_EXPORT
gboolean		 gtk_source_search_settings_get_case_sensitive		(GtkSourceSearchSettings *settings);

G_MODULE_EXPORT
void			 gtk_source_search_settings_set_at_word_boundaries	(GtkSourceSearchSettings *settings,
										 gboolean		  at_word_boundaries);

G_MODULE_EXPORT
gboolean		 gtk_source_search_settings_get_at_word_boundaries	(GtkSourceSearchSettings *settings);

G_MODULE_EXPORT
void			 gtk_source_search_settings_set_wrap_around		(GtkSourceSearchSettings *settings,
										 gboolean		  wrap_around);

G_MODULE_EXPORT
gboolean		 gtk_source_search_settings_get_wrap_around		(GtkSourceSearchSettings *settings);

G_MODULE_EXPORT
void			 gtk_source_search_settings_set_regex_enabled		(GtkSourceSearchSettings *settings,
										 gboolean		  regex_enabled);

G_MODULE_EXPORT
gboolean		 gtk_source_search_settings_get_regex_enabled		(GtkSourceSearchSettings *settings);

G_END_DECLS
