/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.I18n;

public class JpgImporter
extends FileImporter {
    private GpxLayer gpx;
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("jpg,jpeg", "jpg", I18n.tr("Image Files", new Object[0]) + " (*.jpg)");
    public static final ExtensionFileFilter FILE_FILTER_WITH_FOLDERS = new ExtensionFileFilter("jpg,jpeg", "jpg", I18n.tr("Image Files", new Object[0]) + " (*.jpg, " + I18n.tr("folder", new Object[0]) + ')');

    public JpgImporter() {
        this(false);
    }

    public JpgImporter(boolean includeFolders) {
        super(includeFolders ? FILE_FILTER_WITH_FOLDERS : FILE_FILTER);
    }

    public JpgImporter(GpxLayer gpx) {
        this(true);
        this.gpx = gpx;
    }

    @Override
    public boolean acceptFile(File pathname) {
        return super.acceptFile(pathname) || pathname.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importData(List<File> sel, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        progressMonitor.beginTask(I18n.tr("Looking for image files", new Object[0]), 1);
        try {
            ArrayList<File> files = new ArrayList<File>();
            HashSet<String> visitedDirs = new HashSet<String>();
            JpgImporter.addRecursiveFiles(files, visitedDirs, sel, progressMonitor.createSubTaskMonitor(1, true));
            if (progressMonitor.isCanceled()) {
                return;
            }
            if (files.isEmpty()) {
                throw new IOException(I18n.tr("No image files found.", new Object[0]));
            }
            GeoImageLayer.create(files, this.gpx);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addRecursiveFiles(List<File> files, Set<String> visitedDirs, List<File> sel, ProgressMonitor progressMonitor) throws IOException {
        if (progressMonitor.isCanceled()) {
            return;
        }
        progressMonitor.beginTask(null, sel.size());
        try {
            for (File f : sel) {
                if (f.isDirectory()) {
                    if (visitedDirs.add(f.getCanonicalPath())) {
                        File[] dirFiles = f.listFiles();
                        if (dirFiles == null) continue;
                        JpgImporter.addRecursiveFiles(files, visitedDirs, Arrays.asList(dirFiles), progressMonitor.createSubTaskMonitor(1, true));
                        continue;
                    }
                    progressMonitor.worked(1);
                    continue;
                }
                if (FILE_FILTER.accept(f)) {
                    files.add(f);
                }
                progressMonitor.worked(1);
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    @Override
    public boolean isBatchImporter() {
        return true;
    }

    @Override
    public double getPriority() {
        return -1000.0;
    }
}

