/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import javax.swing.JList;
import org.openide.explorer.view.ExplorerDragSupport;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;

class ListViewDragSupport
extends ExplorerDragSupport {
    protected ListView view;
    protected JList list;

    public ListViewDragSupport(ListView listView, JList jList) {
        this.comp = jList;
        this.view = listView;
        this.list = jList;
    }

    @Override
    int getAllowedDropActions() {
        return this.view.getAllowedDropActions();
    }

    @Override
    protected int getAllowedDragActions() {
        return this.view.getAllowedDragActions();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        super.dragGestureRecognized(dragGestureEvent);
    }

    @Override
    Node[] obtainNodes(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        int n = this.list.locationToIndex(point);
        if (n < 0) {
            return null;
        }
        Object object = this.list.getModel().getElementAt(n);
        if (object instanceof VisualizerNode) {
            object = ((VisualizerNode)object).node;
        }
        if (n < 0) {
            return null;
        }
        if (!(object instanceof Node)) {
            return null;
        }
        Node[] nodeArray = null;
        if (this.list.isSelectedIndex(n)) {
            Object[] objectArray = this.list.getSelectedValues();
            nodeArray = new Node[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof VisualizerNode) {
                    nodeArray[i] = ((VisualizerNode)objectArray[i]).node;
                    continue;
                }
                if (!(objectArray[i] instanceof Node)) {
                    return null;
                }
                nodeArray[i] = (Node)objectArray[i];
            }
        } else {
            nodeArray = new Node[]{(Node)object};
        }
        return nodeArray;
    }
}

