/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.crypto.PseudoRandomFunction;
import de.rub.nds.tlsattacker.core.crypto.SSLUtils;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FinishedPreparator
extends HandshakeMessagePreparator<FinishedMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private byte[] verifyData;
    private final FinishedMessage msg;

    public FinishedPreparator(Chooser chooser, FinishedMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing FinishedMessage");
        try {
            this.verifyData = this.computeVerifyData();
        }
        catch (CryptoException ex) {
            LOGGER.warn("Could not compute VerifyData! Using empty verifyData.", (Throwable)ex);
            this.verifyData = new byte[0];
        }
        this.prepareVerifyData(this.msg);
    }

    private byte[] computeVerifyData() throws CryptoException {
        if (this.chooser.getSelectedProtocolVersion().isTLS13()) {
            try {
                HKDFAlgorithm hkdfAlgortihm = AlgorithmResolver.getHKDFAlgorithm(this.chooser.getSelectedCipherSuite());
                Mac mac = Mac.getInstance(hkdfAlgortihm.getMacAlgorithm().getJavaName());
                LOGGER.debug("Connection End: " + this.chooser.getConnectionEndType());
                byte[] finishedKey = this.chooser.getConnectionEndType() == ConnectionEndType.SERVER ? HKDFunction.expandLabel(hkdfAlgortihm, this.chooser.getServerHandshakeTrafficSecret(), "finished", new byte[0], mac.getMacLength()) : HKDFunction.expandLabel(hkdfAlgortihm, this.chooser.getClientHandshakeTrafficSecret(), "finished", new byte[0], mac.getMacLength());
                LOGGER.debug("Finished key: " + ArrayConverter.bytesToHexString((byte[])finishedKey));
                SecretKeySpec keySpec = new SecretKeySpec(finishedKey, mac.getAlgorithm());
                mac.init(keySpec);
                mac.update(this.chooser.getContext().getDigest().digest(this.chooser.getSelectedProtocolVersion(), this.chooser.getSelectedCipherSuite()));
                return mac.doFinal();
            }
            catch (InvalidKeyException | NoSuchAlgorithmException ex) {
                throw new CryptoException(ex);
            }
        }
        if (this.chooser.getSelectedProtocolVersion().isSSL()) {
            LOGGER.trace("Calculating VerifyData:");
            byte[] handshakeMessageContent = this.chooser.getContext().getDigest().getRawBytes();
            byte[] masterSecret = this.chooser.getMasterSecret();
            LOGGER.debug("Using MasterSecret:" + ArrayConverter.bytesToHexString((byte[])masterSecret));
            ConnectionEndType endType = this.chooser.getConnectionEndType();
            return SSLUtils.calculateFinishedData(handshakeMessageContent, masterSecret, endType);
        }
        LOGGER.trace("Calculating VerifyData:");
        PRFAlgorithm prfAlgorithm = this.chooser.getPRFAlgorithm();
        LOGGER.trace("Using PRF:" + prfAlgorithm.name());
        byte[] masterSecret = this.chooser.getMasterSecret();
        LOGGER.debug("Using MasterSecret:" + ArrayConverter.bytesToHexString((byte[])masterSecret));
        byte[] handshakeMessageHash = this.chooser.getContext().getDigest().digest(this.chooser.getSelectedProtocolVersion(), this.chooser.getSelectedCipherSuite());
        LOGGER.debug("Using HandshakeMessage Hash:" + ArrayConverter.bytesToHexString((byte[])handshakeMessageHash));
        String label = this.chooser.getConnectionEndType() == ConnectionEndType.SERVER ? "server finished" : "client finished";
        byte[] res = PseudoRandomFunction.compute(prfAlgorithm, masterSecret, label, handshakeMessageHash, 12);
        return res;
    }

    private void prepareVerifyData(FinishedMessage msg) {
        msg.setVerifyData(this.verifyData);
        LOGGER.debug("VerifyData: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getVerifyData().getValue())));
    }
}

