#!/usr/bin/env python
#
###############################################################################
#   Copyright (C) 2016-2018  Cortney T. Buffington, N0MJS <n0mjs@me.com>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software Foundation,
#   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
###############################################################################

# Does anybody read this stuff? There's a PEP somewhere that says I should do this.
__author__     = 'Cortney T. Buffington, N0MJS'
__copyright__  = 'Copyright (c) 2016-2018 Cortney T. Buffington, N0MJS and the K0USY Group'
__license__    = 'GNU GPLv3'
__maintainer__ = 'Cort Buffington, N0MJS'
__email__      = 'n0mjs@me.com'

ENCODE_2087 = (
	0x0000, 0xB08E, 0xE093, 0x501D, 0x70A9, 0xC027, 0x903A, 0x20B4, 0x60DC, 0xD052, 0x804F, 0x30C1, 0x1075, 0xA0FB,
    0xF0E6, 0x4068, 0x7036, 0xC0B8, 0x90A5, 0x202B, 0x009F, 0xB011, 0xE00C, 0x5082, 0x10EA, 0xA064, 0xF079, 0x40F7,
    0x6043, 0xD0CD, 0x80D0, 0x305E, 0xD06C, 0x60E2, 0x30FF, 0x8071, 0xA0C5, 0x104B, 0x4056, 0xF0D8, 0xB0B0, 0x003E,
    0x5023, 0xE0AD, 0xC019, 0x7097, 0x208A, 0x9004, 0xA05A, 0x10D4, 0x40C9, 0xF047, 0xD0F3, 0x607D, 0x3060, 0x80EE,
    0xC086, 0x7008, 0x2015, 0x909B, 0xB02F, 0x00A1, 0x50BC, 0xE032, 0x90D9, 0x2057, 0x704A, 0xC0C4, 0xE070, 0x50FE,
    0x00E3, 0xB06D, 0xF005, 0x408B, 0x1096, 0xA018, 0x80AC, 0x3022, 0x603F, 0xD0B1, 0xE0EF, 0x5061, 0x007C, 0xB0F2,
	0x9046, 0x20C8, 0x70D5, 0xC05B, 0x8033, 0x30BD, 0x60A0, 0xD02E, 0xF09A, 0x4014, 0x1009, 0xA087, 0x40B5, 0xF03B,
    0xA026, 0x10A8, 0x301C, 0x8092, 0xD08F, 0x6001, 0x2069, 0x90E7, 0xC0FA, 0x7074, 0x50C0, 0xE04E, 0xB053, 0x00DD,
    0x3083, 0x800D, 0xD010, 0x609E, 0x402A, 0xF0A4, 0xA0B9, 0x1037, 0x505F, 0xE0D1, 0xB0CC, 0x0042, 0x20F6, 0x9078,
    0xC065, 0x70EB, 0xA03D, 0x10B3, 0x40AE, 0xF020, 0xD094, 0x601A, 0x3007, 0x8089, 0xC0E1, 0x706F, 0x2072, 0x90FC,
    0xB048, 0x00C6, 0x50DB, 0xE055, 0xD00B, 0x6085, 0x3098, 0x8016, 0xA0A2, 0x102C, 0x4031, 0xF0BF, 0xB0D7, 0x0059,
    0x5044, 0xE0CA, 0xC07E, 0x70F0, 0x20ED, 0x9063, 0x7051, 0xC0DF, 0x90C2, 0x204C, 0x00F8, 0xB076, 0xE06B, 0x50E5,
	0x108D, 0xA003, 0xF01E, 0x4090, 0x6024, 0xD0AA, 0x80B7, 0x3039, 0x0067, 0xB0E9, 0xE0F4, 0x507A, 0x70CE, 0xC040,
    0x905D, 0x20D3, 0x60BB, 0xD035, 0x8028, 0x30A6, 0x1012, 0xA09C, 0xF081, 0x400F, 0x30E4, 0x806A, 0xD077, 0x60F9,
    0x404D, 0xF0C3, 0xA0DE, 0x1050, 0x5038, 0xE0B6, 0xB0AB, 0x0025, 0x2091, 0x901F, 0xC002, 0x708C, 0x40D2, 0xF05C,
    0xA041, 0x10CF, 0x307B, 0x80F5, 0xD0E8, 0x6066, 0x200E, 0x9080, 0xC09D, 0x7013, 0x50A7, 0xE029, 0xB034, 0x00BA,
    0xE088, 0x5006, 0x001B, 0xB095, 0x9021, 0x20AF, 0x70B2, 0xC03C, 0x8054, 0x30DA, 0x60C7, 0xD049, 0xF0FD, 0x4073,
    0x106E, 0xA0E0, 0x90BE, 0x2030, 0x702D, 0xC0A3, 0xE017, 0x5099, 0x0084, 0xB00A, 0xF062, 0x40EC, 0x10F1, 0xA07F,
	0x80CB, 0x3045, 0x6058, 0xD0D6)

DECODE_1987 = (
	0x00000, 0x00001, 0x00002, 0x00003, 0x00004, 0x00005, 0x00006, 0x00007, 0x00008, 0x00009, 0x0000A, 0x0000B, 0x0000C, 
	0x0000D, 0x0000E, 0x24020, 0x00010, 0x00011, 0x00012, 0x00013, 0x00014, 0x00015, 0x00016, 0x00017, 0x00018, 0x00019, 
	0x0001A, 0x0001B, 0x0001C, 0x0001D, 0x48040, 0x01480, 0x00020, 0x00021, 0x00022, 0x00023, 0x00024, 0x00025, 0x00026, 
	0x24008, 0x00028, 0x00029, 0x0002A, 0x24004, 0x0002C, 0x24002, 0x24001, 0x24000, 0x00030, 0x00031, 0x00032, 0x08180, 
	0x00034, 0x00C40, 0x00036, 0x00C42, 0x00038, 0x43000, 0x0003A, 0x43002, 0x02902, 0x24012, 0x02900, 0x24010, 0x00040, 
	0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048, 0x00049, 0x0004A, 0x02500, 0x0004C, 0x0004D, 
	0x48010, 0x48011, 0x00050, 0x00051, 0x00052, 0x21200, 0x00054, 0x00C20, 0x48008, 0x48009, 0x00058, 0x00059, 0x48004, 
	0x48005, 0x48002, 0x48003, 0x48000, 0x48001, 0x00060, 0x00061, 0x00062, 0x00063, 0x00064, 0x00C10, 0x10300, 0x0B000, 
	0x00068, 0x00069, 0x01880, 0x01881, 0x40181, 0x40180, 0x24041, 0x24040, 0x00070, 0x00C04, 0x00072, 0x00C06, 0x00C01, 
	0x00C00, 0x00C03, 0x00C02, 0x05204, 0x00C0C, 0x48024, 0x48025, 0x05200, 0x00C08, 0x48020, 0x48021, 0x00080, 0x00081, 
	0x00082, 0x00083, 0x00084, 0x00085, 0x00086, 0x00087, 0x00088, 0x00089, 0x0008A, 0x50200, 0x0008C, 0x0A800, 0x01411, 
	0x01410, 0x00090, 0x00091, 0x00092, 0x08120, 0x00094, 0x00095, 0x04A00, 0x01408, 0x00098, 0x00099, 0x01405, 0x01404, 
	0x01403, 0x01402, 0x01401, 0x01400, 0x000A0, 0x000A1, 0x000A2, 0x08110, 0x000A4, 0x000A5, 0x42400, 0x42401, 0x000A8, 
	0x000A9, 0x01840, 0x01841, 0x40141, 0x40140, 0x24081, 0x24080, 0x000B0, 0x08102, 0x08101, 0x08100, 0x000B4, 0x08106, 
	0x08105, 0x08104, 0x20A01, 0x20A00, 0x08109, 0x08108, 0x01423, 0x01422, 0x01421, 0x01420, 0x000C0, 0x000C1, 0x000C2, 
	0x000C3, 0x000C4, 0x000C5, 0x000C6, 0x000C7, 0x000C8, 0x000C9, 0x01820, 0x01821, 0x20600, 0x40120, 0x16000, 0x16001, 
	0x000D0, 0x000D1, 0x42801, 0x42800, 0x03100, 0x18200, 0x03102, 0x18202, 0x000D8, 0x000D9, 0x48084, 0x01444, 0x48082, 
	0x01442, 0x48080, 0x01440, 0x000E0, 0x32000, 0x01808, 0x04600, 0x40109, 0x40108, 0x0180C, 0x4010A, 0x01802, 0x40104, 
	0x01800, 0x01801, 0x40101, 0x40100, 0x01804, 0x40102, 0x0A408, 0x08142, 0x08141, 0x08140, 0x00C81, 0x00C80, 0x00C83, 
	0x00C82, 0x0A400, 0x0A401, 0x01810, 0x01811, 0x40111, 0x40110, 0x01814, 0x40112, 0x00100, 0x00101, 0x00102, 0x00103, 
	0x00104, 0x00105, 0x00106, 0x41800, 0x00108, 0x00109, 0x0010A, 0x02440, 0x0010C, 0x0010D, 0x0010E, 0x02444, 0x00110, 
	0x00111, 0x00112, 0x080A0, 0x00114, 0x00115, 0x00116, 0x080A4, 0x00118, 0x00119, 0x15000, 0x15001, 0x02822, 0x02823, 
	0x02820, 0x02821, 0x00120, 0x00121, 0x00122, 0x08090, 0x00124, 0x00125, 0x10240, 0x10241, 0x00128, 0x00129, 0x0012A, 
	0x24104, 0x09400, 0x400C0, 0x02810, 0x24100, 0x00130, 0x08082, 0x08081, 0x08080, 0x31001, 0x31000, 0x02808, 0x08084, 
	0x02806, 0x0808A, 0x02804, 0x08088, 0x02802, 0x02803, 0x02800, 0x02801, 0x00140, 0x00141, 0x00142, 0x02408, 0x00144, 
	0x00145, 0x10220, 0x10221, 0x00148, 0x02402, 0x02401, 0x02400, 0x400A1, 0x400A0, 0x02405, 0x02404, 0x00150, 0x00151, 
	0x00152, 0x02418, 0x03080, 0x03081, 0x03082, 0x03083, 0x09801, 0x09800, 0x02411, 0x02410, 0x48102, 0x09804, 0x48100, 
	0x48101, 0x00160, 0x00161, 0x10204, 0x10205, 0x10202, 0x40088, 0x10200, 0x10201, 0x40085, 0x40084, 0x02421, 0x02420, 
	0x40081, 0x40080, 0x10208, 0x40082, 0x41402, 0x080C2, 0x41400, 0x080C0, 0x00D01, 0x00D00, 0x10210, 0x10211, 0x40095, 
	0x40094, 0x02844, 0x080C8, 0x40091, 0x40090, 0x02840, 0x02841, 0x00180, 0x00181, 0x00182, 0x08030, 0x00184, 0x14400, 
	0x22201, 0x22200, 0x00188, 0x00189, 0x0018A, 0x08038, 0x40061, 0x40060, 0x40063, 0x40062, 0x00190, 0x08022, 0x08021, 
	0x08020, 0x03040, 0x03041, 0x08025, 0x08024, 0x40C00, 0x40C01, 0x08029, 0x08028, 0x2C000, 0x2C001, 0x01501, 0x01500, 
	0x001A0, 0x08012, 0x08011, 0x08010, 0x40049, 0x40048, 0x08015, 0x08014, 0x06200, 0x40044, 0x30400, 0x08018, 0x40041, 
	0x40040, 0x40043, 0x40042, 0x08003, 0x08002, 0x08001, 0x08000, 0x08007, 0x08006, 0x08005, 0x08004, 0x0800B, 0x0800A, 
	0x08009, 0x08008, 0x40051, 0x40050, 0x02880, 0x0800C, 0x001C0, 0x001C1, 0x64000, 0x64001, 0x03010, 0x40028, 0x08C00, 
	0x08C01, 0x40025, 0x40024, 0x02481, 0x02480, 0x40021, 0x40020, 0x40023, 0x40022, 0x03004, 0x03005, 0x08061, 0x08060, 
	0x03000, 0x03001, 0x03002, 0x03003, 0x0300C, 0x40034, 0x30805, 0x30804, 0x03008, 0x40030, 0x30801, 0x30800, 0x4000D, 
	0x4000C, 0x08051, 0x08050, 0x40009, 0x40008, 0x10280, 0x4000A, 0x40005, 0x40004, 0x01900, 0x40006, 0x40001, 0x40000, 
	0x40003, 0x40002, 0x14800, 0x08042, 0x08041, 0x08040, 0x03020, 0x40018, 0x08045, 0x08044, 0x40015, 0x40014, 0x08049, 
	0x08048, 0x40011, 0x40010, 0x40013, 0x40012, 0x00200, 0x00201, 0x00202, 0x00203, 0x00204, 0x00205, 0x00206, 0x00207, 
	0x00208, 0x00209, 0x0020A, 0x50080, 0x0020C, 0x0020D, 0x0020E, 0x50084, 0x00210, 0x00211, 0x00212, 0x21040, 0x00214, 
	0x00215, 0x04880, 0x04881, 0x00218, 0x00219, 0x0E001, 0x0E000, 0x0021C, 0x0021D, 0x04888, 0x0E004, 0x00220, 0x00221, 
	0x00222, 0x00223, 0x00224, 0x00225, 0x10140, 0x10141, 0x00228, 0x00229, 0x0022A, 0x24204, 0x12401, 0x12400, 0x24201, 
	0x24200, 0x00230, 0x00231, 0x00232, 0x21060, 0x2A000, 0x2A001, 0x2A002, 0x2A003, 0x20881, 0x20880, 0x20883, 0x20882, 
	0x05040, 0x05041, 0x05042, 0x24210, 0x00240, 0x00241, 0x00242, 0x21010, 0x00244, 0x46000, 0x10120, 0x10121, 0x00248, 
	0x00249, 0x0024A, 0x21018, 0x20480, 0x20481, 0x20482, 0x20483, 0x00250, 0x21002, 0x21001, 0x21000, 0x18081, 0x18080, 
	0x21005, 0x21004, 0x12800, 0x12801, 0x21009, 0x21008, 0x05020, 0x05021, 0x48200, 0x48201, 0x00260, 0x00261, 0x10104, 
	0x04480, 0x10102, 0x10103, 0x10100, 0x10101, 0x62002, 0x62003, 0x62000, 0x62001, 0x05010, 0x05011, 0x10108, 0x10109, 
	0x0500C, 0x21022, 0x21021, 0x21020, 0x05008, 0x00E00, 0x10110, 0x10111, 0x05004, 0x05005, 0x05006, 0x21028, 0x05000, 
	0x05001, 0x05002, 0x05003, 0x00280, 0x00281, 0x00282, 0x50008, 0x00284, 0x00285, 0x04810, 0x22100, 0x00288, 0x50002, 
	0x50001, 0x50000, 0x20440, 0x20441, 0x50005, 0x50004, 0x00290, 0x00291, 0x04804, 0x04805, 0x04802, 0x18040, 0x04800, 
	0x04801, 0x20821, 0x20820, 0x50011, 0x50010, 0x0480A, 0x01602, 0x04808, 0x01600, 0x002A0, 0x002A1, 0x04441, 0x04440, 
	0x002A4, 0x002A5, 0x04830, 0x04444, 0x06100, 0x20810, 0x50021, 0x50020, 0x06104, 0x20814, 0x50025, 0x50024, 0x20809, 
	0x20808, 0x13000, 0x08300, 0x04822, 0x2080C, 0x04820, 0x04821, 0x20801, 0x20800, 0x20803, 0x20802, 0x20805, 0x20804, 
	0x04828, 0x20806, 0x002C0, 0x002C1, 0x04421, 0x04420, 0x20408, 0x18010, 0x2040A, 0x18012, 0x20404, 0x20405, 0x50041, 
	0x50040, 0x20400, 0x20401, 0x20402, 0x20403, 0x18005, 0x18004, 0x21081, 0x21080, 0x18001, 0x18000, 0x04840, 0x18002, 
	0x20414, 0x1800C, 0x21089, 0x21088, 0x20410, 0x18008, 0x20412, 0x1800A, 0x04403, 0x04402, 0x04401, 0x04400, 0x10182, 
	0x04406, 0x10180, 0x04404, 0x01A02, 0x0440A, 0x01A00, 0x04408, 0x20420, 0x40300, 0x20422, 0x40302, 0x04413, 0x04412, 
	0x04411, 0x04410, 0x18021, 0x18020, 0x10190, 0x18022, 0x20841, 0x20840, 0x01A10, 0x20842, 0x05080, 0x05081, 0x05082, 
	0x05083, 0x00300, 0x00301, 0x00302, 0x00303, 0x00304, 0x00305, 0x10060, 0x22080, 0x00308, 0x00309, 0x28800, 0x28801, 
	0x44402, 0x44403, 0x44400, 0x44401, 0x00310, 0x00311, 0x10C01, 0x10C00, 0x00314, 0x00315, 0x10070, 0x10C04, 0x00318, 
	0x00319, 0x28810, 0x10C08, 0x44412, 0x00000, 0x44410, 0x44411, 0x00320, 0x60400, 0x10044, 0x10045, 0x10042, 0x0C800, 
	0x10040, 0x10041, 0x06080, 0x06081, 0x06082, 0x06083, 0x1004A, 0x0C808, 0x10048, 0x10049, 0x58008, 0x08282, 0x08281, 
	0x08280, 0x10052, 0x0C810, 0x10050, 0x10051, 0x58000, 0x58001, 0x58002, 0x08288, 0x02A02, 0x02A03, 0x02A00, 0x02A01, 
	0x00340, 0x00341, 0x10024, 0x10025, 0x10022, 0x10023, 0x10020, 0x10021, 0x34001, 0x34000, 0x02601, 0x02600, 0x1002A, 
	0x34004, 0x10028, 0x10029, 0x0C400, 0x0C401, 0x21101, 0x21100, 0x60800, 0x60801, 0x10030, 0x10031, 0x0C408, 0x34010, 
	0x21109, 0x21108, 0x60808, 0x60809, 0x10038, 0x28420, 0x10006, 0x10007, 0x10004, 0x10005, 0x10002, 0x10003, 0x10000, 
	0x10001, 0x1000E, 0x40284, 0x1000C, 0x1000D, 0x1000A, 0x40280, 0x10008, 0x10009, 0x10016, 0x10017, 0x10014, 0x10015, 
	0x10012, 0x10013, 0x10010, 0x10011, 0x05104, 0x44802, 0x44801, 0x44800, 0x05100, 0x05101, 0x10018, 0x28400, 0x00380, 
	0x00381, 0x22005, 0x22004, 0x22003, 0x22002, 0x22001, 0x22000, 0x06020, 0x06021, 0x50101, 0x50100, 0x11800, 0x11801, 
	0x22009, 0x22008, 0x45001, 0x45000, 0x08221, 0x08220, 0x04902, 0x22012, 0x04900, 0x22010, 0x06030, 0x45008, 0x08229, 
	0x08228, 0x11810, 0x11811, 0x04908, 0x22018, 0x06008, 0x06009, 0x08211, 0x08210, 0x100C2, 0x22022, 0x100C0, 0x22020, 
	0x06000, 0x06001, 0x06002, 0x06003, 0x06004, 0x40240, 0x06006, 0x40242, 0x08203, 0x08202, 0x08201, 0x08200, 0x08207, 
	0x08206, 0x08205, 0x08204, 0x06010, 0x20900, 0x08209, 0x08208, 0x61002, 0x20904, 0x61000, 0x61001, 0x29020, 0x29021, 
	0x100A4, 0x22044, 0x100A2, 0x22042, 0x100A0, 0x22040, 0x20504, 0x40224, 0x0D005, 0x0D004, 0x20500, 0x40220, 0x0D001, 
	0x0D000, 0x03204, 0x18104, 0x08261, 0x08260, 0x03200, 0x18100, 0x03202, 0x18102, 0x11421, 0x11420, 0x00000, 0x11422, 
	0x03208, 0x18108, 0x0D011, 0x0D010, 0x29000, 0x29001, 0x10084, 0x04500, 0x10082, 0x40208, 0x10080, 0x10081, 0x06040, 
	0x40204, 0x06042, 0x40206, 0x40201, 0x40200, 0x10088, 0x40202, 0x29010, 0x08242, 0x08241, 0x08240, 0x10092, 0x40218, 
	0x10090, 0x10091, 0x11401, 0x11400, 0x11403, 0x11402, 0x40211, 0x40210, 0x10098, 0x40212, 0x00400, 0x00401, 0x00402, 
	0x00403, 0x00404, 0x00405, 0x00406, 0x00407, 0x00408, 0x00409, 0x0040A, 0x02140, 0x0040C, 0x0040D, 0x01091, 0x01090, 
	0x00410, 0x00411, 0x00412, 0x00413, 0x00414, 0x00860, 0x01089, 0x01088, 0x00418, 0x38000, 0x01085, 0x01084, 0x01083, 
	0x01082, 0x01081, 0x01080, 0x00420, 0x00421, 0x00422, 0x00423, 0x00424, 0x00850, 0x42080, 0x42081, 0x00428, 0x00429, 
	0x48801, 0x48800, 0x09100, 0x12200, 0x24401, 0x24400, 0x00430, 0x00844, 0x00432, 0x00846, 0x00841, 0x00840, 0x1C000, 
	0x00842, 0x00438, 0x0084C, 0x010A5, 0x010A4, 0x00849, 0x00848, 0x010A1, 0x010A0, 0x00440, 0x00441, 0x00442, 0x02108, 
	0x00444, 0x00830, 0x70001, 0x70000, 0x00448, 0x02102, 0x02101, 0x02100, 0x20280, 0x20281, 0x02105, 0x02104, 0x00450, 
	0x00824, 0x00452, 0x00826, 0x00821, 0x00820, 0x00823, 0x00822, 0x24802, 0x02112, 0x24800, 0x02110, 0x00829, 0x00828, 
	0x48400, 0x010C0, 0x00460, 0x00814, 0x04281, 0x04280, 0x00811, 0x00810, 0x00813, 0x00812, 0x54000, 0x54001, 0x02121, 
	0x02120, 0x00819, 0x00818, 0x0081B, 0x0081A, 0x00805, 0x00804, 0x41100, 0x00806, 0x00801, 0x00800, 0x00803, 0x00802, 
	0x0A080, 0x0080C, 0x0A082, 0x0080E, 0x00809, 0x00808, 0x0080B, 0x0080A, 0x00480, 0x00481, 0x00482, 0x00483, 0x00484, 
	0x14100, 0x42020, 0x01018, 0x00488, 0x00489, 0x01015, 0x01014, 0x20240, 0x01012, 0x01011, 0x01010, 0x00490, 0x00491, 
	0x0100D, 0x0100C, 0x0100B, 0x0100A, 0x01009, 0x01008, 0x40900, 0x01006, 0x01005, 0x01004, 0x01003, 0x01002, 0x01001, 
	0x01000, 0x004A0, 0x004A1, 0x42004, 0x04240, 0x42002, 0x42003, 0x42000, 0x42001, 0x30102, 0x30103, 0x30100, 0x30101, 
	0x4200A, 0x01032, 0x42008, 0x01030, 0x25000, 0x25001, 0x08501, 0x08500, 0x008C1, 0x008C0, 0x42010, 0x01028, 0x0A040, 
	0x0A041, 0x01025, 0x01024, 0x01023, 0x01022, 0x01021, 0x01020, 0x004C0, 0x49000, 0x04221, 0x04220, 0x20208, 0x20209, 
	0x08900, 0x08901, 0x20204, 0x20205, 0x02181, 0x02180, 0x20200, 0x20201, 0x20202, 0x01050, 0x0A028, 0x008A4, 0x0104D, 
	0x0104C, 0x008A1, 0x008A0, 0x01049, 0x01048, 0x0A020, 0x0A021, 0x01045, 0x01044, 0x20210, 0x01042, 0x01041, 0x01040, 
	0x04203, 0x04202, 0x04201, 0x04200, 0x00891, 0x00890, 0x42040, 0x04204, 0x0A010, 0x0A011, 0x01C00, 0x04208, 0x20220, 
	0x40500, 0x20222, 0x40502, 0x0A008, 0x00884, 0x04211, 0x04210, 0x00881, 0x00880, 0x00883, 0x00882, 0x0A000, 0x0A001, 
	0x0A002, 0x0A003, 0x0A004, 0x00888, 0x01061, 0x01060, 0x00500, 0x00501, 0x00502, 0x02048, 0x00504, 0x14080, 0x00506, 
	0x14082, 0x00508, 0x02042, 0x02041, 0x02040, 0x09020, 0x09021, 0x44200, 0x02044, 0x00510, 0x00511, 0x10A01, 0x10A00, 
	0x4A001, 0x4A000, 0x4A003, 0x4A002, 0x40880, 0x40881, 0x02051, 0x02050, 0x40884, 0x01182, 0x01181, 0x01180, 0x00520, 
	0x60200, 0x00522, 0x60202, 0x09008, 0x09009, 0x0900A, 0x0900B, 0x09004, 0x09005, 0x30080, 0x02060, 0x09000, 0x09001, 
	0x09002, 0x09003, 0x41042, 0x08482, 0x41040, 0x08480, 0x00941, 0x00940, 0x41044, 0x00942, 0x09014, 0x09015, 0x02C04, 
	0x08488, 0x09010, 0x09011, 0x02C00, 0x02C01, 0x00540, 0x0200A, 0x02009, 0x02008, 0x08882, 0x0200E, 0x08880, 0x0200C, 
	0x02003, 0x02002, 0x02001, 0x02000, 0x02007, 0x02006, 0x02005, 0x02004, 0x0C200, 0x0C201, 0x41020, 0x02018, 0x00921, 
	0x00920, 0x41024, 0x00922, 0x02013, 0x02012, 0x02011, 0x02010, 0x02017, 0x02016, 0x02015, 0x02014, 0x41012, 0x0202A, 
	0x41010, 0x02028, 0x26000, 0x00910, 0x10600, 0x10601, 0x02023, 0x02022, 0x02021, 0x02020, 0x09040, 0x40480, 0x02025, 
	0x02024, 0x41002, 0x00904, 0x41000, 0x41001, 0x00901, 0x00900, 0x41004, 0x00902, 0x4100A, 0x02032, 0x41008, 0x02030, 
	0x00909, 0x00908, 0x28201, 0x28200, 0x00580, 0x14004, 0x00582, 0x14006, 0x14001, 0x14000, 0x08840, 0x14002, 0x40810, 
	0x40811, 0x30020, 0x020C0, 0x14009, 0x14008, 0x01111, 0x01110, 0x40808, 0x40809, 0x08421, 0x08420, 0x14011, 0x14010, 
	0x01109, 0x01108, 0x40800, 0x40801, 0x40802, 0x01104, 0x40804, 0x01102, 0x01101, 0x01100, 0x03801, 0x03800, 0x30008, 
	0x08410, 0x14021, 0x14020, 0x42100, 0x42101, 0x30002, 0x30003, 0x30000, 0x30001, 0x09080, 0x40440, 0x30004, 0x30005, 
	0x08403, 0x08402, 0x08401, 0x08400, 0x08407, 0x08406, 0x08405, 0x08404, 0x40820, 0x40821, 0x30010, 0x08408, 0x40824, 
	0x01122, 0x01121, 0x01120, 0x08806, 0x0208A, 0x08804, 0x02088, 0x08802, 0x14040, 0x08800, 0x08801, 0x02083, 0x02082, 
	0x02081, 0x02080, 0x20300, 0x40420, 0x08808, 0x02084, 0x03404, 0x03405, 0x08814, 0x02098, 0x03400, 0x03401, 0x08810, 
	0x08811, 0x40840, 0x40841, 0x02091, 0x02090, 0x40844, 0x01142, 0x01141, 0x01140, 0x04303, 0x04302, 0x04301, 0x04300, 
	0x40409, 0x40408, 0x08820, 0x08821, 0x40405, 0x40404, 0x30040, 0x020A0, 0x40401, 0x40400, 0x40403, 0x40402, 0x41082, 
	0x08442, 0x41080, 0x08440, 0x00981, 0x00980, 0x41084, 0x00982, 0x0A100, 0x11200, 0x0A102, 0x11202, 0x40411, 0x40410, 
	0x40413, 0x40412, 0x00600, 0x00601, 0x00602, 0x00603, 0x00604, 0x00605, 0x00606, 0x00607, 0x00608, 0x05800, 0x0060A, 
	0x05802, 0x200C0, 0x12020, 0x44100, 0x44101, 0x00610, 0x00611, 0x10901, 0x10900, 0x51000, 0x51001, 0x51002, 0x10904, 
	0x00618, 0x05810, 0x01285, 0x01284, 0x51008, 0x01282, 0x01281, 0x01280, 0x00620, 0x60100, 0x040C1, 0x040C0, 0x12009, 
	0x12008, 0x21800, 0x21801, 0x12005, 0x12004, 0x12007, 0x12006, 0x12001, 0x12000, 0x12003, 0x12002, 0x00630, 0x00A44, 
	0x040D1, 0x040D0, 0x00A41, 0x00A40, 0x21810, 0x00A42, 0x12015, 0x12014, 0x00000, 0x12016, 0x12011, 0x12010, 0x12013, 
	0x12012, 0x00640, 0x00641, 0x040A1, 0x040A0, 0x20088, 0x20089, 0x2008A, 0x040A4, 0x20084, 0x20085, 0x19000, 0x02300, 
	0x20080, 0x20081, 0x20082, 0x20083, 0x0C100, 0x0C101, 0x21401, 0x21400, 0x00A21, 0x00A20, 0x00A23, 0x00A22, 0x20094, 
	0x20095, 0x19010, 0x21408, 0x20090, 0x20091, 0x20092, 0x28120, 0x04083, 0x04082, 0x04081, 0x04080, 0x00A11, 0x00A10, 
	0x10500, 0x04084, 0x200A4, 0x0408A, 0x04089, 0x04088, 0x200A0, 0x12040, 0x200A2, 0x12042, 0x00A05, 0x00A04, 0x04091, 
	0x04090, 0x00A01, 0x00A00, 0x00A03, 0x00A02, 0x05404, 0x00A0C, 0x28105, 0x28104, 0x05400, 0x00A08, 0x28101, 0x28100, 
	0x00680, 0x00681, 0x04061, 0x04060, 0x20048, 0x20049, 0x2004A, 0x04064, 0x20044, 0x20045, 0x50401, 0x50400, 0x20040, 
	0x20041, 0x20042, 0x01210, 0x68002, 0x68003, 0x68000, 0x68001, 0x04C02, 0x0120A, 0x04C00, 0x01208, 0x20054, 0x01206, 
	0x01205, 0x01204, 0x20050, 0x01202, 0x01201, 0x01200, 0x18800, 0x04042, 0x04041, 0x04040, 0x42202, 0x04046, 0x42200, 
	0x04044, 0x20064, 0x0404A, 0x04049, 0x04048, 0x20060, 0x12080, 0x20062, 0x12082, 0x18810, 0x04052, 0x04051, 0x04050, 
	0x4C009, 0x4C008, 0x42210, 0x04054, 0x20C01, 0x20C00, 0x20C03, 0x20C02, 0x4C001, 0x4C000, 0x01221, 0x01220, 0x2000C, 
	0x04022, 0x04021, 0x04020, 0x20008, 0x20009, 0x2000A, 0x04024, 0x20004, 0x20005, 0x20006, 0x04028, 0x20000, 0x20001, 
	0x20002, 0x20003, 0x2001C, 0x04032, 0x04031, 0x04030, 0x20018, 0x18400, 0x2001A, 0x18402, 0x20014, 0x20015, 0x20016, 
	0x01244, 0x20010, 0x20011, 0x20012, 0x01240, 0x04003, 0x04002, 0x04001, 0x04000, 0x20028, 0x04006, 0x04005, 0x04004, 
	0x20024, 0x0400A, 0x04009, 0x04008, 0x20020, 0x20021, 0x20022, 0x0400C, 0x04013, 0x04012, 0x04011, 0x04010, 0x00A81, 
	0x00A80, 0x04015, 0x04014, 0x0A200, 0x11100, 0x04019, 0x04018, 0x20030, 0x20031, 0x50800, 0x50801, 0x00700, 0x60020, 
	0x10811, 0x10810, 0x4400A, 0x60024, 0x44008, 0x44009, 0x44006, 0x02242, 0x44004, 0x02240, 0x44002, 0x44003, 0x44000, 
	0x44001, 0x0C040, 0x10802, 0x10801, 0x10800, 0x0C044, 0x10806, 0x10805, 0x10804, 0x23000, 0x23001, 0x10809, 0x10808, 
	0x44012, 0x44013, 0x44010, 0x44011, 0x60001, 0x60000, 0x60003, 0x60002, 0x60005, 0x60004, 0x10440, 0x10441, 0x60009, 
	0x60008, 0x44024, 0x6000A, 0x09200, 0x12100, 0x44020, 0x44021, 0x60011, 0x60010, 0x10821, 0x10820, 0x07003, 0x07002, 
	0x07001, 0x07000, 0x23020, 0x60018, 0x28045, 0x28044, 0x09210, 0x28042, 0x28041, 0x28040, 0x0C010, 0x0C011, 0x02209, 
	0x02208, 0x10422, 0x10423, 0x10420, 0x10421, 0x02203, 0x02202, 0x02201, 0x02200, 0x20180, 0x20181, 0x44040, 0x02204, 
	0x0C000, 0x0C001, 0x0C002, 0x10840, 0x0C004, 0x0C005, 0x0C006, 0x10844, 0x0C008, 0x0C009, 0x02211, 0x02210, 0x0C00C, 
	0x28022, 0x28021, 0x28020, 0x60041, 0x60040, 0x10404, 0x04180, 0x10402, 0x10403, 0x10400, 0x10401, 0x02223, 0x02222, 
    0x02221, 0x02220, 0x1040A, 0x28012, 0x10408, 0x28010, 0x0C020, 0x0C021, 0x41200, 0x41201, 0x00B01, 0x00B00, 0x10410, 
	0x28008, 0x11081, 0x11080, 0x28005, 0x28004, 0x28003, 0x28002, 0x28001, 0x28000, 0x52040, 0x14204, 0x22405, 0x22404, 
	0x14201, 0x14200, 0x22401, 0x22400, 0x20144, 0x20145, 0x44084, 0x022C0, 0x20140, 0x20141, 0x44080, 0x44081, 0x40A08, 
	0x10882, 0x10881, 0x10880, 0x14211, 0x14210, 0x1A008, 0x10884, 0x40A00, 0x40A01, 0x40A02, 0x01304, 0x1A002, 0x01302, 
	0x1A000, 0x01300, 0x60081, 0x60080, 0x04141, 0x04140, 0x60085, 0x60084, 0x104C0, 0x04144, 0x06400, 0x06401, 0x30200, 
	0x30201, 0x06404, 0x40640, 0x30204, 0x30205, 0x08603, 0x08602, 0x08601, 0x08600, 0x00000, 0x08606, 0x08605, 0x08604, 
	0x11041, 0x11040, 0x30210, 0x11042, 0x11045, 0x11044, 0x1A020, 0x01320, 0x52000, 0x52001, 0x04121, 0x04120, 0x20108, 
	0x20109, 0x08A00, 0x08A01, 0x20104, 0x20105, 0x02281, 0x02280, 0x20100, 0x20101, 0x20102, 0x20103, 0x0C080, 0x0C081, 
	0x0C082, 0x04130, 0x0C084, 0x06808, 0x08A10, 0x08A11, 0x11021, 0x11020, 0x11023, 0x11022, 0x20110, 0x06800, 0x20112, 
	0x06802, 0x04103, 0x04102, 0x04101, 0x04100, 0x10482, 0x04106, 0x10480, 0x04104, 0x11011, 0x11010, 0x04109, 0x04108, 
	0x20120, 0x40600, 0x20122, 0x40602, 0x11009, 0x11008, 0x22800, 0x04110, 0x1100D, 0x1100C, 0x22804, 0x04114, 0x11001, 
	0x11000, 0x11003, 0x11002, 0x11005, 0x11004, 0x28081, 0x28080)

ENCODE_23127 = (
	0x000000, 0x0018EA, 0x00293E, 0x0031D4, 0x004A96, 0x00527C, 0x0063A8, 0x007B42, 0x008DC6, 0x00952C, 
	0x00A4F8, 0x00BC12, 0x00C750, 0x00DFBA, 0x00EE6E, 0x00F684, 0x010366, 0x011B8C, 0x012A58, 0x0132B2, 
	0x0149F0, 0x01511A, 0x0160CE, 0x017824, 0x018EA0, 0x01964A, 0x01A79E, 0x01BF74, 0x01C436, 0x01DCDC, 
	0x01ED08, 0x01F5E2, 0x0206CC, 0x021E26, 0x022FF2, 0x023718, 0x024C5A, 0x0254B0, 0x026564, 0x027D8E, 
	0x028B0A, 0x0293E0, 0x02A234, 0x02BADE, 0x02C19C, 0x02D976, 0x02E8A2, 0x02F048, 0x0305AA, 0x031D40, 
	0x032C94, 0x03347E, 0x034F3C, 0x0357D6, 0x036602, 0x037EE8, 0x03886C, 0x039086, 0x03A152, 0x03B9B8, 
	0x03C2FA, 0x03DA10, 0x03EBC4, 0x03F32E, 0x040D98, 0x041572, 0x0424A6, 0x043C4C, 0x04470E, 0x045FE4, 
	0x046E30, 0x0476DA, 0x04805E, 0x0498B4, 0x04A960, 0x04B18A, 0x04CAC8, 0x04D222, 0x04E3F6, 0x04FB1C, 
	0x050EFE, 0x051614, 0x0527C0, 0x053F2A, 0x054468, 0x055C82, 0x056D56, 0x0575BC, 0x058338, 0x059BD2, 
	0x05AA06, 0x05B2EC, 0x05C9AE, 0x05D144, 0x05E090, 0x05F87A, 0x060B54, 0x0613BE, 0x06226A, 0x063A80, 
	0x0641C2, 0x065928, 0x0668FC, 0x067016, 0x068692, 0x069E78, 0x06AFAC, 0x06B746, 0x06CC04, 0x06D4EE, 
	0x06E53A, 0x06FDD0, 0x070832, 0x0710D8, 0x07210C, 0x0739E6, 0x0742A4, 0x075A4E, 0x076B9A, 0x077370, 
	0x0785F4, 0x079D1E, 0x07ACCA, 0x07B420, 0x07CF62, 0x07D788, 0x07E65C, 0x07FEB6, 0x0803DA, 0x081B30, 
	0x082AE4, 0x08320E, 0x08494C, 0x0851A6, 0x086072, 0x087898, 0x088E1C, 0x0896F6, 0x08A722, 0x08BFC8, 
	0x08C48A, 0x08DC60, 0x08EDB4, 0x08F55E, 0x0900BC, 0x091856, 0x092982, 0x093168, 0x094A2A, 0x0952C0, 
	0x096314, 0x097BFE, 0x098D7A, 0x099590, 0x09A444, 0x09BCAE, 0x09C7EC, 0x09DF06, 0x09EED2, 0x09F638, 
	0x0A0516, 0x0A1DFC, 0x0A2C28, 0x0A34C2, 0x0A4F80, 0x0A576A, 0x0A66BE, 0x0A7E54, 0x0A88D0, 0x0A903A, 
	0x0AA1EE, 0x0AB904, 0x0AC246, 0x0ADAAC, 0x0AEB78, 0x0AF392, 0x0B0670, 0x0B1E9A, 0x0B2F4E, 0x0B37A4, 
	0x0B4CE6, 0x0B540C, 0x0B65D8, 0x0B7D32, 0x0B8BB6, 0x0B935C, 0x0BA288, 0x0BBA62, 0x0BC120, 0x0BD9CA, 
	0x0BE81E, 0x0BF0F4, 0x0C0E42, 0x0C16A8, 0x0C277C, 0x0C3F96, 0x0C44D4, 0x0C5C3E, 0x0C6DEA, 0x0C7500, 
	0x0C8384, 0x0C9B6E, 0x0CAABA, 0x0CB250, 0x0CC912, 0x0CD1F8, 0x0CE02C, 0x0CF8C6, 0x0D0D24, 0x0D15CE, 
	0x0D241A, 0x0D3CF0, 0x0D47B2, 0x0D5F58, 0x0D6E8C, 0x0D7666, 0x0D80E2, 0x0D9808, 0x0DA9DC, 0x0DB136, 
	0x0DCA74, 0x0DD29E, 0x0DE34A, 0x0DFBA0, 0x0E088E, 0x0E1064, 0x0E21B0, 0x0E395A, 0x0E4218, 0x0E5AF2, 
	0x0E6B26, 0x0E73CC, 0x0E8548, 0x0E9DA2, 0x0EAC76, 0x0EB49C, 0x0ECFDE, 0x0ED734, 0x0EE6E0, 0x0EFE0A, 
	0x0F0BE8, 0x0F1302, 0x0F22D6, 0x0F3A3C, 0x0F417E, 0x0F5994, 0x0F6840, 0x0F70AA, 0x0F862E, 0x0F9EC4, 
	0x0FAF10, 0x0FB7FA, 0x0FCCB8, 0x0FD452, 0x0FE586, 0x0FFD6C, 0x1007B4, 0x101F5E, 0x102E8A, 0x103660, 
	0x104D22, 0x1055C8, 0x10641C, 0x107CF6, 0x108A72, 0x109298, 0x10A34C, 0x10BBA6, 0x10C0E4, 0x10D80E, 
	0x10E9DA, 0x10F130, 0x1104D2, 0x111C38, 0x112DEC, 0x113506, 0x114E44, 0x1156AE, 0x11677A, 0x117F90, 
	0x118914, 0x1191FE, 0x11A02A, 0x11B8C0, 0x11C382, 0x11DB68, 0x11EABC, 0x11F256, 0x120178, 0x121992, 
	0x122846, 0x1230AC, 0x124BEE, 0x125304, 0x1262D0, 0x127A3A, 0x128CBE, 0x129454, 0x12A580, 0x12BD6A, 
	0x12C628, 0x12DEC2, 0x12EF16, 0x12F7FC, 0x13021E, 0x131AF4, 0x132B20, 0x1333CA, 0x134888, 0x135062, 
	0x1361B6, 0x13795C, 0x138FD8, 0x139732, 0x13A6E6, 0x13BE0C, 0x13C54E, 0x13DDA4, 0x13EC70, 0x13F49A, 
	0x140A2C, 0x1412C6, 0x142312, 0x143BF8, 0x1440BA, 0x145850, 0x146984, 0x14716E, 0x1487EA, 0x149F00, 
	0x14AED4, 0x14B63E, 0x14CD7C, 0x14D596, 0x14E442, 0x14FCA8, 0x15094A, 0x1511A0, 0x152074, 0x15389E, 
	0x1543DC, 0x155B36, 0x156AE2, 0x157208, 0x15848C, 0x159C66, 0x15ADB2, 0x15B558, 0x15CE1A, 0x15D6F0, 
	0x15E724, 0x15FFCE, 0x160CE0, 0x16140A, 0x1625DE, 0x163D34, 0x164676, 0x165E9C, 0x166F48, 0x1677A2, 
	0x168126, 0x1699CC, 0x16A818, 0x16B0F2, 0x16CBB0, 0x16D35A, 0x16E28E, 0x16FA64, 0x170F86, 0x17176C, 
	0x1726B8, 0x173E52, 0x174510, 0x175DFA, 0x176C2E, 0x1774C4, 0x178240, 0x179AAA, 0x17AB7E, 0x17B394, 
	0x17C8D6, 0x17D03C, 0x17E1E8, 0x17F902, 0x18046E, 0x181C84, 0x182D50, 0x1835BA, 0x184EF8, 0x185612, 
	0x1867C6, 0x187F2C, 0x1889A8, 0x189142, 0x18A096, 0x18B87C, 0x18C33E, 0x18DBD4, 0x18EA00, 0x18F2EA, 
	0x190708, 0x191FE2, 0x192E36, 0x1936DC, 0x194D9E, 0x195574, 0x1964A0, 0x197C4A, 0x198ACE, 0x199224, 
	0x19A3F0, 0x19BB1A, 0x19C058, 0x19D8B2, 0x19E966, 0x19F18C, 0x1A02A2, 0x1A1A48, 0x1A2B9C, 0x1A3376, 
	0x1A4834, 0x1A50DE, 0x1A610A, 0x1A79E0, 0x1A8F64, 0x1A978E, 0x1AA65A, 0x1ABEB0, 0x1AC5F2, 0x1ADD18, 
	0x1AECCC, 0x1AF426, 0x1B01C4, 0x1B192E, 0x1B28FA, 0x1B3010, 0x1B4B52, 0x1B53B8, 0x1B626C, 0x1B7A86, 
	0x1B8C02, 0x1B94E8, 0x1BA53C, 0x1BBDD6, 0x1BC694, 0x1BDE7E, 0x1BEFAA, 0x1BF740, 0x1C09F6, 0x1C111C, 
	0x1C20C8, 0x1C3822, 0x1C4360, 0x1C5B8A, 0x1C6A5E, 0x1C72B4, 0x1C8430, 0x1C9CDA, 0x1CAD0E, 0x1CB5E4, 
	0x1CCEA6, 0x1CD64C, 0x1CE798, 0x1CFF72, 0x1D0A90, 0x1D127A, 0x1D23AE, 0x1D3B44, 0x1D4006, 0x1D58EC, 
	0x1D6938, 0x1D71D2, 0x1D8756, 0x1D9FBC, 0x1DAE68, 0x1DB682, 0x1DCDC0, 0x1DD52A, 0x1DE4FE, 0x1DFC14, 
	0x1E0F3A, 0x1E17D0, 0x1E2604, 0x1E3EEE, 0x1E45AC, 0x1E5D46, 0x1E6C92, 0x1E7478, 0x1E82FC, 0x1E9A16, 
	0x1EABC2, 0x1EB328, 0x1EC86A, 0x1ED080, 0x1EE154, 0x1EF9BE, 0x1F0C5C, 0x1F14B6, 0x1F2562, 0x1F3D88, 
	0x1F46CA, 0x1F5E20, 0x1F6FF4, 0x1F771E, 0x1F819A, 0x1F9970, 0x1FA8A4, 0x1FB04E, 0x1FCB0C, 0x1FD3E6, 
	0x1FE232, 0x1FFAD8, 0x200F68, 0x201782, 0x202656, 0x203EBC, 0x2045FE, 0x205D14, 0x206CC0, 0x20742A, 
	0x2082AE, 0x209A44, 0x20AB90, 0x20B37A, 0x20C838, 0x20D0D2, 0x20E106, 0x20F9EC, 0x210C0E, 0x2114E4, 
	0x212530, 0x213DDA, 0x214698, 0x215E72, 0x216FA6, 0x21774C, 0x2181C8, 0x219922, 0x21A8F6, 0x21B01C, 
	0x21CB5E, 0x21D3B4, 0x21E260, 0x21FA8A, 0x2209A4, 0x22114E, 0x22209A, 0x223870, 0x224332, 0x225BD8, 
	0x226A0C, 0x2272E6, 0x228462, 0x229C88, 0x22AD5C, 0x22B5B6, 0x22CEF4, 0x22D61E, 0x22E7CA, 0x22FF20, 
	0x230AC2, 0x231228, 0x2323FC, 0x233B16, 0x234054, 0x2358BE, 0x23696A, 0x237180, 0x238704, 0x239FEE, 
	0x23AE3A, 0x23B6D0, 0x23CD92, 0x23D578, 0x23E4AC, 0x23FC46, 0x2402F0, 0x241A1A, 0x242BCE, 0x243324, 
	0x244866, 0x24508C, 0x246158, 0x2479B2, 0x248F36, 0x2497DC, 0x24A608, 0x24BEE2, 0x24C5A0, 0x24DD4A, 
	0x24EC9E, 0x24F474, 0x250196, 0x25197C, 0x2528A8, 0x253042, 0x254B00, 0x2553EA, 0x25623E, 0x257AD4, 
	0x258C50, 0x2594BA, 0x25A56E, 0x25BD84, 0x25C6C6, 0x25DE2C, 0x25EFF8, 0x25F712, 0x26043C, 0x261CD6, 
	0x262D02, 0x2635E8, 0x264EAA, 0x265640, 0x266794, 0x267F7E, 0x2689FA, 0x269110, 0x26A0C4, 0x26B82E, 
	0x26C36C, 0x26DB86, 0x26EA52, 0x26F2B8, 0x27075A, 0x271FB0, 0x272E64, 0x27368E, 0x274DCC, 0x275526, 
	0x2764F2, 0x277C18, 0x278A9C, 0x279276, 0x27A3A2, 0x27BB48, 0x27C00A, 0x27D8E0, 0x27E934, 0x27F1DE, 
	0x280CB2, 0x281458, 0x28258C, 0x283D66, 0x284624, 0x285ECE, 0x286F1A, 0x2877F0, 0x288174, 0x28999E, 
	0x28A84A, 0x28B0A0, 0x28CBE2, 0x28D308, 0x28E2DC, 0x28FA36, 0x290FD4, 0x29173E, 0x2926EA, 0x293E00, 
	0x294542, 0x295DA8, 0x296C7C, 0x297496, 0x298212, 0x299AF8, 0x29AB2C, 0x29B3C6, 0x29C884, 0x29D06E, 
	0x29E1BA, 0x29F950, 0x2A0A7E, 0x2A1294, 0x2A2340, 0x2A3BAA, 0x2A40E8, 0x2A5802, 0x2A69D6, 0x2A713C, 
	0x2A87B8, 0x2A9F52, 0x2AAE86, 0x2AB66C, 0x2ACD2E, 0x2AD5C4, 0x2AE410, 0x2AFCFA, 0x2B0918, 0x2B11F2, 
	0x2B2026, 0x2B38CC, 0x2B438E, 0x2B5B64, 0x2B6AB0, 0x2B725A, 0x2B84DE, 0x2B9C34, 0x2BADE0, 0x2BB50A, 
	0x2BCE48, 0x2BD6A2, 0x2BE776, 0x2BFF9C, 0x2C012A, 0x2C19C0, 0x2C2814, 0x2C30FE, 0x2C4BBC, 0x2C5356, 
	0x2C6282, 0x2C7A68, 0x2C8CEC, 0x2C9406, 0x2CA5D2, 0x2CBD38, 0x2CC67A, 0x2CDE90, 0x2CEF44, 0x2CF7AE, 
	0x2D024C, 0x2D1AA6, 0x2D2B72, 0x2D3398, 0x2D48DA, 0x2D5030, 0x2D61E4, 0x2D790E, 0x2D8F8A, 0x2D9760, 
	0x2DA6B4, 0x2DBE5E, 0x2DC51C, 0x2DDDF6, 0x2DEC22, 0x2DF4C8, 0x2E07E6, 0x2E1F0C, 0x2E2ED8, 0x2E3632, 
	0x2E4D70, 0x2E559A, 0x2E644E, 0x2E7CA4, 0x2E8A20, 0x2E92CA, 0x2EA31E, 0x2EBBF4, 0x2EC0B6, 0x2ED85C, 
	0x2EE988, 0x2EF162, 0x2F0480, 0x2F1C6A, 0x2F2DBE, 0x2F3554, 0x2F4E16, 0x2F56FC, 0x2F6728, 0x2F7FC2, 
	0x2F8946, 0x2F91AC, 0x2FA078, 0x2FB892, 0x2FC3D0, 0x2FDB3A, 0x2FEAEE, 0x2FF204, 0x3008DC, 0x301036, 
	0x3021E2, 0x303908, 0x30424A, 0x305AA0, 0x306B74, 0x30739E, 0x30851A, 0x309DF0, 0x30AC24, 0x30B4CE, 
	0x30CF8C, 0x30D766, 0x30E6B2, 0x30FE58, 0x310BBA, 0x311350, 0x312284, 0x313A6E, 0x31412C, 0x3159C6, 
	0x316812, 0x3170F8, 0x31867C, 0x319E96, 0x31AF42, 0x31B7A8, 0x31CCEA, 0x31D400, 0x31E5D4, 0x31FD3E, 
	0x320E10, 0x3216FA, 0x32272E, 0x323FC4, 0x324486, 0x325C6C, 0x326DB8, 0x327552, 0x3283D6, 0x329B3C, 
	0x32AAE8, 0x32B202, 0x32C940, 0x32D1AA, 0x32E07E, 0x32F894, 0x330D76, 0x33159C, 0x332448, 0x333CA2, 
	0x3347E0, 0x335F0A, 0x336EDE, 0x337634, 0x3380B0, 0x33985A, 0x33A98E, 0x33B164, 0x33CA26, 0x33D2CC, 
	0x33E318, 0x33FBF2, 0x340544, 0x341DAE, 0x342C7A, 0x343490, 0x344FD2, 0x345738, 0x3466EC, 0x347E06, 
	0x348882, 0x349068, 0x34A1BC, 0x34B956, 0x34C214, 0x34DAFE, 0x34EB2A, 0x34F3C0, 0x350622, 0x351EC8, 
	0x352F1C, 0x3537F6, 0x354CB4, 0x35545E, 0x35658A, 0x357D60, 0x358BE4, 0x35930E, 0x35A2DA, 0x35BA30, 
	0x35C172, 0x35D998, 0x35E84C, 0x35F0A6, 0x360388, 0x361B62, 0x362AB6, 0x36325C, 0x36491E, 0x3651F4, 
	0x366020, 0x3678CA, 0x368E4E, 0x3696A4, 0x36A770, 0x36BF9A, 0x36C4D8, 0x36DC32, 0x36EDE6, 0x36F50C, 
	0x3700EE, 0x371804, 0x3729D0, 0x37313A, 0x374A78, 0x375292, 0x376346, 0x377BAC, 0x378D28, 0x3795C2, 
	0x37A416, 0x37BCFC, 0x37C7BE, 0x37DF54, 0x37EE80, 0x37F66A, 0x380B06, 0x3813EC, 0x382238, 0x383AD2, 
	0x384190, 0x38597A, 0x3868AE, 0x387044, 0x3886C0, 0x389E2A, 0x38AFFE, 0x38B714, 0x38CC56, 0x38D4BC, 
	0x38E568, 0x38FD82, 0x390860, 0x39108A, 0x39215E, 0x3939B4, 0x3942F6, 0x395A1C, 0x396BC8, 0x397322, 
	0x3985A6, 0x399D4C, 0x39AC98, 0x39B472, 0x39CF30, 0x39D7DA, 0x39E60E, 0x39FEE4, 0x3A0DCA, 0x3A1520, 
	0x3A24F4, 0x3A3C1E, 0x3A475C, 0x3A5FB6, 0x3A6E62, 0x3A7688, 0x3A800C, 0x3A98E6, 0x3AA932, 0x3AB1D8, 
	0x3ACA9A, 0x3AD270, 0x3AE3A4, 0x3AFB4E, 0x3B0EAC, 0x3B1646, 0x3B2792, 0x3B3F78, 0x3B443A, 0x3B5CD0, 
	0x3B6D04, 0x3B75EE, 0x3B836A, 0x3B9B80, 0x3BAA54, 0x3BB2BE, 0x3BC9FC, 0x3BD116, 0x3BE0C2, 0x3BF828, 
	0x3C069E, 0x3C1E74, 0x3C2FA0, 0x3C374A, 0x3C4C08, 0x3C54E2, 0x3C6536, 0x3C7DDC, 0x3C8B58, 0x3C93B2, 
	0x3CA266, 0x3CBA8C, 0x3CC1CE, 0x3CD924, 0x3CE8F0, 0x3CF01A, 0x3D05F8, 0x3D1D12, 0x3D2CC6, 0x3D342C, 
	0x3D4F6E, 0x3D5784, 0x3D6650, 0x3D7EBA, 0x3D883E, 0x3D90D4, 0x3DA100, 0x3DB9EA, 0x3DC2A8, 0x3DDA42, 
	0x3DEB96, 0x3DF37C, 0x3E0052, 0x3E18B8, 0x3E296C, 0x3E3186, 0x3E4AC4, 0x3E522E, 0x3E63FA, 0x3E7B10, 
	0x3E8D94, 0x3E957E, 0x3EA4AA, 0x3EBC40, 0x3EC702, 0x3EDFE8, 0x3EEE3C, 0x3EF6D6, 0x3F0334, 0x3F1BDE, 
	0x3F2A0A, 0x3F32E0, 0x3F49A2, 0x3F5148, 0x3F609C, 0x3F7876, 0x3F8EF2, 0x3F9618, 0x3FA7CC, 0x3FBF26, 
	0x3FC464, 0x3FDC8E, 0x3FED5A, 0x3FF5B0, 0x40063A, 0x401ED0, 0x402F04, 0x4037EE, 0x404CAC, 0x405446, 
	0x406592, 0x407D78, 0x408BFC, 0x409316, 0x40A2C2, 0x40BA28, 0x40C16A, 0x40D980, 0x40E854, 0x40F0BE, 
	0x41055C, 0x411DB6, 0x412C62, 0x413488, 0x414FCA, 0x415720, 0x4166F4, 0x417E1E, 0x41889A, 0x419070, 
	0x41A1A4, 0x41B94E, 0x41C20C, 0x41DAE6, 0x41EB32, 0x41F3D8, 0x4200F6, 0x42181C, 0x4229C8, 0x423122, 
	0x424A60, 0x42528A, 0x42635E, 0x427BB4, 0x428D30, 0x4295DA, 0x42A40E, 0x42BCE4, 0x42C7A6, 0x42DF4C, 
	0x42EE98, 0x42F672, 0x430390, 0x431B7A, 0x432AAE, 0x433244, 0x434906, 0x4351EC, 0x436038, 0x4378D2, 
	0x438E56, 0x4396BC, 0x43A768, 0x43BF82, 0x43C4C0, 0x43DC2A, 0x43EDFE, 0x43F514, 0x440BA2, 0x441348, 
	0x44229C, 0x443A76, 0x444134, 0x4459DE, 0x44680A, 0x4470E0, 0x448664, 0x449E8E, 0x44AF5A, 0x44B7B0, 
	0x44CCF2, 0x44D418, 0x44E5CC, 0x44FD26, 0x4508C4, 0x45102E, 0x4521FA, 0x453910, 0x454252, 0x455AB8, 
	0x456B6C, 0x457386, 0x458502, 0x459DE8, 0x45AC3C, 0x45B4D6, 0x45CF94, 0x45D77E, 0x45E6AA, 0x45FE40, 
	0x460D6E, 0x461584, 0x462450, 0x463CBA, 0x4647F8, 0x465F12, 0x466EC6, 0x46762C, 0x4680A8, 0x469842, 
	0x46A996, 0x46B17C, 0x46CA3E, 0x46D2D4, 0x46E300, 0x46FBEA, 0x470E08, 0x4716E2, 0x472736, 0x473FDC, 
	0x47449E, 0x475C74, 0x476DA0, 0x47754A, 0x4783CE, 0x479B24, 0x47AAF0, 0x47B21A, 0x47C958, 0x47D1B2, 
	0x47E066, 0x47F88C, 0x4805E0, 0x481D0A, 0x482CDE, 0x483434, 0x484F76, 0x48579C, 0x486648, 0x487EA2, 
	0x488826, 0x4890CC, 0x48A118, 0x48B9F2, 0x48C2B0, 0x48DA5A, 0x48EB8E, 0x48F364, 0x490686, 0x491E6C, 
	0x492FB8, 0x493752, 0x494C10, 0x4954FA, 0x49652E, 0x497DC4, 0x498B40, 0x4993AA, 0x49A27E, 0x49BA94, 
	0x49C1D6, 0x49D93C, 0x49E8E8, 0x49F002, 0x4A032C, 0x4A1BC6, 0x4A2A12, 0x4A32F8, 0x4A49BA, 0x4A5150, 
	0x4A6084, 0x4A786E, 0x4A8EEA, 0x4A9600, 0x4AA7D4, 0x4ABF3E, 0x4AC47C, 0x4ADC96, 0x4AED42, 0x4AF5A8, 
	0x4B004A, 0x4B18A0, 0x4B2974, 0x4B319E, 0x4B4ADC, 0x4B5236, 0x4B63E2, 0x4B7B08, 0x4B8D8C, 0x4B9566, 
	0x4BA4B2, 0x4BBC58, 0x4BC71A, 0x4BDFF0, 0x4BEE24, 0x4BF6CE, 0x4C0878, 0x4C1092, 0x4C2146, 0x4C39AC, 
	0x4C42EE, 0x4C5A04, 0x4C6BD0, 0x4C733A, 0x4C85BE, 0x4C9D54, 0x4CAC80, 0x4CB46A, 0x4CCF28, 0x4CD7C2, 
	0x4CE616, 0x4CFEFC, 0x4D0B1E, 0x4D13F4, 0x4D2220, 0x4D3ACA, 0x4D4188, 0x4D5962, 0x4D68B6, 0x4D705C, 
	0x4D86D8, 0x4D9E32, 0x4DAFE6, 0x4DB70C, 0x4DCC4E, 0x4DD4A4, 0x4DE570, 0x4DFD9A, 0x4E0EB4, 0x4E165E, 
	0x4E278A, 0x4E3F60, 0x4E4422, 0x4E5CC8, 0x4E6D1C, 0x4E75F6, 0x4E8372, 0x4E9B98, 0x4EAA4C, 0x4EB2A6, 
	0x4EC9E4, 0x4ED10E, 0x4EE0DA, 0x4EF830, 0x4F0DD2, 0x4F1538, 0x4F24EC, 0x4F3C06, 0x4F4744, 0x4F5FAE, 
	0x4F6E7A, 0x4F7690, 0x4F8014, 0x4F98FE, 0x4FA92A, 0x4FB1C0, 0x4FCA82, 0x4FD268, 0x4FE3BC, 0x4FFB56, 
	0x50018E, 0x501964, 0x5028B0, 0x50305A, 0x504B18, 0x5053F2, 0x506226, 0x507ACC, 0x508C48, 0x5094A2, 
	0x50A576, 0x50BD9C, 0x50C6DE, 0x50DE34, 0x50EFE0, 0x50F70A, 0x5102E8, 0x511A02, 0x512BD6, 0x51333C, 
	0x51487E, 0x515094, 0x516140, 0x5179AA, 0x518F2E, 0x5197C4, 0x51A610, 0x51BEFA, 0x51C5B8, 0x51DD52, 
	0x51EC86, 0x51F46C, 0x520742, 0x521FA8, 0x522E7C, 0x523696, 0x524DD4, 0x52553E, 0x5264EA, 0x527C00, 
	0x528A84, 0x52926E, 0x52A3BA, 0x52BB50, 0x52C012, 0x52D8F8, 0x52E92C, 0x52F1C6, 0x530424, 0x531CCE, 
	0x532D1A, 0x5335F0, 0x534EB2, 0x535658, 0x53678C, 0x537F66, 0x5389E2, 0x539108, 0x53A0DC, 0x53B836, 
	0x53C374, 0x53DB9E, 0x53EA4A, 0x53F2A0, 0x540C16, 0x5414FC, 0x542528, 0x543DC2, 0x544680, 0x545E6A, 
	0x546FBE, 0x547754, 0x5481D0, 0x54993A, 0x54A8EE, 0x54B004, 0x54CB46, 0x54D3AC, 0x54E278, 0x54FA92, 
	0x550F70, 0x55179A, 0x55264E, 0x553EA4, 0x5545E6, 0x555D0C, 0x556CD8, 0x557432, 0x5582B6, 0x559A5C, 
	0x55AB88, 0x55B362, 0x55C820, 0x55D0CA, 0x55E11E, 0x55F9F4, 0x560ADA, 0x561230, 0x5623E4, 0x563B0E, 
	0x56404C, 0x5658A6, 0x566972, 0x567198, 0x56871C, 0x569FF6, 0x56AE22, 0x56B6C8, 0x56CD8A, 0x56D560, 
	0x56E4B4, 0x56FC5E, 0x5709BC, 0x571156, 0x572082, 0x573868, 0x57432A, 0x575BC0, 0x576A14, 0x5772FE, 
	0x57847A, 0x579C90, 0x57AD44, 0x57B5AE, 0x57CEEC, 0x57D606, 0x57E7D2, 0x57FF38, 0x580254, 0x581ABE, 
	0x582B6A, 0x583380, 0x5848C2, 0x585028, 0x5861FC, 0x587916, 0x588F92, 0x589778, 0x58A6AC, 0x58BE46, 
	0x58C504, 0x58DDEE, 0x58EC3A, 0x58F4D0, 0x590132, 0x5919D8, 0x59280C, 0x5930E6, 0x594BA4, 0x59534E, 
	0x59629A, 0x597A70, 0x598CF4, 0x59941E, 0x59A5CA, 0x59BD20, 0x59C662, 0x59DE88, 0x59EF5C, 0x59F7B6, 
	0x5A0498, 0x5A1C72, 0x5A2DA6, 0x5A354C, 0x5A4E0E, 0x5A56E4, 0x5A6730, 0x5A7FDA, 0x5A895E, 0x5A91B4, 
	0x5AA060, 0x5AB88A, 0x5AC3C8, 0x5ADB22, 0x5AEAF6, 0x5AF21C, 0x5B07FE, 0x5B1F14, 0x5B2EC0, 0x5B362A, 
	0x5B4D68, 0x5B5582, 0x5B6456, 0x5B7CBC, 0x5B8A38, 0x5B92D2, 0x5BA306, 0x5BBBEC, 0x5BC0AE, 0x5BD844, 
	0x5BE990, 0x5BF17A, 0x5C0FCC, 0x5C1726, 0x5C26F2, 0x5C3E18, 0x5C455A, 0x5C5DB0, 0x5C6C64, 0x5C748E, 
	0x5C820A, 0x5C9AE0, 0x5CAB34, 0x5CB3DE, 0x5CC89C, 0x5CD076, 0x5CE1A2, 0x5CF948, 0x5D0CAA, 0x5D1440, 
	0x5D2594, 0x5D3D7E, 0x5D463C, 0x5D5ED6, 0x5D6F02, 0x5D77E8, 0x5D816C, 0x5D9986, 0x5DA852, 0x5DB0B8, 
	0x5DCBFA, 0x5DD310, 0x5DE2C4, 0x5DFA2E, 0x5E0900, 0x5E11EA, 0x5E203E, 0x5E38D4, 0x5E4396, 0x5E5B7C, 
	0x5E6AA8, 0x5E7242, 0x5E84C6, 0x5E9C2C, 0x5EADF8, 0x5EB512, 0x5ECE50, 0x5ED6BA, 0x5EE76E, 0x5EFF84, 
	0x5F0A66, 0x5F128C, 0x5F2358, 0x5F3BB2, 0x5F40F0, 0x5F581A, 0x5F69CE, 0x5F7124, 0x5F87A0, 0x5F9F4A, 
	0x5FAE9E, 0x5FB674, 0x5FCD36, 0x5FD5DC, 0x5FE408, 0x5FFCE2, 0x600952, 0x6011B8, 0x60206C, 0x603886, 
	0x6043C4, 0x605B2E, 0x606AFA, 0x607210, 0x608494, 0x609C7E, 0x60ADAA, 0x60B540, 0x60CE02, 0x60D6E8, 
	0x60E73C, 0x60FFD6, 0x610A34, 0x6112DE, 0x61230A, 0x613BE0, 0x6140A2, 0x615848, 0x61699C, 0x617176, 
	0x6187F2, 0x619F18, 0x61AECC, 0x61B626, 0x61CD64, 0x61D58E, 0x61E45A, 0x61FCB0, 0x620F9E, 0x621774, 
	0x6226A0, 0x623E4A, 0x624508, 0x625DE2, 0x626C36, 0x6274DC, 0x628258, 0x629AB2, 0x62AB66, 0x62B38C, 
	0x62C8CE, 0x62D024, 0x62E1F0, 0x62F91A, 0x630CF8, 0x631412, 0x6325C6, 0x633D2C, 0x63466E, 0x635E84, 
	0x636F50, 0x6377BA, 0x63813E, 0x6399D4, 0x63A800, 0x63B0EA, 0x63CBA8, 0x63D342, 0x63E296, 0x63FA7C, 
	0x6404CA, 0x641C20, 0x642DF4, 0x64351E, 0x644E5C, 0x6456B6, 0x646762, 0x647F88, 0x64890C, 0x6491E6, 
	0x64A032, 0x64B8D8, 0x64C39A, 0x64DB70, 0x64EAA4, 0x64F24E, 0x6507AC, 0x651F46, 0x652E92, 0x653678, 
	0x654D3A, 0x6555D0, 0x656404, 0x657CEE, 0x658A6A, 0x659280, 0x65A354, 0x65BBBE, 0x65C0FC, 0x65D816, 
	0x65E9C2, 0x65F128, 0x660206, 0x661AEC, 0x662B38, 0x6633D2, 0x664890, 0x66507A, 0x6661AE, 0x667944, 
	0x668FC0, 0x66972A, 0x66A6FE, 0x66BE14, 0x66C556, 0x66DDBC, 0x66EC68, 0x66F482, 0x670160, 0x67198A, 
	0x67285E, 0x6730B4, 0x674BF6, 0x67531C, 0x6762C8, 0x677A22, 0x678CA6, 0x67944C, 0x67A598, 0x67BD72, 
	0x67C630, 0x67DEDA, 0x67EF0E, 0x67F7E4, 0x680A88, 0x681262, 0x6823B6, 0x683B5C, 0x68401E, 0x6858F4, 
	0x686920, 0x6871CA, 0x68874E, 0x689FA4, 0x68AE70, 0x68B69A, 0x68CDD8, 0x68D532, 0x68E4E6, 0x68FC0C, 
	0x6909EE, 0x691104, 0x6920D0, 0x69383A, 0x694378, 0x695B92, 0x696A46, 0x6972AC, 0x698428, 0x699CC2, 
	0x69AD16, 0x69B5FC, 0x69CEBE, 0x69D654, 0x69E780, 0x69FF6A, 0x6A0C44, 0x6A14AE, 0x6A257A, 0x6A3D90, 
	0x6A46D2, 0x6A5E38, 0x6A6FEC, 0x6A7706, 0x6A8182, 0x6A9968, 0x6AA8BC, 0x6AB056, 0x6ACB14, 0x6AD3FE, 
	0x6AE22A, 0x6AFAC0, 0x6B0F22, 0x6B17C8, 0x6B261C, 0x6B3EF6, 0x6B45B4, 0x6B5D5E, 0x6B6C8A, 0x6B7460, 
	0x6B82E4, 0x6B9A0E, 0x6BABDA, 0x6BB330, 0x6BC872, 0x6BD098, 0x6BE14C, 0x6BF9A6, 0x6C0710, 0x6C1FFA, 
	0x6C2E2E, 0x6C36C4, 0x6C4D86, 0x6C556C, 0x6C64B8, 0x6C7C52, 0x6C8AD6, 0x6C923C, 0x6CA3E8, 0x6CBB02, 
	0x6CC040, 0x6CD8AA, 0x6CE97E, 0x6CF194, 0x6D0476, 0x6D1C9C, 0x6D2D48, 0x6D35A2, 0x6D4EE0, 0x6D560A, 
	0x6D67DE, 0x6D7F34, 0x6D89B0, 0x6D915A, 0x6DA08E, 0x6DB864, 0x6DC326, 0x6DDBCC, 0x6DEA18, 0x6DF2F2, 
	0x6E01DC, 0x6E1936, 0x6E28E2, 0x6E3008, 0x6E4B4A, 0x6E53A0, 0x6E6274, 0x6E7A9E, 0x6E8C1A, 0x6E94F0, 
	0x6EA524, 0x6EBDCE, 0x6EC68C, 0x6EDE66, 0x6EEFB2, 0x6EF758, 0x6F02BA, 0x6F1A50, 0x6F2B84, 0x6F336E, 
	0x6F482C, 0x6F50C6, 0x6F6112, 0x6F79F8, 0x6F8F7C, 0x6F9796, 0x6FA642, 0x6FBEA8, 0x6FC5EA, 0x6FDD00, 
	0x6FECD4, 0x6FF43E, 0x700EE6, 0x70160C, 0x7027D8, 0x703F32, 0x704470, 0x705C9A, 0x706D4E, 0x7075A4, 
	0x708320, 0x709BCA, 0x70AA1E, 0x70B2F4, 0x70C9B6, 0x70D15C, 0x70E088, 0x70F862, 0x710D80, 0x71156A, 
	0x7124BE, 0x713C54, 0x714716, 0x715FFC, 0x716E28, 0x7176C2, 0x718046, 0x7198AC, 0x71A978, 0x71B192, 
	0x71CAD0, 0x71D23A, 0x71E3EE, 0x71FB04, 0x72082A, 0x7210C0, 0x722114, 0x7239FE, 0x7242BC, 0x725A56, 
	0x726B82, 0x727368, 0x7285EC, 0x729D06, 0x72ACD2, 0x72B438, 0x72CF7A, 0x72D790, 0x72E644, 0x72FEAE, 
	0x730B4C, 0x7313A6, 0x732272, 0x733A98, 0x7341DA, 0x735930, 0x7368E4, 0x73700E, 0x73868A, 0x739E60, 
	0x73AFB4, 0x73B75E, 0x73CC1C, 0x73D4F6, 0x73E522, 0x73FDC8, 0x74037E, 0x741B94, 0x742A40, 0x7432AA, 
	0x7449E8, 0x745102, 0x7460D6, 0x74783C, 0x748EB8, 0x749652, 0x74A786, 0x74BF6C, 0x74C42E, 0x74DCC4, 
	0x74ED10, 0x74F5FA, 0x750018, 0x7518F2, 0x752926, 0x7531CC, 0x754A8E, 0x755264, 0x7563B0, 0x757B5A, 
	0x758DDE, 0x759534, 0x75A4E0, 0x75BC0A, 0x75C748, 0x75DFA2, 0x75EE76, 0x75F69C, 0x7605B2, 0x761D58, 
	0x762C8C, 0x763466, 0x764F24, 0x7657CE, 0x76661A, 0x767EF0, 0x768874, 0x76909E, 0x76A14A, 0x76B9A0, 
	0x76C2E2, 0x76DA08, 0x76EBDC, 0x76F336, 0x7706D4, 0x771E3E, 0x772FEA, 0x773700, 0x774C42, 0x7754A8, 
	0x77657C, 0x777D96, 0x778B12, 0x7793F8, 0x77A22C, 0x77BAC6, 0x77C184, 0x77D96E, 0x77E8BA, 0x77F050, 
	0x780D3C, 0x7815D6, 0x782402, 0x783CE8, 0x7847AA, 0x785F40, 0x786E94, 0x78767E, 0x7880FA, 0x789810, 
	0x78A9C4, 0x78B12E, 0x78CA6C, 0x78D286, 0x78E352, 0x78FBB8, 0x790E5A, 0x7916B0, 0x792764, 0x793F8E, 
	0x7944CC, 0x795C26, 0x796DF2, 0x797518, 0x79839C, 0x799B76, 0x79AAA2, 0x79B248, 0x79C90A, 0x79D1E0, 
	0x79E034, 0x79F8DE, 0x7A0BF0, 0x7A131A, 0x7A22CE, 0x7A3A24, 0x7A4166, 0x7A598C, 0x7A6858, 0x7A70B2, 
	0x7A8636, 0x7A9EDC, 0x7AAF08, 0x7AB7E2, 0x7ACCA0, 0x7AD44A, 0x7AE59E, 0x7AFD74, 0x7B0896, 0x7B107C, 
	0x7B21A8, 0x7B3942, 0x7B4200, 0x7B5AEA, 0x7B6B3E, 0x7B73D4, 0x7B8550, 0x7B9DBA, 0x7BAC6E, 0x7BB484, 
	0x7BCFC6, 0x7BD72C, 0x7BE6F8, 0x7BFE12, 0x7C00A4, 0x7C184E, 0x7C299A, 0x7C3170, 0x7C4A32, 0x7C52D8, 
	0x7C630C, 0x7C7BE6, 0x7C8D62, 0x7C9588, 0x7CA45C, 0x7CBCB6, 0x7CC7F4, 0x7CDF1E, 0x7CEECA, 0x7CF620, 
	0x7D03C2, 0x7D1B28, 0x7D2AFC, 0x7D3216, 0x7D4954, 0x7D51BE, 0x7D606A, 0x7D7880, 0x7D8E04, 0x7D96EE, 
	0x7DA73A, 0x7DBFD0, 0x7DC492, 0x7DDC78, 0x7DEDAC, 0x7DF546, 0x7E0668, 0x7E1E82, 0x7E2F56, 0x7E37BC, 
	0x7E4CFE, 0x7E5414, 0x7E65C0, 0x7E7D2A, 0x7E8BAE, 0x7E9344, 0x7EA290, 0x7EBA7A, 0x7EC138, 0x7ED9D2, 
	0x7EE806, 0x7EF0EC, 0x7F050E, 0x7F1DE4, 0x7F2C30, 0x7F34DA, 0x7F4F98, 0x7F5772, 0x7F66A6, 0x7F7E4C, 
	0x7F88C8, 0x7F9022, 0x7FA1F6, 0x7FB91C, 0x7FC25E, 0x7FDAB4, 0x7FEB60, 0x7FF38A, 0x800C74, 0x80149E, 
	0x80254A, 0x803DA0, 0x8046E2, 0x805E08, 0x806FDC, 0x807736, 0x8081B2, 0x809958, 0x80A88C, 0x80B066, 
	0x80CB24, 0x80D3CE, 0x80E21A, 0x80FAF0, 0x810F12, 0x8117F8, 0x81262C, 0x813EC6, 0x814584, 0x815D6E, 
	0x816CBA, 0x817450, 0x8182D4, 0x819A3E, 0x81ABEA, 0x81B300, 0x81C842, 0x81D0A8, 0x81E17C, 0x81F996, 
	0x820AB8, 0x821252, 0x822386, 0x823B6C, 0x82402E, 0x8258C4, 0x826910, 0x8271FA, 0x82877E, 0x829F94, 
	0x82AE40, 0x82B6AA, 0x82CDE8, 0x82D502, 0x82E4D6, 0x82FC3C, 0x8309DE, 0x831134, 0x8320E0, 0x83380A, 
	0x834348, 0x835BA2, 0x836A76, 0x83729C, 0x838418, 0x839CF2, 0x83AD26, 0x83B5CC, 0x83CE8E, 0x83D664, 
	0x83E7B0, 0x83FF5A, 0x8401EC, 0x841906, 0x8428D2, 0x843038, 0x844B7A, 0x845390, 0x846244, 0x847AAE, 
	0x848C2A, 0x8494C0, 0x84A514, 0x84BDFE, 0x84C6BC, 0x84DE56, 0x84EF82, 0x84F768, 0x85028A, 0x851A60, 
	0x852BB4, 0x85335E, 0x85481C, 0x8550F6, 0x856122, 0x8579C8, 0x858F4C, 0x8597A6, 0x85A672, 0x85BE98, 
	0x85C5DA, 0x85DD30, 0x85ECE4, 0x85F40E, 0x860720, 0x861FCA, 0x862E1E, 0x8636F4, 0x864DB6, 0x86555C, 
	0x866488, 0x867C62, 0x868AE6, 0x86920C, 0x86A3D8, 0x86BB32, 0x86C070, 0x86D89A, 0x86E94E, 0x86F1A4, 
	0x870446, 0x871CAC, 0x872D78, 0x873592, 0x874ED0, 0x87563A, 0x8767EE, 0x877F04, 0x878980, 0x87916A, 
	0x87A0BE, 0x87B854, 0x87C316, 0x87DBFC, 0x87EA28, 0x87F2C2, 0x880FAE, 0x881744, 0x882690, 0x883E7A, 
	0x884538, 0x885DD2, 0x886C06, 0x8874EC, 0x888268, 0x889A82, 0x88AB56, 0x88B3BC, 0x88C8FE, 0x88D014, 
	0x88E1C0, 0x88F92A, 0x890CC8, 0x891422, 0x8925F6, 0x893D1C, 0x89465E, 0x895EB4, 0x896F60, 0x89778A, 
	0x89810E, 0x8999E4, 0x89A830, 0x89B0DA, 0x89CB98, 0x89D372, 0x89E2A6, 0x89FA4C, 0x8A0962, 0x8A1188, 
	0x8A205C, 0x8A38B6, 0x8A43F4, 0x8A5B1E, 0x8A6ACA, 0x8A7220, 0x8A84A4, 0x8A9C4E, 0x8AAD9A, 0x8AB570, 
	0x8ACE32, 0x8AD6D8, 0x8AE70C, 0x8AFFE6, 0x8B0A04, 0x8B12EE, 0x8B233A, 0x8B3BD0, 0x8B4092, 0x8B5878, 
	0x8B69AC, 0x8B7146, 0x8B87C2, 0x8B9F28, 0x8BAEFC, 0x8BB616, 0x8BCD54, 0x8BD5BE, 0x8BE46A, 0x8BFC80, 
	0x8C0236, 0x8C1ADC, 0x8C2B08, 0x8C33E2, 0x8C48A0, 0x8C504A, 0x8C619E, 0x8C7974, 0x8C8FF0, 0x8C971A, 
	0x8CA6CE, 0x8CBE24, 0x8CC566, 0x8CDD8C, 0x8CEC58, 0x8CF4B2, 0x8D0150, 0x8D19BA, 0x8D286E, 0x8D3084, 
	0x8D4BC6, 0x8D532C, 0x8D62F8, 0x8D7A12, 0x8D8C96, 0x8D947C, 0x8DA5A8, 0x8DBD42, 0x8DC600, 0x8DDEEA, 
	0x8DEF3E, 0x8DF7D4, 0x8E04FA, 0x8E1C10, 0x8E2DC4, 0x8E352E, 0x8E4E6C, 0x8E5686, 0x8E6752, 0x8E7FB8, 
	0x8E893C, 0x8E91D6, 0x8EA002, 0x8EB8E8, 0x8EC3AA, 0x8EDB40, 0x8EEA94, 0x8EF27E, 0x8F079C, 0x8F1F76, 
	0x8F2EA2, 0x8F3648, 0x8F4D0A, 0x8F55E0, 0x8F6434, 0x8F7CDE, 0x8F8A5A, 0x8F92B0, 0x8FA364, 0x8FBB8E, 
	0x8FC0CC, 0x8FD826, 0x8FE9F2, 0x8FF118, 0x900BC0, 0x90132A, 0x9022FE, 0x903A14, 0x904156, 0x9059BC, 
	0x906868, 0x907082, 0x908606, 0x909EEC, 0x90AF38, 0x90B7D2, 0x90CC90, 0x90D47A, 0x90E5AE, 0x90FD44, 
	0x9108A6, 0x91104C, 0x912198, 0x913972, 0x914230, 0x915ADA, 0x916B0E, 0x9173E4, 0x918560, 0x919D8A, 
	0x91AC5E, 0x91B4B4, 0x91CFF6, 0x91D71C, 0x91E6C8, 0x91FE22, 0x920D0C, 0x9215E6, 0x922432, 0x923CD8, 
	0x92479A, 0x925F70, 0x926EA4, 0x92764E, 0x9280CA, 0x929820, 0x92A9F4, 0x92B11E, 0x92CA5C, 0x92D2B6, 
	0x92E362, 0x92FB88, 0x930E6A, 0x931680, 0x932754, 0x933FBE, 0x9344FC, 0x935C16, 0x936DC2, 0x937528, 
	0x9383AC, 0x939B46, 0x93AA92, 0x93B278, 0x93C93A, 0x93D1D0, 0x93E004, 0x93F8EE, 0x940658, 0x941EB2, 
	0x942F66, 0x94378C, 0x944CCE, 0x945424, 0x9465F0, 0x947D1A, 0x948B9E, 0x949374, 0x94A2A0, 0x94BA4A, 
	0x94C108, 0x94D9E2, 0x94E836, 0x94F0DC, 0x95053E, 0x951DD4, 0x952C00, 0x9534EA, 0x954FA8, 0x955742, 
	0x956696, 0x957E7C, 0x9588F8, 0x959012, 0x95A1C6, 0x95B92C, 0x95C26E, 0x95DA84, 0x95EB50, 0x95F3BA, 
	0x960094, 0x96187E, 0x9629AA, 0x963140, 0x964A02, 0x9652E8, 0x96633C, 0x967BD6, 0x968D52, 0x9695B8, 
	0x96A46C, 0x96BC86, 0x96C7C4, 0x96DF2E, 0x96EEFA, 0x96F610, 0x9703F2, 0x971B18, 0x972ACC, 0x973226, 
	0x974964, 0x97518E, 0x97605A, 0x9778B0, 0x978E34, 0x9796DE, 0x97A70A, 0x97BFE0, 0x97C4A2, 0x97DC48, 
	0x97ED9C, 0x97F576, 0x98081A, 0x9810F0, 0x982124, 0x9839CE, 0x98428C, 0x985A66, 0x986BB2, 0x987358, 
	0x9885DC, 0x989D36, 0x98ACE2, 0x98B408, 0x98CF4A, 0x98D7A0, 0x98E674, 0x98FE9E, 0x990B7C, 0x991396, 
	0x992242, 0x993AA8, 0x9941EA, 0x995900, 0x9968D4, 0x99703E, 0x9986BA, 0x999E50, 0x99AF84, 0x99B76E, 
	0x99CC2C, 0x99D4C6, 0x99E512, 0x99FDF8, 0x9A0ED6, 0x9A163C, 0x9A27E8, 0x9A3F02, 0x9A4440, 0x9A5CAA, 
	0x9A6D7E, 0x9A7594, 0x9A8310, 0x9A9BFA, 0x9AAA2E, 0x9AB2C4, 0x9AC986, 0x9AD16C, 0x9AE0B8, 0x9AF852, 
	0x9B0DB0, 0x9B155A, 0x9B248E, 0x9B3C64, 0x9B4726, 0x9B5FCC, 0x9B6E18, 0x9B76F2, 0x9B8076, 0x9B989C, 
	0x9BA948, 0x9BB1A2, 0x9BCAE0, 0x9BD20A, 0x9BE3DE, 0x9BFB34, 0x9C0582, 0x9C1D68, 0x9C2CBC, 0x9C3456, 
	0x9C4F14, 0x9C57FE, 0x9C662A, 0x9C7EC0, 0x9C8844, 0x9C90AE, 0x9CA17A, 0x9CB990, 0x9CC2D2, 0x9CDA38, 
	0x9CEBEC, 0x9CF306, 0x9D06E4, 0x9D1E0E, 0x9D2FDA, 0x9D3730, 0x9D4C72, 0x9D5498, 0x9D654C, 0x9D7DA6, 
	0x9D8B22, 0x9D93C8, 0x9DA21C, 0x9DBAF6, 0x9DC1B4, 0x9DD95E, 0x9DE88A, 0x9DF060, 0x9E034E, 0x9E1BA4, 
	0x9E2A70, 0x9E329A, 0x9E49D8, 0x9E5132, 0x9E60E6, 0x9E780C, 0x9E8E88, 0x9E9662, 0x9EA7B6, 0x9EBF5C, 
	0x9EC41E, 0x9EDCF4, 0x9EED20, 0x9EF5CA, 0x9F0028, 0x9F18C2, 0x9F2916, 0x9F31FC, 0x9F4ABE, 0x9F5254, 
	0x9F6380, 0x9F7B6A, 0x9F8DEE, 0x9F9504, 0x9FA4D0, 0x9FBC3A, 0x9FC778, 0x9FDF92, 0x9FEE46, 0x9FF6AC, 
	0xA0031C, 0xA01BF6, 0xA02A22, 0xA032C8, 0xA0498A, 0xA05160, 0xA060B4, 0xA0785E, 0xA08EDA, 0xA09630, 
	0xA0A7E4, 0xA0BF0E, 0xA0C44C, 0xA0DCA6, 0xA0ED72, 0xA0F598, 0xA1007A, 0xA11890, 0xA12944, 0xA131AE, 
	0xA14AEC, 0xA15206, 0xA163D2, 0xA17B38, 0xA18DBC, 0xA19556, 0xA1A482, 0xA1BC68, 0xA1C72A, 0xA1DFC0, 
	0xA1EE14, 0xA1F6FE, 0xA205D0, 0xA21D3A, 0xA22CEE, 0xA23404, 0xA24F46, 0xA257AC, 0xA26678, 0xA27E92, 
	0xA28816, 0xA290FC, 0xA2A128, 0xA2B9C2, 0xA2C280, 0xA2DA6A, 0xA2EBBE, 0xA2F354, 0xA306B6, 0xA31E5C, 
	0xA32F88, 0xA33762, 0xA34C20, 0xA354CA, 0xA3651E, 0xA37DF4, 0xA38B70, 0xA3939A, 0xA3A24E, 0xA3BAA4, 
	0xA3C1E6, 0xA3D90C, 0xA3E8D8, 0xA3F032, 0xA40E84, 0xA4166E, 0xA427BA, 0xA43F50, 0xA44412, 0xA45CF8, 
	0xA46D2C, 0xA475C6, 0xA48342, 0xA49BA8, 0xA4AA7C, 0xA4B296, 0xA4C9D4, 0xA4D13E, 0xA4E0EA, 0xA4F800, 
	0xA50DE2, 0xA51508, 0xA524DC, 0xA53C36, 0xA54774, 0xA55F9E, 0xA56E4A, 0xA576A0, 0xA58024, 0xA598CE, 
	0xA5A91A, 0xA5B1F0, 0xA5CAB2, 0xA5D258, 0xA5E38C, 0xA5FB66, 0xA60848, 0xA610A2, 0xA62176, 0xA6399C, 
	0xA642DE, 0xA65A34, 0xA66BE0, 0xA6730A, 0xA6858E, 0xA69D64, 0xA6ACB0, 0xA6B45A, 0xA6CF18, 0xA6D7F2, 
	0xA6E626, 0xA6FECC, 0xA70B2E, 0xA713C4, 0xA72210, 0xA73AFA, 0xA741B8, 0xA75952, 0xA76886, 0xA7706C, 
	0xA786E8, 0xA79E02, 0xA7AFD6, 0xA7B73C, 0xA7CC7E, 0xA7D494, 0xA7E540, 0xA7FDAA, 0xA800C6, 0xA8182C, 
	0xA829F8, 0xA83112, 0xA84A50, 0xA852BA, 0xA8636E, 0xA87B84, 0xA88D00, 0xA895EA, 0xA8A43E, 0xA8BCD4, 
	0xA8C796, 0xA8DF7C, 0xA8EEA8, 0xA8F642, 0xA903A0, 0xA91B4A, 0xA92A9E, 0xA93274, 0xA94936, 0xA951DC, 
	0xA96008, 0xA978E2, 0xA98E66, 0xA9968C, 0xA9A758, 0xA9BFB2, 0xA9C4F0, 0xA9DC1A, 0xA9EDCE, 0xA9F524, 
	0xAA060A, 0xAA1EE0, 0xAA2F34, 0xAA37DE, 0xAA4C9C, 0xAA5476, 0xAA65A2, 0xAA7D48, 0xAA8BCC, 0xAA9326, 
	0xAAA2F2, 0xAABA18, 0xAAC15A, 0xAAD9B0, 0xAAE864, 0xAAF08E, 0xAB056C, 0xAB1D86, 0xAB2C52, 0xAB34B8, 
	0xAB4FFA, 0xAB5710, 0xAB66C4, 0xAB7E2E, 0xAB88AA, 0xAB9040, 0xABA194, 0xABB97E, 0xABC23C, 0xABDAD6, 
	0xABEB02, 0xABF3E8, 0xAC0D5E, 0xAC15B4, 0xAC2460, 0xAC3C8A, 0xAC47C8, 0xAC5F22, 0xAC6EF6, 0xAC761C, 
	0xAC8098, 0xAC9872, 0xACA9A6, 0xACB14C, 0xACCA0E, 0xACD2E4, 0xACE330, 0xACFBDA, 0xAD0E38, 0xAD16D2, 
	0xAD2706, 0xAD3FEC, 0xAD44AE, 0xAD5C44, 0xAD6D90, 0xAD757A, 0xAD83FE, 0xAD9B14, 0xADAAC0, 0xADB22A, 
	0xADC968, 0xADD182, 0xADE056, 0xADF8BC, 0xAE0B92, 0xAE1378, 0xAE22AC, 0xAE3A46, 0xAE4104, 0xAE59EE, 
	0xAE683A, 0xAE70D0, 0xAE8654, 0xAE9EBE, 0xAEAF6A, 0xAEB780, 0xAECCC2, 0xAED428, 0xAEE5FC, 0xAEFD16, 
	0xAF08F4, 0xAF101E, 0xAF21CA, 0xAF3920, 0xAF4262, 0xAF5A88, 0xAF6B5C, 0xAF73B6, 0xAF8532, 0xAF9DD8, 
	0xAFAC0C, 0xAFB4E6, 0xAFCFA4, 0xAFD74E, 0xAFE69A, 0xAFFE70, 0xB004A8, 0xB01C42, 0xB02D96, 0xB0357C, 
	0xB04E3E, 0xB056D4, 0xB06700, 0xB07FEA, 0xB0896E, 0xB09184, 0xB0A050, 0xB0B8BA, 0xB0C3F8, 0xB0DB12, 
	0xB0EAC6, 0xB0F22C, 0xB107CE, 0xB11F24, 0xB12EF0, 0xB1361A, 0xB14D58, 0xB155B2, 0xB16466, 0xB17C8C, 
	0xB18A08, 0xB192E2, 0xB1A336, 0xB1BBDC, 0xB1C09E, 0xB1D874, 0xB1E9A0, 0xB1F14A, 0xB20264, 0xB21A8E, 
	0xB22B5A, 0xB233B0, 0xB248F2, 0xB25018, 0xB261CC, 0xB27926, 0xB28FA2, 0xB29748, 0xB2A69C, 0xB2BE76, 
	0xB2C534, 0xB2DDDE, 0xB2EC0A, 0xB2F4E0, 0xB30102, 0xB319E8, 0xB3283C, 0xB330D6, 0xB34B94, 0xB3537E, 
	0xB362AA, 0xB37A40, 0xB38CC4, 0xB3942E, 0xB3A5FA, 0xB3BD10, 0xB3C652, 0xB3DEB8, 0xB3EF6C, 0xB3F786, 
	0xB40930, 0xB411DA, 0xB4200E, 0xB438E4, 0xB443A6, 0xB45B4C, 0xB46A98, 0xB47272, 0xB484F6, 0xB49C1C, 
	0xB4ADC8, 0xB4B522, 0xB4CE60, 0xB4D68A, 0xB4E75E, 0xB4FFB4, 0xB50A56, 0xB512BC, 0xB52368, 0xB53B82, 
	0xB540C0, 0xB5582A, 0xB569FE, 0xB57114, 0xB58790, 0xB59F7A, 0xB5AEAE, 0xB5B644, 0xB5CD06, 0xB5D5EC, 
	0xB5E438, 0xB5FCD2, 0xB60FFC, 0xB61716, 0xB626C2, 0xB63E28, 0xB6456A, 0xB65D80, 0xB66C54, 0xB674BE, 
	0xB6823A, 0xB69AD0, 0xB6AB04, 0xB6B3EE, 0xB6C8AC, 0xB6D046, 0xB6E192, 0xB6F978, 0xB70C9A, 0xB71470, 
	0xB725A4, 0xB73D4E, 0xB7460C, 0xB75EE6, 0xB76F32, 0xB777D8, 0xB7815C, 0xB799B6, 0xB7A862, 0xB7B088, 
	0xB7CBCA, 0xB7D320, 0xB7E2F4, 0xB7FA1E, 0xB80772, 0xB81F98, 0xB82E4C, 0xB836A6, 0xB84DE4, 0xB8550E, 
	0xB864DA, 0xB87C30, 0xB88AB4, 0xB8925E, 0xB8A38A, 0xB8BB60, 0xB8C022, 0xB8D8C8, 0xB8E91C, 0xB8F1F6, 
	0xB90414, 0xB91CFE, 0xB92D2A, 0xB935C0, 0xB94E82, 0xB95668, 0xB967BC, 0xB97F56, 0xB989D2, 0xB99138, 
	0xB9A0EC, 0xB9B806, 0xB9C344, 0xB9DBAE, 0xB9EA7A, 0xB9F290, 0xBA01BE, 0xBA1954, 0xBA2880, 0xBA306A, 
	0xBA4B28, 0xBA53C2, 0xBA6216, 0xBA7AFC, 0xBA8C78, 0xBA9492, 0xBAA546, 0xBABDAC, 0xBAC6EE, 0xBADE04, 
	0xBAEFD0, 0xBAF73A, 0xBB02D8, 0xBB1A32, 0xBB2BE6, 0xBB330C, 0xBB484E, 0xBB50A4, 0xBB6170, 0xBB799A, 
	0xBB8F1E, 0xBB97F4, 0xBBA620, 0xBBBECA, 0xBBC588, 0xBBDD62, 0xBBECB6, 0xBBF45C, 0xBC0AEA, 0xBC1200, 
	0xBC23D4, 0xBC3B3E, 0xBC407C, 0xBC5896, 0xBC6942, 0xBC71A8, 0xBC872C, 0xBC9FC6, 0xBCAE12, 0xBCB6F8, 
	0xBCCDBA, 0xBCD550, 0xBCE484, 0xBCFC6E, 0xBD098C, 0xBD1166, 0xBD20B2, 0xBD3858, 0xBD431A, 0xBD5BF0, 
	0xBD6A24, 0xBD72CE, 0xBD844A, 0xBD9CA0, 0xBDAD74, 0xBDB59E, 0xBDCEDC, 0xBDD636, 0xBDE7E2, 0xBDFF08, 
	0xBE0C26, 0xBE14CC, 0xBE2518, 0xBE3DF2, 0xBE46B0, 0xBE5E5A, 0xBE6F8E, 0xBE7764, 0xBE81E0, 0xBE990A, 
	0xBEA8DE, 0xBEB034, 0xBECB76, 0xBED39C, 0xBEE248, 0xBEFAA2, 0xBF0F40, 0xBF17AA, 0xBF267E, 0xBF3E94, 
	0xBF45D6, 0xBF5D3C, 0xBF6CE8, 0xBF7402, 0xBF8286, 0xBF9A6C, 0xBFABB8, 0xBFB352, 0xBFC810, 0xBFD0FA, 
	0xBFE12E, 0xBFF9C4, 0xC00A4E, 0xC012A4, 0xC02370, 0xC03B9A, 0xC040D8, 0xC05832, 0xC069E6, 0xC0710C, 
	0xC08788, 0xC09F62, 0xC0AEB6, 0xC0B65C, 0xC0CD1E, 0xC0D5F4, 0xC0E420, 0xC0FCCA, 0xC10928, 0xC111C2, 
	0xC12016, 0xC138FC, 0xC143BE, 0xC15B54, 0xC16A80, 0xC1726A, 0xC184EE, 0xC19C04, 0xC1ADD0, 0xC1B53A, 
	0xC1CE78, 0xC1D692, 0xC1E746, 0xC1FFAC, 0xC20C82, 0xC21468, 0xC225BC, 0xC23D56, 0xC24614, 0xC25EFE, 
	0xC26F2A, 0xC277C0, 0xC28144, 0xC299AE, 0xC2A87A, 0xC2B090, 0xC2CBD2, 0xC2D338, 0xC2E2EC, 0xC2FA06, 
	0xC30FE4, 0xC3170E, 0xC326DA, 0xC33E30, 0xC34572, 0xC35D98, 0xC36C4C, 0xC374A6, 0xC38222, 0xC39AC8, 
	0xC3AB1C, 0xC3B3F6, 0xC3C8B4, 0xC3D05E, 0xC3E18A, 0xC3F960, 0xC407D6, 0xC41F3C, 0xC42EE8, 0xC43602, 
	0xC44D40, 0xC455AA, 0xC4647E, 0xC47C94, 0xC48A10, 0xC492FA, 0xC4A32E, 0xC4BBC4, 0xC4C086, 0xC4D86C, 
	0xC4E9B8, 0xC4F152, 0xC504B0, 0xC51C5A, 0xC52D8E, 0xC53564, 0xC54E26, 0xC556CC, 0xC56718, 0xC57FF2, 
	0xC58976, 0xC5919C, 0xC5A048, 0xC5B8A2, 0xC5C3E0, 0xC5DB0A, 0xC5EADE, 0xC5F234, 0xC6011A, 0xC619F0, 
	0xC62824, 0xC630CE, 0xC64B8C, 0xC65366, 0xC662B2, 0xC67A58, 0xC68CDC, 0xC69436, 0xC6A5E2, 0xC6BD08, 
	0xC6C64A, 0xC6DEA0, 0xC6EF74, 0xC6F79E, 0xC7027C, 0xC71A96, 0xC72B42, 0xC733A8, 0xC748EA, 0xC75000, 
	0xC761D4, 0xC7793E, 0xC78FBA, 0xC79750, 0xC7A684, 0xC7BE6E, 0xC7C52C, 0xC7DDC6, 0xC7EC12, 0xC7F4F8, 
	0xC80994, 0xC8117E, 0xC820AA, 0xC83840, 0xC84302, 0xC85BE8, 0xC86A3C, 0xC872D6, 0xC88452, 0xC89CB8, 
	0xC8AD6C, 0xC8B586, 0xC8CEC4, 0xC8D62E, 0xC8E7FA, 0xC8FF10, 0xC90AF2, 0xC91218, 0xC923CC, 0xC93B26, 
	0xC94064, 0xC9588E, 0xC9695A, 0xC971B0, 0xC98734, 0xC99FDE, 0xC9AE0A, 0xC9B6E0, 0xC9CDA2, 0xC9D548, 
	0xC9E49C, 0xC9FC76, 0xCA0F58, 0xCA17B2, 0xCA2666, 0xCA3E8C, 0xCA45CE, 0xCA5D24, 0xCA6CF0, 0xCA741A, 
	0xCA829E, 0xCA9A74, 0xCAABA0, 0xCAB34A, 0xCAC808, 0xCAD0E2, 0xCAE136, 0xCAF9DC, 0xCB0C3E, 0xCB14D4, 
	0xCB2500, 0xCB3DEA, 0xCB46A8, 0xCB5E42, 0xCB6F96, 0xCB777C, 0xCB81F8, 0xCB9912, 0xCBA8C6, 0xCBB02C, 
	0xCBCB6E, 0xCBD384, 0xCBE250, 0xCBFABA, 0xCC040C, 0xCC1CE6, 0xCC2D32, 0xCC35D8, 0xCC4E9A, 0xCC5670, 
	0xCC67A4, 0xCC7F4E, 0xCC89CA, 0xCC9120, 0xCCA0F4, 0xCCB81E, 0xCCC35C, 0xCCDBB6, 0xCCEA62, 0xCCF288, 
	0xCD076A, 0xCD1F80, 0xCD2E54, 0xCD36BE, 0xCD4DFC, 0xCD5516, 0xCD64C2, 0xCD7C28, 0xCD8AAC, 0xCD9246, 
	0xCDA392, 0xCDBB78, 0xCDC03A, 0xCDD8D0, 0xCDE904, 0xCDF1EE, 0xCE02C0, 0xCE1A2A, 0xCE2BFE, 0xCE3314, 
	0xCE4856, 0xCE50BC, 0xCE6168, 0xCE7982, 0xCE8F06, 0xCE97EC, 0xCEA638, 0xCEBED2, 0xCEC590, 0xCEDD7A, 
	0xCEECAE, 0xCEF444, 0xCF01A6, 0xCF194C, 0xCF2898, 0xCF3072, 0xCF4B30, 0xCF53DA, 0xCF620E, 0xCF7AE4, 
	0xCF8C60, 0xCF948A, 0xCFA55E, 0xCFBDB4, 0xCFC6F6, 0xCFDE1C, 0xCFEFC8, 0xCFF722, 0xD00DFA, 0xD01510, 
	0xD024C4, 0xD03C2E, 0xD0476C, 0xD05F86, 0xD06E52, 0xD076B8, 0xD0803C, 0xD098D6, 0xD0A902, 0xD0B1E8, 
	0xD0CAAA, 0xD0D240, 0xD0E394, 0xD0FB7E, 0xD10E9C, 0xD11676, 0xD127A2, 0xD13F48, 0xD1440A, 0xD15CE0, 
	0xD16D34, 0xD175DE, 0xD1835A, 0xD19BB0, 0xD1AA64, 0xD1B28E, 0xD1C9CC, 0xD1D126, 0xD1E0F2, 0xD1F818, 
	0xD20B36, 0xD213DC, 0xD22208, 0xD23AE2, 0xD241A0, 0xD2594A, 0xD2689E, 0xD27074, 0xD286F0, 0xD29E1A, 
	0xD2AFCE, 0xD2B724, 0xD2CC66, 0xD2D48C, 0xD2E558, 0xD2FDB2, 0xD30850, 0xD310BA, 0xD3216E, 0xD33984, 
	0xD342C6, 0xD35A2C, 0xD36BF8, 0xD37312, 0xD38596, 0xD39D7C, 0xD3ACA8, 0xD3B442, 0xD3CF00, 0xD3D7EA, 
	0xD3E63E, 0xD3FED4, 0xD40062, 0xD41888, 0xD4295C, 0xD431B6, 0xD44AF4, 0xD4521E, 0xD463CA, 0xD47B20, 
	0xD48DA4, 0xD4954E, 0xD4A49A, 0xD4BC70, 0xD4C732, 0xD4DFD8, 0xD4EE0C, 0xD4F6E6, 0xD50304, 0xD51BEE, 
	0xD52A3A, 0xD532D0, 0xD54992, 0xD55178, 0xD560AC, 0xD57846, 0xD58EC2, 0xD59628, 0xD5A7FC, 0xD5BF16, 
	0xD5C454, 0xD5DCBE, 0xD5ED6A, 0xD5F580, 0xD606AE, 0xD61E44, 0xD62F90, 0xD6377A, 0xD64C38, 0xD654D2, 
	0xD66506, 0xD67DEC, 0xD68B68, 0xD69382, 0xD6A256, 0xD6BABC, 0xD6C1FE, 0xD6D914, 0xD6E8C0, 0xD6F02A, 
	0xD705C8, 0xD71D22, 0xD72CF6, 0xD7341C, 0xD74F5E, 0xD757B4, 0xD76660, 0xD77E8A, 0xD7880E, 0xD790E4, 
	0xD7A130, 0xD7B9DA, 0xD7C298, 0xD7DA72, 0xD7EBA6, 0xD7F34C, 0xD80E20, 0xD816CA, 0xD8271E, 0xD83FF4, 
	0xD844B6, 0xD85C5C, 0xD86D88, 0xD87562, 0xD883E6, 0xD89B0C, 0xD8AAD8, 0xD8B232, 0xD8C970, 0xD8D19A, 
	0xD8E04E, 0xD8F8A4, 0xD90D46, 0xD915AC, 0xD92478, 0xD93C92, 0xD947D0, 0xD95F3A, 0xD96EEE, 0xD97604, 
	0xD98080, 0xD9986A, 0xD9A9BE, 0xD9B154, 0xD9CA16, 0xD9D2FC, 0xD9E328, 0xD9FBC2, 0xDA08EC, 0xDA1006, 
	0xDA21D2, 0xDA3938, 0xDA427A, 0xDA5A90, 0xDA6B44, 0xDA73AE, 0xDA852A, 0xDA9DC0, 0xDAAC14, 0xDAB4FE, 
	0xDACFBC, 0xDAD756, 0xDAE682, 0xDAFE68, 0xDB0B8A, 0xDB1360, 0xDB22B4, 0xDB3A5E, 0xDB411C, 0xDB59F6, 
	0xDB6822, 0xDB70C8, 0xDB864C, 0xDB9EA6, 0xDBAF72, 0xDBB798, 0xDBCCDA, 0xDBD430, 0xDBE5E4, 0xDBFD0E, 
	0xDC03B8, 0xDC1B52, 0xDC2A86, 0xDC326C, 0xDC492E, 0xDC51C4, 0xDC6010, 0xDC78FA, 0xDC8E7E, 0xDC9694, 
	0xDCA740, 0xDCBFAA, 0xDCC4E8, 0xDCDC02, 0xDCEDD6, 0xDCF53C, 0xDD00DE, 0xDD1834, 0xDD29E0, 0xDD310A, 
	0xDD4A48, 0xDD52A2, 0xDD6376, 0xDD7B9C, 0xDD8D18, 0xDD95F2, 0xDDA426, 0xDDBCCC, 0xDDC78E, 0xDDDF64, 
	0xDDEEB0, 0xDDF65A, 0xDE0574, 0xDE1D9E, 0xDE2C4A, 0xDE34A0, 0xDE4FE2, 0xDE5708, 0xDE66DC, 0xDE7E36, 
	0xDE88B2, 0xDE9058, 0xDEA18C, 0xDEB966, 0xDEC224, 0xDEDACE, 0xDEEB1A, 0xDEF3F0, 0xDF0612, 0xDF1EF8, 
	0xDF2F2C, 0xDF37C6, 0xDF4C84, 0xDF546E, 0xDF65BA, 0xDF7D50, 0xDF8BD4, 0xDF933E, 0xDFA2EA, 0xDFBA00, 
	0xDFC142, 0xDFD9A8, 0xDFE87C, 0xDFF096, 0xE00526, 0xE01DCC, 0xE02C18, 0xE034F2, 0xE04FB0, 0xE0575A, 
	0xE0668E, 0xE07E64, 0xE088E0, 0xE0900A, 0xE0A1DE, 0xE0B934, 0xE0C276, 0xE0DA9C, 0xE0EB48, 0xE0F3A2, 
	0xE10640, 0xE11EAA, 0xE12F7E, 0xE13794, 0xE14CD6, 0xE1543C, 0xE165E8, 0xE17D02, 0xE18B86, 0xE1936C, 
	0xE1A2B8, 0xE1BA52, 0xE1C110, 0xE1D9FA, 0xE1E82E, 0xE1F0C4, 0xE203EA, 0xE21B00, 0xE22AD4, 0xE2323E, 
	0xE2497C, 0xE25196, 0xE26042, 0xE278A8, 0xE28E2C, 0xE296C6, 0xE2A712, 0xE2BFF8, 0xE2C4BA, 0xE2DC50, 
	0xE2ED84, 0xE2F56E, 0xE3008C, 0xE31866, 0xE329B2, 0xE33158, 0xE34A1A, 0xE352F0, 0xE36324, 0xE37BCE, 
	0xE38D4A, 0xE395A0, 0xE3A474, 0xE3BC9E, 0xE3C7DC, 0xE3DF36, 0xE3EEE2, 0xE3F608, 0xE408BE, 0xE41054, 
	0xE42180, 0xE4396A, 0xE44228, 0xE45AC2, 0xE46B16, 0xE473FC, 0xE48578, 0xE49D92, 0xE4AC46, 0xE4B4AC, 
	0xE4CFEE, 0xE4D704, 0xE4E6D0, 0xE4FE3A, 0xE50BD8, 0xE51332, 0xE522E6, 0xE53A0C, 0xE5414E, 0xE559A4, 
	0xE56870, 0xE5709A, 0xE5861E, 0xE59EF4, 0xE5AF20, 0xE5B7CA, 0xE5CC88, 0xE5D462, 0xE5E5B6, 0xE5FD5C, 
	0xE60E72, 0xE61698, 0xE6274C, 0xE63FA6, 0xE644E4, 0xE65C0E, 0xE66DDA, 0xE67530, 0xE683B4, 0xE69B5E, 
	0xE6AA8A, 0xE6B260, 0xE6C922, 0xE6D1C8, 0xE6E01C, 0xE6F8F6, 0xE70D14, 0xE715FE, 0xE7242A, 0xE73CC0, 
	0xE74782, 0xE75F68, 0xE76EBC, 0xE77656, 0xE780D2, 0xE79838, 0xE7A9EC, 0xE7B106, 0xE7CA44, 0xE7D2AE, 
	0xE7E37A, 0xE7FB90, 0xE806FC, 0xE81E16, 0xE82FC2, 0xE83728, 0xE84C6A, 0xE85480, 0xE86554, 0xE87DBE, 
	0xE88B3A, 0xE893D0, 0xE8A204, 0xE8BAEE, 0xE8C1AC, 0xE8D946, 0xE8E892, 0xE8F078, 0xE9059A, 0xE91D70, 
	0xE92CA4, 0xE9344E, 0xE94F0C, 0xE957E6, 0xE96632, 0xE97ED8, 0xE9885C, 0xE990B6, 0xE9A162, 0xE9B988, 
	0xE9C2CA, 0xE9DA20, 0xE9EBF4, 0xE9F31E, 0xEA0030, 0xEA18DA, 0xEA290E, 0xEA31E4, 0xEA4AA6, 0xEA524C, 
	0xEA6398, 0xEA7B72, 0xEA8DF6, 0xEA951C, 0xEAA4C8, 0xEABC22, 0xEAC760, 0xEADF8A, 0xEAEE5E, 0xEAF6B4, 
	0xEB0356, 0xEB1BBC, 0xEB2A68, 0xEB3282, 0xEB49C0, 0xEB512A, 0xEB60FE, 0xEB7814, 0xEB8E90, 0xEB967A, 
	0xEBA7AE, 0xEBBF44, 0xEBC406, 0xEBDCEC, 0xEBED38, 0xEBF5D2, 0xEC0B64, 0xEC138E, 0xEC225A, 0xEC3AB0, 
	0xEC41F2, 0xEC5918, 0xEC68CC, 0xEC7026, 0xEC86A2, 0xEC9E48, 0xECAF9C, 0xECB776, 0xECCC34, 0xECD4DE, 
	0xECE50A, 0xECFDE0, 0xED0802, 0xED10E8, 0xED213C, 0xED39D6, 0xED4294, 0xED5A7E, 0xED6BAA, 0xED7340, 
	0xED85C4, 0xED9D2E, 0xEDACFA, 0xEDB410, 0xEDCF52, 0xEDD7B8, 0xEDE66C, 0xEDFE86, 0xEE0DA8, 0xEE1542, 
	0xEE2496, 0xEE3C7C, 0xEE473E, 0xEE5FD4, 0xEE6E00, 0xEE76EA, 0xEE806E, 0xEE9884, 0xEEA950, 0xEEB1BA, 
	0xEECAF8, 0xEED212, 0xEEE3C6, 0xEEFB2C, 0xEF0ECE, 0xEF1624, 0xEF27F0, 0xEF3F1A, 0xEF4458, 0xEF5CB2, 
	0xEF6D66, 0xEF758C, 0xEF8308, 0xEF9BE2, 0xEFAA36, 0xEFB2DC, 0xEFC99E, 0xEFD174, 0xEFE0A0, 0xEFF84A, 
	0xF00292, 0xF01A78, 0xF02BAC, 0xF03346, 0xF04804, 0xF050EE, 0xF0613A, 0xF079D0, 0xF08F54, 0xF097BE, 
	0xF0A66A, 0xF0BE80, 0xF0C5C2, 0xF0DD28, 0xF0ECFC, 0xF0F416, 0xF101F4, 0xF1191E, 0xF128CA, 0xF13020, 
	0xF14B62, 0xF15388, 0xF1625C, 0xF17AB6, 0xF18C32, 0xF194D8, 0xF1A50C, 0xF1BDE6, 0xF1C6A4, 0xF1DE4E, 
	0xF1EF9A, 0xF1F770, 0xF2045E, 0xF21CB4, 0xF22D60, 0xF2358A, 0xF24EC8, 0xF25622, 0xF267F6, 0xF27F1C, 
	0xF28998, 0xF29172, 0xF2A0A6, 0xF2B84C, 0xF2C30E, 0xF2DBE4, 0xF2EA30, 0xF2F2DA, 0xF30738, 0xF31FD2, 
	0xF32E06, 0xF336EC, 0xF34DAE, 0xF35544, 0xF36490, 0xF37C7A, 0xF38AFE, 0xF39214, 0xF3A3C0, 0xF3BB2A, 
	0xF3C068, 0xF3D882, 0xF3E956, 0xF3F1BC, 0xF40F0A, 0xF417E0, 0xF42634, 0xF43EDE, 0xF4459C, 0xF45D76, 
	0xF46CA2, 0xF47448, 0xF482CC, 0xF49A26, 0xF4ABF2, 0xF4B318, 0xF4C85A, 0xF4D0B0, 0xF4E164, 0xF4F98E, 
	0xF50C6C, 0xF51486, 0xF52552, 0xF53DB8, 0xF546FA, 0xF55E10, 0xF56FC4, 0xF5772E, 0xF581AA, 0xF59940, 
	0xF5A894, 0xF5B07E, 0xF5CB3C, 0xF5D3D6, 0xF5E202, 0xF5FAE8, 0xF609C6, 0xF6112C, 0xF620F8, 0xF63812, 
	0xF64350, 0xF65BBA, 0xF66A6E, 0xF67284, 0xF68400, 0xF69CEA, 0xF6AD3E, 0xF6B5D4, 0xF6CE96, 0xF6D67C, 
	0xF6E7A8, 0xF6FF42, 0xF70AA0, 0xF7124A, 0xF7239E, 0xF73B74, 0xF74036, 0xF758DC, 0xF76908, 0xF771E2, 
	0xF78766, 0xF79F8C, 0xF7AE58, 0xF7B6B2, 0xF7CDF0, 0xF7D51A, 0xF7E4CE, 0xF7FC24, 0xF80148, 0xF819A2, 
	0xF82876, 0xF8309C, 0xF84BDE, 0xF85334, 0xF862E0, 0xF87A0A, 0xF88C8E, 0xF89464, 0xF8A5B0, 0xF8BD5A, 
	0xF8C618, 0xF8DEF2, 0xF8EF26, 0xF8F7CC, 0xF9022E, 0xF91AC4, 0xF92B10, 0xF933FA, 0xF948B8, 0xF95052, 
	0xF96186, 0xF9796C, 0xF98FE8, 0xF99702, 0xF9A6D6, 0xF9BE3C, 0xF9C57E, 0xF9DD94, 0xF9EC40, 0xF9F4AA, 
	0xFA0784, 0xFA1F6E, 0xFA2EBA, 0xFA3650, 0xFA4D12, 0xFA55F8, 0xFA642C, 0xFA7CC6, 0xFA8A42, 0xFA92A8, 
	0xFAA37C, 0xFABB96, 0xFAC0D4, 0xFAD83E, 0xFAE9EA, 0xFAF100, 0xFB04E2, 0xFB1C08, 0xFB2DDC, 0xFB3536, 
	0xFB4E74, 0xFB569E, 0xFB674A, 0xFB7FA0, 0xFB8924, 0xFB91CE, 0xFBA01A, 0xFBB8F0, 0xFBC3B2, 0xFBDB58, 
	0xFBEA8C, 0xFBF266, 0xFC0CD0, 0xFC143A, 0xFC25EE, 0xFC3D04, 0xFC4646, 0xFC5EAC, 0xFC6F78, 0xFC7792, 
	0xFC8116, 0xFC99FC, 0xFCA828, 0xFCB0C2, 0xFCCB80, 0xFCD36A, 0xFCE2BE, 0xFCFA54, 0xFD0FB6, 0xFD175C, 
	0xFD2688, 0xFD3E62, 0xFD4520, 0xFD5DCA, 0xFD6C1E, 0xFD74F4, 0xFD8270, 0xFD9A9A, 0xFDAB4E, 0xFDB3A4, 
	0xFDC8E6, 0xFDD00C, 0xFDE1D8, 0xFDF932, 0xFE0A1C, 0xFE12F6, 0xFE2322, 0xFE3BC8, 0xFE408A, 0xFE5860, 
	0xFE69B4, 0xFE715E, 0xFE87DA, 0xFE9F30, 0xFEAEE4, 0xFEB60E, 0xFECD4C, 0xFED5A6, 0xFEE472, 0xFEFC98, 
	0xFF097A, 0xFF1190, 0xFF2044, 0xFF38AE, 0xFF43EC, 0xFF5B06, 0xFF6AD2, 0xFF7238, 0xFF84BC, 0xFF9C56, 
	0xFFAD82, 0xFFB568, 0xFFCE2A, 0xFFD6C0, 0xFFE714, 0xFFFFFE)

ENCODE_24128 = (
	0x000000, 0x0018EB, 0x00293E, 0x0031D5, 0x004A97, 0x00527C, 0x0063A9, 0x007B42, 0x008DC6, 0x00952D, 
	0x00A4F8, 0x00BC13, 0x00C751, 0x00DFBA, 0x00EE6F, 0x00F684, 0x010367, 0x011B8C, 0x012A59, 0x0132B2, 
	0x0149F0, 0x01511B, 0x0160CE, 0x017825, 0x018EA1, 0x01964A, 0x01A79F, 0x01BF74, 0x01C436, 0x01DCDD, 
	0x01ED08, 0x01F5E3, 0x0206CD, 0x021E26, 0x022FF3, 0x023718, 0x024C5A, 0x0254B1, 0x026564, 0x027D8F, 
	0x028B0B, 0x0293E0, 0x02A235, 0x02BADE, 0x02C19C, 0x02D977, 0x02E8A2, 0x02F049, 0x0305AA, 0x031D41, 
	0x032C94, 0x03347F, 0x034F3D, 0x0357D6, 0x036603, 0x037EE8, 0x03886C, 0x039087, 0x03A152, 0x03B9B9, 
	0x03C2FB, 0x03DA10, 0x03EBC5, 0x03F32E, 0x040D99, 0x041572, 0x0424A7, 0x043C4C, 0x04470E, 0x045FE5, 
	0x046E30, 0x0476DB, 0x04805F, 0x0498B4, 0x04A961, 0x04B18A, 0x04CAC8, 0x04D223, 0x04E3F6, 0x04FB1D, 
	0x050EFE, 0x051615, 0x0527C0, 0x053F2B, 0x054469, 0x055C82, 0x056D57, 0x0575BC, 0x058338, 0x059BD3, 
	0x05AA06, 0x05B2ED, 0x05C9AF, 0x05D144, 0x05E091, 0x05F87A, 0x060B54, 0x0613BF, 0x06226A, 0x063A81, 
	0x0641C3, 0x065928, 0x0668FD, 0x067016, 0x068692, 0x069E79, 0x06AFAC, 0x06B747, 0x06CC05, 0x06D4EE, 
	0x06E53B, 0x06FDD0, 0x070833, 0x0710D8, 0x07210D, 0x0739E6, 0x0742A4, 0x075A4F, 0x076B9A, 0x077371, 
	0x0785F5, 0x079D1E, 0x07ACCB, 0x07B420, 0x07CF62, 0x07D789, 0x07E65C, 0x07FEB7, 0x0803DA, 0x081B31, 
	0x082AE4, 0x08320F, 0x08494D, 0x0851A6, 0x086073, 0x087898, 0x088E1C, 0x0896F7, 0x08A722, 0x08BFC9, 
	0x08C48B, 0x08DC60, 0x08EDB5, 0x08F55E, 0x0900BD, 0x091856, 0x092983, 0x093168, 0x094A2A, 0x0952C1, 
	0x096314, 0x097BFF, 0x098D7B, 0x099590, 0x09A445, 0x09BCAE, 0x09C7EC, 0x09DF07, 0x09EED2, 0x09F639, 
	0x0A0517, 0x0A1DFC, 0x0A2C29, 0x0A34C2, 0x0A4F80, 0x0A576B, 0x0A66BE, 0x0A7E55, 0x0A88D1, 0x0A903A, 
	0x0AA1EF, 0x0AB904, 0x0AC246, 0x0ADAAD, 0x0AEB78, 0x0AF393, 0x0B0670, 0x0B1E9B, 0x0B2F4E, 0x0B37A5, 
	0x0B4CE7, 0x0B540C, 0x0B65D9, 0x0B7D32, 0x0B8BB6, 0x0B935D, 0x0BA288, 0x0BBA63, 0x0BC121, 0x0BD9CA, 
	0x0BE81F, 0x0BF0F4, 0x0C0E43, 0x0C16A8, 0x0C277D, 0x0C3F96, 0x0C44D4, 0x0C5C3F, 0x0C6DEA, 0x0C7501, 
	0x0C8385, 0x0C9B6E, 0x0CAABB, 0x0CB250, 0x0CC912, 0x0CD1F9, 0x0CE02C, 0x0CF8C7, 0x0D0D24, 0x0D15CF, 
	0x0D241A, 0x0D3CF1, 0x0D47B3, 0x0D5F58, 0x0D6E8D, 0x0D7666, 0x0D80E2, 0x0D9809, 0x0DA9DC, 0x0DB137, 
	0x0DCA75, 0x0DD29E, 0x0DE34B, 0x0DFBA0, 0x0E088E, 0x0E1065, 0x0E21B0, 0x0E395B, 0x0E4219, 0x0E5AF2, 
	0x0E6B27, 0x0E73CC, 0x0E8548, 0x0E9DA3, 0x0EAC76, 0x0EB49D, 0x0ECFDF, 0x0ED734, 0x0EE6E1, 0x0EFE0A, 
	0x0F0BE9, 0x0F1302, 0x0F22D7, 0x0F3A3C, 0x0F417E, 0x0F5995, 0x0F6840, 0x0F70AB, 0x0F862F, 0x0F9EC4, 
	0x0FAF11, 0x0FB7FA, 0x0FCCB8, 0x0FD453, 0x0FE586, 0x0FFD6D, 0x1007B4, 0x101F5F, 0x102E8A, 0x103661, 
	0x104D23, 0x1055C8, 0x10641D, 0x107CF6, 0x108A72, 0x109299, 0x10A34C, 0x10BBA7, 0x10C0E5, 0x10D80E, 
	0x10E9DB, 0x10F130, 0x1104D3, 0x111C38, 0x112DED, 0x113506, 0x114E44, 0x1156AF, 0x11677A, 0x117F91, 
	0x118915, 0x1191FE, 0x11A02B, 0x11B8C0, 0x11C382, 0x11DB69, 0x11EABC, 0x11F257, 0x120179, 0x121992, 
	0x122847, 0x1230AC, 0x124BEE, 0x125305, 0x1262D0, 0x127A3B, 0x128CBF, 0x129454, 0x12A581, 0x12BD6A, 
	0x12C628, 0x12DEC3, 0x12EF16, 0x12F7FD, 0x13021E, 0x131AF5, 0x132B20, 0x1333CB, 0x134889, 0x135062, 
	0x1361B7, 0x13795C, 0x138FD8, 0x139733, 0x13A6E6, 0x13BE0D, 0x13C54F, 0x13DDA4, 0x13EC71, 0x13F49A, 
	0x140A2D, 0x1412C6, 0x142313, 0x143BF8, 0x1440BA, 0x145851, 0x146984, 0x14716F, 0x1487EB, 0x149F00, 
	0x14AED5, 0x14B63E, 0x14CD7C, 0x14D597, 0x14E442, 0x14FCA9, 0x15094A, 0x1511A1, 0x152074, 0x15389F, 
	0x1543DD, 0x155B36, 0x156AE3, 0x157208, 0x15848C, 0x159C67, 0x15ADB2, 0x15B559, 0x15CE1B, 0x15D6F0, 
	0x15E725, 0x15FFCE, 0x160CE0, 0x16140B, 0x1625DE, 0x163D35, 0x164677, 0x165E9C, 0x166F49, 0x1677A2, 
	0x168126, 0x1699CD, 0x16A818, 0x16B0F3, 0x16CBB1, 0x16D35A, 0x16E28F, 0x16FA64, 0x170F87, 0x17176C, 
	0x1726B9, 0x173E52, 0x174510, 0x175DFB, 0x176C2E, 0x1774C5, 0x178241, 0x179AAA, 0x17AB7F, 0x17B394, 
	0x17C8D6, 0x17D03D, 0x17E1E8, 0x17F903, 0x18046E, 0x181C85, 0x182D50, 0x1835BB, 0x184EF9, 0x185612, 
	0x1867C7, 0x187F2C, 0x1889A8, 0x189143, 0x18A096, 0x18B87D, 0x18C33F, 0x18DBD4, 0x18EA01, 0x18F2EA, 
	0x190709, 0x191FE2, 0x192E37, 0x1936DC, 0x194D9E, 0x195575, 0x1964A0, 0x197C4B, 0x198ACF, 0x199224, 
	0x19A3F1, 0x19BB1A, 0x19C058, 0x19D8B3, 0x19E966, 0x19F18D, 0x1A02A3, 0x1A1A48, 0x1A2B9D, 0x1A3376, 
	0x1A4834, 0x1A50DF, 0x1A610A, 0x1A79E1, 0x1A8F65, 0x1A978E, 0x1AA65B, 0x1ABEB0, 0x1AC5F2, 0x1ADD19, 
	0x1AECCC, 0x1AF427, 0x1B01C4, 0x1B192F, 0x1B28FA, 0x1B3011, 0x1B4B53, 0x1B53B8, 0x1B626D, 0x1B7A86, 
	0x1B8C02, 0x1B94E9, 0x1BA53C, 0x1BBDD7, 0x1BC695, 0x1BDE7E, 0x1BEFAB, 0x1BF740, 0x1C09F7, 0x1C111C, 
	0x1C20C9, 0x1C3822, 0x1C4360, 0x1C5B8B, 0x1C6A5E, 0x1C72B5, 0x1C8431, 0x1C9CDA, 0x1CAD0F, 0x1CB5E4, 
	0x1CCEA6, 0x1CD64D, 0x1CE798, 0x1CFF73, 0x1D0A90, 0x1D127B, 0x1D23AE, 0x1D3B45, 0x1D4007, 0x1D58EC, 
	0x1D6939, 0x1D71D2, 0x1D8756, 0x1D9FBD, 0x1DAE68, 0x1DB683, 0x1DCDC1, 0x1DD52A, 0x1DE4FF, 0x1DFC14, 
	0x1E0F3A, 0x1E17D1, 0x1E2604, 0x1E3EEF, 0x1E45AD, 0x1E5D46, 0x1E6C93, 0x1E7478, 0x1E82FC, 0x1E9A17, 
	0x1EABC2, 0x1EB329, 0x1EC86B, 0x1ED080, 0x1EE155, 0x1EF9BE, 0x1F0C5D, 0x1F14B6, 0x1F2563, 0x1F3D88, 
	0x1F46CA, 0x1F5E21, 0x1F6FF4, 0x1F771F, 0x1F819B, 0x1F9970, 0x1FA8A5, 0x1FB04E, 0x1FCB0C, 0x1FD3E7, 
	0x1FE232, 0x1FFAD9, 0x200F68, 0x201783, 0x202656, 0x203EBD, 0x2045FF, 0x205D14, 0x206CC1, 0x20742A, 
	0x2082AE, 0x209A45, 0x20AB90, 0x20B37B, 0x20C839, 0x20D0D2, 0x20E107, 0x20F9EC, 0x210C0F, 0x2114E4, 
	0x212531, 0x213DDA, 0x214698, 0x215E73, 0x216FA6, 0x21774D, 0x2181C9, 0x219922, 0x21A8F7, 0x21B01C, 
	0x21CB5E, 0x21D3B5, 0x21E260, 0x21FA8B, 0x2209A5, 0x22114E, 0x22209B, 0x223870, 0x224332, 0x225BD9, 
	0x226A0C, 0x2272E7, 0x228463, 0x229C88, 0x22AD5D, 0x22B5B6, 0x22CEF4, 0x22D61F, 0x22E7CA, 0x22FF21, 
	0x230AC2, 0x231229, 0x2323FC, 0x233B17, 0x234055, 0x2358BE, 0x23696B, 0x237180, 0x238704, 0x239FEF, 
	0x23AE3A, 0x23B6D1, 0x23CD93, 0x23D578, 0x23E4AD, 0x23FC46, 0x2402F1, 0x241A1A, 0x242BCF, 0x243324, 
	0x244866, 0x24508D, 0x246158, 0x2479B3, 0x248F37, 0x2497DC, 0x24A609, 0x24BEE2, 0x24C5A0, 0x24DD4B, 
	0x24EC9E, 0x24F475, 0x250196, 0x25197D, 0x2528A8, 0x253043, 0x254B01, 0x2553EA, 0x25623F, 0x257AD4, 
	0x258C50, 0x2594BB, 0x25A56E, 0x25BD85, 0x25C6C7, 0x25DE2C, 0x25EFF9, 0x25F712, 0x26043C, 0x261CD7, 
	0x262D02, 0x2635E9, 0x264EAB, 0x265640, 0x266795, 0x267F7E, 0x2689FA, 0x269111, 0x26A0C4, 0x26B82F, 
	0x26C36D, 0x26DB86, 0x26EA53, 0x26F2B8, 0x27075B, 0x271FB0, 0x272E65, 0x27368E, 0x274DCC, 0x275527, 
	0x2764F2, 0x277C19, 0x278A9D, 0x279276, 0x27A3A3, 0x27BB48, 0x27C00A, 0x27D8E1, 0x27E934, 0x27F1DF, 
	0x280CB2, 0x281459, 0x28258C, 0x283D67, 0x284625, 0x285ECE, 0x286F1B, 0x2877F0, 0x288174, 0x28999F, 
	0x28A84A, 0x28B0A1, 0x28CBE3, 0x28D308, 0x28E2DD, 0x28FA36, 0x290FD5, 0x29173E, 0x2926EB, 0x293E00, 
	0x294542, 0x295DA9, 0x296C7C, 0x297497, 0x298213, 0x299AF8, 0x29AB2D, 0x29B3C6, 0x29C884, 0x29D06F, 
	0x29E1BA, 0x29F951, 0x2A0A7F, 0x2A1294, 0x2A2341, 0x2A3BAA, 0x2A40E8, 0x2A5803, 0x2A69D6, 0x2A713D, 
	0x2A87B9, 0x2A9F52, 0x2AAE87, 0x2AB66C, 0x2ACD2E, 0x2AD5C5, 0x2AE410, 0x2AFCFB, 0x2B0918, 0x2B11F3, 
	0x2B2026, 0x2B38CD, 0x2B438F, 0x2B5B64, 0x2B6AB1, 0x2B725A, 0x2B84DE, 0x2B9C35, 0x2BADE0, 0x2BB50B, 
	0x2BCE49, 0x2BD6A2, 0x2BE777, 0x2BFF9C, 0x2C012B, 0x2C19C0, 0x2C2815, 0x2C30FE, 0x2C4BBC, 0x2C5357, 
	0x2C6282, 0x2C7A69, 0x2C8CED, 0x2C9406, 0x2CA5D3, 0x2CBD38, 0x2CC67A, 0x2CDE91, 0x2CEF44, 0x2CF7AF, 
	0x2D024C, 0x2D1AA7, 0x2D2B72, 0x2D3399, 0x2D48DB, 0x2D5030, 0x2D61E5, 0x2D790E, 0x2D8F8A, 0x2D9761, 
	0x2DA6B4, 0x2DBE5F, 0x2DC51D, 0x2DDDF6, 0x2DEC23, 0x2DF4C8, 0x2E07E6, 0x2E1F0D, 0x2E2ED8, 0x2E3633, 
	0x2E4D71, 0x2E559A, 0x2E644F, 0x2E7CA4, 0x2E8A20, 0x2E92CB, 0x2EA31E, 0x2EBBF5, 0x2EC0B7, 0x2ED85C, 
	0x2EE989, 0x2EF162, 0x2F0481, 0x2F1C6A, 0x2F2DBF, 0x2F3554, 0x2F4E16, 0x2F56FD, 0x2F6728, 0x2F7FC3, 
	0x2F8947, 0x2F91AC, 0x2FA079, 0x2FB892, 0x2FC3D0, 0x2FDB3B, 0x2FEAEE, 0x2FF205, 0x3008DC, 0x301037, 
	0x3021E2, 0x303909, 0x30424B, 0x305AA0, 0x306B75, 0x30739E, 0x30851A, 0x309DF1, 0x30AC24, 0x30B4CF, 
	0x30CF8D, 0x30D766, 0x30E6B3, 0x30FE58, 0x310BBB, 0x311350, 0x312285, 0x313A6E, 0x31412C, 0x3159C7, 
	0x316812, 0x3170F9, 0x31867D, 0x319E96, 0x31AF43, 0x31B7A8, 0x31CCEA, 0x31D401, 0x31E5D4, 0x31FD3F, 
	0x320E11, 0x3216FA, 0x32272F, 0x323FC4, 0x324486, 0x325C6D, 0x326DB8, 0x327553, 0x3283D7, 0x329B3C, 
	0x32AAE9, 0x32B202, 0x32C940, 0x32D1AB, 0x32E07E, 0x32F895, 0x330D76, 0x33159D, 0x332448, 0x333CA3, 
	0x3347E1, 0x335F0A, 0x336EDF, 0x337634, 0x3380B0, 0x33985B, 0x33A98E, 0x33B165, 0x33CA27, 0x33D2CC, 
	0x33E319, 0x33FBF2, 0x340545, 0x341DAE, 0x342C7B, 0x343490, 0x344FD2, 0x345739, 0x3466EC, 0x347E07, 
	0x348883, 0x349068, 0x34A1BD, 0x34B956, 0x34C214, 0x34DAFF, 0x34EB2A, 0x34F3C1, 0x350622, 0x351EC9, 
	0x352F1C, 0x3537F7, 0x354CB5, 0x35545E, 0x35658B, 0x357D60, 0x358BE4, 0x35930F, 0x35A2DA, 0x35BA31, 
	0x35C173, 0x35D998, 0x35E84D, 0x35F0A6, 0x360388, 0x361B63, 0x362AB6, 0x36325D, 0x36491F, 0x3651F4, 
	0x366021, 0x3678CA, 0x368E4E, 0x3696A5, 0x36A770, 0x36BF9B, 0x36C4D9, 0x36DC32, 0x36EDE7, 0x36F50C, 
	0x3700EF, 0x371804, 0x3729D1, 0x37313A, 0x374A78, 0x375293, 0x376346, 0x377BAD, 0x378D29, 0x3795C2, 
	0x37A417, 0x37BCFC, 0x37C7BE, 0x37DF55, 0x37EE80, 0x37F66B, 0x380B06, 0x3813ED, 0x382238, 0x383AD3, 
	0x384191, 0x38597A, 0x3868AF, 0x387044, 0x3886C0, 0x389E2B, 0x38AFFE, 0x38B715, 0x38CC57, 0x38D4BC, 
	0x38E569, 0x38FD82, 0x390861, 0x39108A, 0x39215F, 0x3939B4, 0x3942F6, 0x395A1D, 0x396BC8, 0x397323, 
	0x3985A7, 0x399D4C, 0x39AC99, 0x39B472, 0x39CF30, 0x39D7DB, 0x39E60E, 0x39FEE5, 0x3A0DCB, 0x3A1520, 
	0x3A24F5, 0x3A3C1E, 0x3A475C, 0x3A5FB7, 0x3A6E62, 0x3A7689, 0x3A800D, 0x3A98E6, 0x3AA933, 0x3AB1D8, 
	0x3ACA9A, 0x3AD271, 0x3AE3A4, 0x3AFB4F, 0x3B0EAC, 0x3B1647, 0x3B2792, 0x3B3F79, 0x3B443B, 0x3B5CD0, 
	0x3B6D05, 0x3B75EE, 0x3B836A, 0x3B9B81, 0x3BAA54, 0x3BB2BF, 0x3BC9FD, 0x3BD116, 0x3BE0C3, 0x3BF828, 
	0x3C069F, 0x3C1E74, 0x3C2FA1, 0x3C374A, 0x3C4C08, 0x3C54E3, 0x3C6536, 0x3C7DDD, 0x3C8B59, 0x3C93B2, 
	0x3CA267, 0x3CBA8C, 0x3CC1CE, 0x3CD925, 0x3CE8F0, 0x3CF01B, 0x3D05F8, 0x3D1D13, 0x3D2CC6, 0x3D342D, 
	0x3D4F6F, 0x3D5784, 0x3D6651, 0x3D7EBA, 0x3D883E, 0x3D90D5, 0x3DA100, 0x3DB9EB, 0x3DC2A9, 0x3DDA42, 
	0x3DEB97, 0x3DF37C, 0x3E0052, 0x3E18B9, 0x3E296C, 0x3E3187, 0x3E4AC5, 0x3E522E, 0x3E63FB, 0x3E7B10, 
	0x3E8D94, 0x3E957F, 0x3EA4AA, 0x3EBC41, 0x3EC703, 0x3EDFE8, 0x3EEE3D, 0x3EF6D6, 0x3F0335, 0x3F1BDE, 
	0x3F2A0B, 0x3F32E0, 0x3F49A2, 0x3F5149, 0x3F609C, 0x3F7877, 0x3F8EF3, 0x3F9618, 0x3FA7CD, 0x3FBF26, 
	0x3FC464, 0x3FDC8F, 0x3FED5A, 0x3FF5B1, 0x40063B, 0x401ED0, 0x402F05, 0x4037EE, 0x404CAC, 0x405447, 
	0x406592, 0x407D79, 0x408BFD, 0x409316, 0x40A2C3, 0x40BA28, 0x40C16A, 0x40D981, 0x40E854, 0x40F0BF, 
	0x41055C, 0x411DB7, 0x412C62, 0x413489, 0x414FCB, 0x415720, 0x4166F5, 0x417E1E, 0x41889A, 0x419071, 
	0x41A1A4, 0x41B94F, 0x41C20D, 0x41DAE6, 0x41EB33, 0x41F3D8, 0x4200F6, 0x42181D, 0x4229C8, 0x423123, 
	0x424A61, 0x42528A, 0x42635F, 0x427BB4, 0x428D30, 0x4295DB, 0x42A40E, 0x42BCE5, 0x42C7A7, 0x42DF4C, 
	0x42EE99, 0x42F672, 0x430391, 0x431B7A, 0x432AAF, 0x433244, 0x434906, 0x4351ED, 0x436038, 0x4378D3, 
	0x438E57, 0x4396BC, 0x43A769, 0x43BF82, 0x43C4C0, 0x43DC2B, 0x43EDFE, 0x43F515, 0x440BA2, 0x441349, 
	0x44229C, 0x443A77, 0x444135, 0x4459DE, 0x44680B, 0x4470E0, 0x448664, 0x449E8F, 0x44AF5A, 0x44B7B1, 
	0x44CCF3, 0x44D418, 0x44E5CD, 0x44FD26, 0x4508C5, 0x45102E, 0x4521FB, 0x453910, 0x454252, 0x455AB9, 
	0x456B6C, 0x457387, 0x458503, 0x459DE8, 0x45AC3D, 0x45B4D6, 0x45CF94, 0x45D77F, 0x45E6AA, 0x45FE41, 
	0x460D6F, 0x461584, 0x462451, 0x463CBA, 0x4647F8, 0x465F13, 0x466EC6, 0x46762D, 0x4680A9, 0x469842, 
	0x46A997, 0x46B17C, 0x46CA3E, 0x46D2D5, 0x46E300, 0x46FBEB, 0x470E08, 0x4716E3, 0x472736, 0x473FDD, 
	0x47449F, 0x475C74, 0x476DA1, 0x47754A, 0x4783CE, 0x479B25, 0x47AAF0, 0x47B21B, 0x47C959, 0x47D1B2, 
	0x47E067, 0x47F88C, 0x4805E1, 0x481D0A, 0x482CDF, 0x483434, 0x484F76, 0x48579D, 0x486648, 0x487EA3, 
	0x488827, 0x4890CC, 0x48A119, 0x48B9F2, 0x48C2B0, 0x48DA5B, 0x48EB8E, 0x48F365, 0x490686, 0x491E6D, 
	0x492FB8, 0x493753, 0x494C11, 0x4954FA, 0x49652F, 0x497DC4, 0x498B40, 0x4993AB, 0x49A27E, 0x49BA95, 
	0x49C1D7, 0x49D93C, 0x49E8E9, 0x49F002, 0x4A032C, 0x4A1BC7, 0x4A2A12, 0x4A32F9, 0x4A49BB, 0x4A5150, 
	0x4A6085, 0x4A786E, 0x4A8EEA, 0x4A9601, 0x4AA7D4, 0x4ABF3F, 0x4AC47D, 0x4ADC96, 0x4AED43, 0x4AF5A8, 
	0x4B004B, 0x4B18A0, 0x4B2975, 0x4B319E, 0x4B4ADC, 0x4B5237, 0x4B63E2, 0x4B7B09, 0x4B8D8D, 0x4B9566, 
	0x4BA4B3, 0x4BBC58, 0x4BC71A, 0x4BDFF1, 0x4BEE24, 0x4BF6CF, 0x4C0878, 0x4C1093, 0x4C2146, 0x4C39AD, 
	0x4C42EF, 0x4C5A04, 0x4C6BD1, 0x4C733A, 0x4C85BE, 0x4C9D55, 0x4CAC80, 0x4CB46B, 0x4CCF29, 0x4CD7C2, 
	0x4CE617, 0x4CFEFC, 0x4D0B1F, 0x4D13F4, 0x4D2221, 0x4D3ACA, 0x4D4188, 0x4D5963, 0x4D68B6, 0x4D705D, 
	0x4D86D9, 0x4D9E32, 0x4DAFE7, 0x4DB70C, 0x4DCC4E, 0x4DD4A5, 0x4DE570, 0x4DFD9B, 0x4E0EB5, 0x4E165E, 
	0x4E278B, 0x4E3F60, 0x4E4422, 0x4E5CC9, 0x4E6D1C, 0x4E75F7, 0x4E8373, 0x4E9B98, 0x4EAA4D, 0x4EB2A6, 
	0x4EC9E4, 0x4ED10F, 0x4EE0DA, 0x4EF831, 0x4F0DD2, 0x4F1539, 0x4F24EC, 0x4F3C07, 0x4F4745, 0x4F5FAE, 
	0x4F6E7B, 0x4F7690, 0x4F8014, 0x4F98FF, 0x4FA92A, 0x4FB1C1, 0x4FCA83, 0x4FD268, 0x4FE3BD, 0x4FFB56, 
	0x50018F, 0x501964, 0x5028B1, 0x50305A, 0x504B18, 0x5053F3, 0x506226, 0x507ACD, 0x508C49, 0x5094A2, 
	0x50A577, 0x50BD9C, 0x50C6DE, 0x50DE35, 0x50EFE0, 0x50F70B, 0x5102E8, 0x511A03, 0x512BD6, 0x51333D, 
	0x51487F, 0x515094, 0x516141, 0x5179AA, 0x518F2E, 0x5197C5, 0x51A610, 0x51BEFB, 0x51C5B9, 0x51DD52, 
	0x51EC87, 0x51F46C, 0x520742, 0x521FA9, 0x522E7C, 0x523697, 0x524DD5, 0x52553E, 0x5264EB, 0x527C00, 
	0x528A84, 0x52926F, 0x52A3BA, 0x52BB51, 0x52C013, 0x52D8F8, 0x52E92D, 0x52F1C6, 0x530425, 0x531CCE, 
	0x532D1B, 0x5335F0, 0x534EB2, 0x535659, 0x53678C, 0x537F67, 0x5389E3, 0x539108, 0x53A0DD, 0x53B836, 
	0x53C374, 0x53DB9F, 0x53EA4A, 0x53F2A1, 0x540C16, 0x5414FD, 0x542528, 0x543DC3, 0x544681, 0x545E6A, 
	0x546FBF, 0x547754, 0x5481D0, 0x54993B, 0x54A8EE, 0x54B005, 0x54CB47, 0x54D3AC, 0x54E279, 0x54FA92, 
	0x550F71, 0x55179A, 0x55264F, 0x553EA4, 0x5545E6, 0x555D0D, 0x556CD8, 0x557433, 0x5582B7, 0x559A5C, 
	0x55AB89, 0x55B362, 0x55C820, 0x55D0CB, 0x55E11E, 0x55F9F5, 0x560ADB, 0x561230, 0x5623E5, 0x563B0E, 
	0x56404C, 0x5658A7, 0x566972, 0x567199, 0x56871D, 0x569FF6, 0x56AE23, 0x56B6C8, 0x56CD8A, 0x56D561, 
	0x56E4B4, 0x56FC5F, 0x5709BC, 0x571157, 0x572082, 0x573869, 0x57432B, 0x575BC0, 0x576A15, 0x5772FE, 
	0x57847A, 0x579C91, 0x57AD44, 0x57B5AF, 0x57CEED, 0x57D606, 0x57E7D3, 0x57FF38, 0x580255, 0x581ABE, 
	0x582B6B, 0x583380, 0x5848C2, 0x585029, 0x5861FC, 0x587917, 0x588F93, 0x589778, 0x58A6AD, 0x58BE46, 
	0x58C504, 0x58DDEF, 0x58EC3A, 0x58F4D1, 0x590132, 0x5919D9, 0x59280C, 0x5930E7, 0x594BA5, 0x59534E, 
	0x59629B, 0x597A70, 0x598CF4, 0x59941F, 0x59A5CA, 0x59BD21, 0x59C663, 0x59DE88, 0x59EF5D, 0x59F7B6, 
	0x5A0498, 0x5A1C73, 0x5A2DA6, 0x5A354D, 0x5A4E0F, 0x5A56E4, 0x5A6731, 0x5A7FDA, 0x5A895E, 0x5A91B5, 
	0x5AA060, 0x5AB88B, 0x5AC3C9, 0x5ADB22, 0x5AEAF7, 0x5AF21C, 0x5B07FF, 0x5B1F14, 0x5B2EC1, 0x5B362A, 
	0x5B4D68, 0x5B5583, 0x5B6456, 0x5B7CBD, 0x5B8A39, 0x5B92D2, 0x5BA307, 0x5BBBEC, 0x5BC0AE, 0x5BD845, 
	0x5BE990, 0x5BF17B, 0x5C0FCC, 0x5C1727, 0x5C26F2, 0x5C3E19, 0x5C455B, 0x5C5DB0, 0x5C6C65, 0x5C748E, 
	0x5C820A, 0x5C9AE1, 0x5CAB34, 0x5CB3DF, 0x5CC89D, 0x5CD076, 0x5CE1A3, 0x5CF948, 0x5D0CAB, 0x5D1440, 
	0x5D2595, 0x5D3D7E, 0x5D463C, 0x5D5ED7, 0x5D6F02, 0x5D77E9, 0x5D816D, 0x5D9986, 0x5DA853, 0x5DB0B8, 
	0x5DCBFA, 0x5DD311, 0x5DE2C4, 0x5DFA2F, 0x5E0901, 0x5E11EA, 0x5E203F, 0x5E38D4, 0x5E4396, 0x5E5B7D, 
	0x5E6AA8, 0x5E7243, 0x5E84C7, 0x5E9C2C, 0x5EADF9, 0x5EB512, 0x5ECE50, 0x5ED6BB, 0x5EE76E, 0x5EFF85, 
	0x5F0A66, 0x5F128D, 0x5F2358, 0x5F3BB3, 0x5F40F1, 0x5F581A, 0x5F69CF, 0x5F7124, 0x5F87A0, 0x5F9F4B, 
	0x5FAE9E, 0x5FB675, 0x5FCD37, 0x5FD5DC, 0x5FE409, 0x5FFCE2, 0x600953, 0x6011B8, 0x60206D, 0x603886, 
	0x6043C4, 0x605B2F, 0x606AFA, 0x607211, 0x608495, 0x609C7E, 0x60ADAB, 0x60B540, 0x60CE02, 0x60D6E9, 
	0x60E73C, 0x60FFD7, 0x610A34, 0x6112DF, 0x61230A, 0x613BE1, 0x6140A3, 0x615848, 0x61699D, 0x617176, 
	0x6187F2, 0x619F19, 0x61AECC, 0x61B627, 0x61CD65, 0x61D58E, 0x61E45B, 0x61FCB0, 0x620F9E, 0x621775, 
	0x6226A0, 0x623E4B, 0x624509, 0x625DE2, 0x626C37, 0x6274DC, 0x628258, 0x629AB3, 0x62AB66, 0x62B38D, 
	0x62C8CF, 0x62D024, 0x62E1F1, 0x62F91A, 0x630CF9, 0x631412, 0x6325C7, 0x633D2C, 0x63466E, 0x635E85, 
	0x636F50, 0x6377BB, 0x63813F, 0x6399D4, 0x63A801, 0x63B0EA, 0x63CBA8, 0x63D343, 0x63E296, 0x63FA7D, 
	0x6404CA, 0x641C21, 0x642DF4, 0x64351F, 0x644E5D, 0x6456B6, 0x646763, 0x647F88, 0x64890C, 0x6491E7, 
	0x64A032, 0x64B8D9, 0x64C39B, 0x64DB70, 0x64EAA5, 0x64F24E, 0x6507AD, 0x651F46, 0x652E93, 0x653678, 
	0x654D3A, 0x6555D1, 0x656404, 0x657CEF, 0x658A6B, 0x659280, 0x65A355, 0x65BBBE, 0x65C0FC, 0x65D817, 
	0x65E9C2, 0x65F129, 0x660207, 0x661AEC, 0x662B39, 0x6633D2, 0x664890, 0x66507B, 0x6661AE, 0x667945, 
	0x668FC1, 0x66972A, 0x66A6FF, 0x66BE14, 0x66C556, 0x66DDBD, 0x66EC68, 0x66F483, 0x670160, 0x67198B, 
	0x67285E, 0x6730B5, 0x674BF7, 0x67531C, 0x6762C9, 0x677A22, 0x678CA6, 0x67944D, 0x67A598, 0x67BD73, 
	0x67C631, 0x67DEDA, 0x67EF0F, 0x67F7E4, 0x680A89, 0x681262, 0x6823B7, 0x683B5C, 0x68401E, 0x6858F5, 
	0x686920, 0x6871CB, 0x68874F, 0x689FA4, 0x68AE71, 0x68B69A, 0x68CDD8, 0x68D533, 0x68E4E6, 0x68FC0D, 
	0x6909EE, 0x691105, 0x6920D0, 0x69383B, 0x694379, 0x695B92, 0x696A47, 0x6972AC, 0x698428, 0x699CC3, 
	0x69AD16, 0x69B5FD, 0x69CEBF, 0x69D654, 0x69E781, 0x69FF6A, 0x6A0C44, 0x6A14AF, 0x6A257A, 0x6A3D91, 
	0x6A46D3, 0x6A5E38, 0x6A6FED, 0x6A7706, 0x6A8182, 0x6A9969, 0x6AA8BC, 0x6AB057, 0x6ACB15, 0x6AD3FE, 
	0x6AE22B, 0x6AFAC0, 0x6B0F23, 0x6B17C8, 0x6B261D, 0x6B3EF6, 0x6B45B4, 0x6B5D5F, 0x6B6C8A, 0x6B7461, 
	0x6B82E5, 0x6B9A0E, 0x6BABDB, 0x6BB330, 0x6BC872, 0x6BD099, 0x6BE14C, 0x6BF9A7, 0x6C0710, 0x6C1FFB, 
	0x6C2E2E, 0x6C36C5, 0x6C4D87, 0x6C556C, 0x6C64B9, 0x6C7C52, 0x6C8AD6, 0x6C923D, 0x6CA3E8, 0x6CBB03, 
	0x6CC041, 0x6CD8AA, 0x6CE97F, 0x6CF194, 0x6D0477, 0x6D1C9C, 0x6D2D49, 0x6D35A2, 0x6D4EE0, 0x6D560B, 
	0x6D67DE, 0x6D7F35, 0x6D89B1, 0x6D915A, 0x6DA08F, 0x6DB864, 0x6DC326, 0x6DDBCD, 0x6DEA18, 0x6DF2F3, 
	0x6E01DD, 0x6E1936, 0x6E28E3, 0x6E3008, 0x6E4B4A, 0x6E53A1, 0x6E6274, 0x6E7A9F, 0x6E8C1B, 0x6E94F0, 
	0x6EA525, 0x6EBDCE, 0x6EC68C, 0x6EDE67, 0x6EEFB2, 0x6EF759, 0x6F02BA, 0x6F1A51, 0x6F2B84, 0x6F336F, 
	0x6F482D, 0x6F50C6, 0x6F6113, 0x6F79F8, 0x6F8F7C, 0x6F9797, 0x6FA642, 0x6FBEA9, 0x6FC5EB, 0x6FDD00, 
	0x6FECD5, 0x6FF43E, 0x700EE7, 0x70160C, 0x7027D9, 0x703F32, 0x704470, 0x705C9B, 0x706D4E, 0x7075A5, 
	0x708321, 0x709BCA, 0x70AA1F, 0x70B2F4, 0x70C9B6, 0x70D15D, 0x70E088, 0x70F863, 0x710D80, 0x71156B, 
	0x7124BE, 0x713C55, 0x714717, 0x715FFC, 0x716E29, 0x7176C2, 0x718046, 0x7198AD, 0x71A978, 0x71B193, 
	0x71CAD1, 0x71D23A, 0x71E3EF, 0x71FB04, 0x72082A, 0x7210C1, 0x722114, 0x7239FF, 0x7242BD, 0x725A56, 
	0x726B83, 0x727368, 0x7285EC, 0x729D07, 0x72ACD2, 0x72B439, 0x72CF7B, 0x72D790, 0x72E645, 0x72FEAE, 
	0x730B4D, 0x7313A6, 0x732273, 0x733A98, 0x7341DA, 0x735931, 0x7368E4, 0x73700F, 0x73868B, 0x739E60, 
	0x73AFB5, 0x73B75E, 0x73CC1C, 0x73D4F7, 0x73E522, 0x73FDC9, 0x74037E, 0x741B95, 0x742A40, 0x7432AB, 
	0x7449E9, 0x745102, 0x7460D7, 0x74783C, 0x748EB8, 0x749653, 0x74A786, 0x74BF6D, 0x74C42F, 0x74DCC4, 
	0x74ED11, 0x74F5FA, 0x750019, 0x7518F2, 0x752927, 0x7531CC, 0x754A8E, 0x755265, 0x7563B0, 0x757B5B, 
	0x758DDF, 0x759534, 0x75A4E1, 0x75BC0A, 0x75C748, 0x75DFA3, 0x75EE76, 0x75F69D, 0x7605B3, 0x761D58, 
	0x762C8D, 0x763466, 0x764F24, 0x7657CF, 0x76661A, 0x767EF1, 0x768875, 0x76909E, 0x76A14B, 0x76B9A0, 
	0x76C2E2, 0x76DA09, 0x76EBDC, 0x76F337, 0x7706D4, 0x771E3F, 0x772FEA, 0x773701, 0x774C43, 0x7754A8, 
	0x77657D, 0x777D96, 0x778B12, 0x7793F9, 0x77A22C, 0x77BAC7, 0x77C185, 0x77D96E, 0x77E8BB, 0x77F050, 
	0x780D3D, 0x7815D6, 0x782403, 0x783CE8, 0x7847AA, 0x785F41, 0x786E94, 0x78767F, 0x7880FB, 0x789810, 
	0x78A9C5, 0x78B12E, 0x78CA6C, 0x78D287, 0x78E352, 0x78FBB9, 0x790E5A, 0x7916B1, 0x792764, 0x793F8F, 
	0x7944CD, 0x795C26, 0x796DF3, 0x797518, 0x79839C, 0x799B77, 0x79AAA2, 0x79B249, 0x79C90B, 0x79D1E0, 
	0x79E035, 0x79F8DE, 0x7A0BF0, 0x7A131B, 0x7A22CE, 0x7A3A25, 0x7A4167, 0x7A598C, 0x7A6859, 0x7A70B2, 
	0x7A8636, 0x7A9EDD, 0x7AAF08, 0x7AB7E3, 0x7ACCA1, 0x7AD44A, 0x7AE59F, 0x7AFD74, 0x7B0897, 0x7B107C, 
	0x7B21A9, 0x7B3942, 0x7B4200, 0x7B5AEB, 0x7B6B3E, 0x7B73D5, 0x7B8551, 0x7B9DBA, 0x7BAC6F, 0x7BB484, 
	0x7BCFC6, 0x7BD72D, 0x7BE6F8, 0x7BFE13, 0x7C00A4, 0x7C184F, 0x7C299A, 0x7C3171, 0x7C4A33, 0x7C52D8, 
	0x7C630D, 0x7C7BE6, 0x7C8D62, 0x7C9589, 0x7CA45C, 0x7CBCB7, 0x7CC7F5, 0x7CDF1E, 0x7CEECB, 0x7CF620, 
	0x7D03C3, 0x7D1B28, 0x7D2AFD, 0x7D3216, 0x7D4954, 0x7D51BF, 0x7D606A, 0x7D7881, 0x7D8E05, 0x7D96EE, 
	0x7DA73B, 0x7DBFD0, 0x7DC492, 0x7DDC79, 0x7DEDAC, 0x7DF547, 0x7E0669, 0x7E1E82, 0x7E2F57, 0x7E37BC, 
	0x7E4CFE, 0x7E5415, 0x7E65C0, 0x7E7D2B, 0x7E8BAF, 0x7E9344, 0x7EA291, 0x7EBA7A, 0x7EC138, 0x7ED9D3, 
	0x7EE806, 0x7EF0ED, 0x7F050E, 0x7F1DE5, 0x7F2C30, 0x7F34DB, 0x7F4F99, 0x7F5772, 0x7F66A7, 0x7F7E4C, 
	0x7F88C8, 0x7F9023, 0x7FA1F6, 0x7FB91D, 0x7FC25F, 0x7FDAB4, 0x7FEB61, 0x7FF38A, 0x800C75, 0x80149E, 
	0x80254B, 0x803DA0, 0x8046E2, 0x805E09, 0x806FDC, 0x807737, 0x8081B3, 0x809958, 0x80A88D, 0x80B066, 
	0x80CB24, 0x80D3CF, 0x80E21A, 0x80FAF1, 0x810F12, 0x8117F9, 0x81262C, 0x813EC7, 0x814585, 0x815D6E, 
	0x816CBB, 0x817450, 0x8182D4, 0x819A3F, 0x81ABEA, 0x81B301, 0x81C843, 0x81D0A8, 0x81E17D, 0x81F996, 
	0x820AB8, 0x821253, 0x822386, 0x823B6D, 0x82402F, 0x8258C4, 0x826911, 0x8271FA, 0x82877E, 0x829F95, 
	0x82AE40, 0x82B6AB, 0x82CDE9, 0x82D502, 0x82E4D7, 0x82FC3C, 0x8309DF, 0x831134, 0x8320E1, 0x83380A, 
	0x834348, 0x835BA3, 0x836A76, 0x83729D, 0x838419, 0x839CF2, 0x83AD27, 0x83B5CC, 0x83CE8E, 0x83D665, 
	0x83E7B0, 0x83FF5B, 0x8401EC, 0x841907, 0x8428D2, 0x843039, 0x844B7B, 0x845390, 0x846245, 0x847AAE, 
	0x848C2A, 0x8494C1, 0x84A514, 0x84BDFF, 0x84C6BD, 0x84DE56, 0x84EF83, 0x84F768, 0x85028B, 0x851A60, 
	0x852BB5, 0x85335E, 0x85481C, 0x8550F7, 0x856122, 0x8579C9, 0x858F4D, 0x8597A6, 0x85A673, 0x85BE98, 
	0x85C5DA, 0x85DD31, 0x85ECE4, 0x85F40F, 0x860721, 0x861FCA, 0x862E1F, 0x8636F4, 0x864DB6, 0x86555D, 
	0x866488, 0x867C63, 0x868AE7, 0x86920C, 0x86A3D9, 0x86BB32, 0x86C070, 0x86D89B, 0x86E94E, 0x86F1A5, 
	0x870446, 0x871CAD, 0x872D78, 0x873593, 0x874ED1, 0x87563A, 0x8767EF, 0x877F04, 0x878980, 0x87916B, 
	0x87A0BE, 0x87B855, 0x87C317, 0x87DBFC, 0x87EA29, 0x87F2C2, 0x880FAF, 0x881744, 0x882691, 0x883E7A, 
	0x884538, 0x885DD3, 0x886C06, 0x8874ED, 0x888269, 0x889A82, 0x88AB57, 0x88B3BC, 0x88C8FE, 0x88D015, 
	0x88E1C0, 0x88F92B, 0x890CC8, 0x891423, 0x8925F6, 0x893D1D, 0x89465F, 0x895EB4, 0x896F61, 0x89778A, 
	0x89810E, 0x8999E5, 0x89A830, 0x89B0DB, 0x89CB99, 0x89D372, 0x89E2A7, 0x89FA4C, 0x8A0962, 0x8A1189, 
	0x8A205C, 0x8A38B7, 0x8A43F5, 0x8A5B1E, 0x8A6ACB, 0x8A7220, 0x8A84A4, 0x8A9C4F, 0x8AAD9A, 0x8AB571, 
	0x8ACE33, 0x8AD6D8, 0x8AE70D, 0x8AFFE6, 0x8B0A05, 0x8B12EE, 0x8B233B, 0x8B3BD0, 0x8B4092, 0x8B5879, 
	0x8B69AC, 0x8B7147, 0x8B87C3, 0x8B9F28, 0x8BAEFD, 0x8BB616, 0x8BCD54, 0x8BD5BF, 0x8BE46A, 0x8BFC81, 
	0x8C0236, 0x8C1ADD, 0x8C2B08, 0x8C33E3, 0x8C48A1, 0x8C504A, 0x8C619F, 0x8C7974, 0x8C8FF0, 0x8C971B, 
	0x8CA6CE, 0x8CBE25, 0x8CC567, 0x8CDD8C, 0x8CEC59, 0x8CF4B2, 0x8D0151, 0x8D19BA, 0x8D286F, 0x8D3084, 
	0x8D4BC6, 0x8D532D, 0x8D62F8, 0x8D7A13, 0x8D8C97, 0x8D947C, 0x8DA5A9, 0x8DBD42, 0x8DC600, 0x8DDEEB, 
	0x8DEF3E, 0x8DF7D5, 0x8E04FB, 0x8E1C10, 0x8E2DC5, 0x8E352E, 0x8E4E6C, 0x8E5687, 0x8E6752, 0x8E7FB9, 
	0x8E893D, 0x8E91D6, 0x8EA003, 0x8EB8E8, 0x8EC3AA, 0x8EDB41, 0x8EEA94, 0x8EF27F, 0x8F079C, 0x8F1F77, 
	0x8F2EA2, 0x8F3649, 0x8F4D0B, 0x8F55E0, 0x8F6435, 0x8F7CDE, 0x8F8A5A, 0x8F92B1, 0x8FA364, 0x8FBB8F, 
	0x8FC0CD, 0x8FD826, 0x8FE9F3, 0x8FF118, 0x900BC1, 0x90132A, 0x9022FF, 0x903A14, 0x904156, 0x9059BD, 
	0x906868, 0x907083, 0x908607, 0x909EEC, 0x90AF39, 0x90B7D2, 0x90CC90, 0x90D47B, 0x90E5AE, 0x90FD45, 
	0x9108A6, 0x91104D, 0x912198, 0x913973, 0x914231, 0x915ADA, 0x916B0F, 0x9173E4, 0x918560, 0x919D8B, 
	0x91AC5E, 0x91B4B5, 0x91CFF7, 0x91D71C, 0x91E6C9, 0x91FE22, 0x920D0C, 0x9215E7, 0x922432, 0x923CD9, 
	0x92479B, 0x925F70, 0x926EA5, 0x92764E, 0x9280CA, 0x929821, 0x92A9F4, 0x92B11F, 0x92CA5D, 0x92D2B6, 
	0x92E363, 0x92FB88, 0x930E6B, 0x931680, 0x932755, 0x933FBE, 0x9344FC, 0x935C17, 0x936DC2, 0x937529, 
	0x9383AD, 0x939B46, 0x93AA93, 0x93B278, 0x93C93A, 0x93D1D1, 0x93E004, 0x93F8EF, 0x940658, 0x941EB3, 
	0x942F66, 0x94378D, 0x944CCF, 0x945424, 0x9465F1, 0x947D1A, 0x948B9E, 0x949375, 0x94A2A0, 0x94BA4B, 
	0x94C109, 0x94D9E2, 0x94E837, 0x94F0DC, 0x95053F, 0x951DD4, 0x952C01, 0x9534EA, 0x954FA8, 0x955743, 
	0x956696, 0x957E7D, 0x9588F9, 0x959012, 0x95A1C7, 0x95B92C, 0x95C26E, 0x95DA85, 0x95EB50, 0x95F3BB, 
	0x960095, 0x96187E, 0x9629AB, 0x963140, 0x964A02, 0x9652E9, 0x96633C, 0x967BD7, 0x968D53, 0x9695B8, 
	0x96A46D, 0x96BC86, 0x96C7C4, 0x96DF2F, 0x96EEFA, 0x96F611, 0x9703F2, 0x971B19, 0x972ACC, 0x973227, 
	0x974965, 0x97518E, 0x97605B, 0x9778B0, 0x978E34, 0x9796DF, 0x97A70A, 0x97BFE1, 0x97C4A3, 0x97DC48, 
	0x97ED9D, 0x97F576, 0x98081B, 0x9810F0, 0x982125, 0x9839CE, 0x98428C, 0x985A67, 0x986BB2, 0x987359, 
	0x9885DD, 0x989D36, 0x98ACE3, 0x98B408, 0x98CF4A, 0x98D7A1, 0x98E674, 0x98FE9F, 0x990B7C, 0x991397, 
	0x992242, 0x993AA9, 0x9941EB, 0x995900, 0x9968D5, 0x99703E, 0x9986BA, 0x999E51, 0x99AF84, 0x99B76F, 
	0x99CC2D, 0x99D4C6, 0x99E513, 0x99FDF8, 0x9A0ED6, 0x9A163D, 0x9A27E8, 0x9A3F03, 0x9A4441, 0x9A5CAA, 
	0x9A6D7F, 0x9A7594, 0x9A8310, 0x9A9BFB, 0x9AAA2E, 0x9AB2C5, 0x9AC987, 0x9AD16C, 0x9AE0B9, 0x9AF852, 
	0x9B0DB1, 0x9B155A, 0x9B248F, 0x9B3C64, 0x9B4726, 0x9B5FCD, 0x9B6E18, 0x9B76F3, 0x9B8077, 0x9B989C, 
	0x9BA949, 0x9BB1A2, 0x9BCAE0, 0x9BD20B, 0x9BE3DE, 0x9BFB35, 0x9C0582, 0x9C1D69, 0x9C2CBC, 0x9C3457, 
	0x9C4F15, 0x9C57FE, 0x9C662B, 0x9C7EC0, 0x9C8844, 0x9C90AF, 0x9CA17A, 0x9CB991, 0x9CC2D3, 0x9CDA38, 
	0x9CEBED, 0x9CF306, 0x9D06E5, 0x9D1E0E, 0x9D2FDB, 0x9D3730, 0x9D4C72, 0x9D5499, 0x9D654C, 0x9D7DA7, 
	0x9D8B23, 0x9D93C8, 0x9DA21D, 0x9DBAF6, 0x9DC1B4, 0x9DD95F, 0x9DE88A, 0x9DF061, 0x9E034F, 0x9E1BA4, 
	0x9E2A71, 0x9E329A, 0x9E49D8, 0x9E5133, 0x9E60E6, 0x9E780D, 0x9E8E89, 0x9E9662, 0x9EA7B7, 0x9EBF5C, 
	0x9EC41E, 0x9EDCF5, 0x9EED20, 0x9EF5CB, 0x9F0028, 0x9F18C3, 0x9F2916, 0x9F31FD, 0x9F4ABF, 0x9F5254, 
	0x9F6381, 0x9F7B6A, 0x9F8DEE, 0x9F9505, 0x9FA4D0, 0x9FBC3B, 0x9FC779, 0x9FDF92, 0x9FEE47, 0x9FF6AC, 
	0xA0031D, 0xA01BF6, 0xA02A23, 0xA032C8, 0xA0498A, 0xA05161, 0xA060B4, 0xA0785F, 0xA08EDB, 0xA09630, 
	0xA0A7E5, 0xA0BF0E, 0xA0C44C, 0xA0DCA7, 0xA0ED72, 0xA0F599, 0xA1007A, 0xA11891, 0xA12944, 0xA131AF, 
	0xA14AED, 0xA15206, 0xA163D3, 0xA17B38, 0xA18DBC, 0xA19557, 0xA1A482, 0xA1BC69, 0xA1C72B, 0xA1DFC0, 
	0xA1EE15, 0xA1F6FE, 0xA205D0, 0xA21D3B, 0xA22CEE, 0xA23405, 0xA24F47, 0xA257AC, 0xA26679, 0xA27E92, 
	0xA28816, 0xA290FD, 0xA2A128, 0xA2B9C3, 0xA2C281, 0xA2DA6A, 0xA2EBBF, 0xA2F354, 0xA306B7, 0xA31E5C, 
	0xA32F89, 0xA33762, 0xA34C20, 0xA354CB, 0xA3651E, 0xA37DF5, 0xA38B71, 0xA3939A, 0xA3A24F, 0xA3BAA4, 
	0xA3C1E6, 0xA3D90D, 0xA3E8D8, 0xA3F033, 0xA40E84, 0xA4166F, 0xA427BA, 0xA43F51, 0xA44413, 0xA45CF8, 
	0xA46D2D, 0xA475C6, 0xA48342, 0xA49BA9, 0xA4AA7C, 0xA4B297, 0xA4C9D5, 0xA4D13E, 0xA4E0EB, 0xA4F800, 
	0xA50DE3, 0xA51508, 0xA524DD, 0xA53C36, 0xA54774, 0xA55F9F, 0xA56E4A, 0xA576A1, 0xA58025, 0xA598CE, 
	0xA5A91B, 0xA5B1F0, 0xA5CAB2, 0xA5D259, 0xA5E38C, 0xA5FB67, 0xA60849, 0xA610A2, 0xA62177, 0xA6399C, 
	0xA642DE, 0xA65A35, 0xA66BE0, 0xA6730B, 0xA6858F, 0xA69D64, 0xA6ACB1, 0xA6B45A, 0xA6CF18, 0xA6D7F3, 
	0xA6E626, 0xA6FECD, 0xA70B2E, 0xA713C5, 0xA72210, 0xA73AFB, 0xA741B9, 0xA75952, 0xA76887, 0xA7706C, 
	0xA786E8, 0xA79E03, 0xA7AFD6, 0xA7B73D, 0xA7CC7F, 0xA7D494, 0xA7E541, 0xA7FDAA, 0xA800C7, 0xA8182C, 
	0xA829F9, 0xA83112, 0xA84A50, 0xA852BB, 0xA8636E, 0xA87B85, 0xA88D01, 0xA895EA, 0xA8A43F, 0xA8BCD4, 
	0xA8C796, 0xA8DF7D, 0xA8EEA8, 0xA8F643, 0xA903A0, 0xA91B4B, 0xA92A9E, 0xA93275, 0xA94937, 0xA951DC, 
	0xA96009, 0xA978E2, 0xA98E66, 0xA9968D, 0xA9A758, 0xA9BFB3, 0xA9C4F1, 0xA9DC1A, 0xA9EDCF, 0xA9F524, 
	0xAA060A, 0xAA1EE1, 0xAA2F34, 0xAA37DF, 0xAA4C9D, 0xAA5476, 0xAA65A3, 0xAA7D48, 0xAA8BCC, 0xAA9327, 
	0xAAA2F2, 0xAABA19, 0xAAC15B, 0xAAD9B0, 0xAAE865, 0xAAF08E, 0xAB056D, 0xAB1D86, 0xAB2C53, 0xAB34B8, 
	0xAB4FFA, 0xAB5711, 0xAB66C4, 0xAB7E2F, 0xAB88AB, 0xAB9040, 0xABA195, 0xABB97E, 0xABC23C, 0xABDAD7, 
	0xABEB02, 0xABF3E9, 0xAC0D5E, 0xAC15B5, 0xAC2460, 0xAC3C8B, 0xAC47C9, 0xAC5F22, 0xAC6EF7, 0xAC761C, 
	0xAC8098, 0xAC9873, 0xACA9A6, 0xACB14D, 0xACCA0F, 0xACD2E4, 0xACE331, 0xACFBDA, 0xAD0E39, 0xAD16D2, 
	0xAD2707, 0xAD3FEC, 0xAD44AE, 0xAD5C45, 0xAD6D90, 0xAD757B, 0xAD83FF, 0xAD9B14, 0xADAAC1, 0xADB22A, 
	0xADC968, 0xADD183, 0xADE056, 0xADF8BD, 0xAE0B93, 0xAE1378, 0xAE22AD, 0xAE3A46, 0xAE4104, 0xAE59EF, 
	0xAE683A, 0xAE70D1, 0xAE8655, 0xAE9EBE, 0xAEAF6B, 0xAEB780, 0xAECCC2, 0xAED429, 0xAEE5FC, 0xAEFD17, 
	0xAF08F4, 0xAF101F, 0xAF21CA, 0xAF3921, 0xAF4263, 0xAF5A88, 0xAF6B5D, 0xAF73B6, 0xAF8532, 0xAF9DD9, 
	0xAFAC0C, 0xAFB4E7, 0xAFCFA5, 0xAFD74E, 0xAFE69B, 0xAFFE70, 0xB004A9, 0xB01C42, 0xB02D97, 0xB0357C, 
	0xB04E3E, 0xB056D5, 0xB06700, 0xB07FEB, 0xB0896F, 0xB09184, 0xB0A051, 0xB0B8BA, 0xB0C3F8, 0xB0DB13, 
	0xB0EAC6, 0xB0F22D, 0xB107CE, 0xB11F25, 0xB12EF0, 0xB1361B, 0xB14D59, 0xB155B2, 0xB16467, 0xB17C8C, 
	0xB18A08, 0xB192E3, 0xB1A336, 0xB1BBDD, 0xB1C09F, 0xB1D874, 0xB1E9A1, 0xB1F14A, 0xB20264, 0xB21A8F, 
	0xB22B5A, 0xB233B1, 0xB248F3, 0xB25018, 0xB261CD, 0xB27926, 0xB28FA2, 0xB29749, 0xB2A69C, 0xB2BE77, 
	0xB2C535, 0xB2DDDE, 0xB2EC0B, 0xB2F4E0, 0xB30103, 0xB319E8, 0xB3283D, 0xB330D6, 0xB34B94, 0xB3537F, 
	0xB362AA, 0xB37A41, 0xB38CC5, 0xB3942E, 0xB3A5FB, 0xB3BD10, 0xB3C652, 0xB3DEB9, 0xB3EF6C, 0xB3F787, 
	0xB40930, 0xB411DB, 0xB4200E, 0xB438E5, 0xB443A7, 0xB45B4C, 0xB46A99, 0xB47272, 0xB484F6, 0xB49C1D, 
	0xB4ADC8, 0xB4B523, 0xB4CE61, 0xB4D68A, 0xB4E75F, 0xB4FFB4, 0xB50A57, 0xB512BC, 0xB52369, 0xB53B82, 
	0xB540C0, 0xB5582B, 0xB569FE, 0xB57115, 0xB58791, 0xB59F7A, 0xB5AEAF, 0xB5B644, 0xB5CD06, 0xB5D5ED, 
	0xB5E438, 0xB5FCD3, 0xB60FFD, 0xB61716, 0xB626C3, 0xB63E28, 0xB6456A, 0xB65D81, 0xB66C54, 0xB674BF, 
	0xB6823B, 0xB69AD0, 0xB6AB05, 0xB6B3EE, 0xB6C8AC, 0xB6D047, 0xB6E192, 0xB6F979, 0xB70C9A, 0xB71471, 
	0xB725A4, 0xB73D4F, 0xB7460D, 0xB75EE6, 0xB76F33, 0xB777D8, 0xB7815C, 0xB799B7, 0xB7A862, 0xB7B089, 
	0xB7CBCB, 0xB7D320, 0xB7E2F5, 0xB7FA1E, 0xB80773, 0xB81F98, 0xB82E4D, 0xB836A6, 0xB84DE4, 0xB8550F, 
	0xB864DA, 0xB87C31, 0xB88AB5, 0xB8925E, 0xB8A38B, 0xB8BB60, 0xB8C022, 0xB8D8C9, 0xB8E91C, 0xB8F1F7, 
	0xB90414, 0xB91CFF, 0xB92D2A, 0xB935C1, 0xB94E83, 0xB95668, 0xB967BD, 0xB97F56, 0xB989D2, 0xB99139, 
	0xB9A0EC, 0xB9B807, 0xB9C345, 0xB9DBAE, 0xB9EA7B, 0xB9F290, 0xBA01BE, 0xBA1955, 0xBA2880, 0xBA306B, 
	0xBA4B29, 0xBA53C2, 0xBA6217, 0xBA7AFC, 0xBA8C78, 0xBA9493, 0xBAA546, 0xBABDAD, 0xBAC6EF, 0xBADE04, 
	0xBAEFD1, 0xBAF73A, 0xBB02D9, 0xBB1A32, 0xBB2BE7, 0xBB330C, 0xBB484E, 0xBB50A5, 0xBB6170, 0xBB799B, 
	0xBB8F1F, 0xBB97F4, 0xBBA621, 0xBBBECA, 0xBBC588, 0xBBDD63, 0xBBECB6, 0xBBF45D, 0xBC0AEA, 0xBC1201, 
	0xBC23D4, 0xBC3B3F, 0xBC407D, 0xBC5896, 0xBC6943, 0xBC71A8, 0xBC872C, 0xBC9FC7, 0xBCAE12, 0xBCB6F9, 
	0xBCCDBB, 0xBCD550, 0xBCE485, 0xBCFC6E, 0xBD098D, 0xBD1166, 0xBD20B3, 0xBD3858, 0xBD431A, 0xBD5BF1, 
	0xBD6A24, 0xBD72CF, 0xBD844B, 0xBD9CA0, 0xBDAD75, 0xBDB59E, 0xBDCEDC, 0xBDD637, 0xBDE7E2, 0xBDFF09, 
	0xBE0C27, 0xBE14CC, 0xBE2519, 0xBE3DF2, 0xBE46B0, 0xBE5E5B, 0xBE6F8E, 0xBE7765, 0xBE81E1, 0xBE990A, 
	0xBEA8DF, 0xBEB034, 0xBECB76, 0xBED39D, 0xBEE248, 0xBEFAA3, 0xBF0F40, 0xBF17AB, 0xBF267E, 0xBF3E95, 
	0xBF45D7, 0xBF5D3C, 0xBF6CE9, 0xBF7402, 0xBF8286, 0xBF9A6D, 0xBFABB8, 0xBFB353, 0xBFC811, 0xBFD0FA, 
	0xBFE12F, 0xBFF9C4, 0xC00A4E, 0xC012A5, 0xC02370, 0xC03B9B, 0xC040D9, 0xC05832, 0xC069E7, 0xC0710C, 
	0xC08788, 0xC09F63, 0xC0AEB6, 0xC0B65D, 0xC0CD1F, 0xC0D5F4, 0xC0E421, 0xC0FCCA, 0xC10929, 0xC111C2, 
	0xC12017, 0xC138FC, 0xC143BE, 0xC15B55, 0xC16A80, 0xC1726B, 0xC184EF, 0xC19C04, 0xC1ADD1, 0xC1B53A, 
	0xC1CE78, 0xC1D693, 0xC1E746, 0xC1FFAD, 0xC20C83, 0xC21468, 0xC225BD, 0xC23D56, 0xC24614, 0xC25EFF, 
	0xC26F2A, 0xC277C1, 0xC28145, 0xC299AE, 0xC2A87B, 0xC2B090, 0xC2CBD2, 0xC2D339, 0xC2E2EC, 0xC2FA07, 
	0xC30FE4, 0xC3170F, 0xC326DA, 0xC33E31, 0xC34573, 0xC35D98, 0xC36C4D, 0xC374A6, 0xC38222, 0xC39AC9, 
	0xC3AB1C, 0xC3B3F7, 0xC3C8B5, 0xC3D05E, 0xC3E18B, 0xC3F960, 0xC407D7, 0xC41F3C, 0xC42EE9, 0xC43602, 
	0xC44D40, 0xC455AB, 0xC4647E, 0xC47C95, 0xC48A11, 0xC492FA, 0xC4A32F, 0xC4BBC4, 0xC4C086, 0xC4D86D, 
	0xC4E9B8, 0xC4F153, 0xC504B0, 0xC51C5B, 0xC52D8E, 0xC53565, 0xC54E27, 0xC556CC, 0xC56719, 0xC57FF2, 
	0xC58976, 0xC5919D, 0xC5A048, 0xC5B8A3, 0xC5C3E1, 0xC5DB0A, 0xC5EADF, 0xC5F234, 0xC6011A, 0xC619F1, 
	0xC62824, 0xC630CF, 0xC64B8D, 0xC65366, 0xC662B3, 0xC67A58, 0xC68CDC, 0xC69437, 0xC6A5E2, 0xC6BD09, 
	0xC6C64B, 0xC6DEA0, 0xC6EF75, 0xC6F79E, 0xC7027D, 0xC71A96, 0xC72B43, 0xC733A8, 0xC748EA, 0xC75001, 
	0xC761D4, 0xC7793F, 0xC78FBB, 0xC79750, 0xC7A685, 0xC7BE6E, 0xC7C52C, 0xC7DDC7, 0xC7EC12, 0xC7F4F9, 
	0xC80994, 0xC8117F, 0xC820AA, 0xC83841, 0xC84303, 0xC85BE8, 0xC86A3D, 0xC872D6, 0xC88452, 0xC89CB9, 
	0xC8AD6C, 0xC8B587, 0xC8CEC5, 0xC8D62E, 0xC8E7FB, 0xC8FF10, 0xC90AF3, 0xC91218, 0xC923CD, 0xC93B26, 
	0xC94064, 0xC9588F, 0xC9695A, 0xC971B1, 0xC98735, 0xC99FDE, 0xC9AE0B, 0xC9B6E0, 0xC9CDA2, 0xC9D549, 
	0xC9E49C, 0xC9FC77, 0xCA0F59, 0xCA17B2, 0xCA2667, 0xCA3E8C, 0xCA45CE, 0xCA5D25, 0xCA6CF0, 0xCA741B, 
	0xCA829F, 0xCA9A74, 0xCAABA1, 0xCAB34A, 0xCAC808, 0xCAD0E3, 0xCAE136, 0xCAF9DD, 0xCB0C3E, 0xCB14D5, 
	0xCB2500, 0xCB3DEB, 0xCB46A9, 0xCB5E42, 0xCB6F97, 0xCB777C, 0xCB81F8, 0xCB9913, 0xCBA8C6, 0xCBB02D, 
	0xCBCB6F, 0xCBD384, 0xCBE251, 0xCBFABA, 0xCC040D, 0xCC1CE6, 0xCC2D33, 0xCC35D8, 0xCC4E9A, 0xCC5671, 
	0xCC67A4, 0xCC7F4F, 0xCC89CB, 0xCC9120, 0xCCA0F5, 0xCCB81E, 0xCCC35C, 0xCCDBB7, 0xCCEA62, 0xCCF289, 
	0xCD076A, 0xCD1F81, 0xCD2E54, 0xCD36BF, 0xCD4DFD, 0xCD5516, 0xCD64C3, 0xCD7C28, 0xCD8AAC, 0xCD9247, 
	0xCDA392, 0xCDBB79, 0xCDC03B, 0xCDD8D0, 0xCDE905, 0xCDF1EE, 0xCE02C0, 0xCE1A2B, 0xCE2BFE, 0xCE3315, 
	0xCE4857, 0xCE50BC, 0xCE6169, 0xCE7982, 0xCE8F06, 0xCE97ED, 0xCEA638, 0xCEBED3, 0xCEC591, 0xCEDD7A, 
	0xCEECAF, 0xCEF444, 0xCF01A7, 0xCF194C, 0xCF2899, 0xCF3072, 0xCF4B30, 0xCF53DB, 0xCF620E, 0xCF7AE5, 
	0xCF8C61, 0xCF948A, 0xCFA55F, 0xCFBDB4, 0xCFC6F6, 0xCFDE1D, 0xCFEFC8, 0xCFF723, 0xD00DFA, 0xD01511, 
	0xD024C4, 0xD03C2F, 0xD0476D, 0xD05F86, 0xD06E53, 0xD076B8, 0xD0803C, 0xD098D7, 0xD0A902, 0xD0B1E9, 
	0xD0CAAB, 0xD0D240, 0xD0E395, 0xD0FB7E, 0xD10E9D, 0xD11676, 0xD127A3, 0xD13F48, 0xD1440A, 0xD15CE1, 
	0xD16D34, 0xD175DF, 0xD1835B, 0xD19BB0, 0xD1AA65, 0xD1B28E, 0xD1C9CC, 0xD1D127, 0xD1E0F2, 0xD1F819, 
	0xD20B37, 0xD213DC, 0xD22209, 0xD23AE2, 0xD241A0, 0xD2594B, 0xD2689E, 0xD27075, 0xD286F1, 0xD29E1A, 
	0xD2AFCF, 0xD2B724, 0xD2CC66, 0xD2D48D, 0xD2E558, 0xD2FDB3, 0xD30850, 0xD310BB, 0xD3216E, 0xD33985, 
	0xD342C7, 0xD35A2C, 0xD36BF9, 0xD37312, 0xD38596, 0xD39D7D, 0xD3ACA8, 0xD3B443, 0xD3CF01, 0xD3D7EA, 
	0xD3E63F, 0xD3FED4, 0xD40063, 0xD41888, 0xD4295D, 0xD431B6, 0xD44AF4, 0xD4521F, 0xD463CA, 0xD47B21, 
	0xD48DA5, 0xD4954E, 0xD4A49B, 0xD4BC70, 0xD4C732, 0xD4DFD9, 0xD4EE0C, 0xD4F6E7, 0xD50304, 0xD51BEF, 
	0xD52A3A, 0xD532D1, 0xD54993, 0xD55178, 0xD560AD, 0xD57846, 0xD58EC2, 0xD59629, 0xD5A7FC, 0xD5BF17, 
	0xD5C455, 0xD5DCBE, 0xD5ED6B, 0xD5F580, 0xD606AE, 0xD61E45, 0xD62F90, 0xD6377B, 0xD64C39, 0xD654D2, 
	0xD66507, 0xD67DEC, 0xD68B68, 0xD69383, 0xD6A256, 0xD6BABD, 0xD6C1FF, 0xD6D914, 0xD6E8C1, 0xD6F02A, 
	0xD705C9, 0xD71D22, 0xD72CF7, 0xD7341C, 0xD74F5E, 0xD757B5, 0xD76660, 0xD77E8B, 0xD7880F, 0xD790E4, 
	0xD7A131, 0xD7B9DA, 0xD7C298, 0xD7DA73, 0xD7EBA6, 0xD7F34D, 0xD80E20, 0xD816CB, 0xD8271E, 0xD83FF5, 
	0xD844B7, 0xD85C5C, 0xD86D89, 0xD87562, 0xD883E6, 0xD89B0D, 0xD8AAD8, 0xD8B233, 0xD8C971, 0xD8D19A, 
	0xD8E04F, 0xD8F8A4, 0xD90D47, 0xD915AC, 0xD92479, 0xD93C92, 0xD947D0, 0xD95F3B, 0xD96EEE, 0xD97605, 
	0xD98081, 0xD9986A, 0xD9A9BF, 0xD9B154, 0xD9CA16, 0xD9D2FD, 0xD9E328, 0xD9FBC3, 0xDA08ED, 0xDA1006, 
	0xDA21D3, 0xDA3938, 0xDA427A, 0xDA5A91, 0xDA6B44, 0xDA73AF, 0xDA852B, 0xDA9DC0, 0xDAAC15, 0xDAB4FE, 
	0xDACFBC, 0xDAD757, 0xDAE682, 0xDAFE69, 0xDB0B8A, 0xDB1361, 0xDB22B4, 0xDB3A5F, 0xDB411D, 0xDB59F6, 
	0xDB6823, 0xDB70C8, 0xDB864C, 0xDB9EA7, 0xDBAF72, 0xDBB799, 0xDBCCDB, 0xDBD430, 0xDBE5E5, 0xDBFD0E, 
	0xDC03B9, 0xDC1B52, 0xDC2A87, 0xDC326C, 0xDC492E, 0xDC51C5, 0xDC6010, 0xDC78FB, 0xDC8E7F, 0xDC9694, 
	0xDCA741, 0xDCBFAA, 0xDCC4E8, 0xDCDC03, 0xDCEDD6, 0xDCF53D, 0xDD00DE, 0xDD1835, 0xDD29E0, 0xDD310B, 
	0xDD4A49, 0xDD52A2, 0xDD6377, 0xDD7B9C, 0xDD8D18, 0xDD95F3, 0xDDA426, 0xDDBCCD, 0xDDC78F, 0xDDDF64, 
	0xDDEEB1, 0xDDF65A, 0xDE0574, 0xDE1D9F, 0xDE2C4A, 0xDE34A1, 0xDE4FE3, 0xDE5708, 0xDE66DD, 0xDE7E36, 
	0xDE88B2, 0xDE9059, 0xDEA18C, 0xDEB967, 0xDEC225, 0xDEDACE, 0xDEEB1B, 0xDEF3F0, 0xDF0613, 0xDF1EF8, 
	0xDF2F2D, 0xDF37C6, 0xDF4C84, 0xDF546F, 0xDF65BA, 0xDF7D51, 0xDF8BD5, 0xDF933E, 0xDFA2EB, 0xDFBA00, 
	0xDFC142, 0xDFD9A9, 0xDFE87C, 0xDFF097, 0xE00526, 0xE01DCD, 0xE02C18, 0xE034F3, 0xE04FB1, 0xE0575A, 
	0xE0668F, 0xE07E64, 0xE088E0, 0xE0900B, 0xE0A1DE, 0xE0B935, 0xE0C277, 0xE0DA9C, 0xE0EB49, 0xE0F3A2, 
	0xE10641, 0xE11EAA, 0xE12F7F, 0xE13794, 0xE14CD6, 0xE1543D, 0xE165E8, 0xE17D03, 0xE18B87, 0xE1936C, 
	0xE1A2B9, 0xE1BA52, 0xE1C110, 0xE1D9FB, 0xE1E82E, 0xE1F0C5, 0xE203EB, 0xE21B00, 0xE22AD5, 0xE2323E, 
	0xE2497C, 0xE25197, 0xE26042, 0xE278A9, 0xE28E2D, 0xE296C6, 0xE2A713, 0xE2BFF8, 0xE2C4BA, 0xE2DC51, 
	0xE2ED84, 0xE2F56F, 0xE3008C, 0xE31867, 0xE329B2, 0xE33159, 0xE34A1B, 0xE352F0, 0xE36325, 0xE37BCE, 
	0xE38D4A, 0xE395A1, 0xE3A474, 0xE3BC9F, 0xE3C7DD, 0xE3DF36, 0xE3EEE3, 0xE3F608, 0xE408BF, 0xE41054, 
	0xE42181, 0xE4396A, 0xE44228, 0xE45AC3, 0xE46B16, 0xE473FD, 0xE48579, 0xE49D92, 0xE4AC47, 0xE4B4AC, 
	0xE4CFEE, 0xE4D705, 0xE4E6D0, 0xE4FE3B, 0xE50BD8, 0xE51333, 0xE522E6, 0xE53A0D, 0xE5414F, 0xE559A4, 
	0xE56871, 0xE5709A, 0xE5861E, 0xE59EF5, 0xE5AF20, 0xE5B7CB, 0xE5CC89, 0xE5D462, 0xE5E5B7, 0xE5FD5C, 
	0xE60E72, 0xE61699, 0xE6274C, 0xE63FA7, 0xE644E5, 0xE65C0E, 0xE66DDB, 0xE67530, 0xE683B4, 0xE69B5F, 
	0xE6AA8A, 0xE6B261, 0xE6C923, 0xE6D1C8, 0xE6E01D, 0xE6F8F6, 0xE70D15, 0xE715FE, 0xE7242B, 0xE73CC0, 
	0xE74782, 0xE75F69, 0xE76EBC, 0xE77657, 0xE780D3, 0xE79838, 0xE7A9ED, 0xE7B106, 0xE7CA44, 0xE7D2AF, 
	0xE7E37A, 0xE7FB91, 0xE806FC, 0xE81E17, 0xE82FC2, 0xE83729, 0xE84C6B, 0xE85480, 0xE86555, 0xE87DBE, 
	0xE88B3A, 0xE893D1, 0xE8A204, 0xE8BAEF, 0xE8C1AD, 0xE8D946, 0xE8E893, 0xE8F078, 0xE9059B, 0xE91D70, 
	0xE92CA5, 0xE9344E, 0xE94F0C, 0xE957E7, 0xE96632, 0xE97ED9, 0xE9885D, 0xE990B6, 0xE9A163, 0xE9B988, 
	0xE9C2CA, 0xE9DA21, 0xE9EBF4, 0xE9F31F, 0xEA0031, 0xEA18DA, 0xEA290F, 0xEA31E4, 0xEA4AA6, 0xEA524D, 
	0xEA6398, 0xEA7B73, 0xEA8DF7, 0xEA951C, 0xEAA4C9, 0xEABC22, 0xEAC760, 0xEADF8B, 0xEAEE5E, 0xEAF6B5, 
	0xEB0356, 0xEB1BBD, 0xEB2A68, 0xEB3283, 0xEB49C1, 0xEB512A, 0xEB60FF, 0xEB7814, 0xEB8E90, 0xEB967B, 
	0xEBA7AE, 0xEBBF45, 0xEBC407, 0xEBDCEC, 0xEBED39, 0xEBF5D2, 0xEC0B65, 0xEC138E, 0xEC225B, 0xEC3AB0, 
	0xEC41F2, 0xEC5919, 0xEC68CC, 0xEC7027, 0xEC86A3, 0xEC9E48, 0xECAF9D, 0xECB776, 0xECCC34, 0xECD4DF, 
	0xECE50A, 0xECFDE1, 0xED0802, 0xED10E9, 0xED213C, 0xED39D7, 0xED4295, 0xED5A7E, 0xED6BAB, 0xED7340, 
	0xED85C4, 0xED9D2F, 0xEDACFA, 0xEDB411, 0xEDCF53, 0xEDD7B8, 0xEDE66D, 0xEDFE86, 0xEE0DA8, 0xEE1543, 
	0xEE2496, 0xEE3C7D, 0xEE473F, 0xEE5FD4, 0xEE6E01, 0xEE76EA, 0xEE806E, 0xEE9885, 0xEEA950, 0xEEB1BB, 
	0xEECAF9, 0xEED212, 0xEEE3C7, 0xEEFB2C, 0xEF0ECF, 0xEF1624, 0xEF27F1, 0xEF3F1A, 0xEF4458, 0xEF5CB3, 
	0xEF6D66, 0xEF758D, 0xEF8309, 0xEF9BE2, 0xEFAA37, 0xEFB2DC, 0xEFC99E, 0xEFD175, 0xEFE0A0, 0xEFF84B, 
	0xF00292, 0xF01A79, 0xF02BAC, 0xF03347, 0xF04805, 0xF050EE, 0xF0613B, 0xF079D0, 0xF08F54, 0xF097BF, 
	0xF0A66A, 0xF0BE81, 0xF0C5C3, 0xF0DD28, 0xF0ECFD, 0xF0F416, 0xF101F5, 0xF1191E, 0xF128CB, 0xF13020, 
	0xF14B62, 0xF15389, 0xF1625C, 0xF17AB7, 0xF18C33, 0xF194D8, 0xF1A50D, 0xF1BDE6, 0xF1C6A4, 0xF1DE4F, 
	0xF1EF9A, 0xF1F771, 0xF2045F, 0xF21CB4, 0xF22D61, 0xF2358A, 0xF24EC8, 0xF25623, 0xF267F6, 0xF27F1D, 
	0xF28999, 0xF29172, 0xF2A0A7, 0xF2B84C, 0xF2C30E, 0xF2DBE5, 0xF2EA30, 0xF2F2DB, 0xF30738, 0xF31FD3, 
	0xF32E06, 0xF336ED, 0xF34DAF, 0xF35544, 0xF36491, 0xF37C7A, 0xF38AFE, 0xF39215, 0xF3A3C0, 0xF3BB2B, 
	0xF3C069, 0xF3D882, 0xF3E957, 0xF3F1BC, 0xF40F0B, 0xF417E0, 0xF42635, 0xF43EDE, 0xF4459C, 0xF45D77, 
	0xF46CA2, 0xF47449, 0xF482CD, 0xF49A26, 0xF4ABF3, 0xF4B318, 0xF4C85A, 0xF4D0B1, 0xF4E164, 0xF4F98F, 
	0xF50C6C, 0xF51487, 0xF52552, 0xF53DB9, 0xF546FB, 0xF55E10, 0xF56FC5, 0xF5772E, 0xF581AA, 0xF59941, 
	0xF5A894, 0xF5B07F, 0xF5CB3D, 0xF5D3D6, 0xF5E203, 0xF5FAE8, 0xF609C6, 0xF6112D, 0xF620F8, 0xF63813, 
	0xF64351, 0xF65BBA, 0xF66A6F, 0xF67284, 0xF68400, 0xF69CEB, 0xF6AD3E, 0xF6B5D5, 0xF6CE97, 0xF6D67C, 
	0xF6E7A9, 0xF6FF42, 0xF70AA1, 0xF7124A, 0xF7239F, 0xF73B74, 0xF74036, 0xF758DD, 0xF76908, 0xF771E3, 
	0xF78767, 0xF79F8C, 0xF7AE59, 0xF7B6B2, 0xF7CDF0, 0xF7D51B, 0xF7E4CE, 0xF7FC25, 0xF80148, 0xF819A3, 
	0xF82876, 0xF8309D, 0xF84BDF, 0xF85334, 0xF862E1, 0xF87A0A, 0xF88C8E, 0xF89465, 0xF8A5B0, 0xF8BD5B, 
	0xF8C619, 0xF8DEF2, 0xF8EF27, 0xF8F7CC, 0xF9022F, 0xF91AC4, 0xF92B11, 0xF933FA, 0xF948B8, 0xF95053, 
	0xF96186, 0xF9796D, 0xF98FE9, 0xF99702, 0xF9A6D7, 0xF9BE3C, 0xF9C57E, 0xF9DD95, 0xF9EC40, 0xF9F4AB, 
	0xFA0785, 0xFA1F6E, 0xFA2EBB, 0xFA3650, 0xFA4D12, 0xFA55F9, 0xFA642C, 0xFA7CC7, 0xFA8A43, 0xFA92A8, 
	0xFAA37D, 0xFABB96, 0xFAC0D4, 0xFAD83F, 0xFAE9EA, 0xFAF101, 0xFB04E2, 0xFB1C09, 0xFB2DDC, 0xFB3537, 
	0xFB4E75, 0xFB569E, 0xFB674B, 0xFB7FA0, 0xFB8924, 0xFB91CF, 0xFBA01A, 0xFBB8F1, 0xFBC3B3, 0xFBDB58, 
	0xFBEA8D, 0xFBF266, 0xFC0CD1, 0xFC143A, 0xFC25EF, 0xFC3D04, 0xFC4646, 0xFC5EAD, 0xFC6F78, 0xFC7793, 
	0xFC8117, 0xFC99FC, 0xFCA829, 0xFCB0C2, 0xFCCB80, 0xFCD36B, 0xFCE2BE, 0xFCFA55, 0xFD0FB6, 0xFD175D, 
	0xFD2688, 0xFD3E63, 0xFD4521, 0xFD5DCA, 0xFD6C1F, 0xFD74F4, 0xFD8270, 0xFD9A9B, 0xFDAB4E, 0xFDB3A5, 
	0xFDC8E7, 0xFDD00C, 0xFDE1D9, 0xFDF932, 0xFE0A1C, 0xFE12F7, 0xFE2322, 0xFE3BC9, 0xFE408B, 0xFE5860, 
	0xFE69B5, 0xFE715E, 0xFE87DA, 0xFE9F31, 0xFEAEE4, 0xFEB60F, 0xFECD4D, 0xFED5A6, 0xFEE473, 0xFEFC98, 
	0xFF097B, 0xFF1190, 0xFF2045, 0xFF38AE, 0xFF43EC, 0xFF5B07, 0xFF6AD2, 0xFF7239, 0xFF84BD, 0xFF9C56, 
	0xFFAD83, 0xFFB568, 0xFFCE2A, 0xFFD6C1, 0xFFE714, 0xFFFFFF)

DECODE_23127 = (
	0x000000, 0x000001, 0x000002, 0x000003, 0x000004, 0x000005, 0x000006, 0x000007, 0x000008, 0x000009, 
	0x00000A, 0x00000B, 0x00000C, 0x00000D, 0x00000E, 0x024020, 0x000010, 0x000011, 0x000012, 0x000013, 
	0x000014, 0x000015, 0x000016, 0x412000, 0x000018, 0x000019, 0x00001A, 0x180800, 0x00001C, 0x200300, 
	0x048040, 0x001480, 0x000020, 0x000021, 0x000022, 0x000023, 0x000024, 0x000025, 0x000026, 0x024008, 
	0x000028, 0x000029, 0x00002A, 0x024004, 0x00002C, 0x024002, 0x024001, 0x024000, 0x000030, 0x000031, 
	0x000032, 0x008180, 0x000034, 0x000C40, 0x301000, 0x0C0200, 0x000038, 0x043000, 0x400600, 0x210040, 
	0x090080, 0x508000, 0x002900, 0x024010, 0x000040, 0x000041, 0x000042, 0x000043, 0x000044, 0x000045, 
	0x000046, 0x280080, 0x000048, 0x000049, 0x00004A, 0x002500, 0x00004C, 0x111000, 0x048010, 0x400A00, 
	0x000050, 0x000051, 0x000052, 0x021200, 0x000054, 0x000C20, 0x048008, 0x104100, 0x000058, 0x404080, 
	0x048004, 0x210020, 0x048002, 0x0A2000, 0x048000, 0x048001, 0x000060, 0x000061, 0x000062, 0x540000, 
	0x000064, 0x000C10, 0x010300, 0x00B000, 0x000068, 0x088200, 0x001880, 0x210010, 0x602000, 0x040180, 
	0x180400, 0x024040, 0x000070, 0x000C04, 0x086000, 0x210008, 0x000C01, 0x000C00, 0x420080, 0x000C02, 
	0x120100, 0x210002, 0x210001, 0x210000, 0x005200, 0x000C08, 0x048020, 0x210004, 0x000080, 0x000081, 
	0x000082, 0x000083, 0x000084, 0x000085, 0x000086, 0x280040, 0x000088, 0x000089, 0x00008A, 0x050200, 
	0x00008C, 0x00A800, 0x500100, 0x001410, 0x000090, 0x000091, 0x000092, 0x008120, 0x000094, 0x160000, 
	0x004A00, 0x001408, 0x000098, 0x404040, 0x222000, 0x001404, 0x090020, 0x001402, 0x001401, 0x001400, 
	0x0000A0, 0x0000A1, 0x0000A2, 0x008110, 0x0000A4, 0x401200, 0x042400, 0x110800, 0x0000A8, 0x300400, 
	0x001840, 0x482000, 0x090010, 0x040140, 0x208200, 0x024080, 0x0000B0, 0x008102, 0x008101, 0x008100, 
	0x090008, 0x206000, 0x420040, 0x008104, 0x090004, 0x020A00, 0x144000, 0x008108, 0x090000, 0x090001, 
	0x090002, 0x001420, 0x0000C0, 0x0000C1, 0x0000C2, 0x280004, 0x0000C4, 0x280002, 0x280001, 0x280000, 
	0x0000C8, 0x404010, 0x001820, 0x128000, 0x020600, 0x040120, 0x016000, 0x280008, 0x0000D0, 0x404008, 
	0x110400, 0x042800, 0x003100, 0x018200, 0x420020, 0x280010, 0x404001, 0x404000, 0x080300, 0x404002, 
	0x300800, 0x404004, 0x048080, 0x001440, 0x0000E0, 0x032000, 0x001808, 0x004600, 0x10C000, 0x040108, 
	0x420010, 0x280020, 0x001802, 0x040104, 0x001800, 0x001801, 0x040101, 0x040100, 0x001804, 0x040102, 
	0x240200, 0x181000, 0x420004, 0x008140, 0x420002, 0x000C80, 0x420000, 0x420001, 0x00A400, 0x404020, 
	0x001810, 0x210080, 0x090040, 0x040110, 0x420008, 0x102200, 0x000100, 0x000101, 0x000102, 0x000103, 
	0x000104, 0x000105, 0x000106, 0x041800, 0x000108, 0x000109, 0x00010A, 0x002440, 0x00010C, 0x200210, 
	0x500080, 0x098000, 0x000110, 0x000111, 0x000112, 0x0080A0, 0x000114, 0x200208, 0x0A0400, 0x104040, 
	0x000118, 0x200204, 0x015000, 0x460000, 0x200201, 0x200200, 0x002820, 0x200202, 0x000120, 0x000121, 
	0x000122, 0x008090, 0x000124, 0x182000, 0x010240, 0x600400, 0x000128, 0x410800, 0x2C0000, 0x101200, 
	0x009400, 0x0400C0, 0x002810, 0x024100, 0x000130, 0x008082, 0x008081, 0x008080, 0x444000, 0x031000, 
	0x002808, 0x008084, 0x120040, 0x084400, 0x002804, 0x008088, 0x002802, 0x200220, 0x002800, 0x002801, 
	0x000140, 0x000141, 0x000142, 0x002408, 0x000144, 0x428000, 0x010220, 0x104010, 0x000148, 0x002402, 
	0x002401, 0x002400, 0x084800, 0x0400A0, 0x221000, 0x002404, 0x000150, 0x0D0000, 0x600800, 0x104004, 
	0x003080, 0x104002, 0x104001, 0x104000, 0x120020, 0x009800, 0x080280, 0x002410, 0x410400, 0x200240, 
	0x048100, 0x104008, 0x000160, 0x205000, 0x010204, 0x0A0800, 0x010202, 0x040088, 0x010200, 0x010201, 
	0x120010, 0x040084, 0x40C000, 0x002420, 0x040081, 0x040080, 0x010208, 0x040082, 0x120008, 0x402200, 
	0x041400, 0x0080C0, 0x288000, 0x000D00, 0x010210, 0x104020, 0x120000, 0x120001, 0x120002, 0x210100, 
	0x120004, 0x040090, 0x002840, 0x481000, 0x000180, 0x000181, 0x000182, 0x008030, 0x000184, 0x014400, 
	0x500008, 0x022200, 0x000188, 0x0A1000, 0x500004, 0x204800, 0x500002, 0x040060, 0x500000, 0x500001, 
	0x000190, 0x008022, 0x008021, 0x008020, 0x003040, 0x480800, 0x250000, 0x008024, 0x040C00, 0x112000, 
	0x080240, 0x008028, 0x02C000, 0x200280, 0x500010, 0x001500, 0x0001A0, 0x008012, 0x008011, 0x008010, 
	0x220800, 0x040048, 0x085000, 0x008014, 0x006200, 0x040044, 0x030400, 0x008018, 0x040041, 0x040040, 
	0x500020, 0x040042, 0x008003, 0x008002, 0x008001, 0x008000, 0x100600, 0x008006, 0x008005, 0x008004, 
	0x601000, 0x00800A, 0x008009, 0x008008, 0x090100, 0x040050, 0x002880, 0x00800C, 0x0001C0, 0x100A00, 
	0x064000, 0x411000, 0x003010, 0x040028, 0x008C00, 0x280100, 0x218000, 0x040024, 0x080210, 0x002480, 
	0x040021, 0x040020, 0x500040, 0x040022, 0x003004, 0x220400, 0x080208, 0x008060, 0x003000, 0x003001, 
	0x003002, 0x104080, 0x080202, 0x404100, 0x080200, 0x080201, 0x003008, 0x040030, 0x080204, 0x030800, 
	0x480400, 0x04000C, 0x302000, 0x008050, 0x040009, 0x040008, 0x010280, 0x04000A, 0x040005, 0x040004, 
	0x001900, 0x040006, 0x040001, 0x040000, 0x040003, 0x040002, 0x014800, 0x008042, 0x008041, 0x008040, 
	0x003020, 0x040018, 0x420100, 0x008044, 0x120080, 0x040014, 0x080220, 0x008048, 0x040011, 0x040010, 
	0x204400, 0x040012, 0x000200, 0x000201, 0x000202, 0x000203, 0x000204, 0x000205, 0x000206, 0x108400, 
	0x000208, 0x000209, 0x00020A, 0x050080, 0x00020C, 0x200110, 0x083000, 0x400840, 0x000210, 0x000211, 
	0x000212, 0x021040, 0x000214, 0x200108, 0x004880, 0x0C0020, 0x000218, 0x200104, 0x400420, 0x00E000, 
	0x200101, 0x200100, 0x130000, 0x200102, 0x000220, 0x000221, 0x000222, 0x202800, 0x000224, 0x401080, 
	0x010140, 0x0C0010, 0x000228, 0x088040, 0x400410, 0x101100, 0x140800, 0x012400, 0x208080, 0x024200, 
	0x000230, 0x114000, 0x400408, 0x0C0004, 0x02A000, 0x0C0002, 0x0C0001, 0x0C0000, 0x400402, 0x020880, 
	0x400400, 0x400401, 0x005040, 0x200120, 0x400404, 0x0C0008, 0x000240, 0x000241, 0x000242, 0x021010, 
	0x000244, 0x046000, 0x010120, 0x400808, 0x000248, 0x088020, 0x304000, 0x400804, 0x020480, 0x400802, 
	0x400801, 0x400800, 0x000250, 0x021002, 0x021001, 0x021000, 0x580000, 0x018080, 0x202400, 0x021004, 
	0x012800, 0x140400, 0x080180, 0x021008, 0x005020, 0x200140, 0x048200, 0x400810, 0x000260, 0x088008, 
	0x010104, 0x004480, 0x010102, 0x320000, 0x010100, 0x010101, 0x088001, 0x088000, 0x062000, 0x088002, 
	0x005010, 0x088004, 0x010108, 0x400820, 0x240080, 0x402100, 0x108800, 0x021020, 0x005008, 0x000E00, 
	0x010110, 0x0C0040, 0x005004, 0x088010, 0x400440, 0x210200, 0x005000, 0x005001, 0x005002, 0x102080, 
	0x000280, 0x000281, 0x000282, 0x050008, 0x000284, 0x401020, 0x004810, 0x022100, 0x000288, 0x050002, 
	0x050001, 0x050000, 0x020440, 0x184000, 0x208020, 0x050004, 0x000290, 0x082400, 0x004804, 0x700000, 
	0x004802, 0x018040, 0x004800, 0x004801, 0x109000, 0x020820, 0x080140, 0x050010, 0x442000, 0x200180, 
	0x004808, 0x001600, 0x0002A0, 0x401004, 0x1A0000, 0x004440, 0x401001, 0x401000, 0x208008, 0x401002, 
	0x006100, 0x020810, 0x208004, 0x050020, 0x208002, 0x401008, 0x208000, 0x208001, 0x240040, 0x020808, 
	0x013000, 0x008300, 0x100500, 0x401010, 0x004820, 0x0C0080, 0x020801, 0x020800, 0x400480, 0x020802, 
	0x090200, 0x020804, 0x208010, 0x102040, 0x0002C0, 0x100900, 0x40A000, 0x004420, 0x020408, 0x018010, 
	0x141000, 0x280200, 0x020404, 0x203000, 0x080110, 0x050040, 0x020400, 0x020401, 0x020402, 0x400880, 
	0x240020, 0x018004, 0x080108, 0x021080, 0x018001, 0x018000, 0x004840, 0x018002, 0x080102, 0x404200, 
	0x080100, 0x080101, 0x020410, 0x018008, 0x080104, 0x102020, 0x240010, 0x004402, 0x004401, 0x004400, 
	0x082800, 0x401040, 0x010180, 0x004404, 0x510000, 0x088080, 0x001A00, 0x004408, 0x020420, 0x040300, 
	0x208040, 0x102010, 0x240000, 0x240001, 0x240002, 0x004410, 0x240004, 0x018020, 0x420200, 0x102008, 
	0x240008, 0x020840, 0x080120, 0x102004, 0x005080, 0x102002, 0x102001, 0x102000, 0x000300, 0x000301, 
	0x000302, 0x484000, 0x000304, 0x200018, 0x010060, 0x022080, 0x000308, 0x200014, 0x028800, 0x101020, 
	0x200011, 0x200010, 0x044400, 0x200012, 0x000310, 0x20000C, 0x142000, 0x010C00, 0x200009, 0x200008, 
	0x409000, 0x20000A, 0x200005, 0x200004, 0x0800C0, 0x200006, 0x200001, 0x200000, 0x200003, 0x200002, 
	0x000320, 0x060400, 0x010044, 0x101008, 0x010042, 0x00C800, 0x010040, 0x010041, 0x006080, 0x101002, 
	0x101001, 0x101000, 0x4A0000, 0x200030, 0x010048, 0x101004, 0x081800, 0x402040, 0x224000, 0x008280, 
	0x100480, 0x200028, 0x010050, 0x0C0100, 0x058000, 0x200024, 0x400500, 0x101010, 0x200021, 0x200020, 
	0x002A00, 0x200022, 0x000340, 0x100880, 0x010024, 0x248000, 0x010022, 0x081400, 0x010020, 0x010021, 
	0x441000, 0x034000, 0x080090, 0x002600, 0x10A000, 0x200050, 0x010028, 0x400900, 0x00C400, 0x402020, 
	0x080088, 0x021100, 0x060800, 0x200048, 0x010030, 0x104200, 0x080082, 0x200044, 0x080080, 0x080081, 
	0x200041, 0x200040, 0x080084, 0x200042, 0x010006, 0x402010, 0x010004, 0x010005, 0x010002, 0x010003, 
	0x010000, 0x010001, 0x200C00, 0x088100, 0x01000C, 0x101040, 0x01000A, 0x040280, 0x010008, 0x010009, 
	0x402001, 0x402000, 0x010014, 0x402002, 0x010012, 0x402004, 0x010010, 0x010011, 0x120200, 0x402008, 
	0x0800A0, 0x044800, 0x005100, 0x200060, 0x010018, 0x028400, 0x000380, 0x100840, 0x201400, 0x022004, 
	0x0C8000, 0x022002, 0x022001, 0x022000, 0x006020, 0x408400, 0x080050, 0x050100, 0x011800, 0x200090, 
	0x500200, 0x022008, 0x430000, 0x045000, 0x080048, 0x008220, 0x100420, 0x200088, 0x004900, 0x022010, 
	0x080042, 0x200084, 0x080040, 0x080041, 0x200081, 0x200080, 0x080044, 0x200082, 0x006008, 0x290000, 
	0x440800, 0x008210, 0x100410, 0x401100, 0x0100C0, 0x022020, 0x006000, 0x006001, 0x006002, 0x101080, 
	0x006004, 0x040240, 0x208100, 0x080C00, 0x100404, 0x008202, 0x008201, 0x008200, 0x100400, 0x100401, 
	0x100402, 0x008204, 0x006010, 0x020900, 0x080060, 0x008208, 0x100408, 0x2000A0, 0x061000, 0x414000, 
	0x100801, 0x100800, 0x080018, 0x100802, 0x604000, 0x100804, 0x0100A0, 0x022040, 0x080012, 0x100808, 
	0x080010, 0x080011, 0x020500, 0x040220, 0x080014, 0x00D000, 0x08000A, 0x100810, 0x080008, 0x080009, 
	0x003200, 0x018100, 0x08000C, 0x440400, 0x080002, 0x080003, 0x080000, 0x080001, 0x080006, 0x2000C0, 
	0x080004, 0x080005, 0x029000, 0x100820, 0x010084, 0x004500, 0x010082, 0x040208, 0x010080, 0x010081, 
	0x006040, 0x040204, 0x080030, 0x620000, 0x040201, 0x040200, 0x010088, 0x040202, 0x240100, 0x402080, 
	0x080028, 0x008240, 0x100440, 0x0A4000, 0x010090, 0x201800, 0x080022, 0x011400, 0x080020, 0x080021, 
	0x408800, 0x040210, 0x080024, 0x102100, 0x000400, 0x000401, 0x000402, 0x000403, 0x000404, 0x000405, 
	0x000406, 0x108200, 0x000408, 0x000409, 0x00040A, 0x002140, 0x00040C, 0x4C0000, 0x210800, 0x001090, 
	0x000410, 0x000411, 0x000412, 0x244000, 0x000414, 0x000860, 0x0A0100, 0x001088, 0x000418, 0x038000, 
	0x400220, 0x001084, 0x106000, 0x001082, 0x001081, 0x001080, 0x000420, 0x000421, 0x000422, 0x091000, 
	0x000424, 0x000850, 0x042080, 0x600100, 0x000428, 0x300080, 0x400210, 0x048800, 0x009100, 0x012200, 
	0x180040, 0x024400, 0x000430, 0x000844, 0x400208, 0x122000, 0x000841, 0x000840, 0x01C000, 0x000842, 
	0x400202, 0x084100, 0x400200, 0x400201, 0x260000, 0x000848, 0x400204, 0x0010A0, 0x000440, 0x000441, 
	0x000442, 0x002108, 0x000444, 0x000830, 0x405000, 0x070000, 0x000448, 0x002102, 0x002101, 0x002100, 
	0x020280, 0x20C000, 0x180020, 0x002104, 0x000450, 0x000824, 0x110080, 0x488000, 0x000821, 0x000820, 
	0x202200, 0x000822, 0x281000, 0x140200, 0x024800, 0x002110, 0x410100, 0x000828, 0x048400, 0x0010C0, 
	0x000460, 0x000814, 0x228000, 0x004280, 0x000811, 0x000810, 0x180008, 0x000812, 0x054000, 0x421000, 
	0x180004, 0x002120, 0x180002, 0x000818, 0x180000, 0x180001, 0x000805, 0x000804, 0x041100, 0x000806, 
	0x000801, 0x000800, 0x000803, 0x000802, 0x00A080, 0x00080C, 0x400240, 0x210400, 0x000809, 0x000808, 
	0x180010, 0x00080A, 0x000480, 0x000481, 0x000482, 0x420800, 0x000484, 0x014100, 0x042020, 0x001018, 
	0x000488, 0x300020, 0x08C000, 0x001014, 0x020240, 0x001012, 0x001011, 0x001010, 0x000490, 0x082200, 
	0x110040, 0x00100C, 0x608000, 0x00100A, 0x001009, 0x001008, 0x040900, 0x001006, 0x001005, 0x001004, 
	0x001003, 0x001002, 0x001001, 0x001000, 0x0004A0, 0x300008, 0x042004, 0x004240, 0x042002, 0x0A8000, 
	0x042000, 0x042001, 0x300001, 0x300000, 0x030100, 0x300002, 0x404800, 0x300004, 0x042008, 0x001030, 
	0x025000, 0x450000, 0x280800, 0x008500, 0x100300, 0x0008C0, 0x042010, 0x001028, 0x00A040, 0x300010, 
	0x400280, 0x001024, 0x090400, 0x001022, 0x001021, 0x001020, 0x0004C0, 0x049000, 0x110010, 0x004220, 
	0x020208, 0x502000, 0x008900, 0x280400, 0x020204, 0x090800, 0x640000, 0x002180, 0x020200, 0x020201, 
	0x020202, 0x001050, 0x110002, 0x220100, 0x110000, 0x110001, 0x0C4000, 0x0008A0, 0x110004, 0x001048, 
	0x00A020, 0x404400, 0x110008, 0x001044, 0x020210, 0x001042, 0x001041, 0x001040, 0x480100, 0x004202, 
	0x004201, 0x004200, 0x211000, 0x000890, 0x042040, 0x004204, 0x00A010, 0x300040, 0x001C00, 0x004208, 
	0x020220, 0x040500, 0x180080, 0x418000, 0x00A008, 0x000884, 0x110020, 0x004210, 0x000881, 0x000880, 
	0x420400, 0x000882, 0x00A000, 0x00A001, 0x00A002, 0x0E0000, 0x00A004, 0x000888, 0x204100, 0x001060, 
	0x000500, 0x000501, 0x000502, 0x002048, 0x000504, 0x014080, 0x0A0010, 0x600020, 0x000508, 0x002042, 
	0x002041, 0x002040, 0x009020, 0x120800, 0x044200, 0x002044, 0x000510, 0x501000, 0x0A0004, 0x010A00, 
	0x0A0002, 0x04A000, 0x0A0000, 0x0A0001, 0x040880, 0x084020, 0x308000, 0x002050, 0x410040, 0x200600, 
	0x0A0008, 0x001180, 0x000520, 0x060200, 0x104800, 0x600004, 0x009008, 0x600002, 0x600001, 0x600000, 
	0x009004, 0x084010, 0x030080, 0x002060, 0x009000, 0x009001, 0x009002, 0x600008, 0x212000, 0x084008, 
	0x041040, 0x008480, 0x100280, 0x000940, 0x0A0020, 0x600010, 0x084001, 0x084000, 0x400300, 0x084002, 
	0x009010, 0x084004, 0x002C00, 0x150000, 0x000540, 0x00200A, 0x002009, 0x002008, 0x340000, 0x081200, 
	0x008880, 0x00200C, 0x002003, 0x002002, 0x002001, 0x002000, 0x410010, 0x002006, 0x002005, 0x002004, 
	0x00C200, 0x220080, 0x041020, 0x002018, 0x410008, 0x000920, 0x0A0040, 0x104400, 0x410004, 0x002012, 
	0x002011, 0x002010, 0x410000, 0x410001, 0x410002, 0x002014, 0x480080, 0x118000, 0x041010, 0x002028, 
	0x026000, 0x000910, 0x010600, 0x600040, 0x200A00, 0x002022, 0x002021, 0x002020, 0x009040, 0x040480, 
	0x180100, 0x002024, 0x041002, 0x000904, 0x041000, 0x041001, 0x000901, 0x000900, 0x041004, 0x000902, 
	0x120400, 0x084040, 0x041008, 0x002030, 0x410020, 0x000908, 0x204080, 0x028200, 0x000580, 0x014004, 
	0x201200, 0x1C0000, 0x014001, 0x014000, 0x008840, 0x014002, 0x040810, 0x408200, 0x030020, 0x0020C0, 
	0x282000, 0x014008, 0x500400, 0x001110, 0x040808, 0x220040, 0x406000, 0x008420, 0x100220, 0x014010, 
	0x0A0080, 0x001108, 0x040800, 0x040801, 0x040802, 0x001104, 0x040804, 0x001102, 0x001101, 0x001100, 
	0x480040, 0x003800, 0x030008, 0x008410, 0x100210, 0x014020, 0x042100, 0x600080, 0x030002, 0x300100, 
	0x030000, 0x030001, 0x009080, 0x040440, 0x030004, 0x080A00, 0x100204, 0x008402, 0x008401, 0x008400, 
	0x100200, 0x100201, 0x100202, 0x008404, 0x040820, 0x084080, 0x030010, 0x008408, 0x100208, 0x422000, 
	0x204040, 0x001120, 0x480020, 0x220010, 0x008804, 0x002088, 0x008802, 0x014040, 0x008800, 0x008801, 
	0x105000, 0x002082, 0x002081, 0x002080, 0x020300, 0x040420, 0x008808, 0x002084, 0x220001, 0x220000, 
	0x110100, 0x220002, 0x003400, 0x220004, 0x008810, 0x440200, 0x040840, 0x220008, 0x080600, 0x002090, 
	0x410080, 0x188000, 0x204020, 0x001140, 0x480000, 0x480001, 0x480002, 0x004300, 0x480004, 0x040408, 
	0x008820, 0x121000, 0x480008, 0x040404, 0x030040, 0x0020A0, 0x040401, 0x040400, 0x204010, 0x040402, 
	0x480010, 0x220020, 0x041080, 0x008440, 0x100240, 0x000980, 0x204008, 0x092000, 0x00A100, 0x011200, 
	0x204004, 0x500800, 0x204002, 0x040410, 0x204000, 0x204001, 0x000600, 0x000601, 0x000602, 0x108004, 
	0x000604, 0x108002, 0x108001, 0x108000, 0x000608, 0x005800, 0x400030, 0x2A0000, 0x0200C0, 0x012020, 
	0x044100, 0x108008, 0x000610, 0x082080, 0x400028, 0x010900, 0x051000, 0x424000, 0x202040, 0x108010, 
	0x400022, 0x140040, 0x400020, 0x400021, 0x088800, 0x200500, 0x400024, 0x001280, 0x000620, 0x060100, 
	0x400018, 0x0040C0, 0x284000, 0x012008, 0x021800, 0x108020, 0x400012, 0x012004, 0x400010, 0x400011, 
	0x012001, 0x012000, 0x400014, 0x012002, 0x40000A, 0x209000, 0x400008, 0x400009, 0x100180, 0x000A40, 
	0x40000C, 0x0C0400, 0x400002, 0x400003, 0x400000, 0x400001, 0x400006, 0x012010, 0x400004, 0x400005, 
	0x000640, 0x610000, 0x0C0800, 0x0040A0, 0x020088, 0x081100, 0x202010, 0x108040, 0x020084, 0x140010, 
	0x019000, 0x002300, 0x020080, 0x020081, 0x020082, 0x400C00, 0x00C100, 0x140008, 0x202004, 0x021400, 
	0x202002, 0x000A20, 0x202000, 0x202001, 0x140001, 0x140000, 0x400060, 0x140002, 0x020090, 0x140004, 
	0x202008, 0x094000, 0x103000, 0x004082, 0x004081, 0x004080, 0x448000, 0x000A10, 0x010500, 0x004084, 
	0x200900, 0x088400, 0x400050, 0x004088, 0x0200A0, 0x012040, 0x180200, 0x241000, 0x0B0000, 0x000A04, 
	0x400048, 0x004090, 0x000A01, 0x000A00, 0x202020, 0x000A02, 0x400042, 0x140020, 0x400040, 0x400041, 
	0x005400, 0x000A08, 0x400044, 0x028100, 0x000680, 0x082010, 0x201100, 0x004060, 0x020048, 0x240800, 
	0x490000, 0x108080, 0x020044, 0x408100, 0x102800, 0x050400, 0x020040, 0x020041, 0x020042, 0x001210, 
	0x082001, 0x082000, 0x068000, 0x082002, 0x100120, 0x082004, 0x004C00, 0x001208, 0x214000, 0x082008, 
	0x4000A0, 0x001204, 0x020050, 0x001202, 0x001201, 0x001200, 0x018800, 0x004042, 0x004041, 0x004040, 
	0x100110, 0x401400, 0x042200, 0x004044, 0x0C1000, 0x300200, 0x400090, 0x004048, 0x020060, 0x012080, 
	0x208400, 0x080900, 0x100104, 0x082020, 0x400088, 0x004050, 0x100100, 0x100101, 0x100102, 0x230000, 
	0x400082, 0x020C00, 0x400080, 0x400081, 0x100108, 0x04C000, 0x400084, 0x001220, 0x02000C, 0x004022, 
	0x004021, 0x004020, 0x020008, 0x020009, 0x02000A, 0x004024, 0x020004, 0x020005, 0x020006, 0x004028, 
	0x020000, 0x020001, 0x020002, 0x020003, 0x401800, 0x082040, 0x110200, 0x004030, 0x020018, 0x018400, 
	0x202080, 0x440100, 0x020014, 0x140080, 0x080500, 0x208800, 0x020010, 0x020011, 0x020012, 0x001240, 
	0x004003, 0x004002, 0x004001, 0x004000, 0x020028, 0x004006, 0x004005, 0x004004, 0x020024, 0x00400A, 
	0x004009, 0x004008, 0x020020, 0x020021, 0x020022, 0x00400C, 0x240400, 0x004012, 0x004011, 0x004010, 
	0x100140, 0x000A80, 0x089000, 0x004014, 0x00A200, 0x011100, 0x4000C0, 0x004018, 0x020030, 0x680000, 
	0x050800, 0x102400, 0x000700, 0x060020, 0x201080, 0x010810, 0x402800, 0x081040, 0x044008, 0x108100, 
	0x190000, 0x408080, 0x044004, 0x002240, 0x044002, 0x200410, 0x044000, 0x044001, 0x00C040, 0x010802, 
	0x010801, 0x010800, 0x1000A0, 0x200408, 0x0A0200, 0x010804, 0x023000, 0x200404, 0x400120, 0x010808, 
	0x200401, 0x200400, 0x044010, 0x200402, 0x060001, 0x060000, 0x08A000, 0x060002, 0x100090, 0x060004, 
	0x010440, 0x600200, 0x200840, 0x060008, 0x400110, 0x101400, 0x009200, 0x012100, 0x044020, 0x080880, 
	0x100084, 0x060010, 0x400108, 0x010820, 0x100080, 0x100081, 0x100082, 0x007000, 0x400102, 0x084200, 
	0x400100, 0x400101, 0x100088, 0x200420, 0x400104, 0x028040, 0x00C010, 0x081004, 0x520000, 0x002208, 
	0x081001, 0x081000, 0x010420, 0x081002, 0x200820, 0x002202, 0x002201, 0x002200, 0x020180, 0x081008, 
	0x044040, 0x002204, 0x00C000, 0x00C001, 0x00C002, 0x010840, 0x00C004, 0x081010, 0x202100, 0x440080, 
	0x00C008, 0x140100, 0x080480, 0x002210, 0x410200, 0x200440, 0x101800, 0x028020, 0x200808, 0x060040, 
	0x010404, 0x004180, 0x010402, 0x081020, 0x010400, 0x010401, 0x200800, 0x200801, 0x200802, 0x002220, 
	0x200804, 0x504000, 0x010408, 0x028010, 0x00C020, 0x402400, 0x041200, 0x380000, 0x1000C0, 0x000B00, 
	0x010410, 0x028008, 0x200810, 0x011080, 0x400140, 0x028004, 0x0C2000, 0x028002, 0x028001, 0x028000, 
	0x201002, 0x408008, 0x201000, 0x201001, 0x100030, 0x014200, 0x201004, 0x022400, 0x408001, 0x408000, 
	0x201008, 0x408002, 0x020140, 0x408004, 0x044080, 0x080820, 0x100024, 0x082100, 0x201010, 0x010880, 
	0x100020, 0x100021, 0x100022, 0x440040, 0x040A00, 0x408010, 0x080440, 0x124000, 0x100028, 0x200480, 
	0x01A000, 0x001300, 0x100014, 0x060080, 0x201020, 0x004140, 0x100010, 0x100011, 0x100012, 0x080808, 
	0x006400, 0x408020, 0x030200, 0x080804, 0x100018, 0x080802, 0x080801, 0x080800, 0x100004, 0x100005, 
	0x100006, 0x008600, 0x100000, 0x100001, 0x100002, 0x100003, 0x10000C, 0x011040, 0x400180, 0x242000, 
	0x100008, 0x100009, 0x10000A, 0x080810, 0x052000, 0x100C00, 0x201040, 0x004120, 0x020108, 0x081080, 
	0x008A00, 0x440010, 0x020104, 0x408040, 0x080410, 0x002280, 0x020100, 0x020101, 0x020102, 0x310000, 
	0x00C080, 0x220200, 0x080408, 0x440004, 0x100060, 0x440002, 0x440001, 0x440000, 0x080402, 0x011020, 
	0x080400, 0x080401, 0x020110, 0x006800, 0x080404, 0x440008, 0x480200, 0x004102, 0x004101, 0x004100, 
	0x100050, 0x20A000, 0x010480, 0x004104, 0x200880, 0x011010, 0x148000, 0x004108, 0x020120, 0x040600, 
	0x403000, 0x080840, 0x100044, 0x011008, 0x022800, 0x004110, 0x100040, 0x100041, 0x100042, 0x440020, 
	0x011001, 0x011000, 0x080420, 0x011002, 0x100048, 0x011004, 0x204200, 0x028080)